(function() {
    var type_impls = Object.fromEntries([["kernel",[["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-HasPinData-for-Lock%3CT,+B%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/sync/lock.rs.html#105\">Source</a><a href=\"#impl-HasPinData-for-Lock%3CT,+B%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>, B: <a class=\"trait\" href=\"kernel/sync/lock/trait.Backend.html\" title=\"trait kernel::sync::lock::Backend\">Backend</a>&gt; HasPinData for <a class=\"struct\" href=\"kernel/sync/lock/struct.Lock.html\" title=\"struct kernel::sync::lock::Lock\">Lock</a>&lt;T, B&gt;</h3></section></summary><div class=\"impl-items\"><section id=\"associatedtype.PinData\" class=\"associatedtype trait-impl\"><a class=\"src rightside\" href=\"src/kernel/sync/lock.rs.html#105\">Source</a><a href=\"#associatedtype.PinData\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"#associatedtype.PinData\" class=\"associatedtype\">PinData</a> = __ThePinData&lt;T, B&gt;</h4></section><section id=\"method.__pin_data\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/sync/lock.rs.html#105\">Source</a><a href=\"#method.__pin_data\" class=\"anchor\">§</a><h4 class=\"code-header\">unsafe fn <a href=\"#tymethod.__pin_data\" class=\"fn\">__pin_data</a>() -&gt; Self::PinData</h4></section></div></details>","HasPinData","kernel::sync::lock::mutex::Mutex","kernel::sync::lock::spinlock::SpinLock"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Lock%3C(),+B%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/sync/lock.rs.html#143-163\">Source</a><a href=\"#impl-Lock%3C(),+B%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;B: <a class=\"trait\" href=\"kernel/sync/lock/trait.Backend.html\" title=\"trait kernel::sync::lock::Backend\">Backend</a>&gt; <a class=\"struct\" href=\"kernel/sync/lock/struct.Lock.html\" title=\"struct kernel::sync::lock::Lock\">Lock</a>&lt;<a class=\"primitive\" href=\"core/primitive.unit.html\">()</a>, B&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_raw\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/sync/lock.rs.html#154-162\">Source</a><h4 class=\"code-header\">pub unsafe fn <a href=\"kernel/sync/lock/struct.Lock.html#tymethod.from_raw\" class=\"fn\">from_raw</a>&lt;'a&gt;(ptr: <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut </a>B::<a class=\"associatedtype\" href=\"kernel/sync/lock/trait.Backend.html#associatedtype.State\" title=\"type kernel::sync::lock::Backend::State\">State</a>) -&gt; &amp;'a Self</h4></section></summary><div class=\"docblock\"><p>Constructs a <a href=\"kernel/sync/lock/struct.Lock.html\" title=\"struct kernel::sync::lock::Lock\"><code>Lock</code></a> from a raw pointer.</p>\n<p>This can be useful for interacting with a lock which was initialised outside of Rust.</p>\n<h5 id=\"safety\"><a class=\"doc-anchor\" href=\"#safety\">§</a>Safety</h5>\n<p>The caller promises that <code>ptr</code> points to a valid initialised instance of <a href=\"kernel/sync/lock/trait.Backend.html#associatedtype.State\" title=\"associated type kernel::sync::lock::Backend::State\"><code>State</code></a> during\nthe whole lifetime of <code>'a</code>.</p>\n</div></details></div></details>",0,"kernel::sync::lock::mutex::Mutex","kernel::sync::lock::spinlock::SpinLock"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Lock%3CT,+B%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/sync/lock.rs.html#128-141\">Source</a><a href=\"#impl-Lock%3CT,+B%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, B: <a class=\"trait\" href=\"kernel/sync/lock/trait.Backend.html\" title=\"trait kernel::sync::lock::Backend\">Backend</a>&gt; <a class=\"struct\" href=\"kernel/sync/lock/struct.Lock.html\" title=\"struct kernel::sync::lock::Lock\">Lock</a>&lt;T, B&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.new\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/sync/lock.rs.html#130-140\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/sync/lock/struct.Lock.html#tymethod.new\" class=\"fn\">new</a>(\n    t: T,\n    name: &amp;'static <a class=\"struct\" href=\"kernel/str/struct.CStr.html\" title=\"struct kernel::str::CStr\">CStr</a>,\n    key: <a class=\"struct\" href=\"core/pin/struct.Pin.html\" title=\"struct core::pin::Pin\">Pin</a>&lt;&amp;'static <a class=\"struct\" href=\"kernel/sync/struct.LockClassKey.html\" title=\"struct kernel::sync::LockClassKey\">LockClassKey</a>&gt;,\n) -&gt; impl <a class=\"trait\" href=\"kernel/prelude/trait.PinInit.html\" title=\"trait kernel::prelude::PinInit\">PinInit</a>&lt;Self&gt;</h4></section></summary><div class=\"docblock\"><p>Constructs a new lock initialiser.</p>\n</div></details></div></details>",0,"kernel::sync::lock::mutex::Mutex","kernel::sync::lock::spinlock::SpinLock"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Lock%3CT,+B%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/sync/lock.rs.html#165-185\">Source</a><a href=\"#impl-Lock%3CT,+B%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>, B: <a class=\"trait\" href=\"kernel/sync/lock/trait.Backend.html\" title=\"trait kernel::sync::lock::Backend\">Backend</a>&gt; <a class=\"struct\" href=\"kernel/sync/lock/struct.Lock.html\" title=\"struct kernel::sync::lock::Lock\">Lock</a>&lt;T, B&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.lock\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/sync/lock.rs.html#167-173\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/sync/lock/struct.Lock.html#tymethod.lock\" class=\"fn\">lock</a>(&amp;self) -&gt; <a class=\"struct\" href=\"kernel/sync/lock/struct.Guard.html\" title=\"struct kernel::sync::lock::Guard\">Guard</a>&lt;'_, T, B&gt;</h4></section></summary><div class=\"docblock\"><p>Acquires the lock and gives the caller access to the data protected by it.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_lock\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/sync/lock.rs.html#180-184\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/sync/lock/struct.Lock.html#tymethod.try_lock\" class=\"fn\">try_lock</a>(&amp;self) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;<a class=\"struct\" href=\"kernel/sync/lock/struct.Guard.html\" title=\"struct kernel::sync::lock::Guard\">Guard</a>&lt;'_, T, B&gt;&gt;</h4></section></summary><div class=\"docblock\"><p>Tries to acquire the lock.</p>\n<p>Returns a guard that can be used to access the data protected by the lock if successful.</p>\n</div></details></div></details>",0,"kernel::sync::lock::mutex::Mutex","kernel::sync::lock::spinlock::SpinLock"],["<section id=\"impl-Send-for-Lock%3CT,+B%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/sync/lock.rs.html#122\">Source</a><a href=\"#impl-Send-for-Lock%3CT,+B%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a> + <a class=\"trait\" href=\"core/marker/trait.Send.html\" title=\"trait core::marker::Send\">Send</a>, B: <a class=\"trait\" href=\"kernel/sync/lock/trait.Backend.html\" title=\"trait kernel::sync::lock::Backend\">Backend</a>&gt; <a class=\"trait\" href=\"core/marker/trait.Send.html\" title=\"trait core::marker::Send\">Send</a> for <a class=\"struct\" href=\"kernel/sync/lock/struct.Lock.html\" title=\"struct kernel::sync::lock::Lock\">Lock</a>&lt;T, B&gt;</h3></section>","Send","kernel::sync::lock::mutex::Mutex","kernel::sync::lock::spinlock::SpinLock"],["<section id=\"impl-Sync-for-Lock%3CT,+B%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/sync/lock.rs.html#126\">Source</a><a href=\"#impl-Sync-for-Lock%3CT,+B%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a> + <a class=\"trait\" href=\"core/marker/trait.Send.html\" title=\"trait core::marker::Send\">Send</a>, B: <a class=\"trait\" href=\"kernel/sync/lock/trait.Backend.html\" title=\"trait kernel::sync::lock::Backend\">Backend</a>&gt; <a class=\"trait\" href=\"core/marker/trait.Sync.html\" title=\"trait core::marker::Sync\">Sync</a> for <a class=\"struct\" href=\"kernel/sync/lock/struct.Lock.html\" title=\"struct kernel::sync::lock::Lock\">Lock</a>&lt;T, B&gt;</h3></section>","Sync","kernel::sync::lock::mutex::Mutex","kernel::sync::lock::spinlock::SpinLock"]]]]);
    if (window.register_type_impls) {
        window.register_type_impls(type_impls);
    } else {
        window.pending_type_impls = type_impls;
    }
})()
//{"start":55,"fragment_lengths":[9138]}