const char *cylinders_fs =
  "#version 400\n"
  "precision highp float;\n"
  "\n"
  "in vec3 fnormal;\n"
  "in vec4 outColor;\n"
  "\n"
  "out vec4 colorOut;\n"
  "\n"
  "\n"
  "uniform float opacity;\n"
  "\n"
  "void main()\n"
  "{\n"
  "  vec3 N = normalize(fnormal);\n"
  "  vec3 L = normalize(vec3(0, 1, 1));\n"
  "  vec3 E = vec3(0, 0, 1);\n"
  "  vec3 H = normalize(L + E);\n"
  "  float df = max(0.0, dot(N, L));\n"
  "  float sf = max(0.0, dot(N, H));\n"
  "  vec4 ambient = 0.4 * outColor;\n"
  "  vec4 diffuse = 0.55 * outColor;\n"
  "  vec4 specular = 0.5 * (vec4(1, 1, 1, 1) - outColor);\n"
  "  colorOut = ambient + df * diffuse + pow(sf, 20.0) * specular;\n"
  "  colorOut.a = opacity;\n"
  "}\n"
  "\n";
