const char *volume_box_vs =
  "#version 400\n"
  "precision highp float;\n"
  "\n"
  "in vec3 vertexPosition;\n"
  "out vec3 vWorldPos;\n"
  "\n"
  "uniform mat4 uModelView;\n"
  "uniform mat4 uProjection;\n"
  "uniform vec3 uBoxMin;\n"
  "uniform vec3 uBoxMax;\n"
  "\n"
  "void main()\n"
  "{\n"
  "    // Transform unit cube [-1,1] to world-space cube bounds\n"
  "    vec3 worldPos = uBoxMin + (vertexPosition * 0.5 + 0.5) * (uBoxMax - uBoxMin);\n"
  "    vWorldPos = worldPos;\n"
  "\n"
  "    gl_Position = uProjection * uModelView * vec4(worldPos, 1.0);\n"
  "}\n"
  "\n";
