/* brightness-helper.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from brightness-helper.vala, do not modify */

/*
* This file is part of budgie-desktop
*
* Copyright Budgie Desktop Developers
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*/

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_LOGIND_SESSION (budgie_logind_session_get_type ())
#define BUDGIE_LOGIND_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_LOGIND_SESSION, BudgieLogindSession))
#define BUDGIE_IS_LOGIND_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_LOGIND_SESSION))
#define BUDGIE_LOGIND_SESSION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BUDGIE_TYPE_LOGIND_SESSION, BudgieLogindSessionIface))

typedef struct _BudgieLogindSession BudgieLogindSession;
typedef struct _BudgieLogindSessionIface BudgieLogindSessionIface;

#define BUDGIE_TYPE_LOGIND_SESSION_PROXY (budgie_logind_session_proxy_get_type ())
typedef GDBusProxy BudgieLogindSessionProxy;
typedef GDBusProxyClass BudgieLogindSessionProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define BUDGIE_TYPE_BRIGHTNESS_HELPER (budgie_brightness_helper_get_type ())
#define BUDGIE_BRIGHTNESS_HELPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_BRIGHTNESS_HELPER, BudgieBrightnessHelper))
#define BUDGIE_BRIGHTNESS_HELPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_BRIGHTNESS_HELPER, BudgieBrightnessHelperClass))
#define BUDGIE_IS_BRIGHTNESS_HELPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_BRIGHTNESS_HELPER))
#define BUDGIE_IS_BRIGHTNESS_HELPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_BRIGHTNESS_HELPER))
#define BUDGIE_BRIGHTNESS_HELPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_BRIGHTNESS_HELPER, BudgieBrightnessHelperClass))

typedef struct _BudgieBrightnessHelper BudgieBrightnessHelper;
typedef struct _BudgieBrightnessHelperClass BudgieBrightnessHelperClass;
typedef struct _BudgieBrightnessHelperPrivate BudgieBrightnessHelperPrivate;

#define BUDGIE_TYPE_BRIGHTNESS_UTIL (budgie_brightness_util_get_type ())
#define BUDGIE_BRIGHTNESS_UTIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_BRIGHTNESS_UTIL, BudgieBrightnessUtil))
#define BUDGIE_BRIGHTNESS_UTIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_BRIGHTNESS_UTIL, BudgieBrightnessUtilClass))
#define BUDGIE_IS_BRIGHTNESS_UTIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_BRIGHTNESS_UTIL))
#define BUDGIE_IS_BRIGHTNESS_UTIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_BRIGHTNESS_UTIL))
#define BUDGIE_BRIGHTNESS_UTIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_BRIGHTNESS_UTIL, BudgieBrightnessUtilClass))

typedef struct _BudgieBrightnessUtil BudgieBrightnessUtil;
typedef struct _BudgieBrightnessUtilClass BudgieBrightnessUtilClass;
enum  {
	BUDGIE_BRIGHTNESS_HELPER_0_PROPERTY,
	BUDGIE_BRIGHTNESS_HELPER_NUM_PROPERTIES
};
static GParamSpec* budgie_brightness_helper_properties[BUDGIE_BRIGHTNESS_HELPER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _BudgieLogindSessionIface {
	GTypeInterface parent_iface;
	void (*SetBrightness) (BudgieLogindSession* self, const gchar* subsystem, const gchar* name, guint32 brightness, GError** error);
};

struct _BudgieBrightnessHelper {
	GApplication parent_instance;
	BudgieBrightnessHelperPrivate * priv;
};

struct _BudgieBrightnessHelperClass {
	GApplicationClass parent_class;
};

struct _BudgieBrightnessHelperPrivate {
	BudgieBrightnessUtil* util;
	BudgieLogindSession* logind_session;
};

static gint BudgieBrightnessHelper_private_offset;
static gpointer budgie_brightness_helper_parent_class = NULL;

VALA_EXTERN GType budgie_logind_session_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint budgie_logind_session_register_object (void* object,
                                             GDBusConnection* connection,
                                             const gchar* path,
                                             GError** error);
VALA_EXTERN GType budgie_logind_session_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieLogindSession, g_object_unref)
VALA_EXTERN void budgie_logind_session_SetBrightness (BudgieLogindSession* self,
                                          const gchar* subsystem,
                                          const gchar* name,
                                          guint32 brightness,
                                          GError** error);
static GType budgie_logind_session_get_type_once (void);
static void budgie_logind_session_proxy_g_signal (GDBusProxy* proxy,
                                           const gchar* sender_name,
                                           const gchar* signal_name,
                                           GVariant* parameters);
static void budgie_logind_session_proxy_SetBrightness (BudgieLogindSession* self,
                                                const gchar* subsystem,
                                                const gchar* name,
                                                guint32 brightness,
                                                GError** error);
static void budgie_logind_session_proxy_budgie_logind_session_interface_init (BudgieLogindSessionIface* iface);
static void _dbus_budgie_logind_session_SetBrightness (BudgieLogindSession* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation);
static void budgie_logind_session_dbus_interface_method_call (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* method_name,
                                                       GVariant* parameters,
                                                       GDBusMethodInvocation* invocation,
                                                       gpointer user_data);
static GVariant* budgie_logind_session_dbus_interface_get_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GError** error,
                                                             gpointer user_data);
static gboolean budgie_logind_session_dbus_interface_set_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GVariant* value,
                                                            GError** error,
                                                            gpointer user_data);
static void _budgie_logind_session_unregister_object (gpointer user_data);
VALA_EXTERN GType budgie_brightness_helper_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieBrightnessHelper, g_object_unref)
VALA_EXTERN GType budgie_brightness_util_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieBrightnessUtil, g_object_unref)
VALA_EXTERN BudgieBrightnessHelper* budgie_brightness_helper_new (void);
VALA_EXTERN BudgieBrightnessHelper* budgie_brightness_helper_construct (GType object_type);
VALA_EXTERN BudgieBrightnessUtil* budgie_brightness_util_new (void);
VALA_EXTERN BudgieBrightnessUtil* budgie_brightness_util_construct (GType object_type);
static gint budgie_brightness_helper_real_command_line (GApplication* base,
                                                 GApplicationCommandLine* cmd);
VALA_EXTERN gboolean budgie_brightness_util_find_backlight_device (BudgieBrightnessUtil* self);
static gboolean budgie_brightness_helper_setup_logind_session (BudgieBrightnessHelper* self);
VALA_EXTERN gboolean budgie_brightness_helper_increase_brightness (BudgieBrightnessHelper* self,
                                                       gint step_percent);
VALA_EXTERN gboolean budgie_brightness_helper_decrease_brightness (BudgieBrightnessHelper* self,
                                                       gint step_percent);
VALA_EXTERN gboolean budgie_brightness_helper_set_brightness_percent (BudgieBrightnessHelper* self,
                                                          gint percent);
VALA_EXTERN gchar* budgie_brightness_util_get_session_id (void);
VALA_EXTERN gboolean budgie_brightness_helper_set_brightness (BudgieBrightnessHelper* self,
                                                  guint32 value);
VALA_EXTERN const gchar* budgie_brightness_util_get_backlight_device (BudgieBrightnessUtil* self);
VALA_EXTERN gint budgie_brightness_util_get_max_brightness (BudgieBrightnessUtil* self);
VALA_EXTERN gint budgie_brightness_util_get_current_brightness (BudgieBrightnessUtil* self);
static gint budgie_brightness_helper_main (gchar** args,
                                    gint args_length1);
static void budgie_brightness_helper_finalize (GObject * obj);
static GType budgie_brightness_helper_get_type_once (void);

static const GDBusArgInfo _budgie_logind_session_dbus_arg_info_SetBrightness_subsystem = {-1, "subsystem", "s", NULL};
static const GDBusArgInfo _budgie_logind_session_dbus_arg_info_SetBrightness_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _budgie_logind_session_dbus_arg_info_SetBrightness_brightness = {-1, "brightness", "u", NULL};
static const GDBusArgInfo * const _budgie_logind_session_dbus_arg_info_SetBrightness_in[] = {&_budgie_logind_session_dbus_arg_info_SetBrightness_subsystem, &_budgie_logind_session_dbus_arg_info_SetBrightness_name, &_budgie_logind_session_dbus_arg_info_SetBrightness_brightness, NULL};
static const GDBusArgInfo * const _budgie_logind_session_dbus_arg_info_SetBrightness_out[] = {NULL};
static const GDBusMethodInfo _budgie_logind_session_dbus_method_info_SetBrightness = {-1, "SetBrightness", (GDBusArgInfo **) (&_budgie_logind_session_dbus_arg_info_SetBrightness_in), (GDBusArgInfo **) (&_budgie_logind_session_dbus_arg_info_SetBrightness_out), NULL};
static const GDBusMethodInfo * const _budgie_logind_session_dbus_method_info[] = {&_budgie_logind_session_dbus_method_info_SetBrightness, NULL};
static const GDBusSignalInfo * const _budgie_logind_session_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_logind_session_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_logind_session_dbus_interface_info = {-1, "org.freedesktop.login1.Session", (GDBusMethodInfo **) (&_budgie_logind_session_dbus_method_info), (GDBusSignalInfo **) (&_budgie_logind_session_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_logind_session_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_logind_session_dbus_interface_vtable = {budgie_logind_session_dbus_interface_method_call, budgie_logind_session_dbus_interface_get_property, budgie_logind_session_dbus_interface_set_property};

void
budgie_logind_session_SetBrightness (BudgieLogindSession* self,
                                     const gchar* subsystem,
                                     const gchar* name,
                                     guint32 brightness,
                                     GError** error)
{
	BudgieLogindSessionIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BUDGIE_LOGIND_SESSION_GET_INTERFACE (self);
	if (_iface_->SetBrightness) {
		_iface_->SetBrightness (self, subsystem, name, brightness, error);
	}
}

static void
budgie_logind_session_default_init (BudgieLogindSessionIface * iface,
                                    gpointer iface_data)
{
}

/**
* DBus interface for logind Session
*/
 G_GNUC_NO_INLINE static GType
budgie_logind_session_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieLogindSessionIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_logind_session_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType budgie_logind_session_type_id;
	budgie_logind_session_type_id = g_type_register_static (G_TYPE_INTERFACE, "BudgieLogindSession", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (budgie_logind_session_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (budgie_logind_session_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) budgie_logind_session_proxy_get_type);
	g_type_set_qdata (budgie_logind_session_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.login1.Session");
	g_type_set_qdata (budgie_logind_session_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_budgie_logind_session_dbus_interface_info));
	g_type_set_qdata (budgie_logind_session_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_logind_session_register_object);
	return budgie_logind_session_type_id;
}

GType
budgie_logind_session_get_type (void)
{
	static volatile gsize budgie_logind_session_type_id__once = 0;
	if (g_once_init_enter (&budgie_logind_session_type_id__once)) {
		GType budgie_logind_session_type_id;
		budgie_logind_session_type_id = budgie_logind_session_get_type_once ();
		g_once_init_leave (&budgie_logind_session_type_id__once, budgie_logind_session_type_id);
	}
	return budgie_logind_session_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (BudgieLogindSessionProxy, budgie_logind_session_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BUDGIE_TYPE_LOGIND_SESSION, budgie_logind_session_proxy_budgie_logind_session_interface_init) )
static void
budgie_logind_session_proxy_class_init (BudgieLogindSessionProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = budgie_logind_session_proxy_g_signal;
}

static void
budgie_logind_session_proxy_g_signal (GDBusProxy* proxy,
                                      const gchar* sender_name,
                                      const gchar* signal_name,
                                      GVariant* parameters)
{
}

static void
budgie_logind_session_proxy_init (BudgieLogindSessionProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_budgie_logind_session_dbus_interface_info));
}

static void
budgie_logind_session_proxy_SetBrightness (BudgieLogindSession* self,
                                           const gchar* subsystem,
                                           const gchar* name,
                                           guint32 brightness,
                                           GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.login1.Session", "SetBrightness");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (subsystem));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (brightness));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
budgie_logind_session_proxy_budgie_logind_session_interface_init (BudgieLogindSessionIface* iface)
{
	iface->SetBrightness = budgie_logind_session_proxy_SetBrightness;
}

static void
_dbus_budgie_logind_session_SetBrightness (BudgieLogindSession* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* subsystem = NULL;
	GVariant* _tmp0_;
	gchar* name = NULL;
	GVariant* _tmp1_;
	guint32 brightness = 0U;
	GVariant* _tmp2_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	subsystem = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	brightness = g_variant_get_uint32 (_tmp2_);
	g_variant_unref (_tmp2_);
	budgie_logind_session_SetBrightness (self, subsystem, name, brightness, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (subsystem);
	_g_free0 (name);
	;
}

static void
budgie_logind_session_dbus_interface_method_call (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* method_name,
                                                  GVariant* parameters,
                                                  GDBusMethodInvocation* invocation,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "SetBrightness") == 0) {
		_dbus_budgie_logind_session_SetBrightness (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
budgie_logind_session_dbus_interface_get_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_logind_session_dbus_interface_set_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GVariant* value,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
budgie_logind_session_register_object (gpointer object,
                                       GDBusConnection* connection,
                                       const gchar* path,
                                       GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_logind_session_dbus_interface_info), &_budgie_logind_session_dbus_interface_vtable, data, _budgie_logind_session_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_budgie_logind_session_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
budgie_brightness_helper_get_instance_private (BudgieBrightnessHelper* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieBrightnessHelper_private_offset);
}

BudgieBrightnessHelper*
budgie_brightness_helper_construct (GType object_type)
{
	BudgieBrightnessHelper * self = NULL;
	BudgieBrightnessUtil* _tmp0_;
	self = (BudgieBrightnessHelper*) g_object_new (object_type, "application-id", "org.buddiesofbudgie.BrightnessCLI", "flags", G_APPLICATION_HANDLES_COMMAND_LINE, NULL);
	g_application_add_main_option ((GApplication*) self, "up", 'u', G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, "Increase brightness", NULL);
	g_application_add_main_option ((GApplication*) self, "down", 'd', G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, "Decrease brightness", NULL);
	g_application_add_main_option ((GApplication*) self, "set", 's', G_OPTION_FLAG_NONE, G_OPTION_ARG_INT, "Set brightness to PERCENT (0-100)", "PERCENT");
	g_application_add_main_option ((GApplication*) self, "step", 't', G_OPTION_FLAG_NONE, G_OPTION_ARG_INT, "Step size for up/down (default: 5)", "PERCENT");
	_tmp0_ = budgie_brightness_util_new ();
	_g_object_unref0 (self->priv->util);
	self->priv->util = _tmp0_;
	return self;
}

BudgieBrightnessHelper*
budgie_brightness_helper_new (void)
{
	return budgie_brightness_helper_construct (BUDGIE_TYPE_BRIGHTNESS_HELPER);
}

static gpointer
_g_variant_dict_ref0 (gpointer self)
{
	return self ? g_variant_dict_ref (self) : NULL;
}

static gint
budgie_brightness_helper_real_command_line (GApplication* base,
                                            GApplicationCommandLine* cmd)
{
	BudgieBrightnessHelper * self;
	GVariantDict* options = NULL;
	GVariantDict* _tmp0_;
	GVariantDict* _tmp1_;
	BudgieBrightnessUtil* _tmp2_;
	gboolean opt_up = FALSE;
	GVariantDict* _tmp3_;
	gboolean opt_down = FALSE;
	GVariantDict* _tmp4_;
	gboolean has_set = FALSE;
	GVariantDict* _tmp5_;
	gint32 _tmp6_ = 0;
	gint opt_set = 0;
	gint32 _tmp11_ = 0;
	GVariantDict* _tmp12_;
	gint opt_step = 0;
	gboolean _tmp17_ = FALSE;
	gint commands_given = 0;
	gboolean success = FALSE;
	gint _tmp22_ = 0;
	gint result;
	self = (BudgieBrightnessHelper*) base;
	g_return_val_if_fail (cmd != NULL, 0);
	_tmp0_ = g_application_command_line_get_options_dict (cmd);
	_tmp1_ = _g_variant_dict_ref0 (_tmp0_);
	options = _tmp1_;
	_tmp2_ = self->priv->util;
	if (!budgie_brightness_util_find_backlight_device (_tmp2_)) {
		g_application_command_line_printerr (cmd, "Failed to find backlight device\n");
		result = 1;
		_g_variant_dict_unref0 (options);
		return result;
	}
	if (!budgie_brightness_helper_setup_logind_session (self)) {
		g_application_command_line_printerr (cmd, "Failed to connect to logind session\n");
		result = 1;
		_g_variant_dict_unref0 (options);
		return result;
	}
	_tmp3_ = options;
	opt_up = g_variant_dict_contains (_tmp3_, "up");
	_tmp4_ = options;
	opt_down = g_variant_dict_contains (_tmp4_, "down");
	_tmp5_ = options;
	has_set = g_variant_dict_contains (_tmp5_, "set");
	if (has_set) {
		GVariantDict* _tmp7_;
		const GVariantType* _tmp8_;
		GVariant* _tmp9_;
		GVariant* _tmp10_;
		_tmp7_ = options;
		_tmp8_ = G_VARIANT_TYPE_INT32;
		_tmp9_ = g_variant_dict_lookup_value (_tmp7_, "set", _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = g_variant_get_int32 (_tmp10_);
		_g_variant_unref0 (_tmp10_);
	} else {
		_tmp6_ = (gint32) -1;
	}
	opt_set = (gint) _tmp6_;
	_tmp12_ = options;
	if (g_variant_dict_contains (_tmp12_, "step")) {
		GVariantDict* _tmp13_;
		const GVariantType* _tmp14_;
		GVariant* _tmp15_;
		GVariant* _tmp16_;
		_tmp13_ = options;
		_tmp14_ = G_VARIANT_TYPE_INT32;
		_tmp15_ = g_variant_dict_lookup_value (_tmp13_, "step", _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp11_ = g_variant_get_int32 (_tmp16_);
		_g_variant_unref0 (_tmp16_);
	} else {
		_tmp11_ = (gint32) 5;
	}
	opt_step = (gint) _tmp11_;
	if (opt_step < 1) {
		_tmp17_ = TRUE;
	} else {
		_tmp17_ = opt_step > 100;
	}
	if (_tmp17_) {
		g_application_command_line_printerr (cmd, "Error: step must be between 1 and 100\n");
		result = 1;
		_g_variant_dict_unref0 (options);
		return result;
	}
	commands_given = 0;
	if (opt_up) {
		gint _tmp18_;
		_tmp18_ = commands_given;
		commands_given = _tmp18_ + 1;
	}
	if (opt_down) {
		gint _tmp19_;
		_tmp19_ = commands_given;
		commands_given = _tmp19_ + 1;
	}
	if (has_set) {
		gint _tmp20_;
		_tmp20_ = commands_given;
		commands_given = _tmp20_ + 1;
	}
	if (commands_given == 0) {
		g_application_command_line_printerr (cmd, "Error: Must specify one of --up, --down, or --set\n");
		g_application_command_line_printerr (cmd, "Run with --help for usage information\n");
		result = 1;
		_g_variant_dict_unref0 (options);
		return result;
	}
	if (commands_given > 1) {
		g_application_command_line_printerr (cmd, "Error: Cannot specify multiple commands (--up, --down, --set) simultan" \
"eously\n");
		result = 1;
		_g_variant_dict_unref0 (options);
		return result;
	}
	success = FALSE;
	if (opt_up) {
		success = budgie_brightness_helper_increase_brightness (self, opt_step);
	} else {
		if (opt_down) {
			success = budgie_brightness_helper_decrease_brightness (self, opt_step);
		} else {
			if (has_set) {
				gboolean _tmp21_ = FALSE;
				if (opt_set < 0) {
					_tmp21_ = TRUE;
				} else {
					_tmp21_ = opt_set > 100;
				}
				if (_tmp21_) {
					g_application_command_line_printerr (cmd, "Error: brightness percentage must be between 0 and 100\n");
					result = 1;
					_g_variant_dict_unref0 (options);
					return result;
				}
				success = budgie_brightness_helper_set_brightness_percent (self, opt_set);
			}
		}
	}
	if (success) {
		_tmp22_ = 0;
	} else {
		_tmp22_ = 1;
	}
	result = _tmp22_;
	_g_variant_dict_unref0 (options);
	return result;
}

static gboolean
budgie_brightness_helper_setup_logind_session (BudgieBrightnessHelper* self)
{
	gboolean _tmp12_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gchar* session_id = NULL;
		gchar* _tmp0_;
		gboolean _tmp1_ = FALSE;
		const gchar* _tmp2_;
		gchar* session_path = NULL;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		BudgieLogindSession* _tmp6_ = NULL;
		const gchar* _tmp7_;
		BudgieLogindSession* _tmp8_;
		BudgieLogindSession* _tmp9_;
		_tmp0_ = budgie_brightness_util_get_session_id ();
		session_id = _tmp0_;
		_tmp2_ = session_id;
		if (_tmp2_ == NULL) {
			_tmp1_ = TRUE;
		} else {
			const gchar* _tmp3_;
			_tmp3_ = session_id;
			_tmp1_ = g_strcmp0 (_tmp3_, "") == 0;
		}
		if (_tmp1_) {
			g_critical ("brightness-helper.vala:119: Could not determine session ID");
			result = FALSE;
			_g_free0 (session_id);
			return result;
		}
		_tmp4_ = session_id;
		_tmp5_ = g_build_filename ("/org/freedesktop/login1/session", _tmp4_, NULL);
		session_path = _tmp5_;
		_tmp7_ = session_path;
		_tmp8_ = (BudgieLogindSession*) g_initable_new (BUDGIE_TYPE_LOGIND_SESSION_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.freedesktop.login1", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _tmp7_, "g-interface-name", "org.freedesktop.login1.Session", NULL);
		_tmp6_ = (BudgieLogindSession*) _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (session_path);
			_g_free0 (session_id);
			goto __catch0_g_error;
		}
		_tmp9_ = _tmp6_;
		_tmp6_ = NULL;
		_g_object_unref0 (self->priv->logind_session);
		self->priv->logind_session = _tmp9_;
		result = TRUE;
		_g_object_unref0 (_tmp6_);
		_g_free0 (session_path);
		_g_free0 (session_id);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_critical ("brightness-helper.vala:134: Error connecting to logind: %s", _tmp11_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp12_;
}

gboolean
budgie_brightness_helper_set_brightness (BudgieBrightnessHelper* self,
                                         guint32 value)
{
	gboolean _tmp0_ = FALSE;
	BudgieLogindSession* _tmp1_;
	guint32 clamped = 0U;
	BudgieBrightnessUtil* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gboolean _tmp14_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->logind_session;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		BudgieBrightnessUtil* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = self->priv->util;
		_tmp3_ = budgie_brightness_util_get_backlight_device (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == NULL;
	}
	if (_tmp0_) {
		g_critical ("brightness-helper.vala:141: Brightness control not initialized");
		result = FALSE;
		return result;
	}
	_tmp5_ = self->priv->util;
	_tmp6_ = budgie_brightness_util_get_max_brightness (_tmp5_);
	_tmp7_ = _tmp6_;
	clamped = MIN (value, (guint32) _tmp7_);
	{
		BudgieLogindSession* _tmp8_;
		BudgieBrightnessUtil* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp8_ = self->priv->logind_session;
		_tmp9_ = self->priv->util;
		_tmp10_ = budgie_brightness_util_get_backlight_device (_tmp9_);
		_tmp11_ = _tmp10_;
		budgie_logind_session_SetBrightness (_tmp8_, "backlight", _tmp11_, clamped, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = TRUE;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_critical ("brightness-helper.vala:151: Failed to set brightness: %s", _tmp13_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp14_;
}

gboolean
budgie_brightness_helper_set_brightness_percent (BudgieBrightnessHelper* self,
                                                 gint percent)
{
	BudgieBrightnessUtil* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint clamped = 0;
	guint32 value = 0U;
	BudgieBrightnessUtil* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->util;
	_tmp1_ = budgie_brightness_util_get_max_brightness (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		g_critical ("brightness-helper.vala:158: Max brightness is 0");
		result = FALSE;
		return result;
	}
	clamped = CLAMP (percent, 0, 100);
	_tmp3_ = self->priv->util;
	_tmp4_ = budgie_brightness_util_get_max_brightness (_tmp3_);
	_tmp5_ = _tmp4_;
	value = (guint32) ((clamped * _tmp5_) / 100);
	result = budgie_brightness_helper_set_brightness (self, value);
	return result;
}

gboolean
budgie_brightness_helper_increase_brightness (BudgieBrightnessHelper* self,
                                              gint step_percent)
{
	BudgieBrightnessUtil* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint current_percent = 0;
	BudgieBrightnessUtil* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	BudgieBrightnessUtil* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint new_percent = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->util;
	_tmp1_ = budgie_brightness_util_get_max_brightness (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		g_critical ("brightness-helper.vala:169: Max brightness is 0");
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->util;
	_tmp4_ = budgie_brightness_util_get_current_brightness (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->util;
	_tmp7_ = budgie_brightness_util_get_max_brightness (_tmp6_);
	_tmp8_ = _tmp7_;
	current_percent = (_tmp5_ * 100) / _tmp8_;
	new_percent = CLAMP (current_percent + step_percent, 0, 100);
	result = budgie_brightness_helper_set_brightness_percent (self, new_percent);
	return result;
}

gboolean
budgie_brightness_helper_decrease_brightness (BudgieBrightnessHelper* self,
                                              gint step_percent)
{
	BudgieBrightnessUtil* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint current_percent = 0;
	BudgieBrightnessUtil* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	BudgieBrightnessUtil* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint new_percent = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->util;
	_tmp1_ = budgie_brightness_util_get_max_brightness (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		g_critical ("brightness-helper.vala:180: Max brightness is 0");
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->util;
	_tmp4_ = budgie_brightness_util_get_current_brightness (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->util;
	_tmp7_ = budgie_brightness_util_get_max_brightness (_tmp6_);
	_tmp8_ = _tmp7_;
	current_percent = (_tmp5_ * 100) / _tmp8_;
	new_percent = CLAMP (current_percent - step_percent, 0, 100);
	result = budgie_brightness_helper_set_brightness_percent (self, new_percent);
	return result;
}

static gint
budgie_brightness_helper_main (gchar** args,
                               gint args_length1)
{
	BudgieBrightnessHelper* app = NULL;
	BudgieBrightnessHelper* _tmp0_;
	gint result;
	_tmp0_ = budgie_brightness_helper_new ();
	app = _tmp0_;
	result = g_application_run ((GApplication*) app, (gint) args_length1, args);
	_g_object_unref0 (app);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return budgie_brightness_helper_main (argv, argc);
}

static void
budgie_brightness_helper_class_init (BudgieBrightnessHelperClass * klass,
                                     gpointer klass_data)
{
	budgie_brightness_helper_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieBrightnessHelper_private_offset);
	((GApplicationClass *) klass)->command_line = (gint (*) (GApplication*, GApplicationCommandLine*)) budgie_brightness_helper_real_command_line;
	G_OBJECT_CLASS (klass)->finalize = budgie_brightness_helper_finalize;
}

static void
budgie_brightness_helper_instance_init (BudgieBrightnessHelper * self,
                                        gpointer klass)
{
	self->priv = budgie_brightness_helper_get_instance_private (self);
	self->priv->logind_session = NULL;
}

static void
budgie_brightness_helper_finalize (GObject * obj)
{
	BudgieBrightnessHelper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_BRIGHTNESS_HELPER, BudgieBrightnessHelper);
	_g_object_unref0 (self->priv->util);
	_g_object_unref0 (self->priv->logind_session);
	G_OBJECT_CLASS (budgie_brightness_helper_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
budgie_brightness_helper_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieBrightnessHelperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_brightness_helper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieBrightnessHelper), 0, (GInstanceInitFunc) budgie_brightness_helper_instance_init, NULL };
	GType budgie_brightness_helper_type_id;
	budgie_brightness_helper_type_id = g_type_register_static (g_application_get_type (), "BudgieBrightnessHelper", &g_define_type_info, 0);
	BudgieBrightnessHelper_private_offset = g_type_add_instance_private (budgie_brightness_helper_type_id, sizeof (BudgieBrightnessHelperPrivate));
	return budgie_brightness_helper_type_id;
}

GType
budgie_brightness_helper_get_type (void)
{
	static volatile gsize budgie_brightness_helper_type_id__once = 0;
	if (g_once_init_enter (&budgie_brightness_helper_type_id__once)) {
		GType budgie_brightness_helper_type_id;
		budgie_brightness_helper_type_id = budgie_brightness_helper_get_type_once ();
		g_once_init_leave (&budgie_brightness_helper_type_id__once, budgie_brightness_helper_type_id);
	}
	return budgie_brightness_helper_type_id__once;
}

