/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	metav1 "github.com/cert-manager/cert-manager/pkg/client/applyconfigurations/meta/v1"
)

// ACMEIssuerApplyConfiguration represents a declarative configuration of the ACMEIssuer type for use
// with apply.
type ACMEIssuerApplyConfiguration struct {
	Email                       *string                                       `json:"email,omitempty"`
	Server                      *string                                       `json:"server,omitempty"`
	PreferredChain              *string                                       `json:"preferredChain,omitempty"`
	CABundle                    []byte                                        `json:"caBundle,omitempty"`
	SkipTLSVerify               *bool                                         `json:"skipTLSVerify,omitempty"`
	ExternalAccountBinding      *ACMEExternalAccountBindingApplyConfiguration `json:"externalAccountBinding,omitempty"`
	PrivateKey                  *metav1.SecretKeySelectorApplyConfiguration   `json:"privateKeySecretRef,omitempty"`
	Solvers                     []ACMEChallengeSolverApplyConfiguration       `json:"solvers,omitempty"`
	DisableAccountKeyGeneration *bool                                         `json:"disableAccountKeyGeneration,omitempty"`
	EnableDurationFeature       *bool                                         `json:"enableDurationFeature,omitempty"`
	Profile                     *string                                       `json:"profile,omitempty"`
}

// ACMEIssuerApplyConfiguration constructs a declarative configuration of the ACMEIssuer type for use with
// apply.
func ACMEIssuer() *ACMEIssuerApplyConfiguration {
	return &ACMEIssuerApplyConfiguration{}
}

// WithEmail sets the Email field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Email field is set to the value of the last call.
func (b *ACMEIssuerApplyConfiguration) WithEmail(value string) *ACMEIssuerApplyConfiguration {
	b.Email = &value
	return b
}

// WithServer sets the Server field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Server field is set to the value of the last call.
func (b *ACMEIssuerApplyConfiguration) WithServer(value string) *ACMEIssuerApplyConfiguration {
	b.Server = &value
	return b
}

// WithPreferredChain sets the PreferredChain field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PreferredChain field is set to the value of the last call.
func (b *ACMEIssuerApplyConfiguration) WithPreferredChain(value string) *ACMEIssuerApplyConfiguration {
	b.PreferredChain = &value
	return b
}

// WithCABundle adds the given value to the CABundle field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the CABundle field.
func (b *ACMEIssuerApplyConfiguration) WithCABundle(values ...byte) *ACMEIssuerApplyConfiguration {
	for i := range values {
		b.CABundle = append(b.CABundle, values[i])
	}
	return b
}

// WithSkipTLSVerify sets the SkipTLSVerify field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SkipTLSVerify field is set to the value of the last call.
func (b *ACMEIssuerApplyConfiguration) WithSkipTLSVerify(value bool) *ACMEIssuerApplyConfiguration {
	b.SkipTLSVerify = &value
	return b
}

// WithExternalAccountBinding sets the ExternalAccountBinding field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ExternalAccountBinding field is set to the value of the last call.
func (b *ACMEIssuerApplyConfiguration) WithExternalAccountBinding(value *ACMEExternalAccountBindingApplyConfiguration) *ACMEIssuerApplyConfiguration {
	b.ExternalAccountBinding = value
	return b
}

// WithPrivateKey sets the PrivateKey field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PrivateKey field is set to the value of the last call.
func (b *ACMEIssuerApplyConfiguration) WithPrivateKey(value *metav1.SecretKeySelectorApplyConfiguration) *ACMEIssuerApplyConfiguration {
	b.PrivateKey = value
	return b
}

// WithSolvers adds the given value to the Solvers field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Solvers field.
func (b *ACMEIssuerApplyConfiguration) WithSolvers(values ...*ACMEChallengeSolverApplyConfiguration) *ACMEIssuerApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithSolvers")
		}
		b.Solvers = append(b.Solvers, *values[i])
	}
	return b
}

// WithDisableAccountKeyGeneration sets the DisableAccountKeyGeneration field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DisableAccountKeyGeneration field is set to the value of the last call.
func (b *ACMEIssuerApplyConfiguration) WithDisableAccountKeyGeneration(value bool) *ACMEIssuerApplyConfiguration {
	b.DisableAccountKeyGeneration = &value
	return b
}

// WithEnableDurationFeature sets the EnableDurationFeature field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EnableDurationFeature field is set to the value of the last call.
func (b *ACMEIssuerApplyConfiguration) WithEnableDurationFeature(value bool) *ACMEIssuerApplyConfiguration {
	b.EnableDurationFeature = &value
	return b
}

// WithProfile sets the Profile field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Profile field is set to the value of the last call.
func (b *ACMEIssuerApplyConfiguration) WithProfile(value string) *ACMEIssuerApplyConfiguration {
	b.Profile = &value
	return b
}
