ECORE_CON_API ECORE_CON_API_WEAK Eina_Error efl_net_dialer_error_couldnt_connect_get(void)
{
   static Eina_Error err = EINA_ERROR_NO_ERROR;
   if (err == EINA_ERROR_NO_ERROR)
     err = eina_error_msg_static_register("Couldn\'t connect to server");
   return err;
}

ECORE_CON_API ECORE_CON_API_WEAK Eina_Error efl_net_dialer_error_couldnt_resolve_proxy_get(void)
{
   static Eina_Error err = EINA_ERROR_NO_ERROR;
   if (err == EINA_ERROR_NO_ERROR)
     err = eina_error_msg_static_register("Couldn\'t resolve proxy name");
   return err;
}

ECORE_CON_API ECORE_CON_API_WEAK Eina_Error efl_net_dialer_error_proxy_authentication_failed_get(void)
{
   static Eina_Error err = EINA_ERROR_NO_ERROR;
   if (err == EINA_ERROR_NO_ERROR)
     err = eina_error_msg_static_register("Proxy authentication failed");
   return err;
}

ECORE_CON_API ECORE_CON_API_WEAK const Efl_Event_Description _EFL_NET_DIALER_EVENT_DIALER_RESOLVED =
   EFL_EVENT_DESCRIPTION("dialer,resolved");
ECORE_CON_API ECORE_CON_API_WEAK const Efl_Event_Description _EFL_NET_DIALER_EVENT_DIALER_ERROR =
   EFL_EVENT_DESCRIPTION("dialer,error");
ECORE_CON_API ECORE_CON_API_WEAK const Efl_Event_Description _EFL_NET_DIALER_EVENT_DIALER_CONNECTED =
   EFL_EVENT_DESCRIPTION("dialer,connected");
ECORE_CON_API ECORE_CON_API_WEAK EFL_FUNC_BODYV(efl_net_dialer_dial, Eina_Error, 0, EFL_FUNC_CALL(address), const char *address);

static Eina_Error
__eolian_efl_net_dialer_address_dial_set_reflect(Eo *obj, Eina_Value val)
{
   Eina_Error r = 0;   const char *cval;
   if (!eina_value_string_convert(&val, &cval))
      {
         r = EINA_ERROR_VALUE_FAILED;
         goto end;
      }
   efl_net_dialer_address_dial_set(obj, cval);
 end:
   eina_value_flush(&val);
   return r;
}

ECORE_CON_API ECORE_CON_API_WEAK EFL_VOID_FUNC_BODYV(efl_net_dialer_address_dial_set, EFL_FUNC_CALL(address), const char *address);

static Eina_Value
__eolian_efl_net_dialer_address_dial_get_reflect(const Eo *obj)
{
   const char *val = efl_net_dialer_address_dial_get(obj);
   return eina_value_string_init(val);
}

ECORE_CON_API ECORE_CON_API_WEAK EFL_FUNC_BODY_CONST(efl_net_dialer_address_dial_get, const char *, NULL);

static Eina_Error
__eolian_efl_net_dialer_connected_set_reflect(Eo *obj, Eina_Value val)
{
   Eina_Error r = 0;   Eina_Bool cval;
   if (!eina_value_bool_convert(&val, &cval))
      {
         r = EINA_ERROR_VALUE_FAILED;
         goto end;
      }
   efl_net_dialer_connected_set(obj, cval);
 end:
   eina_value_flush(&val);
   return r;
}

ECORE_CON_API ECORE_CON_API_WEAK EFL_VOID_FUNC_BODYV(efl_net_dialer_connected_set, EFL_FUNC_CALL(connected), Eina_Bool connected);

static Eina_Value
__eolian_efl_net_dialer_connected_get_reflect(const Eo *obj)
{
   Eina_Bool val = efl_net_dialer_connected_get(obj);
   return eina_value_bool_init(val);
}

ECORE_CON_API ECORE_CON_API_WEAK EFL_FUNC_BODY_CONST(efl_net_dialer_connected_get, Eina_Bool, 0);

static Eina_Error
__eolian_efl_net_dialer_proxy_set_reflect(Eo *obj, Eina_Value val)
{
   Eina_Error r = 0;   const char *cval;
   if (!eina_value_string_convert(&val, &cval))
      {
         r = EINA_ERROR_VALUE_FAILED;
         goto end;
      }
   efl_net_dialer_proxy_set(obj, cval);
 end:
   eina_value_flush(&val);
   return r;
}

ECORE_CON_API ECORE_CON_API_WEAK EFL_VOID_FUNC_BODYV(efl_net_dialer_proxy_set, EFL_FUNC_CALL(proxy_url), const char *proxy_url);

static Eina_Value
__eolian_efl_net_dialer_proxy_get_reflect(const Eo *obj)
{
   const char *val = efl_net_dialer_proxy_get(obj);
   return eina_value_string_init(val);
}

ECORE_CON_API ECORE_CON_API_WEAK EFL_FUNC_BODY_CONST(efl_net_dialer_proxy_get, const char *, NULL);

static Eina_Error
__eolian_efl_net_dialer_timeout_dial_set_reflect(Eo *obj, Eina_Value val)
{
   Eina_Error r = 0;   double cval;
   if (!eina_value_double_convert(&val, &cval))
      {
         r = EINA_ERROR_VALUE_FAILED;
         goto end;
      }
   efl_net_dialer_timeout_dial_set(obj, cval);
 end:
   eina_value_flush(&val);
   return r;
}

ECORE_CON_API ECORE_CON_API_WEAK EFL_VOID_FUNC_BODYV(efl_net_dialer_timeout_dial_set, EFL_FUNC_CALL(seconds), double seconds);

static Eina_Value
__eolian_efl_net_dialer_timeout_dial_get_reflect(const Eo *obj)
{
   double val = efl_net_dialer_timeout_dial_get(obj);
   return eina_value_double_init(val);
}

ECORE_CON_API ECORE_CON_API_WEAK EFL_FUNC_BODY_CONST(efl_net_dialer_timeout_dial_get, double, 0);

static Eina_Bool
_efl_net_dialer_class_initializer(Efl_Class *klass)
{
   const Efl_Object_Ops *opsp = NULL;

   const Efl_Object_Property_Reflection_Ops *ropsp = NULL;

#ifndef EFL_NET_DIALER_EXTRA_OPS
#define EFL_NET_DIALER_EXTRA_OPS
#endif

   EFL_OPS_DEFINE(ops,
      EFL_OBJECT_OP_FUNC(efl_net_dialer_dial, NULL),
      EFL_OBJECT_OP_FUNC(efl_net_dialer_address_dial_set, NULL),
      EFL_OBJECT_OP_FUNC(efl_net_dialer_address_dial_get, NULL),
      EFL_OBJECT_OP_FUNC(efl_net_dialer_connected_set, NULL),
      EFL_OBJECT_OP_FUNC(efl_net_dialer_connected_get, NULL),
      EFL_OBJECT_OP_FUNC(efl_net_dialer_proxy_set, NULL),
      EFL_OBJECT_OP_FUNC(efl_net_dialer_proxy_get, NULL),
      EFL_OBJECT_OP_FUNC(efl_net_dialer_timeout_dial_set, NULL),
      EFL_OBJECT_OP_FUNC(efl_net_dialer_timeout_dial_get, NULL),
      EFL_NET_DIALER_EXTRA_OPS
   );
   opsp = &ops;

   static const Efl_Object_Property_Reflection refl_table[] = {
      {"address_dial", __eolian_efl_net_dialer_address_dial_set_reflect, __eolian_efl_net_dialer_address_dial_get_reflect},
      {"connected", __eolian_efl_net_dialer_connected_set_reflect, __eolian_efl_net_dialer_connected_get_reflect},
      {"proxy", __eolian_efl_net_dialer_proxy_set_reflect, __eolian_efl_net_dialer_proxy_get_reflect},
      {"timeout_dial", __eolian_efl_net_dialer_timeout_dial_set_reflect, __eolian_efl_net_dialer_timeout_dial_get_reflect},
   };
   static const Efl_Object_Property_Reflection_Ops rops = {
      refl_table, EINA_C_ARRAY_LENGTH(refl_table)
   };
   ropsp = &rops;

   return efl_class_functions_set(klass, opsp, ropsp);
}

static const Efl_Class_Description _efl_net_dialer_class_desc = {
   EO_VERSION,
   "Efl.Net.Dialer",
   EFL_CLASS_TYPE_INTERFACE,
   0,
   _efl_net_dialer_class_initializer,
   NULL,
   NULL
};

EFL_DEFINE_CLASS(efl_net_dialer_interface_get, &_efl_net_dialer_class_desc, NULL, EFL_NET_SOCKET_INTERFACE, NULL);
