// Generated from libavfilter/vulkan/debayer.comp
const char *ff_source_debayer_comp =
"/*\n"
" *\n"
" * Copyright (c) 2025 Lynne <dev@lynne.ee>\n"
" *\n"
" * This file is part of FFmpeg.\n"
" *\n"
" * FFmpeg is free software; you can redistribute it and/or\n"
" * modify it under the terms of the GNU Lesser General Public\n"
" * License as published by the Free Software Foundation; either\n"
" * version 2.1 of the License, or (at your option) any later version.\n"
" *\n"
" * FFmpeg is distributed in the hope that it will be useful,\n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
" * Lesser General Public License for more details.\n"
" *\n"
" * You should have received a copy of the GNU Lesser General Public\n"
" * License along with FFmpeg; if not, write to the Free Software\n"
" * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA\n"
" */\n"
"\n"
"#define LD(xo, yo) \\\n"
"    (imageLoad(input_img[0], pos + ivec2((xo), (yo))).r)\n"
"\n"
"void debayer_bilinear(void)\n"
"{\n"
"    ivec2 pos = ivec2(gl_GlobalInvocationID.xy) << 1;\n"
"\n"
"    /* R basis */\n"
"    vec4 tl = vec4(LD(0, 0),\n"
"                   (LD(1, 0) + LD(-1, 0) + LD(0, 1) + LD(0, -1)) / 4.0f,\n"
"                   (LD(-1, -1) + LD(1, 1) + LD(-1, 1) + LD(1, -1)) / 4.0f,\n"
"                   1.0f);\n"
"    imageStore(output_img[0], pos, tl);\n"
"\n"
"    /* G1 basis */\n"
"    vec4 tr = vec4((LD(2, 0) + LD(0, 0)) / 2.0f,\n"
"                   LD(1, 0),\n"
"                   (LD(1, 1) + LD(1, -1)) / 2.0f,\n"
"                   1.0f);\n"
"    imageStore(output_img[0], pos + ivec2(1, 0), tr);\n"
"\n"
"    /* G2 basis */\n"
"    vec4 bl = vec4((LD(0, 2) + LD(0, 0)) / 2.0f,\n"
"                   LD(0, 1),\n"
"                   (LD(1, 1) + LD(-1, 1)) / 2.0f,\n"
"                   1.0f);\n"
"    imageStore(output_img[0], pos + ivec2(0, 1), bl);\n"
"\n"
"    /* B basis */\n"
"    vec4 br = vec4((LD(0, 0) + LD(2, 2) + LD(0, 2) + LD(2, 0)) / 4.0f,\n"
"                   (LD(2, 1) + LD(0, 1) + LD(1, 2) + LD(1, 0)) / 4.0f,\n"
"                   LD(1, 1),\n"
"                   1.0f);\n"
"    imageStore(output_img[0], pos + ivec2(1, 1), br);\n"
"}\n"
"\n"
"void debayer_bilinear_hq(void)\n"
"{\n"
"    ivec2 pos = ivec2(gl_GlobalInvocationID.xy) << 1;\n"
"\n"
"    /* R basis */\n"
"    vec4 tl = vec4(LD(0, 0),\n"
"                   (4.0f*LD(0, 0) + 2.0f*(LD(0, -1) + LD(0, 1) + LD(-1, 0) + LD(1, 0)) -\n"
"                    (LD(0, -2) + LD(0, 2) + LD(-2, 0) + LD(2, 0))) / 8.0f,\n"
"                   (12.0f*LD(0, 0) + 4.0f*(LD(-1, -1) + LD(-1, 1) + LD(1, -1) + LD(1, 1)) -\n"
"                    3.0f*(LD(0, -2) + LD(0, 2) + LD(-2, 0) + LD(2, 0))) / 16.0f,\n"
"                   1.0f);\n"
"    imageStore(output_img[0], pos, tl);\n"
"\n"
"    /* G1 basis */\n"
"    vec4 tr = vec4((10.0f*LD(1, 0) + 8.0f*(LD(0, 0) + LD(2, 0)) -\n"
"                    2.0f*(LD(0, -1) + LD(2, 1) + LD(0, 1) + LD(2, -1) + LD(-1, 0) + LD(3, 0)) +\n"
"                    LD(1, -2) + LD(1, 2)) / 16.0f,\n"
"                   LD(1, 0),\n"
"                   (10.0f*LD(1, 0) + 8.0f*(LD(1, -1) + LD(1, 1)) -\n"
"                    2.0f*(LD(0, -1) + LD(0, 1) + LD(2, -1) + LD(2, 1) + LD(1, -2) + LD(1, 2)) +\n"
"                    LD(-1, 0) + LD(3, 0)) / 16.0f,\n"
"                   1.0f);\n"
"    imageStore(output_img[0], pos + ivec2(1, 0), tr);\n"
"\n"
"\n"
"    /* G2 basis */\n"
"    vec4 bl = vec4((10.0f*LD(0, 1) + 8.0f*(LD(0, 0) + LD(0, 2)) -\n"
"                   2.0f*(LD(-1, 0) + LD(-1, 2) + LD(1, 0) + LD(1, 2) + LD(0, -1) + LD(0, 3)) +\n"
"                   LD(-2, 1) + LD(2, 1)) / 16.0f,\n"
"                   LD(0, 1),\n"
"                   (10.0f*LD(0, 1) + 8.0f*(LD(-1, 1) + LD(1, 1)) -\n"
"                   2.0f*(LD(-1, 0) + LD(1, 2) + LD(-1, 2) + LD(1, 0) + LD(-2, 1) + LD(2, 1)) +\n"
"                    LD(0, -1) + LD(0, 3)) / 16.0f,\n"
"                   1.0f);\n"
"    imageStore(output_img[0], pos + ivec2(0, 1), bl);\n"
"\n"
"    /* B basis */\n"
"    vec4 br = vec4((12.0f*LD(1, 1) + 4.0f*(LD(0, 0) + LD(0, 2) + LD(2, 0) + LD(2, 2)) -\n"
"                    3.0f*(LD(1, -1) + LD(1, 3) + LD(-1, 1) + LD(3, 1))) / 16.0f,\n"
"                   (4.0f*LD(1, 1) + 2.0f*(LD(1, 0) + LD(1, 2) + LD(0, 1) + LD(2, 1)) -\n"
"                    (LD(1, -1) + LD(1, 3) + LD(-1, 1) + LD(3, 1))) / 8.0f,\n"
"                   LD(1, 1),\n"
"                   1.0f);\n"
"    imageStore(output_img[0], pos + ivec2(1, 1), br);\n"
"}\n"
;
