/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM OfflineAudioCompletionEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "OfflineAudioCompletionEvent.h"
#include "OfflineAudioCompletionEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/AudioBuffer.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/OfflineAudioCompletionEvent.h"
#include "mozilla/dom/PrimitiveConversions.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(OfflineAudioCompletionEvent)

NS_IMPL_ADDREF_INHERITED(OfflineAudioCompletionEvent, Event)
NS_IMPL_RELEASE_INHERITED(OfflineAudioCompletionEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(OfflineAudioCompletionEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mRenderedBuffer)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(OfflineAudioCompletionEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(OfflineAudioCompletionEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mRenderedBuffer)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(OfflineAudioCompletionEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

OfflineAudioCompletionEvent::OfflineAudioCompletionEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

OfflineAudioCompletionEvent::~OfflineAudioCompletionEvent()
{
}

OfflineAudioCompletionEvent*
OfflineAudioCompletionEvent::AsOfflineAudioCompletionEvent()
{
  return this;
}

JSObject*
OfflineAudioCompletionEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return OfflineAudioCompletionEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<OfflineAudioCompletionEvent>
OfflineAudioCompletionEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const OfflineAudioCompletionEventInit& aEventInitDict)
{
  RefPtr<OfflineAudioCompletionEvent> e = new OfflineAudioCompletionEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mRenderedBuffer = aEventInitDict.mRenderedBuffer;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<OfflineAudioCompletionEvent>
OfflineAudioCompletionEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const OfflineAudioCompletionEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

AudioBuffer*
OfflineAudioCompletionEvent::RenderedBuffer() const
{
  return mRenderedBuffer;
}


} // namespace mozilla::dom
