//
// Automatically generated by ipdlc.
// Edit at your own risk
//

#ifndef SessionStoreTypes_h
#define SessionStoreTypes_h

#include "mozilla/Attributes.h"
#include "IPCMessageStart.h"
#include "mozilla/RefPtr.h"
#include "nsString.h"
#include "nsTArray.h"
#include "nsTHashtable.h"
#include "mozilla/MozPromise.h"
#include "mozilla/OperatorNewExtensions.h"
#include "mozilla/UniquePtr.h"
#include "mozilla/ipc/ByteBuf.h"
#include "mozilla/ipc/FileDescriptor.h"
#include "mozilla/ipc/IPCForwards.h"
#include "mozilla/ipc/Shmem.h"

// Headers for typedefs
#include "mozilla/ipc/IPDLStructMember.h"
#include "mozilla/dom/CustomElementTypes.h"
#include "mozilla/dom/DOMTypes.h"


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct Checkbox|
//
namespace mozilla {
namespace dom {
namespace sessionstore {
class Checkbox final
{
private:

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    Checkbox() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT Checkbox(const bool& _value) :
        value_(_value)
    {
    }

    MOZ_IMPLICIT Checkbox(bool&& _value) :
        value_(std::move(_value))
    {
    }

    bool&
    value()
    {
        return value_;
    }
    const bool&
    value() const
    {
        return value_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<bool> value_;
};
} // namespace sessionstore
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::sessionstore::Checkbox>
{
    typedef ::mozilla::dom::sessionstore::Checkbox paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct TextField|
//
namespace mozilla {
namespace dom {
namespace sessionstore {
class TextField final
{
private:
    typedef ::nsString nsString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    TextField() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT TextField(const nsString& _value) :
        value_(_value)
    {
    }

    MOZ_IMPLICIT TextField(nsString&& _value) :
        value_(std::move(_value))
    {
    }

    nsString&
    value()
    {
        return value_;
    }
    const nsString&
    value() const
    {
        return value_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> value_;
};
} // namespace sessionstore
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::sessionstore::TextField>
{
    typedef ::mozilla::dom::sessionstore::TextField paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FileList|
//
namespace mozilla {
namespace dom {
namespace sessionstore {
class FileList final
{
private:
    typedef ::nsString nsString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FileList() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FileList(const nsTArray<nsString>& _valueList) :
        valueList_(_valueList)
    {
    }

    MOZ_IMPLICIT FileList(nsTArray<nsString>&& _valueList) :
        valueList_(std::move(_valueList))
    {
    }

    nsTArray<nsString>&
    valueList()
    {
        return valueList_;
    }
    const nsTArray<nsString>&
    valueList() const
    {
        return valueList_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<nsString>> valueList_;
};
} // namespace sessionstore
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::sessionstore::FileList>
{
    typedef ::mozilla::dom::sessionstore::FileList paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct SingleSelect|
//
namespace mozilla {
namespace dom {
namespace sessionstore {
class SingleSelect final
{
private:
    typedef ::uint32_t uint32_t;
    typedef ::nsString nsString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    SingleSelect() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT SingleSelect(
            const uint32_t& _index,
            const nsString& _value) :
        value_(_value),
        index_(_index)
    {
    }

    MOZ_IMPLICIT SingleSelect(
            uint32_t&& _index,
            nsString&& _value) :
        value_(std::move(_value)),
        index_(std::move(_index))
    {
    }

    uint32_t&
    index()
    {
        return index_;
    }
    const uint32_t&
    index() const
    {
        return index_;
    }

    nsString&
    value()
    {
        return value_;
    }
    const nsString&
    value() const
    {
        return value_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> value_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> index_;
};
} // namespace sessionstore
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::sessionstore::SingleSelect>
{
    typedef ::mozilla::dom::sessionstore::SingleSelect paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct MultipleSelect|
//
namespace mozilla {
namespace dom {
namespace sessionstore {
class MultipleSelect final
{
private:
    typedef ::nsString nsString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    MultipleSelect() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT MultipleSelect(const nsTArray<nsString>& _valueList) :
        valueList_(_valueList)
    {
    }

    MOZ_IMPLICIT MultipleSelect(nsTArray<nsString>&& _valueList) :
        valueList_(std::move(_valueList))
    {
    }

    nsTArray<nsString>&
    valueList()
    {
        return valueList_;
    }
    const nsTArray<nsString>&
    valueList() const
    {
        return valueList_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<nsString>> valueList_;
};
} // namespace sessionstore
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::sessionstore::MultipleSelect>
{
    typedef ::mozilla::dom::sessionstore::MultipleSelect paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union FormEntryValue|
//
namespace mozilla {
namespace dom {
namespace sessionstore {
class FormEntryValue final
{
public:
    enum Type {
        T__None,
        TCheckbox = 1,
        TTextField,
        TFileList,
        TSingleSelect,
        TMultipleSelect,
        TCustomElementTuple,
        T__Last = TCustomElementTuple
    };

private:
    typedef ::mozilla::dom::sessionstore::Checkbox Checkbox;
    typedef ::mozilla::dom::sessionstore::TextField TextField;
    typedef ::mozilla::dom::sessionstore::FileList FileList;
    typedef ::mozilla::dom::sessionstore::SingleSelect SingleSelect;
    typedef ::mozilla::dom::sessionstore::MultipleSelect MultipleSelect;
    typedef ::mozilla::dom::CustomElementTuple CustomElementTuple;
    typedef Checkbox Checkbox__tdef;
    typedef TextField TextField__tdef;
    typedef FileList FileList__tdef;
    typedef SingleSelect SingleSelect__tdef;
    typedef MultipleSelect MultipleSelect__tdef;
    typedef CustomElementTuple CustomElementTuple__tdef;

    Checkbox*
    ptr_Checkbox()
    {
        return (&(mVCheckbox));
    }
    const Checkbox*
    constptr_Checkbox() const
    {
        return (&(mVCheckbox));
    }
    TextField*
    ptr_TextField()
    {
        return (&(mVTextField));
    }
    const TextField*
    constptr_TextField() const
    {
        return (&(mVTextField));
    }
    FileList*
    ptr_FileList()
    {
        return (&(mVFileList));
    }
    const FileList*
    constptr_FileList() const
    {
        return (&(mVFileList));
    }
    SingleSelect*
    ptr_SingleSelect()
    {
        return (&(mVSingleSelect));
    }
    const SingleSelect*
    constptr_SingleSelect() const
    {
        return (&(mVSingleSelect));
    }
    MultipleSelect*
    ptr_MultipleSelect()
    {
        return (&(mVMultipleSelect));
    }
    const MultipleSelect*
    constptr_MultipleSelect() const
    {
        return (&(mVMultipleSelect));
    }
    CustomElementTuple*
    ptr_CustomElementTuple()
    {
        return (&(mVCustomElementTuple));
    }
    const CustomElementTuple*
    constptr_CustomElementTuple() const
    {
        return (&(mVCustomElementTuple));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT FormEntryValue() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT FormEntryValue(const Checkbox& aOther);

    MOZ_IMPLICIT FormEntryValue(Checkbox&& aOther);

    MOZ_IMPLICIT FormEntryValue(const TextField& aOther);

    MOZ_IMPLICIT FormEntryValue(TextField&& aOther);

    MOZ_IMPLICIT FormEntryValue(const FileList& aOther);

    MOZ_IMPLICIT FormEntryValue(FileList&& aOther);

    MOZ_IMPLICIT FormEntryValue(const SingleSelect& aOther);

    MOZ_IMPLICIT FormEntryValue(SingleSelect&& aOther);

    MOZ_IMPLICIT FormEntryValue(const MultipleSelect& aOther);

    MOZ_IMPLICIT FormEntryValue(MultipleSelect&& aOther);

    MOZ_IMPLICIT FormEntryValue(const CustomElementTuple& aOther);

    MOZ_IMPLICIT FormEntryValue(CustomElementTuple&& aOther);

    MOZ_IMPLICIT FormEntryValue(const FormEntryValue& aOther);

    MOZ_IMPLICIT FormEntryValue(FormEntryValue&& aOther);

    ~FormEntryValue();

    Type
    type() const
    {
        return mType;
    }

    FormEntryValue&
    operator=(const Checkbox& aRhs);

    FormEntryValue&
    operator=(Checkbox&& aRhs);

    FormEntryValue&
    operator=(const TextField& aRhs);

    FormEntryValue&
    operator=(TextField&& aRhs);

    FormEntryValue&
    operator=(const FileList& aRhs);

    FormEntryValue&
    operator=(FileList&& aRhs);

    FormEntryValue&
    operator=(const SingleSelect& aRhs);

    FormEntryValue&
    operator=(SingleSelect&& aRhs);

    FormEntryValue&
    operator=(const MultipleSelect& aRhs);

    FormEntryValue&
    operator=(MultipleSelect&& aRhs);

    FormEntryValue&
    operator=(const CustomElementTuple& aRhs);

    FormEntryValue&
    operator=(CustomElementTuple&& aRhs);

    FormEntryValue&
    operator=(const FormEntryValue& aRhs);

    FormEntryValue&
    operator=(FormEntryValue&& aRhs);

    Checkbox&
    get_Checkbox()
    {
        AssertSanity(TCheckbox);
        return (*(ptr_Checkbox()));
    }
    const Checkbox&
    get_Checkbox() const
    {
        AssertSanity(TCheckbox);
        return (*(constptr_Checkbox()));
    }
    operator Checkbox&()
    {
        return get_Checkbox();
    }
    operator const Checkbox&() const
    {
        return get_Checkbox();
    }

    TextField&
    get_TextField()
    {
        AssertSanity(TTextField);
        return (*(ptr_TextField()));
    }
    const TextField&
    get_TextField() const
    {
        AssertSanity(TTextField);
        return (*(constptr_TextField()));
    }
    operator TextField&()
    {
        return get_TextField();
    }
    operator const TextField&() const
    {
        return get_TextField();
    }

    FileList&
    get_FileList()
    {
        AssertSanity(TFileList);
        return (*(ptr_FileList()));
    }
    const FileList&
    get_FileList() const
    {
        AssertSanity(TFileList);
        return (*(constptr_FileList()));
    }
    operator FileList&()
    {
        return get_FileList();
    }
    operator const FileList&() const
    {
        return get_FileList();
    }

    SingleSelect&
    get_SingleSelect()
    {
        AssertSanity(TSingleSelect);
        return (*(ptr_SingleSelect()));
    }
    const SingleSelect&
    get_SingleSelect() const
    {
        AssertSanity(TSingleSelect);
        return (*(constptr_SingleSelect()));
    }
    operator SingleSelect&()
    {
        return get_SingleSelect();
    }
    operator const SingleSelect&() const
    {
        return get_SingleSelect();
    }

    MultipleSelect&
    get_MultipleSelect()
    {
        AssertSanity(TMultipleSelect);
        return (*(ptr_MultipleSelect()));
    }
    const MultipleSelect&
    get_MultipleSelect() const
    {
        AssertSanity(TMultipleSelect);
        return (*(constptr_MultipleSelect()));
    }
    operator MultipleSelect&()
    {
        return get_MultipleSelect();
    }
    operator const MultipleSelect&() const
    {
        return get_MultipleSelect();
    }

    CustomElementTuple&
    get_CustomElementTuple()
    {
        AssertSanity(TCustomElementTuple);
        return (*(ptr_CustomElementTuple()));
    }
    const CustomElementTuple&
    get_CustomElementTuple() const
    {
        AssertSanity(TCustomElementTuple);
        return (*(constptr_CustomElementTuple()));
    }
    operator CustomElementTuple&()
    {
        return get_CustomElementTuple();
    }
    operator const CustomElementTuple&() const
    {
        return get_CustomElementTuple();
    }

private:
    union {
        Checkbox mVCheckbox;
        TextField mVTextField;
        FileList mVFileList;
        SingleSelect mVSingleSelect;
        MultipleSelect mVMultipleSelect;
        CustomElementTuple mVCustomElementTuple;
    };
    Type mType;
};
} // namespace sessionstore
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::sessionstore::FormEntryValue>
{
    typedef ::mozilla::dom::sessionstore::FormEntryValue paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FormEntry|
//
namespace mozilla {
namespace dom {
namespace sessionstore {
class FormEntry final
{
private:
    typedef ::nsString nsString;
    typedef ::mozilla::dom::sessionstore::FormEntryValue FormEntryValue;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FormEntry() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FormEntry(
            const nsString& _id,
            const FormEntryValue& _value) :
        id_(_id),
        value_(_value)
    {
    }

    MOZ_IMPLICIT FormEntry(
            nsString&& _id,
            FormEntryValue&& _value) :
        id_(std::move(_id)),
        value_(std::move(_value))
    {
    }

    nsString&
    id()
    {
        return id_;
    }
    const nsString&
    id() const
    {
        return id_;
    }

    FormEntryValue&
    value()
    {
        return value_;
    }
    const FormEntryValue&
    value() const
    {
        return value_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> id_;
    ::mozilla::ipc::IPDLStructMember<FormEntryValue> value_;
};
} // namespace sessionstore
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::sessionstore::FormEntry>
{
    typedef ::mozilla::dom::sessionstore::FormEntry paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FormData|
//
namespace mozilla {
namespace dom {
namespace sessionstore {
class FormData final
{
private:
    typedef ::mozilla::dom::sessionstore::FormEntry FormEntry;
    typedef ::nsString nsString;
    typedef ::nsCString nsCString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FormData() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FormData(
            const bool& _hasData,
            const nsTArray<FormEntry>& _id,
            const nsTArray<FormEntry>& _xpath,
            const nsString& _innerHTML,
            const nsCString& _uri) :
        hasData_(_hasData),
        id_(_id),
        xpath_(_xpath),
        innerHTML_(_innerHTML),
        uri_(_uri)
    {
    }

    MOZ_IMPLICIT FormData(
            bool&& _hasData,
            nsTArray<FormEntry>&& _id,
            nsTArray<FormEntry>&& _xpath,
            nsString&& _innerHTML,
            nsCString&& _uri) :
        hasData_(std::move(_hasData)),
        id_(std::move(_id)),
        xpath_(std::move(_xpath)),
        innerHTML_(std::move(_innerHTML)),
        uri_(std::move(_uri))
    {
    }

    bool&
    hasData()
    {
        return hasData_;
    }
    const bool&
    hasData() const
    {
        return hasData_;
    }

    nsTArray<FormEntry>&
    id()
    {
        return id_;
    }
    const nsTArray<FormEntry>&
    id() const
    {
        return id_;
    }

    nsTArray<FormEntry>&
    xpath()
    {
        return xpath_;
    }
    const nsTArray<FormEntry>&
    xpath() const
    {
        return xpath_;
    }

    nsString&
    innerHTML()
    {
        return innerHTML_;
    }
    const nsString&
    innerHTML() const
    {
        return innerHTML_;
    }

    nsCString&
    uri()
    {
        return uri_;
    }
    const nsCString&
    uri() const
    {
        return uri_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<bool> hasData_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<FormEntry>> id_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<FormEntry>> xpath_;
    ::mozilla::ipc::IPDLStructMember<nsString> innerHTML_;
    ::mozilla::ipc::IPDLStructMember<nsCString> uri_;
};
} // namespace sessionstore
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::sessionstore::FormData>
{
    typedef ::mozilla::dom::sessionstore::FormData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct DocShellRestoreState|
//
namespace mozilla {
namespace dom {
namespace sessionstore {
class DocShellRestoreState final
{
private:
    typedef ::nsIURI nsIURI;
    typedef ::nsCString nsCString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    DocShellRestoreState() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT DocShellRestoreState(
            nsIURI* _URI,
            const nsCString& _docShellCaps) :
        URI_(_URI),
        docShellCaps_(_docShellCaps)
    {
    }

    MOZ_IMPLICIT DocShellRestoreState(
            RefPtr<nsIURI>&& _URI,
            nsCString&& _docShellCaps) :
        URI_(std::move(_URI)),
        docShellCaps_(std::move(_docShellCaps))
    {
    }

    RefPtr<nsIURI>&
    URI()
    {
        return URI_;
    }
    nsIURI*
    URI() const
    {
        return URI_;
    }

    nsCString&
    docShellCaps()
    {
        return docShellCaps_;
    }
    const nsCString&
    docShellCaps() const
    {
        return docShellCaps_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<RefPtr<nsIURI>> URI_;
    ::mozilla::ipc::IPDLStructMember<nsCString> docShellCaps_;
};
} // namespace sessionstore
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::sessionstore::DocShellRestoreState>
{
    typedef ::mozilla::dom::sessionstore::DocShellRestoreState paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

#endif // ifndef SessionStoreTypes_h
