//
// Setting and shell dialogs for the Fast Light Tool Kit (FLTK).
//
// Copyright 1998-2023 by Bill Spitzak and others.
//
// This library is free software. Distribution and use rights are outlined in
// the file "COPYING" which should have been included with this file.  If this
// file is missing or damaged, see the license at:
//
//     https://www.fltk.org/COPYING.php
//
// Please see the following page on how to report bugs and issues:
//
//     https://www.fltk.org/bugs.php
//

// generated by Fast Light User Interface Designer (fluid) version 1.0402

#include "settings_panel.h"
#include "undo.h"
#include <FL/Fl_Preferences.H>
#include <FL/Fl_Tooltip.H>
#include <FL/fl_ask.H>
#include <string.h>
#include "../src/flstring.h"
void scheme_cb(Fl_Scheme_Choice *, void *);
int w_settings_shell_list_selected;

static void cb_Comments(Fl_Choice* o, void* v) {
  Fl_Font *font = (Fl_Font*)o->user_data();
  if (v == LOAD) {
    o->value(*font);
  } else {
    *font = (int)o->value();
    widget_browser->redraw();
    widget_browser->save_prefs();
  }
}

static void cb_Color_Chip(Fl_Button* o, void* v) {
  Fl_Color *color = (Fl_Color*)o->user_data();
  if (v == LOAD) {
    o->color(*color);
    o->redraw();
  } else {
    Fl_Color d = fl_show_colormap(*color);
    *color = d;
    o->color(d);
    widget_browser->redraw();
    widget_browser->save_prefs();
  }
}

static void cb_Color_Choice(Fl_Menu_Button* o, void* v) {
  if (v != LOAD) {
    Fl_Color *color = (Fl_Color*)o->user_data();
    Fl_Color d = (Fl_Color)(o->mvalue()->argument());
    *color = d;
    o->parent()->do_callback(o->parent(), LOAD);
    widget_browser->redraw();
    widget_browser->save_prefs();
  }
}

Fl_Double_Window *script_panel=(Fl_Double_Window *)0;

static void cb_script_panel(Fl_Double_Window*, void*) {
  if (Fl::event()==FL_SHORTCUT && Fl::event_key()==FL_Escape)
    return; // ignore Escape
  script_panel->hide(); // otherwise hide..;
}

Fl_Text_Editor *script_input=(Fl_Text_Editor *)0;

Fl_Return_Button *script_panel_ok=(Fl_Return_Button *)0;

Fl_Button *script_panel_cancel=(Fl_Button *)0;

Fl_Double_Window* make_script_panel() {
  { Fl_Double_Window* o = script_panel = new Fl_Double_Window(540, 180, "Shell Script Editor");
    script_panel->labelsize(11);
    script_panel->callback((Fl_Callback*)cb_script_panel);
    { script_input = new Fl_Text_Editor(10, 10, 520, 130);
      script_input->box(FL_DOWN_BOX);
      script_input->labelsize(11);
      script_input->textfont(4);
      script_input->textsize(11);
      script_input->when(FL_WHEN_RELEASE | FL_WHEN_CHANGED | FL_WHEN_ENTER_KEY);
      Fl_Group::current()->resizable(script_input);
      script_input->buffer(new Fl_Text_Buffer);
    } // Fl_Text_Editor* script_input
    { Fl_Group* o = new Fl_Group(10, 150, 520, 20);
      o->labelsize(11);
      o->callback((Fl_Callback*)propagate_load);
      { script_panel_ok = new Fl_Return_Button(400, 150, 60, 20, "OK");
        script_panel_ok->labelsize(11);
        script_panel_ok->window()->hotspot(script_panel_ok);
      } // Fl_Return_Button* script_panel_ok
      { script_panel_cancel = new Fl_Button(470, 150, 60, 20, "Cancel");
        script_panel_cancel->labelsize(11);
      } // Fl_Button* script_panel_cancel
      { Fl_Box* o = new Fl_Box(10, 150, 380, 20);
        o->labelsize(11);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      o->end();
    } // Fl_Group* o
    script_panel->set_modal();
    o->size_range(200, 150);
    script_panel->end();
  } // Fl_Double_Window* script_panel
  // Enable line numbers
  script_input->linenumber_width(60);
  script_input->linenumber_size(script_input->Fl_Text_Display::textsize());
  return script_panel;
}

Fl_Double_Window *settings_window=(Fl_Double_Window *)0;

Fl_Tabs *w_settings_tabs=(Fl_Tabs *)0;

static void cb_w_settings_tabs(Fl_Tabs* o, void* v) {
  propagate_load(o, v);
}

Fl_Group *w_settings_general_tab=(Fl_Group *)0;

#include <FL/Fl_PNG_Image.H>

static const unsigned char idata_general_64[] =
{137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,96,0,0,0,64,8,4,0,0,0,
79,61,186,133,0,0,8,57,73,68,65,84,104,222,205,154,107,112,85,213,21,199,127,
151,60,185,36,18,66,204,131,120,155,82,136,163,131,4,41,180,130,36,2,117,8,15,
173,58,109,103,168,97,42,67,135,78,167,84,16,59,118,192,41,29,201,244,3,14,182,
14,62,74,77,149,42,12,226,180,160,130,19,32,136,144,34,193,240,104,136,52,193,
18,196,16,200,131,128,121,191,47,185,247,158,126,72,206,221,251,60,238,189,39,
112,46,115,247,249,178,207,217,123,159,179,214,218,107,173,255,90,107,31,176,
187,37,81,72,13,237,184,25,196,135,130,130,143,65,220,180,83,67,33,73,68,120,
203,162,114,152,108,179,203,199,89,178,34,155,129,210,128,196,171,87,73,36,147,
63,11,119,72,6,220,60,108,231,39,71,217,204,64,108,200,57,177,204,180,243,147,
209,182,50,112,175,191,167,188,231,72,197,65,52,224,65,225,58,43,20,28,195,99,
223,139,92,6,114,212,206,115,142,185,196,73,3,110,86,59,222,80,111,210,34,87,
133,198,169,157,4,162,52,3,81,36,138,155,187,35,149,129,120,225,229,83,116,12,
140,98,172,184,153,100,231,190,223,202,171,82,153,137,135,47,185,161,123,158,41,
196,156,233,87,120,149,1,9,193,146,201,160,94,183,54,141,217,140,226,20,141,225,
118,148,73,108,167,29,47,30,218,216,71,174,127,7,147,216,196,13,225,44,15,40,77,
186,107,135,236,74,27,217,64,130,95,132,115,41,166,29,47,94,58,217,65,114,56,
201,143,231,51,157,79,175,100,5,78,150,114,69,198,95,151,114,204,192,64,137,30,
147,107,200,39,129,149,124,201,77,205,200,49,156,225,99,96,155,73,152,224,165,
89,71,130,50,77,57,99,96,224,164,114,191,126,229,0,205,120,77,194,141,183,71,
66,82,212,8,230,174,96,131,201,124,135,222,229,36,243,56,15,51,90,55,109,144,
38,174,208,175,181,191,4,157,169,12,189,47,135,58,254,107,149,40,135,101,242,
93,156,9,237,193,103,243,20,51,112,201,78,83,69,54,186,168,231,52,123,249,79,
232,111,53,49,203,96,230,183,189,3,219,69,8,176,148,181,164,114,141,30,205,132,
251,89,199,175,153,77,154,6,194,132,164,226,73,101,42,115,152,200,101,58,52,99,
233,20,176,26,39,85,234,131,68,82,248,216,222,29,152,79,137,26,231,76,103,51,83,
232,161,150,227,236,163,122,120,66,1,203,185,143,24,11,175,114,83,205,54,246,
162,190,237,113,114,153,72,2,213,172,163,82,76,202,231,115,59,25,40,103,150,218,
45,98,201,240,198,221,164,145,51,236,231,48,235,249,57,169,35,48,167,38,118,
178,133,37,60,198,116,38,12,75,198,203,62,158,21,83,62,99,129,125,12,44,96,191,
42,220,103,88,39,34,6,192,199,13,174,49,137,187,70,232,208,218,185,194,4,82,52,
161,64,43,47,243,190,176,250,133,148,218,101,3,69,100,15,117,156,252,129,201,6,
39,148,97,170,245,193,219,104,210,25,163,147,159,19,39,187,5,101,99,196,205,
237,197,66,89,252,80,237,254,130,41,97,5,250,105,252,74,222,119,11,233,167,149,
88,104,145,240,138,249,254,8,32,120,243,209,78,61,77,12,224,32,142,76,92,36,89,
146,85,34,243,4,142,221,197,34,138,236,96,32,93,221,105,39,221,220,12,153,116,
41,92,163,140,35,156,160,205,15,109,121,60,202,28,241,162,32,30,106,64,214,206,
84,123,108,96,10,75,134,190,60,72,5,9,184,12,40,43,55,15,167,120,149,55,184,40,
161,110,63,53,28,164,137,52,210,131,238,67,43,31,179,70,150,196,238,208,168,103,
133,129,22,86,16,63,212,237,226,48,94,238,97,92,0,89,122,56,194,70,78,153,142,
93,228,44,46,178,2,176,160,112,137,191,179,89,235,168,126,79,167,29,12,116,16,
71,158,248,110,5,117,164,144,97,170,125,229,108,224,155,128,47,106,227,60,57,
100,154,170,78,25,175,242,145,252,200,203,75,28,180,203,141,30,167,139,92,161,
252,117,156,32,1,151,33,238,109,226,117,173,244,251,248,150,30,162,5,64,183,209,
203,15,12,142,160,133,15,249,147,31,211,1,232,225,69,94,67,177,211,195,61,194,
37,109,224,251,182,46,96,110,80,182,200,227,189,252,153,73,196,19,79,54,175,
211,47,70,182,42,13,186,149,127,211,135,212,53,214,107,71,214,115,226,207,153,
195,30,124,226,193,120,3,182,150,202,178,95,198,11,124,195,0,3,124,205,26,126,
41,220,203,33,218,13,121,146,198,3,239,33,143,47,194,145,212,95,103,169,216,
214,100,57,77,7,160,158,195,50,118,239,213,12,126,192,187,66,31,175,27,146,105,
167,176,229,215,88,106,200,182,109,171,74,248,168,81,187,19,12,154,220,68,159,
144,255,91,134,181,91,212,225,54,90,117,67,99,229,90,87,141,188,203,246,151,85,
226,84,255,25,101,88,234,22,221,78,174,26,86,54,8,151,216,106,32,34,74,128,215,
8,195,42,123,11,91,193,223,235,184,83,31,10,142,245,138,234,166,125,134,205,
145,138,47,247,24,86,126,71,24,77,138,65,51,189,194,6,220,225,101,224,1,85,142,
181,116,7,54,197,209,172,54,172,124,94,141,64,146,13,254,171,131,90,177,75,83,
71,70,211,72,38,167,113,128,85,194,78,187,12,89,127,190,184,89,201,211,154,193,
229,44,23,128,146,22,216,252,225,55,124,66,70,56,24,152,207,41,22,203,243,91,13,
69,187,31,201,174,253,31,188,233,7,178,34,138,132,134,45,212,100,116,67,193,
158,134,162,199,40,231,81,187,109,229,69,250,100,172,76,87,54,43,213,134,226,85,
133,242,99,45,162,246,210,72,147,118,229,83,74,165,97,93,149,242,178,146,174,93,
217,199,70,107,194,181,22,11,253,145,66,57,13,152,207,75,44,48,169,253,36,146,
202,89,127,22,0,196,144,72,162,92,170,200,102,189,116,10,34,82,201,251,152,70,
27,151,229,149,143,16,195,81,123,24,152,200,123,114,220,182,138,231,200,9,144,
9,165,227,226,188,204,130,166,101,179,145,135,76,5,27,141,139,7,137,149,195,
127,7,223,103,31,223,218,193,64,1,63,81,125,79,58,27,89,70,70,64,151,62,138,44,
166,209,195,69,147,177,39,89,207,67,1,83,64,7,227,200,97,50,135,196,163,88,234,
57,97,71,74,121,183,74,111,50,175,144,23,34,165,140,102,6,46,22,115,80,151,82,
46,100,54,169,33,176,108,28,63,229,119,101,228,74,229,4,91,146,250,102,134,15,
232,218,24,109,225,24,210,65,26,79,144,199,117,90,105,193,65,10,227,73,179,152,
212,199,176,39,247,103,226,182,214,30,6,74,232,86,235,86,37,76,53,49,94,51,85,
26,111,128,43,43,173,151,99,114,72,126,192,30,28,184,34,52,113,23,95,133,181,
46,84,205,54,57,15,252,202,30,6,224,21,6,85,161,236,209,1,152,66,43,103,13,168,
28,186,245,80,73,139,46,158,234,100,191,192,100,15,127,181,15,7,234,88,132,107,
168,91,197,84,178,135,249,246,208,72,41,239,178,137,104,38,90,44,121,169,185,
209,78,94,224,42,110,156,36,12,191,205,199,81,10,229,250,192,122,251,24,128,75,
20,168,246,210,192,116,82,233,231,2,197,108,229,45,254,199,32,95,208,69,186,
174,84,27,184,114,116,158,34,182,50,200,5,14,82,69,55,177,36,18,195,5,254,66,
131,40,237,254,150,175,173,16,102,61,70,223,141,223,61,60,205,60,170,217,171,59,
68,121,128,101,204,39,51,168,76,124,92,163,148,247,57,167,11,3,159,224,65,142,
179,67,60,250,132,39,173,145,101,243,17,211,92,22,51,131,239,50,198,100,172,143,
58,42,248,148,35,86,74,105,115,76,177,240,54,219,114,6,67,254,76,163,160,184,
148,103,149,42,67,192,118,94,121,94,113,41,86,214,227,97,101,120,242,129,237,
108,55,41,53,41,180,227,209,86,39,254,77,175,137,252,143,234,207,237,60,180,155,
150,174,118,241,78,184,50,178,53,148,233,72,56,199,90,238,165,128,58,249,113,
173,137,91,237,215,135,120,87,121,134,201,172,162,82,203,62,39,229,115,38,251,
91,10,219,232,196,135,143,46,138,89,228,143,44,82,40,164,89,168,65,177,65,133,
62,148,149,164,133,77,254,210,121,52,249,124,68,7,62,124,244,240,175,145,100,
99,183,90,41,112,145,11,148,209,168,195,161,108,42,212,56,99,167,156,157,1,112,
64,40,118,47,51,185,96,72,168,231,18,67,25,151,71,86,21,186,181,191,85,234,249,
192,244,249,101,90,85,6,26,241,233,180,179,95,6,225,6,195,218,70,118,221,153,
178,74,112,132,234,21,65,129,86,144,94,57,51,105,212,157,144,223,209,186,80,240,
230,167,178,75,103,153,62,249,232,168,206,206,79,218,251,207,220,57,230,13,117,
78,83,204,120,198,18,7,12,208,73,7,21,98,86,119,228,50,224,79,64,78,115,122,56,
93,71,174,249,12,181,139,145,203,64,57,110,109,113,182,207,56,103,144,114,34,
184,29,10,25,40,124,74,68,183,76,202,131,254,252,125,210,238,159,191,163,108,
102,160,155,127,210,133,147,49,68,161,224,192,1,40,120,241,208,73,37,239,176,
150,102,123,63,248,127,27,97,180,206,27,14,172,151,0,0,0,0,73,69,78,68,174,66,
96,130};
static Fl_Image *image_general_64() {
  static Fl_Image *image = NULL;
  if (!image)
    image = new Fl_PNG_Image("general_64.png", idata_general_64, 2162);
  return image;
}

static void cb_(Fl_Group* o, void* v) {
  propagate_load(o, v);
}

Fl_Scheme_Choice *scheme_choice=(Fl_Scheme_Choice *)0;

Fl_Check_Button *tooltips_button=(Fl_Check_Button *)0;

static void cb_tooltips_button(Fl_Check_Button*, void*) {
  Fl_Tooltip::enable(tooltips_button->value());
  fluid_prefs.set("show_tooltips", tooltips_button->value());
}

Fl_Check_Button *completion_button=(Fl_Check_Button *)0;

static void cb_completion_button(Fl_Check_Button*, void*) {
  fluid_prefs.set("show_completion_dialogs", completion_button->value());
}

Fl_Check_Button *openlast_button=(Fl_Check_Button *)0;

static void cb_openlast_button(Fl_Check_Button*, void*) {
  fluid_prefs.set("open_previous_file", openlast_button->value());
}

Fl_Check_Button *prevpos_button=(Fl_Check_Button *)0;

static void cb_prevpos_button(Fl_Check_Button*, void*) {
  fluid_prefs.set("prev_window_pos", prevpos_button->value());
}

Fl_Check_Button *show_comments_button=(Fl_Check_Button *)0;

static void cb_show_comments_button(Fl_Check_Button*, void*) {
  show_comments = show_comments_button->value();
  fluid_prefs.set("show_comments", show_comments);
  redraw_browser();
}

static void cb_1(Fl_Group* o, void* v) {
  propagate_load(o, v);
}

Fl_Spinner *recent_spinner=(Fl_Spinner *)0;

static void cb_recent_spinner(Fl_Spinner*, void*) {
  fluid_prefs.set("recent_files", recent_spinner->value());
  load_history();
}

Fl_Check_Button *use_external_editor_button=(Fl_Check_Button *)0;

static void cb_use_external_editor_button(Fl_Check_Button*, void*) {
  G_use_external_editor = use_external_editor_button->value();
  fluid_prefs.set("use_external_editor", G_use_external_editor);
  redraw_browser();
}

Fl_Input *editor_command_input=(Fl_Input *)0;

static void cb_editor_command_input(Fl_Input*, void*) {
  strncpy(G_external_editor_command, editor_command_input->value(), sizeof(G_external_editor_command)-1);
  G_external_editor_command[sizeof(G_external_editor_command)-1] = 0;
  fluid_prefs.set("external_editor_command", G_external_editor_command);
  redraw_browser();
}

Fl_Check_Button *guides_button=(Fl_Check_Button *)0;

Fl_Check_Button *restricted_button=(Fl_Check_Button *)0;

Fl_Check_Button *ghosted_outline_button=(Fl_Check_Button *)0;

Fl_Group *w_settings_project_tab=(Fl_Group *)0;

static void cb_w_settings_project_tab(Fl_Group* o, void* v) {
  propagate_load(o, v);
}

static const unsigned char idata_document_64[] =
{137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,96,0,0,0,64,8,4,0,0,0,
79,61,186,133,0,0,3,102,73,68,65,84,104,222,237,154,223,75,83,81,28,192,63,155,
115,58,171,153,191,42,140,2,75,115,41,69,20,73,61,244,3,67,176,68,122,168,8,234,
65,123,90,32,81,68,65,47,65,100,208,15,95,194,8,130,94,140,30,250,3,210,94,6,
65,15,162,15,21,250,160,145,62,68,141,182,39,205,205,156,211,181,173,135,221,
93,231,118,167,251,113,239,238,153,236,156,135,125,57,231,220,123,191,159,123,
239,247,215,221,129,244,90,39,223,9,16,206,178,7,113,97,71,135,102,199,151,181,
242,209,30,224,113,174,213,111,194,163,154,250,145,231,240,44,183,0,3,170,170,
31,65,232,203,86,41,83,26,107,143,70,133,50,74,51,184,148,31,95,252,144,145,
219,192,221,220,0,24,87,180,190,65,27,134,52,47,20,198,193,83,165,179,102,137,
144,14,128,49,42,214,178,63,3,128,9,89,238,98,150,247,42,33,152,244,112,102,167,
57,72,136,33,85,16,140,122,0,24,57,68,47,29,171,95,164,190,60,2,0,131,106,8,58,
1,168,135,160,27,128,90,8,58,2,168,131,160,43,64,18,132,222,60,2,136,32,60,
162,51,86,163,59,156,20,28,96,17,111,76,159,103,15,55,87,242,20,40,165,91,192,
64,102,160,88,150,223,50,26,119,23,131,120,98,7,14,11,25,137,183,203,210,48,
195,107,47,45,199,196,63,225,94,33,27,87,52,137,234,57,107,21,116,113,74,245,
179,230,52,153,107,230,33,67,56,112,179,156,90,189,32,26,128,145,6,174,115,137,
5,130,169,214,11,226,165,211,165,236,92,183,94,200,171,64,150,71,70,92,0,208,
206,6,194,120,249,131,159,176,194,156,25,43,149,20,137,12,224,103,132,65,62,51,
163,56,187,9,27,103,105,163,74,84,128,101,6,121,192,108,210,249,89,156,56,232,
193,78,181,152,54,48,65,223,26,234,71,219,75,62,42,248,126,1,0,130,124,193,153,
210,202,15,41,96,234,240,10,45,241,83,150,79,176,149,80,220,221,9,48,142,27,128,
105,188,212,136,7,16,98,94,206,128,175,81,159,224,135,22,232,151,0,60,138,249,
143,80,201,156,133,50,133,81,237,28,104,33,18,111,160,72,28,27,147,87,215,193,
225,184,185,176,52,46,12,128,129,18,73,242,240,137,169,4,128,69,126,201,241,218,
193,164,12,80,66,29,123,177,232,15,96,166,86,150,95,173,185,210,23,87,174,236,
226,42,151,99,10,125,157,108,160,152,230,12,143,116,242,132,55,171,63,166,232,
99,196,45,220,202,248,216,231,140,233,15,96,165,155,251,236,200,240,232,49,2,
250,123,161,109,116,211,138,147,57,217,68,127,243,66,250,194,112,128,14,44,9,
166,237,102,0,63,0,46,150,98,190,216,233,230,70,45,52,210,24,227,36,39,121,45,1,
236,166,157,205,9,0,211,188,147,0,150,196,138,3,134,184,223,168,172,166,223,47,
164,18,27,60,149,72,44,120,22,20,94,180,69,209,1,204,148,75,245,215,56,253,20,
39,148,57,115,114,0,179,102,157,110,107,2,96,165,129,31,0,184,165,114,38,89,
171,195,44,162,13,84,210,158,210,186,58,90,178,126,2,154,0,20,209,70,79,10,152,
247,216,39,170,17,87,97,167,158,65,166,20,140,56,50,127,140,243,28,201,50,10,
107,234,133,170,185,64,43,94,197,82,222,128,133,10,182,168,18,224,52,116,163,38,
106,52,249,144,82,136,196,5,0,157,82,137,208,74,64,117,241,77,245,12,51,140,75,
241,90,169,102,192,169,180,9,154,34,66,102,219,46,215,107,49,127,179,142,114,92,
11,47,52,18,5,240,101,244,143,110,90,87,210,164,217,152,83,125,239,174,82,159,
193,166,213,157,233,226,175,230,234,123,185,168,229,195,61,199,184,10,219,239,
147,239,104,255,202,153,244,20,250,15,100,60,232,29,230,9,101,148,0,0,0,0,73,69,
78,68,174,66,96,130};
static Fl_Image *image_document_64() {
  static Fl_Image *image = NULL;
  if (!image)
    image = new Fl_PNG_Image("document_64.png", idata_document_64, 927);
  return image;
}

Fl_Input *header_file_input=(Fl_Input *)0;

static void cb_header_file_input(Fl_Input* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.header_file_name.c_str());
  } else {
    if (strcmp(g_project.header_file_name.c_str(), o->value())) {
      g_project.header_file_name = o->value();
      set_modflag(1);
    }
  }
}

Fl_Input *code_file_input=(Fl_Input *)0;

static void cb_code_file_input(Fl_Input* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.code_file_name.c_str());
  } else {
    if (strcmp(g_project.code_file_name.c_str(), o->value())) {
      g_project.code_file_name = o->value();
      set_modflag(1);
    }
  }
}

Fl_Check_Button *include_H_from_C_button=(Fl_Check_Button *)0;

static void cb_include_H_from_C_button(Fl_Check_Button* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.include_H_from_C);
  } else {
    if (g_project.include_H_from_C != o->value()) {
      set_modflag(1);
      g_project.include_H_from_C = o->value();
    }
  }
}

Fl_Check_Button *use_FL_COMMAND_button=(Fl_Check_Button *)0;

static void cb_use_FL_COMMAND_button(Fl_Check_Button* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.use_FL_COMMAND);
  } else {
    if (g_project.use_FL_COMMAND != o->value()) {
      set_modflag(1);
      g_project.use_FL_COMMAND = o->value();
    }
  }
}

Fl_Check_Button *utf8_in_src_button=(Fl_Check_Button *)0;

static void cb_utf8_in_src_button(Fl_Check_Button* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.utf8_in_src);
  } else {
    if (g_project.utf8_in_src != o->value()) {
      set_modflag(1);
      g_project.utf8_in_src = o->value();
    }
  }
}

Fl_Check_Button *avoid_early_includes_button=(Fl_Check_Button *)0;

static void cb_avoid_early_includes_button(Fl_Check_Button* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.avoid_early_includes);
  } else {
    if (g_project.avoid_early_includes != o->value()) {
      set_modflag(1);
      g_project.avoid_early_includes = o->value();
    }
  }
}

Fl_Check_Button *w_proj_mergeback=(Fl_Check_Button *)0;

static void cb_w_proj_mergeback(Fl_Check_Button* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.write_mergeback_data);
  } else {
    if (g_project.write_mergeback_data != o->value()) {
      set_modflag(1);
      g_project.write_mergeback_data = o->value();
    }
  }
}

Fl_Group *w_settings_layout_tab=(Fl_Group *)0;

static void cb_w_settings_layout_tab(Fl_Group* o, void* v) {
  propagate_load(o, v);
}

static const unsigned char idata_layout_64[] =
{137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,96,0,0,0,64,8,4,0,0,0,
79,61,186,133,0,0,1,168,73,68,65,84,104,222,237,154,49,75,3,49,20,199,127,119,
84,168,109,23,197,201,209,69,116,16,197,130,159,160,123,151,226,226,42,14,98,
29,244,35,184,56,59,250,77,244,27,88,113,171,90,144,66,41,116,180,72,75,45,120,
92,92,122,109,167,144,75,155,35,202,123,89,18,146,123,252,127,112,239,46,47,
121,144,206,78,232,16,161,28,181,136,14,53,28,218,21,99,103,226,147,246,205,185,
43,249,135,12,157,203,87,40,6,28,152,139,10,83,0,92,83,36,11,43,113,106,190,56,
151,194,241,94,210,41,144,215,46,28,51,154,246,215,141,221,207,61,85,118,1,16,
178,154,116,47,168,16,104,22,126,112,57,17,83,161,78,17,101,224,94,241,200,109,
50,216,32,36,94,62,192,84,243,38,59,26,0,136,201,79,0,214,216,166,100,228,94,
209,156,13,2,115,128,144,63,110,2,32,0,2,32,0,2,176,144,229,220,186,143,24,26,
174,84,140,125,4,104,112,195,138,209,86,2,218,62,2,116,233,74,12,72,16,47,102,
86,249,128,63,0,150,249,128,63,0,150,249,128,4,177,0,8,128,0,8,128,0,8,128,0,8,
128,0,8,128,0,8,128,0,184,55,171,156,184,199,155,246,146,175,109,121,76,152,25,
192,29,247,218,121,187,3,146,12,1,70,25,10,148,32,254,151,65,92,102,75,51,27,
208,231,193,111,128,26,85,205,87,40,224,157,103,62,125,6,200,83,210,150,26,20,
36,6,4,64,0,4,64,0,4,192,187,31,89,60,187,171,51,207,7,250,180,140,47,249,122,
243,131,216,84,86,144,2,182,201,110,242,167,117,92,118,249,196,145,139,173,196,
75,2,144,38,31,176,218,19,53,220,188,110,251,12,50,41,61,254,154,149,216,46,
219,234,153,20,127,159,185,12,250,99,90,14,203,239,127,120,165,154,78,208,47,
215,15,118,242,56,45,94,1,0,0,0,0,73,69,78,68,174,66,96,130};
static Fl_Image *image_layout_64() {
  static Fl_Image *image = NULL;
  if (!image)
    image = new Fl_PNG_Image("layout_64.png", idata_layout_64, 481);
  return image;
}

Fl_Choice *layout_choice=(Fl_Choice *)0;

static void cb_layout_choice(Fl_Choice* o, void* v) {
  if (v == LOAD) {
      o->value(g_layout_list.current_suite());
    } else {
      int index = o->value();
      g_layout_list.current_suite(index);
      g_layout_list.update_dialogs();
    }
}

Fl_Menu_Item menu_layout_choice[] = {
 {"FLTK", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 14, 0},
 {"Grid", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

static void cb_2(Fl_Button*, void* v) {
  // Clone the current layout suite

  if (v == LOAD) return;

  Fl_String old_name = "Copy of ";
  old_name.append(g_layout_list[g_layout_list.current_suite()].name_);
  const char *new_name = fl_input("Enter a name for the new layout:", old_name.c_str());
  if (new_name == NULL)
    return;

  g_layout_list.add(new_name);
  g_layout_list.update_dialogs();
}

Fl_Menu_Button *w_layout_menu=(Fl_Menu_Button *)0;

static void cb_w_layout_menu(Fl_Menu_Button*, void* v) {
  if (v == LOAD) {
    Fd_Layout_Suite &suite = g_layout_list[g_layout_list.current_suite()];
    if (suite.storage_ == FD_STORE_INTERNAL) {
      w_layout_menu_rename->deactivate();
      for (int i=1; i<4; i++) w_layout_menu_storage[i]->deactivate();
      w_layout_menu_delete->deactivate();
    } else {
      w_layout_menu_rename->activate();
      for (int i=1; i<4; i++) w_layout_menu_storage[i]->activate();
      w_layout_menu_delete->activate();
    }
    w_layout_menu_storage[suite.storage_]->setonly();
  }
}

static void cb_w_layout_menu_rename(Fl_Menu_*, void*) {
  // Rename the current layout suite

  Fl_String old_name = g_layout_list[g_layout_list.current_suite()].name_;
  const char *new_name = fl_input("Enter a new name for the layout:", old_name.c_str());
  if (new_name == NULL)
    return;

  g_layout_list.rename(new_name);
  g_layout_list.update_dialogs();
}

static void cb_w_layout_menu_storage(Fl_Menu_*, void*) {
  Fd_Layout_Suite &suite = g_layout_list[g_layout_list.current_suite()];
  suite.storage(FD_STORE_INTERNAL);
  g_layout_list.update_dialogs();
}

static void cb_w_layout_menu_storage1(Fl_Menu_*, void*) {
  Fd_Layout_Suite &suite = g_layout_list[g_layout_list.current_suite()];
  suite.storage(FD_STORE_USER);
  g_layout_list.update_dialogs();
}

static void cb_w_layout_menu_storage2(Fl_Menu_*, void*) {
  Fd_Layout_Suite &suite = g_layout_list[g_layout_list.current_suite()];
  suite.storage(FD_STORE_PROJECT);
  g_layout_list.update_dialogs();
}

static void cb_w_layout_menu_storage3(Fl_Menu_*, void*) {
  Fd_Layout_Suite &suite = g_layout_list[g_layout_list.current_suite()];
  suite.storage(FD_STORE_FILE);
  g_layout_list.update_dialogs();
}

static void cb_w_layout_menu_load(Fl_Menu_*, void*) {
  // Give the user a file chooser and load that file
  Fl_Native_File_Chooser fnfc;
  fnfc.title("Load Layout Settings:");
  fnfc.type(Fl_Native_File_Chooser::BROWSE_FILE);
  fnfc.options(Fl_Native_File_Chooser::USE_FILTER_EXT);
  fnfc.filter("FLUID Layouts\t*.fll\n");
  if (fnfc.show() != 0) return;
  const char *new_filename = fnfc.filename();
  if (!new_filename) return;
  g_layout_list.load(new_filename);
  //g_layout_list.current_suite(n);
  g_layout_list.update_dialogs();
}

static void cb_w_layout_menu_save(Fl_Menu_*, void*) {
  // Give the user a file chooser with a suggested name
    Fl_Native_File_Chooser fnfc;
    fnfc.title("Save Layout Settings:");
    fnfc.type(Fl_Native_File_Chooser::BROWSE_SAVE_FILE);
    fnfc.options(Fl_Native_File_Chooser::SAVEAS_CONFIRM | Fl_Native_File_Chooser::USE_FILTER_EXT);
    fnfc.filter("FLUID Layouts\t*.fll\n");
    Fl_String filename = g_layout_list.filename_;
    fnfc.directory(fl_filename_path(filename).c_str());
    fnfc.preset_file(fl_filename_name(filename).c_str());
    if (fnfc.show() != 0) return;
    const char *new_filename = fnfc.filename();
    if (!new_filename) return;
    g_layout_list.filename_ = new_filename;
    g_layout_list.save(new_filename);
}

static void cb_w_layout_menu_delete(Fl_Menu_*, void*) {
  // remove the current suite

  g_layout_list.remove(g_layout_list.current_suite());
  g_layout_list.update_dialogs();
}

Fl_Menu_Item menu_w_layout_menu[] = {
 {"Rename...", 0,  (Fl_Callback*)cb_w_layout_menu_rename, 0, 128, (uchar)FL_NORMAL_LABEL, 0, 14, 0},
 {"@fd_beaker  FLUID Built-In", 0,  (Fl_Callback*)cb_w_layout_menu_storage, 0, 9, (uchar)FL_NORMAL_LABEL, 0, 14, 0},
 {"@fd_user  User Preference", 0,  (Fl_Callback*)cb_w_layout_menu_storage1, 0, 8, (uchar)FL_NORMAL_LABEL, 0, 14, 0},
 {"@fd_project  Store in .fl Project File", 0,  (Fl_Callback*)cb_w_layout_menu_storage2, 0, 8, (uchar)FL_NORMAL_LABEL, 0, 14, 0},
 {"@fd_file  Store in External File", 0,  (Fl_Callback*)cb_w_layout_menu_storage3, 0, 136, (uchar)FL_NORMAL_LABEL, 0, 14, 0},
 {"Load...", 0,  (Fl_Callback*)cb_w_layout_menu_load, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 14, 0},
 {"Save...", 0,  (Fl_Callback*)cb_w_layout_menu_save, 0, 128, (uchar)FL_NORMAL_LABEL, 0, 14, 0},
 {"Delete", 0,  (Fl_Callback*)cb_w_layout_menu_delete, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Button *preset_choice[3]={(Fl_Button *)0};

static void cb_Left(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->left_window_margin);
  } else {
    layout->left_window_margin = (int)o->value();
  }
}

static void cb_Top(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->top_window_margin);
  } else {
    layout->top_window_margin = (int)o->value();
  }
}

static void cb_Right(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->right_window_margin);
  } else {
    layout->right_window_margin = (int)o->value();
  }
}

static void cb_Bottom(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->bottom_window_margin);
  } else {
    layout->bottom_window_margin = (int)o->value();
  }
}

static void cb_Horizontal(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->window_grid_x);
  } else {
    layout->window_grid_x = (int)o->value();
  }
}

static void cb_Vertical(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->window_grid_y);
  } else {
    layout->window_grid_y = (int)o->value();
  }
}

static void cb_Left1(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->left_group_margin);
  } else {
    layout->left_group_margin = (int)o->value();
  }
}

static void cb_Top1(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->top_group_margin);
  } else {
    layout->top_group_margin = (int)o->value();
  }
}

static void cb_Right1(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->right_group_margin);
  } else {
    layout->right_group_margin = (int)o->value();
  }
}

static void cb_Bottom1(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->bottom_group_margin);
  } else {
    layout->bottom_group_margin = (int)o->value();
  }
}

static void cb_Horizontal1(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->group_grid_x);
  } else {
    layout->group_grid_x = (int)o->value();
  }
}

static void cb_Vertical1(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->group_grid_y);
  } else {
    layout->group_grid_y = (int)o->value();
  }
}

static void cb_Top2(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->top_tabs_margin);
  } else {
    layout->top_tabs_margin = (int)o->value();
  }
}

static void cb_Bottom2(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->bottom_tabs_margin);
  } else {
    layout->bottom_tabs_margin = (int)o->value();
  }
}

static void cb_Minimum(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->widget_min_w);
  } else {
    layout->widget_min_w = (int)o->value();
  }
}

static void cb_Increment(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->widget_inc_w);
  } else {
    layout->widget_inc_w = (int)o->value();
  }
}

static void cb_Gap(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->widget_gap_x);
  } else {
    layout->widget_gap_x = (int)o->value();
  }
}

static void cb_3(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->widget_min_h);
  } else {
    layout->widget_min_h = (int)o->value();
  }
}

static void cb_4(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->widget_inc_h);
  } else {
    layout->widget_inc_h = (int)o->value();
  }
}

static void cb_5(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->widget_gap_y);
  } else {
    layout->widget_gap_y = (int)o->value();
  }
}

static void cb_6(Fl_Choice* o, void* v) {
  if (v == LOAD) {
    o->value(layout->labelfont+1);
  } else {
    layout->labelfont = (int)o->value()-1;
  }
}

static void cb_7(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value(layout->labelsize);
  } else {
    layout->labelsize = (int)o->value();
  }
}

static void cb_8(Fl_Choice* o, void* v) {
  if (v == LOAD) {
    o->value(layout->textfont+1);
  } else {
    layout->textfont = (int)o->value()-1;
  }
}

static void cb_9(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value(layout->textsize);
  } else {
    layout->textsize = (int)o->value();
  }
}

Fl_Group *w_settings_shell_tab=(Fl_Group *)0;

static const unsigned char idata_shell_64[] =
{137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,96,0,0,0,64,8,4,0,0,0,
79,61,186,133,0,0,2,233,73,68,65,84,104,222,237,154,207,107,19,65,20,199,63,
155,196,70,235,161,154,149,104,165,148,170,104,127,252,3,30,5,43,69,130,55,15,
222,234,77,65,240,34,182,1,127,28,2,189,181,9,120,16,244,82,240,32,210,179,162,
69,241,170,30,196,91,107,171,208,218,94,26,161,77,218,131,182,49,38,245,80,77,
118,67,205,254,152,113,102,87,242,114,217,101,194,240,253,236,188,247,102,230,
205,128,179,181,145,97,141,10,219,10,127,21,86,201,208,134,4,139,49,165,88,124,
29,98,146,152,56,64,70,147,252,29,132,180,147,60,195,17,96,141,4,250,236,43,71,
68,1,42,68,118,30,246,18,87,164,122,163,254,88,37,42,10,176,253,71,126,134,30,
170,10,228,71,248,98,245,28,195,41,68,93,90,156,110,78,40,26,129,170,39,220,144,
91,11,64,183,185,142,129,18,203,68,20,5,241,178,135,127,187,206,66,245,52,106,
73,114,116,252,19,132,18,91,174,21,122,0,208,100,70,43,136,255,147,32,134,33,
14,42,241,39,131,34,47,229,3,36,184,78,159,34,128,57,222,83,144,63,2,237,236,
87,228,22,237,173,153,184,5,16,200,44,100,223,114,124,96,157,227,12,176,39,140,
0,155,60,102,12,56,198,109,206,201,41,29,168,117,161,60,83,0,44,114,135,87,
252,8,31,128,81,27,184,60,119,53,35,248,2,56,204,69,203,104,232,69,240,5,176,
143,75,140,4,4,193,103,26,53,25,14,8,130,239,121,32,40,8,2,19,89,48,16,132,102,
226,32,32,8,46,37,244,35,8,175,133,116,35,72,88,204,153,12,115,211,134,240,154,
114,184,86,163,38,151,109,163,48,198,76,216,150,211,118,71,90,100,154,205,176,
237,7,76,134,45,69,241,55,172,135,111,67,99,114,186,182,155,45,11,22,33,11,58,0,
62,241,136,239,181,26,134,170,141,78,76,158,252,44,79,107,111,131,202,14,214,
36,1,204,147,179,200,79,49,40,239,203,168,0,152,39,203,179,218,219,16,55,232,
14,250,166,222,106,115,228,108,242,71,233,119,81,244,14,12,192,28,19,60,183,
200,79,211,167,80,190,112,22,250,104,147,127,94,154,252,132,154,17,152,37,103,
147,63,74,175,210,175,47,8,48,203,4,211,154,229,11,0,204,144,109,42,191,76,201,
67,111,113,223,19,95,204,175,252,113,203,33,68,138,17,78,217,228,127,230,5,75,
84,92,246,22,165,135,148,207,123,0,190,0,10,76,54,200,239,109,104,127,192,19,
143,125,46,113,203,215,236,237,43,11,21,121,215,68,190,189,221,173,189,165,168,
46,141,182,211,245,251,233,194,46,242,173,237,238,173,203,211,185,140,160,11,
37,185,194,79,22,57,203,85,78,254,181,125,222,67,143,253,92,35,169,14,32,202,
25,6,248,198,33,14,52,105,223,112,125,36,104,208,65,210,233,102,147,220,44,20,
163,211,177,189,51,108,59,50,61,214,2,208,109,174,99,160,192,130,178,251,66,11,
214,235,54,142,9,192,201,42,205,71,41,33,161,178,208,216,199,86,173,56,32,227,
218,229,42,166,70,15,89,225,168,104,12,220,87,226,55,187,91,149,123,50,162,100,
82,219,229,239,135,114,138,14,109,164,201,83,85,44,126,133,81,55,103,232,191,0,
145,21,211,195,226,88,204,195,0,0,0,0,73,69,78,68,174,66,96,130};
static Fl_Image *image_shell_64() {
  static Fl_Image *image = NULL;
  if (!image)
    image = new Fl_PNG_Image("shell_64.png", idata_shell_64, 802);
  return image;
}

Fl_Browser *w_settings_shell_list=(Fl_Browser *)0;

static void cb_w_settings_shell_list(Fl_Browser* o, void* v) {
  if (v == LOAD) {
    // load from g_shell_config
    if (g_shell_config) {
      o->clear();
      w_settings_shell_list_selected = 0;
      for (int i=0; i<g_shell_config->list_size; i++) {
        Fd_Shell_Command *cmd = g_shell_config->list[i];
        o->add(cmd->name.c_str());
        if (cmd->storage == FD_STORE_USER)
          o->icon(i+1, w_settings_shell_fd_user->image());
        else if (cmd->storage == FD_STORE_PROJECT)
          o->icon(i+1, w_settings_shell_fd_project->image());
      }
    }
  } else {
  //  int prev_selected = w_settings_shell_list_selected;
    w_settings_shell_list_selected = 0;
    int selected = w_settings_shell_list->value();
    if (selected) {
      if (w_settings_shell_list->selected(selected))
        w_settings_shell_list_selected = selected;
    }
    w_settings_shell_cmd->do_callback(w_settings_shell_cmd, LOAD);
    w_settings_shell_toolbox->do_callback(w_settings_shell_toolbox, LOAD);
  }
}

Fl_Group *w_settings_shell_toolbox=(Fl_Group *)0;

static void cb_w_settings_shell_toolbox(Fl_Group* o, void* v) {
  if (v==LOAD) {
    propagate_load(o, v);
  }
}

static void cb_a(Fl_Button*, void* v) {
  if (v != LOAD) {
    int selected = w_settings_shell_list_selected;
    Fd_Shell_Command *cmd = new Fd_Shell_Command("new shell command");
    g_shell_config->insert(selected, cmd);
    w_settings_shell_list->insert(selected+1, cmd->name.c_str());
    w_settings_shell_list->deselect();
    w_settings_shell_list->value(selected+1);
    if (cmd->storage == FD_STORE_USER) {
      w_settings_shell_list->icon(selected+1, w_settings_shell_fd_user->image());
    } else if (cmd->storage == FD_STORE_PROJECT) {
      w_settings_shell_list->icon(selected+1, w_settings_shell_fd_project->image());
      set_modflag(1);
    }
    w_settings_shell_list->do_callback();
    w_settings_shell_cmd->do_callback(w_settings_shell_cmd, LOAD);
    w_settings_shell_toolbox->do_callback(w_settings_shell_toolbox, LOAD);
    g_shell_config->rebuild_shell_menu();
  }
}

Fl_Button *w_settings_shell_dup=(Fl_Button *)0;

static void cb_w_settings_shell_dup(Fl_Button* o, void* v) {
  int selected = w_settings_shell_list_selected;
  if (v==LOAD) {
    if (selected) {
      o->activate();
    } else {
      o->deactivate();
    }
  } else {
    if (!selected) return;
    Fd_Shell_Command *cmd = new Fd_Shell_Command(g_shell_config->list[selected-1]);
    g_shell_config->insert(selected, cmd);
    w_settings_shell_list->insert(selected+1, cmd->name.c_str());
    w_settings_shell_list->deselect();
    w_settings_shell_list->value(selected+1);
    if (cmd->storage == FD_STORE_USER) {
      w_settings_shell_list->icon(selected+1, w_settings_shell_fd_user->image());
    } else if (cmd->storage == FD_STORE_PROJECT) {
      w_settings_shell_list->icon(selected+1, w_settings_shell_fd_project->image());
      set_modflag(1);
    }
    w_settings_shell_list->do_callback();
    w_settings_shell_cmd->do_callback(w_settings_shell_cmd, LOAD);
    w_settings_shell_toolbox->do_callback(w_settings_shell_toolbox, LOAD);
    g_shell_config->rebuild_shell_menu();
  }
}

Fl_Button *w_settings_shell_remove=(Fl_Button *)0;

static void cb_w_settings_shell_remove(Fl_Button* o, void* v) {
  int selected = w_settings_shell_list_selected;
  if (v==LOAD) {
    if (selected) {
      o->activate();
    } else {
      o->deactivate();
    }
  } else {
    if (!selected) return;
    int ret = fl_choice("Delete the shell command\n\"%s\"?\n\nThis can not be undone.",
      "Delete", "Cancel", NULL, g_shell_config->list[selected-1]->name.c_str());
    if (ret==1) return;
    if (g_shell_config->at(selected-1)->storage == FD_STORE_PROJECT) set_modflag(1);
    g_shell_config->remove(selected-1);
    w_settings_shell_list->remove(selected);
    if (selected <= w_settings_shell_list->size())
      w_settings_shell_list->value(selected);
    else
      w_settings_shell_list->value(0);
    w_settings_shell_list->do_callback();
    w_settings_shell_cmd->do_callback(w_settings_shell_cmd, LOAD);
    w_settings_shell_toolbox->do_callback(w_settings_shell_toolbox, LOAD);
    g_shell_config->rebuild_shell_menu();
  }
}

Fl_Menu_Button *w_settings_shell_menu=(Fl_Menu_Button *)0;

static void cb_Import(Fl_Menu_*, void* v) {
  if (v != LOAD)
    Fd_Shell_Command_List::import_from_file();
}

static void cb_Export(Fl_Menu_*, void* v) {
  if (v != LOAD)
    Fd_Shell_Command_List::export_selected();
}

Fl_Menu_Item menu_w_settings_shell_menu[] = {
 {"Import...", 0,  (Fl_Callback*)cb_Import, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"Export selected...", 0,  (Fl_Callback*)cb_Export, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"Example Scripts:", 0,  0, 0, 17, (uchar)FL_NORMAL_LABEL, 1, 10, 0},
 {"Compile with fltk-config", 0,  0, 0, 16, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"Build and run", 0,  0, 0, 16, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"Build with Xcode on macOS", 0,  0, 0, 16, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"Build with CMake", 0,  0, 0, 16, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

static void cb_T(Fl_Button*, void* v) {
  if (v!=LOAD) show_terminal_window();
}

Fl_Button *w_settings_shell_play=(Fl_Button *)0;

static void cb_w_settings_shell_play(Fl_Button* o, void* v) {
  int selected = w_settings_shell_list_selected;
  if (v==LOAD) {
    if (selected) {
      o->activate();
    } else {
      o->deactivate();
    }
  } else {
    if (!selected) return;
    Fd_Shell_Command *cmd = g_shell_config->list[selected-1];
    cmd->run();
  }
}

Fl_Group *w_settings_shell_cmd=(Fl_Group *)0;

static void cb_w_settings_shell_cmd(Fl_Group* o, void* v) {
  if (v==LOAD) {
    int selected = w_settings_shell_list_selected;
    if (selected) {
      o->activate();
    } else {
      o->deactivate();
    }
    propagate_load(o, v);
  }
}

static void cb_Name(Fl_Input* o, void* v) {
  int selected = w_settings_shell_list_selected;
  if (v == LOAD) {
    if (selected) {
      o->value(g_shell_config->list[selected-1]->name.c_str());
    } else {
      o->value("");
    }
  } else {
    if (selected) {
      Fd_Shell_Command *cmd = g_shell_config->list[selected-1];
      cmd->name = o->value();
      w_settings_shell_list->text(selected, o->value());
      if (cmd->storage == FD_STORE_PROJECT) set_modflag(1);
    }
  }
}

static void cb_Menu(Fl_Input* o, void* v) {
  int selected = w_settings_shell_list_selected;
  if (v == LOAD) {
    if (selected) {
      o->value(g_shell_config->list[selected-1]->label.c_str());
    } else {
      o->value("");
    }
  } else {
    if (selected) {
      Fd_Shell_Command *cmd = g_shell_config->list[selected-1];
      cmd->label = o->value();
      cmd->update_shell_menu();
      if (cmd->storage == FD_STORE_PROJECT) set_modflag(1);
    }
  }
}

static void cb_b(Fl_Group* o, void* v) {
  propagate_load(o, v);
}

static void cb_Shortcut(Fl_Shortcut_Button* o, void* v) {
  int selected = w_settings_shell_list_selected;
  if (v == LOAD) {
    if (selected) {
      o->value(g_shell_config->list[selected-1]->shortcut);
      //o->default_value(o->value());
    } else {
      o->value(0);
    }
  } else {
    if (selected) {
      Fd_Shell_Command *cmd = g_shell_config->list[selected-1];
      cmd->shortcut = o->value();
      cmd->update_shell_menu();
      if (cmd->storage == FD_STORE_PROJECT) set_modflag(1);
    }
  }
}

static void cb_Store(Fl_Choice* o, void* v) {
  int selected = w_settings_shell_list_selected;
  if (v == LOAD) {
    if (selected) {
      Fd_Tool_Store ts = g_shell_config->list[selected-1]->storage;
      o->value(o->find_item_with_argument((long)ts));
    } else {
      o->value(o->find_item_with_argument((long)FD_STORE_USER));
    }
  } else {
    if (selected) {
      Fd_Shell_Command *cmd = g_shell_config->list[selected-1];
      Fd_Tool_Store ts = (Fd_Tool_Store)(o->mvalue()->argument());
      if (cmd->storage == FD_STORE_PROJECT) set_modflag(1);
      cmd->storage = ts;
      //w_settings_shell_list->text(selected, cmd->name.c_str());
      if (cmd->storage == FD_STORE_USER)
        w_settings_shell_list->icon(selected, w_settings_shell_fd_user->image());
      else if (cmd->storage == FD_STORE_PROJECT)
        w_settings_shell_list->icon(selected, w_settings_shell_fd_project->image());
      if (cmd->storage == FD_STORE_PROJECT) set_modflag(1);
    }
  }
}

Fl_Menu_Item menu_Store[] = {
 {"@fd_user User Setting", 0,  0, (void*)(FD_STORE_USER), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"@fd_project Project File", 0,  0, (void*)(FD_STORE_PROJECT), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

static void cb_Condition(Fl_Choice* o, void* v) {
  int selected = w_settings_shell_list_selected;
  if (v == LOAD) {
    if (selected) {
      int cond = g_shell_config->list[selected-1]->condition;
      o->value(o->find_item_with_argument(cond));
    } else {
      o->value(o->find_item_with_argument(0));
    }
  } else {
    if (selected) {
      Fd_Shell_Command *cmd = g_shell_config->list[selected-1];
      int cond = (int)(o->mvalue()->argument());
      cmd->condition = cond;
      g_shell_config->rebuild_shell_menu();
      if (cmd->storage == FD_STORE_PROJECT) set_modflag(1);
    }
  }
}

Fl_Menu_Item menu_Condition[] = {
 {"all platforms", 0,  0, (void*)(Fd_Shell_Command::ALWAYS), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"Windows only", 0,  0, (void*)(Fd_Shell_Command::WIN_ONLY), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"Linux only", 0,  0, (void*)(Fd_Shell_Command::UX_ONLY), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"macOS only", 0,  0, (void*)(Fd_Shell_Command::MAC_ONLY), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"Linux and macOS", 0,  0, (void*)(Fd_Shell_Command::MAC_AND_UX_ONLY), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"don\'t use", 0,  0, (void*)(Fd_Shell_Command::NEVER), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

static void cb_Label(Fl_Input* o, void* v) {
  if (v == LOAD) {
  //  o->value(g_shell_command.c_str());
  } else {
  //  g_shell_command = o->value();
  }
}

Fl_Text_Editor *w_settings_shell_command=(Fl_Text_Editor *)0;

static void cb_w_settings_shell_command(Fl_Text_Editor* o, void* v) {
  int selected = w_settings_shell_list_selected;
  if (v == LOAD) {
    if (selected) {
      o->buffer()->text(g_shell_config->list[selected-1]->command.c_str());
    } else {
      o->buffer()->text("");
    }
  } else {
    if (selected) {
      Fd_Shell_Command *cmd = g_shell_config->list[selected-1];
      cmd->command = o->buffer()->text();
      if (cmd->storage == FD_STORE_PROJECT) set_modflag(1);
    }
  }
}

Fl_Menu_Button *w_settings_shell_text_macros=(Fl_Menu_Button *)0;

static void cb_w_settings_shell_text_macros(Fl_Menu_Button* o, void*) {
  const Fl_Menu_Item *mi = o->mvalue();
  if (mi) {
    char buffer[256];
    fl_strlcpy(buffer, mi->label(), 255);
    int n = (int)strlen(buffer)-1;
    if (buffer[n]=='@') buffer[n] = 0;
    char *word = buffer;
    if (word[0]=='@') word++;
    if (w_settings_shell_command->buffer()->selected()) {
      int start = 0, end = 0;
      w_settings_shell_command->buffer()->selection_position(&start, &end);
      w_settings_shell_command->buffer()->replace(start, end, word);
    } else {
      int pos = w_settings_shell_command->insert_position();
      w_settings_shell_command->buffer()->insert(pos, word);
    }
    w_settings_shell_command->do_callback(w_settings_shell_command, (void*)NULL);
  }
}

Fl_Menu_Item menu_w_settings_shell_text_macros[] = {
 {"@@BASENAME@@", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 4, 11, 0},
 {"@@PROJECTFILE_PATH@@", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 4, 11, 0},
 {"@@PROJECTFILE_NAME@@", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 4, 11, 0},
 {"@@CODEFILE_PATH@@", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 4, 11, 0},
 {"@@CODEFILE_NAME@@", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 4, 11, 0},
 {"@@HEADERFILE_PATH@@", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 4, 11, 0},
 {"@@HEADERFILE_NAME@@", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 4, 11, 0},
 {"@@TEXTFILE_PATH@@", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 4, 11, 0},
 {"@@TEXTFILE_NAME@@", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 4, 11, 0},
 // Not yet implemented
 {"@@FLTK_CONFIG@@", 0,  0, 0, 16, (uchar)FL_NORMAL_LABEL, 4, 11, 0},
 {"@@TMPDIR@@", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 4, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

static void cb_1fd_zoom(Fl_Button*, void*) {
  if (!script_panel) make_script_panel();
  script_input->buffer()->text(w_settings_shell_command->buffer()->text());
  script_panel->show();

  for (;;) {
    Fl_Widget* w = Fl::readqueue();
    if (w == script_panel_cancel) goto BREAK2;
    else if (w == script_panel_ok) break;
    else if (!w) Fl::wait();
  }

  w_settings_shell_command->buffer()->text(script_input->buffer()->text());
  w_settings_shell_command->do_callback();
  BREAK2:
  script_panel->hide();
}

static void cb_save(Fl_Check_Button* o, void* v) {
  int selected = w_settings_shell_list_selected;
  if (v == LOAD) {
    if (selected) {
      o->value(g_shell_config->list[selected-1]->flags & Fd_Shell_Command::SAVE_PROJECT);
    } else {
      o->value(0);
    }
  } else {
    if (selected) {
      Fd_Shell_Command *cmd = g_shell_config->list[selected-1];
      int v = o->value();
      if (v) {
        cmd->flags |= Fd_Shell_Command::SAVE_PROJECT;
      } else {
        cmd->flags &= ~Fd_Shell_Command::SAVE_PROJECT;
      }
      if (cmd->storage == FD_STORE_PROJECT) set_modflag(1);
    }
  }
}

static void cb_save1(Fl_Check_Button* o, void* v) {
  int selected = w_settings_shell_list_selected;
  if (v == LOAD) {
    if (selected) {
      o->value(g_shell_config->list[selected-1]->flags & Fd_Shell_Command::SAVE_SOURCECODE);
    } else {
      o->value(0);
    }
  } else {
    if (selected) {
      Fd_Shell_Command *cmd = g_shell_config->list[selected-1];
      int v = o->value();
      if (v) {
        cmd->flags |= Fd_Shell_Command::SAVE_SOURCECODE;
      } else {
        cmd->flags &= ~Fd_Shell_Command::SAVE_SOURCECODE;
      }
      if (cmd->storage == FD_STORE_PROJECT) set_modflag(1);
    }
  }
}

static void cb_save2(Fl_Check_Button* o, void* v) {
  int selected = w_settings_shell_list_selected;
  if (v == LOAD) {
    if (selected) {
      o->value(g_shell_config->list[selected-1]->flags & Fd_Shell_Command::SAVE_STRINGS);
    } else {
      o->value(0);
    }
  } else {
    if (selected) {
      Fd_Shell_Command *cmd = g_shell_config->list[selected-1];
      int v = o->value();
      if (v) {
        cmd->flags |= Fd_Shell_Command::SAVE_STRINGS;
      } else {
        cmd->flags &= ~Fd_Shell_Command::SAVE_STRINGS;
      }
      if (cmd->storage == FD_STORE_PROJECT) set_modflag(1);
    }
  }
}

static void cb_show(Fl_Check_Button* o, void* v) {
  int selected = w_settings_shell_list_selected;
  if (v == LOAD) {
    if (selected) {
      o->value(!(g_shell_config->list[selected-1]->flags & Fd_Shell_Command::DONT_SHOW_TERMINAL));
    } else {
      o->value(0);
    }
  } else {
    if (selected) {
      Fd_Shell_Command *cmd = g_shell_config->list[selected-1];
      int v = o->value();
      if (!v) {
        cmd->flags |= Fd_Shell_Command::DONT_SHOW_TERMINAL;
      } else {
        cmd->flags &= ~Fd_Shell_Command::DONT_SHOW_TERMINAL;
      }
      if (cmd->storage == FD_STORE_PROJECT) set_modflag(1);
    }
  }
}

static void cb_clear(Fl_Check_Button* o, void* v) {
  int selected = w_settings_shell_list_selected;
  if (v == LOAD) {
    if (selected) {
      o->value(g_shell_config->list[selected-1]->flags & Fd_Shell_Command::CLEAR_TERMINAL);
    } else {
      o->value(0);
    }
  } else {
    if (selected) {
      Fd_Shell_Command *cmd = g_shell_config->list[selected-1];
      int v = o->value();
      if (v) {
        cmd->flags |= Fd_Shell_Command::CLEAR_TERMINAL;
      } else {
        cmd->flags &= ~Fd_Shell_Command::CLEAR_TERMINAL;
      }
      if (cmd->storage == FD_STORE_PROJECT) set_modflag(1);
    }
  }
}

static void cb_clear1(Fl_Check_Button* o, void* v) {
  int selected = w_settings_shell_list_selected;
  if (v == LOAD) {
    if (selected) {
      o->value(g_shell_config->list[selected-1]->flags & Fd_Shell_Command::CLEAR_HISTORY);
    } else {
      o->value(0);
    }
  } else {
    if (selected) {
      Fd_Shell_Command *cmd = g_shell_config->list[selected-1];
      int v = o->value();
      if (v) {
        cmd->flags |= Fd_Shell_Command::CLEAR_HISTORY;
      } else {
        cmd->flags &= ~Fd_Shell_Command::CLEAR_HISTORY;
      }
      if (cmd->storage == FD_STORE_PROJECT) set_modflag(1);
    }
  }
}

Fl_Box *w_settings_shell_fd_project=(Fl_Box *)0;

static const unsigned char idata_fd_project[] =
{137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,32,0,0,0,32,8,6,0,0,0,
115,122,122,244,0,0,1,110,105,67,67,80,105,99,99,0,0,40,145,117,145,187,75,195,
80,20,198,127,173,239,23,14,58,136,116,200,80,197,65,65,20,196,81,235,208,165,
72,169,21,172,186,180,49,109,133,164,13,73,139,136,171,224,226,80,112,16,93,
124,13,254,7,186,10,174,10,130,160,8,34,110,238,190,22,145,120,174,45,180,136,
189,225,230,252,248,238,253,14,39,95,192,31,49,117,203,109,156,2,43,87,112,98,
225,144,182,144,88,212,90,94,104,163,153,46,2,244,39,117,215,158,142,70,35,212,
93,159,119,248,84,189,29,81,189,234,223,251,119,117,172,24,174,14,190,86,225,9,
221,118,10,194,50,13,145,181,130,173,120,91,184,87,207,38,87,132,15,133,135,29,
25,80,248,74,233,169,50,63,43,206,148,249,93,177,19,143,205,128,95,245,212,50,
53,156,170,97,61,235,88,194,67,194,65,203,44,234,149,121,212,151,116,26,185,
249,57,169,253,178,3,184,196,8,19,66,35,69,145,85,76,10,140,72,205,73,102,255,
251,70,127,125,179,228,197,163,203,219,102,29,71,28,25,178,226,29,22,181,40,93,
13,169,105,209,13,121,76,214,85,238,127,243,116,211,227,99,229,238,157,33,104,
122,242,188,183,1,104,217,129,239,146,231,125,29,121,222,247,49,52,60,194,69,
174,234,207,75,78,147,31,162,151,170,90,240,0,186,55,225,236,178,170,165,118,
225,124,11,250,30,236,164,147,252,149,26,100,251,211,105,120,61,133,174,4,244,
220,64,251,82,57,171,202,57,39,247,16,223,144,95,116,13,123,251,48,40,247,187,
151,127,0,229,44,103,253,189,250,32,75,0,0,0,9,112,72,89,115,0,0,22,37,0,0,22,
37,1,73,82,36,240,0,0,1,13,116,69,88,116,82,97,119,32,112,114,111,102,105,108,
101,32,116,121,112,101,32,101,120,105,102,0,10,101,120,105,102,10,32,32,32,32,
32,49,49,52,10,52,53,55,56,54,57,54,54,48,48,48,48,52,57,52,57,50,97,48,48,48,
56,48,48,48,48,48,48,48,52,48,48,49,97,48,49,48,53,48,48,48,49,48,48,48,48,48,
48,51,101,48,48,48,48,48,48,49,98,48,49,48,53,48,48,48,49,48,48,48,48,48,48,10,
52,54,48,48,48,48,48,48,50,56,48,49,48,51,48,48,48,49,48,48,48,48,48,48,48,50,
48,48,48,48,48,48,54,57,56,55,48,52,48,48,48,49,48,48,48,48,48,48,52,101,48,48,
48,48,48,48,48,48,48,48,48,48,48,48,57,48,48,48,48,48,48,48,10,48,49,48,48,48,
48,48,48,57,48,48,48,48,48,48,48,48,49,48,48,48,48,48,48,48,50,48,48,48,50,97,
48,48,52,48,48,48,49,48,48,48,48,48,48,53,50,48,48,48,48,48,48,48,51,97,48,48,
52,48,48,48,49,48,48,48,48,48,48,56,48,48,48,10,48,48,48,48,48,48,48,48,48,48,
48,48,10,190,225,144,105,0,0,0,90,116,69,88,116,82,97,119,32,112,114,111,102,
105,108,101,32,116,121,112,101,32,105,112,116,99,0,10,105,112,116,99,10,32,32,
32,32,32,32,50,54,10,53,48,54,56,54,102,55,52,54,102,55,51,54,56,54,102,55,48,
50,48,51,51,50,101,51,48,48,48,51,56,52,50,52,57,52,100,48,52,48,52,48,48,48,
48,48,48,48,48,48,48,48,48,10,199,209,105,220,0,0,20,96,116,69,88,116,82,97,
119,32,112,114,111,102,105,108,101,32,116,121,112,101,32,120,109,112,0,10,120,
109,112,10,32,32,32,32,50,53,53,53,10,51,99,51,102,55,56,55,48,54,49,54,51,54,
98,54,53,55,52,50,48,54,50,54,53,54,55,54,57,54,101,51,100,50,50,101,102,98,98,
98,102,50,50,50,48,54,57,54,52,51,100,50,50,53,55,51,53,52,100,51,48,52,100,55,
48,52,51,54,53,54,56,54,57,10,52,56,55,97,55,50,54,53,53,51,55,97,52,101,53,52,
54,51,55,97,54,98,54,51,51,57,54,52,50,50,51,102,51,101,48,97,51,99,55,56,51,
97,55,56,54,100,55,48,54,100,54,53,55,52,54,49,50,48,55,56,54,100,54,99,54,101,
55,51,51,97,55,56,10,51,100,50,50,54,49,54,52,54,102,54,50,54,53,51,97,54,101,
55,51,51,97,54,100,54,53,55,52,54,49,50,102,50,50,50,48,55,56,51,97,55,56,54,
100,55,48,55,52,54,98,51,100,50,50,53,56,52,100,53,48,50,48,52,51,54,102,55,50,
54,53,50,48,10,51,52,50,101,51,52,50,101,51,48,50,100,52,53,55,56,54,57,55,54,
51,50,50,50,51,101,48,97,50,48,51,99,55,50,54,52,54,54,51,97,53,50,52,52,52,54,
50,48,55,56,54,100,54,99,54,101,55,51,51,97,55,50,54,52,54,54,51,100,50,50,54,
56,10,55,52,55,52,55,48,51,97,50,102,50,102,55,55,55,55,55,55,50,101,55,55,51,
51,50,101,54,102,55,50,54,55,50,102,51,49,51,57,51,57,51,57,50,102,51,48,51,50,
50,102,51,50,51,50,50,100,55,50,54,52,54,54,50,100,55,51,55,57,54,101,55,52,10,
54,49,55,56,50,100,54,101,55,51,50,51,50,50,51,101,48,97,50,48,50,48,51,99,55,
50,54,52,54,54,51,97,52,52,54,53,55,51,54,51,55,50,54,57,55,48,55,52,54,57,54,
102,54,101,50,48,55,50,54,52,54,54,51,97,54,49,54,50,54,102,55,53,10,55,52,51,
100,50,50,50,50,48,97,50,48,50,48,50,48,50,48,55,56,54,100,54,99,54,101,55,51,
51,97,54,53,55,56,54,57,54,54,51,100,50,50,54,56,55,52,55,52,55,48,51,97,50,
102,50,102,54,101,55,51,50,101,54,49,54,52,54,102,54,50,54,53,10,50,101,54,51,
54,102,54,100,50,102,54,53,55,56,54,57,54,54,50,102,51,49,50,101,51,48,50,102,
50,50,48,97,50,48,50,48,50,48,50,48,55,56,54,100,54,99,54,101,55,51,51,97,55,
52,54,57,54,54,54,54,51,100,50,50,54,56,55,52,55,52,55,48,10,51,97,50,102,50,
102,54,101,55,51,50,101,54,49,54,52,54,102,54,50,54,53,50,101,54,51,54,102,54,
100,50,102,55,52,54,57,54,54,54,54,50,102,51,49,50,101,51,48,50,102,50,50,48,97,
50,48,50,48,50,48,54,53,55,56,54,57,54,54,51,97,53,48,10,54,57,55,56,54,53,54,
99,53,56,52,52,54,57,54,100,54,53,54,101,55,51,54,57,54,102,54,101,51,100,50,
50,51,56,51,50,50,50,48,97,50,48,50,48,50,48,54,53,55,56,54,57,54,54,51,97,53,
48,54,57,55,56,54,53,54,99,53,57,52,52,54,57,10,54,100,54,53,54,101,55,51,54,
57,54,102,54,101,51,100,50,50,51,49,51,50,51,56,50,50,48,97,50,48,50,48,50,48,
55,52,54,57,54,54,54,54,51,97,53,50,54,53,55,51,54,102,54,99,55,53,55,52,54,57,
54,102,54,101,53,53,54,101,54,57,55,52,10,51,100,50,50,51,50,50,50,48,97,50,48,
50,48,50,48,55,52,54,57,54,54,54,54,51,97,53,57,53,50,54,53,55,51,54,102,54,99,
55,53,55,52,54,57,54,102,54,101,51,100,50,50,51,49,51,52,51,52,50,48,50,102,50,
48,51,49,50,50,48,97,50,48,10,50,48,50,48,55,52,54,57,54,54,54,54,51,97,53,56,
53,50,54,53,55,51,54,102,54,99,55,53,55,52,54,57,54,102,54,101,51,100,50,50,51,
49,51,52,51,52,50,48,50,102,50,48,51,49,50,50,50,102,51,101,48,97,50,48,51,99,
50,102,55,50,54,52,10,54,54,51,97,53,50,52,52,52,54,51,101,48,97,51,99,50,102,
55,56,51,97,55,56,54,100,55,48,54,100,54,53,55,52,54,49,51,101,48,97,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,48,97,50,48,10,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,48,97,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,48,97,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,48,
97,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,48,97,10,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,10,48,97,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,48,97,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,48,
97,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,48,97,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,48,97,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,48,50,48,50,48,10,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,48,97,51,99,51,102,55,56,55,48,54,49,
54,51,54,98,54,53,55,52,50,48,54,53,54,101,54,52,51,100,50,50,55,55,50,50,51,
102,51,101,10,87,123,188,247,0,0,3,115,73,68,65,84,88,71,189,151,75,75,91,65,20,
199,79,110,222,169,52,180,203,22,186,239,210,47,80,236,206,126,5,177,17,151,46,
68,23,82,220,138,90,84,116,163,184,80,81,132,98,93,234,42,203,210,79,209,149,
32,213,68,164,165,165,129,230,97,94,246,252,166,157,246,246,102,154,132,230,
226,31,134,59,247,204,153,243,158,123,207,68,206,206,206,164,86,171,73,52,26,
149,68,34,17,175,84,42,215,123,123,123,15,119,118,118,164,23,26,141,134,164,211,
105,243,28,29,29,149,229,229,229,183,177,88,236,101,171,213,106,235,83,154,205,
166,120,158,39,145,72,196,12,23,188,106,181,42,201,100,82,110,111,111,69,149,55,
246,247,247,139,187,187,187,102,209,110,252,215,200,100,50,162,202,12,111,62,
159,151,211,211,211,49,85,252,70,135,231,212,230,64,44,149,74,201,205,205,141,
196,227,113,97,174,222,84,48,102,102,102,70,230,230,230,186,110,110,183,219,178,
177,177,33,219,219,219,198,129,133,133,5,188,30,27,31,31,71,78,78,89,90,93,5,40,
60,60,32,92,8,168,215,235,120,86,96,129,148,244,138,0,70,219,208,142,140,140,
144,66,89,89,89,145,163,163,163,49,221,255,90,195,31,65,62,60,200,7,240,48,39,
53,198,0,187,96,94,126,230,43,195,28,239,122,129,189,150,111,120,120,88,22,23,
23,13,109,105,105,73,142,143,143,95,169,242,247,42,51,107,249,144,79,202,49,
136,186,1,198,0,191,17,186,88,177,194,123,1,239,134,134,134,76,228,152,79,78,78,
202,250,250,186,137,232,218,218,154,156,156,156,60,211,72,92,43,235,115,60,247,
43,166,238,128,137,67,192,136,102,183,170,245,3,30,45,92,227,25,74,121,78,76,
76,152,72,112,2,168,137,195,195,195,148,210,223,169,226,23,208,40,92,210,203,
201,3,158,205,15,33,98,232,60,101,22,188,222,133,108,235,135,90,64,40,239,200,
154,154,154,50,17,96,190,185,185,73,77,80,224,121,93,127,130,62,12,97,15,48,6,
88,101,254,72,244,19,1,194,138,48,242,74,26,108,152,145,145,203,229,76,65,226,
212,234,234,170,28,28,28,96,228,71,235,168,69,44,24,110,221,156,237,39,255,22,
40,197,155,173,173,45,115,36,153,147,22,66,205,241,198,57,140,164,54,74,165,82,
99,122,122,250,47,71,141,235,129,40,164,131,133,249,47,16,242,96,85,227,29,133,
201,187,149,107,63,116,58,10,24,131,209,22,158,221,4,51,2,117,67,201,127,110,
187,1,190,249,249,121,185,188,188,148,98,177,40,87,87,87,102,126,126,126,110,
230,133,66,65,46,46,46,100,118,118,214,242,127,192,32,127,10,92,149,246,217,65,
11,11,159,130,4,151,1,53,7,45,44,60,8,18,92,6,60,114,208,194,66,35,72,112,25,
80,113,208,194,66,50,72,112,25,240,205,65,11,11,55,65,194,93,167,160,175,8,68,
29,180,176,224,142,0,103,211,254,163,245,140,86,59,247,253,31,252,95,216,95,
243,108,144,199,21,129,14,166,16,113,63,72,112,25,80,119,208,194,194,215,32,193,
101,64,104,41,112,160,28,36,220,117,10,238,5,9,119,157,130,14,125,46,3,254,252,
43,195,71,51,72,112,25,240,197,65,11,11,29,245,229,217,179,106,155,10,237,104,
154,253,180,228,253,2,153,246,142,161,207,36,223,26,123,155,2,30,139,86,33,237,
148,246,118,41,255,197,97,16,160,148,238,135,214,140,161,198,52,81,110,47,39,
224,119,71,196,176,157,45,253,28,173,211,160,176,109,25,45,25,50,213,193,199,
190,27,152,225,137,209,159,99,17,30,151,203,101,218,236,44,52,154,76,90,234,65,
128,34,228,250,90,246,136,255,29,196,176,206,118,175,58,79,232,226,83,24,236,
213,122,16,176,223,94,207,73,175,70,249,59,81,177,117,128,158,31,49,127,246,30,
207,181,170,20,0,0,0,0,73,69,78,68,174,66,96,130};
static Fl_Image *image_fd_project() {
  static Fl_Image *image = NULL;
  if (!image)
    image = new Fl_PNG_Image("fd_project.png", idata_fd_project, 6950);
  return image;
}

Fl_Box *w_settings_shell_fd_user=(Fl_Box *)0;

static const unsigned char idata_fd_user[] =
{137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,32,0,0,0,32,8,6,0,0,0,
115,122,122,244,0,0,1,110,105,67,67,80,105,99,99,0,0,40,145,117,145,187,75,195,
80,20,198,127,173,239,23,14,58,136,116,200,80,197,65,65,20,196,81,235,208,165,
72,169,21,172,186,180,49,109,133,164,13,73,139,136,171,224,226,80,112,16,93,
124,13,254,7,186,10,174,10,130,160,8,34,110,238,190,22,145,120,174,45,180,136,
189,225,230,252,248,238,253,14,39,95,192,31,49,117,203,109,156,2,43,87,112,98,
225,144,182,144,88,212,90,94,104,163,153,46,2,244,39,117,215,158,142,70,35,212,
93,159,119,248,84,189,29,81,189,234,223,251,119,117,172,24,174,14,190,86,225,9,
221,118,10,194,50,13,145,181,130,173,120,91,184,87,207,38,87,132,15,133,135,29,
25,80,248,74,233,169,50,63,43,206,148,249,93,177,19,143,205,128,95,245,212,50,
53,156,170,97,61,235,88,194,67,194,65,203,44,234,149,121,212,151,116,26,185,
249,57,169,253,178,3,184,196,8,19,66,35,69,145,85,76,10,140,72,205,73,102,255,
251,70,127,125,179,228,197,163,203,219,102,29,71,28,25,178,226,29,22,181,40,93,
13,169,105,209,13,121,76,214,85,238,127,243,116,211,227,99,229,238,157,33,104,
122,242,188,183,1,104,217,129,239,146,231,125,29,121,222,247,49,52,60,194,69,
174,234,207,75,78,147,31,162,151,170,90,240,0,186,55,225,236,178,170,165,118,
225,124,11,250,30,236,164,147,252,149,26,100,251,211,105,120,61,133,174,4,244,
220,64,251,82,57,171,202,57,39,247,16,223,144,95,116,13,123,251,48,40,247,187,
151,127,0,229,44,103,253,189,250,32,75,0,0,0,9,112,72,89,115,0,0,22,37,0,0,22,
37,1,73,82,36,240,0,0,1,13,116,69,88,116,82,97,119,32,112,114,111,102,105,108,
101,32,116,121,112,101,32,101,120,105,102,0,10,101,120,105,102,10,32,32,32,32,
32,49,49,52,10,52,53,55,56,54,57,54,54,48,48,48,48,52,57,52,57,50,97,48,48,48,
56,48,48,48,48,48,48,48,52,48,48,49,97,48,49,48,53,48,48,48,49,48,48,48,48,48,
48,51,101,48,48,48,48,48,48,49,98,48,49,48,53,48,48,48,49,48,48,48,48,48,48,10,
52,54,48,48,48,48,48,48,50,56,48,49,48,51,48,48,48,49,48,48,48,48,48,48,48,50,
48,48,48,48,48,48,54,57,56,55,48,52,48,48,48,49,48,48,48,48,48,48,52,101,48,48,
48,48,48,48,48,48,48,48,48,48,48,48,57,48,48,48,48,48,48,48,10,48,49,48,48,48,
48,48,48,57,48,48,48,48,48,48,48,48,49,48,48,48,48,48,48,48,50,48,48,48,50,97,
48,48,52,48,48,48,49,48,48,48,48,48,48,53,50,48,48,48,48,48,48,48,51,97,48,48,
52,48,48,48,49,48,48,48,48,48,48,56,48,48,48,10,48,48,48,48,48,48,48,48,48,48,
48,48,10,190,225,144,105,0,0,0,90,116,69,88,116,82,97,119,32,112,114,111,102,
105,108,101,32,116,121,112,101,32,105,112,116,99,0,10,105,112,116,99,10,32,32,
32,32,32,32,50,54,10,53,48,54,56,54,102,55,52,54,102,55,51,54,56,54,102,55,48,
50,48,51,51,50,101,51,48,48,48,51,56,52,50,52,57,52,100,48,52,48,52,48,48,48,
48,48,48,48,48,48,48,48,48,10,199,209,105,220,0,0,20,96,116,69,88,116,82,97,
119,32,112,114,111,102,105,108,101,32,116,121,112,101,32,120,109,112,0,10,120,
109,112,10,32,32,32,32,50,53,53,53,10,51,99,51,102,55,56,55,48,54,49,54,51,54,
98,54,53,55,52,50,48,54,50,54,53,54,55,54,57,54,101,51,100,50,50,101,102,98,98,
98,102,50,50,50,48,54,57,54,52,51,100,50,50,53,55,51,53,52,100,51,48,52,100,55,
48,52,51,54,53,54,56,54,57,10,52,56,55,97,55,50,54,53,53,51,55,97,52,101,53,52,
54,51,55,97,54,98,54,51,51,57,54,52,50,50,51,102,51,101,48,97,51,99,55,56,51,
97,55,56,54,100,55,48,54,100,54,53,55,52,54,49,50,48,55,56,54,100,54,99,54,101,
55,51,51,97,55,56,10,51,100,50,50,54,49,54,52,54,102,54,50,54,53,51,97,54,101,
55,51,51,97,54,100,54,53,55,52,54,49,50,102,50,50,50,48,55,56,51,97,55,56,54,
100,55,48,55,52,54,98,51,100,50,50,53,56,52,100,53,48,50,48,52,51,54,102,55,50,
54,53,50,48,10,51,52,50,101,51,52,50,101,51,48,50,100,52,53,55,56,54,57,55,54,
51,50,50,50,51,101,48,97,50,48,51,99,55,50,54,52,54,54,51,97,53,50,52,52,52,54,
50,48,55,56,54,100,54,99,54,101,55,51,51,97,55,50,54,52,54,54,51,100,50,50,54,
56,10,55,52,55,52,55,48,51,97,50,102,50,102,55,55,55,55,55,55,50,101,55,55,51,
51,50,101,54,102,55,50,54,55,50,102,51,49,51,57,51,57,51,57,50,102,51,48,51,50,
50,102,51,50,51,50,50,100,55,50,54,52,54,54,50,100,55,51,55,57,54,101,55,52,10,
54,49,55,56,50,100,54,101,55,51,50,51,50,50,51,101,48,97,50,48,50,48,51,99,55,
50,54,52,54,54,51,97,52,52,54,53,55,51,54,51,55,50,54,57,55,48,55,52,54,57,54,
102,54,101,50,48,55,50,54,52,54,54,51,97,54,49,54,50,54,102,55,53,10,55,52,51,
100,50,50,50,50,48,97,50,48,50,48,50,48,50,48,55,56,54,100,54,99,54,101,55,51,
51,97,54,53,55,56,54,57,54,54,51,100,50,50,54,56,55,52,55,52,55,48,51,97,50,
102,50,102,54,101,55,51,50,101,54,49,54,52,54,102,54,50,54,53,10,50,101,54,51,
54,102,54,100,50,102,54,53,55,56,54,57,54,54,50,102,51,49,50,101,51,48,50,102,
50,50,48,97,50,48,50,48,50,48,50,48,55,56,54,100,54,99,54,101,55,51,51,97,55,
52,54,57,54,54,54,54,51,100,50,50,54,56,55,52,55,52,55,48,10,51,97,50,102,50,
102,54,101,55,51,50,101,54,49,54,52,54,102,54,50,54,53,50,101,54,51,54,102,54,
100,50,102,55,52,54,57,54,54,54,54,50,102,51,49,50,101,51,48,50,102,50,50,48,97,
50,48,50,48,50,48,54,53,55,56,54,57,54,54,51,97,53,48,10,54,57,55,56,54,53,54,
99,53,56,52,52,54,57,54,100,54,53,54,101,55,51,54,57,54,102,54,101,51,100,50,
50,51,56,51,50,50,50,48,97,50,48,50,48,50,48,54,53,55,56,54,57,54,54,51,97,53,
48,54,57,55,56,54,53,54,99,53,57,52,52,54,57,10,54,100,54,53,54,101,55,51,54,
57,54,102,54,101,51,100,50,50,51,49,51,50,51,56,50,50,48,97,50,48,50,48,50,48,
55,52,54,57,54,54,54,54,51,97,53,50,54,53,55,51,54,102,54,99,55,53,55,52,54,57,
54,102,54,101,53,53,54,101,54,57,55,52,10,51,100,50,50,51,50,50,50,48,97,50,48,
50,48,50,48,55,52,54,57,54,54,54,54,51,97,53,57,53,50,54,53,55,51,54,102,54,99,
55,53,55,52,54,57,54,102,54,101,51,100,50,50,51,49,51,52,51,52,50,48,50,102,50,
48,51,49,50,50,48,97,50,48,10,50,48,50,48,55,52,54,57,54,54,54,54,51,97,53,56,
53,50,54,53,55,51,54,102,54,99,55,53,55,52,54,57,54,102,54,101,51,100,50,50,51,
49,51,52,51,52,50,48,50,102,50,48,51,49,50,50,50,102,51,101,48,97,50,48,51,99,
50,102,55,50,54,52,10,54,54,51,97,53,50,52,52,52,54,51,101,48,97,51,99,50,102,
55,56,51,97,55,56,54,100,55,48,54,100,54,53,55,52,54,49,51,101,48,97,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,48,97,50,48,10,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,48,97,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,48,97,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,48,
97,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,48,97,10,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,10,48,97,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,48,97,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,48,
97,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,48,97,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,48,97,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,48,50,48,50,48,10,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,48,97,51,99,51,102,55,56,55,48,54,49,
54,51,54,98,54,53,55,52,50,48,54,53,54,101,54,52,51,100,50,50,55,55,50,50,51,
102,51,101,10,87,123,188,247,0,0,9,241,73,68,65,84,88,71,109,87,105,144,85,197,
21,254,186,239,242,222,155,25,102,88,12,14,46,227,16,96,12,26,80,118,103,16,
113,3,5,89,203,10,70,75,42,106,170,48,196,16,141,154,20,18,177,8,41,21,149,82,
81,244,71,48,166,42,75,37,96,22,29,5,9,155,131,37,139,16,65,113,153,25,71,8,66,
153,165,148,137,226,204,91,238,210,55,223,233,251,30,49,58,77,53,115,223,237,
190,167,207,249,206,57,223,57,173,218,59,223,128,163,92,104,147,32,138,12,84,
162,225,58,62,100,36,137,66,38,147,65,177,88,4,31,225,186,46,130,56,134,210,9,
188,140,139,158,82,30,78,198,65,20,26,238,5,60,237,91,57,242,157,231,184,8,75,1,
148,82,118,130,223,12,168,27,152,62,127,97,104,3,23,9,52,226,242,76,228,173,50,
118,81,169,4,249,124,15,5,198,86,160,85,138,135,185,78,22,189,61,37,104,30,104,
98,5,87,103,184,158,227,51,191,113,249,206,24,132,97,152,202,41,79,101,13,74,
240,229,225,26,83,131,68,203,193,49,12,2,24,45,31,184,246,35,199,113,64,120,104,
177,139,222,82,137,104,228,16,169,88,187,137,250,238,137,79,62,251,246,238,93,
187,250,83,232,137,113,227,199,71,77,77,77,71,78,22,78,222,149,209,94,41,227,
249,68,165,68,153,148,65,52,42,255,250,26,174,67,200,211,161,211,153,104,139,
136,60,151,104,133,235,106,68,38,132,118,29,132,145,25,250,139,103,158,217,186,
105,227,214,97,199,143,253,131,240,41,56,70,67,211,13,67,134,12,198,236,249,215,
220,178,112,225,245,187,170,171,252,233,132,58,53,216,162,233,244,121,184,12,
213,217,222,97,31,100,183,5,138,10,40,229,88,248,5,21,223,23,69,138,242,46,179,
252,222,159,183,183,190,176,121,104,130,44,178,153,254,152,56,102,10,98,198,196,
161,183,246,163,55,255,31,120,185,24,87,207,188,20,15,220,191,242,128,49,193,
196,40,14,98,71,149,229,81,137,218,218,218,20,213,47,12,87,39,97,89,1,5,35,112,
241,3,109,53,151,169,24,3,69,56,158,118,215,172,121,114,127,235,11,155,134,122,
110,45,150,46,125,16,45,205,151,211,184,156,85,160,95,181,135,109,59,94,194,170,
71,238,69,235,11,127,197,160,1,3,198,222,241,163,239,63,79,9,179,147,10,242,
125,123,128,56,19,70,9,26,9,52,135,24,136,66,137,138,184,196,103,122,194,247,
125,245,234,206,221,109,191,122,246,119,163,20,170,112,255,202,53,184,184,249,
106,6,99,21,181,118,224,185,89,20,243,6,151,77,189,6,203,151,61,4,159,10,62,251,
203,223,98,223,190,191,141,75,143,48,167,142,234,35,6,233,70,30,46,43,137,157,
113,249,131,116,138,117,68,166,186,189,189,115,50,19,18,115,103,45,192,248,177,
23,35,10,178,60,184,14,90,101,9,105,22,97,192,248,40,41,76,110,158,134,185,179,
175,227,59,31,7,14,188,233,126,249,176,190,178,160,18,129,68,168,156,50,246,111,
100,115,93,16,160,207,146,55,15,190,131,160,148,96,204,133,205,40,246,42,248,78,
53,24,151,20,232,160,144,15,80,83,221,143,252,193,12,9,52,206,251,198,88,196,
92,123,243,224,161,56,149,92,65,160,239,161,157,47,40,165,202,81,43,239,44,26,
212,56,8,130,248,224,129,3,240,189,44,134,15,111,66,198,175,161,229,220,39,123,
153,1,53,53,57,20,11,198,198,144,239,229,48,98,68,19,60,47,131,183,223,126,183,
88,62,162,143,99,255,55,180,48,147,107,35,228,203,27,211,223,76,195,184,177,
177,129,86,149,112,244,232,17,166,98,17,145,216,38,228,198,45,226,127,215,35,
123,122,224,90,47,142,29,63,76,18,42,161,190,190,254,36,18,221,135,220,175,156,
162,203,169,167,210,116,41,127,36,40,72,124,184,218,137,167,78,157,130,108,149,
135,182,157,91,200,7,12,80,29,17,58,11,144,245,171,226,239,48,250,156,73,219,
131,215,118,109,227,122,140,25,51,102,100,42,178,83,37,250,118,133,85,47,34,158,
9,179,65,38,148,87,230,1,199,42,101,146,200,204,152,57,237,125,147,228,177,
243,181,205,120,175,99,31,81,233,229,222,34,21,76,200,142,204,29,174,105,175,
136,119,59,247,98,123,91,171,85,104,250,244,43,125,77,6,53,166,98,28,229,39,95,
85,66,71,41,251,83,63,42,65,14,168,40,18,89,10,117,108,38,12,31,209,120,83,115,
203,120,148,130,147,184,231,222,219,177,105,243,6,120,126,36,52,129,124,177,100,
41,124,71,219,75,88,198,181,56,233,193,228,201,147,208,216,216,56,75,228,168,
50,11,138,187,84,31,222,176,172,35,100,33,22,11,92,177,74,103,197,119,36,33,81,
111,207,83,79,175,217,187,224,186,121,40,20,63,197,99,143,63,136,205,91,90,89,
17,149,240,4,182,110,219,132,135,30,89,137,124,161,27,243,230,207,196,186,103,
158,218,67,22,125,79,170,171,84,80,97,191,40,138,208,91,232,65,108,34,235,182,
34,43,101,41,40,165,65,104,161,150,169,211,103,85,174,15,162,152,148,226,32,40,
18,137,112,206,178,101,75,183,141,190,224,124,107,49,139,55,74,20,98,40,208,
247,61,6,102,128,81,163,206,199,138,21,247,173,47,20,10,45,130,105,38,227,217,
170,88,98,33,75,203,112,130,79,79,118,227,147,238,19,164,238,188,157,172,39,14,
9,141,126,42,79,139,136,69,37,101,66,177,192,243,60,233,11,62,102,74,62,76,82,
162,50,9,38,76,152,96,149,148,67,46,188,112,12,171,90,6,29,29,93,193,231,159,23,
158,20,223,107,126,28,70,37,155,214,242,189,252,22,20,4,101,73,83,249,93,118,
129,197,223,22,159,116,166,164,45,127,197,255,217,108,214,30,24,4,17,118,239,
126,61,137,194,4,35,207,29,133,65,3,79,39,180,202,90,87,83,93,135,97,67,207,101,
63,224,153,3,111,28,202,184,174,239,136,229,41,145,41,203,41,34,75,179,204,139,
65,50,108,191,192,227,221,83,197,226,212,72,35,213,214,114,250,174,187,187,155,
188,190,79,255,229,207,47,206,223,183,247,157,135,227,64,161,101,210,101,164,94,
32,173,90,160,146,53,152,48,126,10,142,28,237,204,254,224,182,59,159,187,100,
202,164,127,206,155,63,235,195,150,150,139,158,173,170,170,122,217,36,113,94,24,
95,14,15,67,246,29,236,92,114,185,156,85,66,181,119,118,88,6,252,127,69,82,37,
94,106,221,56,106,245,234,71,175,232,62,209,51,203,113,170,91,76,224,231,38,76,
184,20,75,190,119,23,206,58,123,56,203,116,10,181,75,234,62,246,81,39,158,88,
187,10,239,180,239,71,18,247,218,56,169,98,149,252,241,79,238,196,220,185,179,
47,247,60,231,21,81,34,117,133,177,127,5,25,213,222,222,14,169,136,142,231,218,
128,50,73,32,10,12,88,187,246,233,59,215,173,251,245,45,42,169,61,99,120,227,88,
76,155,190,0,83,155,175,68,255,65,131,105,56,59,7,82,95,28,146,176,24,55,137,
229,112,33,167,8,255,254,248,24,118,182,109,196,43,109,47,163,189,243,32,15,138,
177,232,214,155,112,251,29,183,77,85,137,121,53,45,72,58,45,76,68,80,189,253,
214,33,194,209,207,194,33,41,215,211,243,233,232,229,203,151,255,126,203,150,29,
231,185,172,120,75,22,255,20,211,167,221,72,70,172,163,94,14,164,159,8,36,152,0,
219,204,74,200,136,44,9,48,41,227,174,71,106,87,228,6,213,139,23,95,124,14,79,
174,125,136,27,3,92,50,181,217,172,121,124,245,24,173,205,33,203,158,182,81,165,
225,75,126,184,132,86,211,227,180,202,209,222,153,119,223,125,207,235,219,183,
239,110,168,171,61,3,43,239,123,156,254,190,10,85,85,167,161,80,136,88,130,93,
27,88,68,144,169,71,146,226,193,177,73,27,78,66,12,135,235,113,28,165,5,149,
194,217,39,226,155,163,70,99,207,174,93,248,224,112,151,58,124,164,107,241,244,
171,166,29,103,237,56,40,116,45,25,161,125,95,160,15,108,239,199,96,187,97,103,
219,158,129,190,219,31,171,87,173,195,216,11,46,99,233,29,192,146,27,157,138,
222,82,41,141,232,56,182,201,99,93,32,214,136,95,77,148,240,119,134,41,153,35,
186,213,136,131,12,198,140,190,24,143,174,94,135,154,220,215,176,99,251,107,120,
125,239,254,7,136,182,170,196,154,14,216,239,101,115,210,5,71,151,175,88,249,
179,165,33,133,44,188,97,49,154,190,62,142,66,171,73,48,20,200,86,91,14,9,73,54,
174,207,190,136,133,73,44,141,227,52,88,45,205,10,141,11,125,115,198,180,44,138,
121,71,64,127,148,242,62,70,142,156,136,57,115,174,167,66,46,86,63,242,196,32,
130,214,84,9,119,45,36,81,40,244,158,182,97,195,134,223,124,208,245,193,192,179,
207,26,134,111,93,187,144,13,8,157,29,123,105,59,109,42,221,140,177,129,26,210,
223,18,197,158,167,109,129,137,152,86,202,94,92,202,118,73,185,230,118,135,37,
211,247,170,17,20,20,22,222,120,11,59,231,6,116,117,29,118,159,127,190,117,69,
84,142,35,29,209,145,142,155,61,255,15,235,255,116,70,93,221,233,184,249,59,
139,104,5,153,138,157,175,133,88,167,80,11,2,162,172,237,106,89,5,227,40,96,239,
79,74,54,129,205,0,197,12,136,19,42,39,237,16,247,243,106,192,192,78,121,223,
146,26,207,91,116,235,98,42,31,99,195,31,215,79,114,41,75,134,155,48,178,185,
195,59,114,248,56,130,162,143,230,139,166,216,194,164,43,209,29,167,85,76,243,
191,48,76,155,28,199,241,108,76,164,205,108,74,90,70,114,154,123,36,150,4,21,
113,179,40,171,29,9,204,34,41,187,26,227,199,93,100,255,190,223,113,204,72,44,
249,76,101,22,35,15,135,187,62,26,98,34,31,67,234,207,177,27,148,244,134,210,
116,136,134,101,4,36,215,229,224,180,175,55,246,112,197,158,80,131,190,86,25,72,
95,85,25,210,97,185,90,89,235,131,82,104,175,114,48,164,97,93,139,51,235,155,
104,168,151,251,232,248,103,20,202,119,212,86,31,61,122,108,149,4,80,67,67,131,
189,136,228,195,30,114,127,129,26,74,235,205,128,67,234,83,200,83,249,222,152,
118,58,94,249,89,242,46,172,108,42,95,195,180,101,87,47,35,233,202,106,232,196,
168,98,176,15,30,124,26,254,254,161,170,233,234,234,194,208,198,122,81,52,202,
53,156,51,196,44,186,245,230,127,13,169,111,200,38,186,23,253,6,120,82,231,221,
176,196,226,159,208,145,112,107,172,97,9,97,81,9,159,217,14,33,166,242,18,73,
230,4,103,29,223,243,217,94,114,184,238,68,118,63,97,36,82,174,152,47,212,204,
238,14,243,174,189,2,19,155,135,117,203,225,246,210,218,222,241,22,3,134,23,84,
238,147,74,103,27,19,11,113,26,120,114,249,176,150,90,139,203,237,112,5,133,83,
163,124,159,80,105,166,84,154,25,123,221,51,105,57,150,247,65,216,203,236,81,
116,89,108,93,41,107,255,5,119,155,194,247,64,241,254,70,0,0,0,0,73,69,78,68,
174,66,96,130};
static Fl_Image *image_fd_user() {
  static Fl_Image *image = NULL;
  if (!image)
    image = new Fl_PNG_Image("fd_user.png", idata_fd_user, 8612);
  return image;
}

Fl_Group *w_settings_i18n_tab=(Fl_Group *)0;

static void cb_w_settings_i18n_tab(Fl_Group* o, void* v) {
  propagate_load(o, v);
}

static const unsigned char idata_language_64[] =
{137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,96,0,0,0,64,8,4,0,0,0,
79,61,186,133,0,0,5,113,73,68,65,84,104,222,237,154,107,76,28,85,20,199,127,
188,10,44,182,184,116,75,75,65,1,129,146,20,140,15,106,91,170,166,129,182,40,98,
53,104,98,66,240,145,26,67,140,38,245,21,245,139,177,54,126,48,126,48,209,38,
162,198,132,24,141,181,173,209,86,98,130,129,32,98,1,91,196,214,90,181,136,20,
90,160,32,10,8,88,96,11,44,227,7,102,239,206,46,236,206,238,236,206,204,154,
120,246,195,158,123,103,231,222,243,223,123,207,255,156,251,0,117,89,193,43,140,
226,64,210,244,89,96,154,47,72,197,52,137,230,144,102,227,93,159,78,178,204,2,
176,63,4,230,75,72,52,154,5,96,52,36,230,75,204,82,164,207,4,81,147,171,157,74,
28,177,26,58,152,112,42,49,220,74,147,25,0,34,157,230,239,39,131,133,128,26,
143,96,154,26,90,156,197,181,230,140,128,44,177,92,171,193,15,167,72,116,21,162,
244,0,16,25,124,19,14,102,152,51,145,36,131,148,113,154,57,199,90,138,200,88,
182,249,213,174,194,80,24,2,88,160,153,87,1,24,96,175,114,186,136,137,183,133,
134,69,203,71,248,52,140,0,56,24,225,31,192,206,247,114,77,43,219,73,101,129,56,
214,16,167,248,229,205,188,193,69,86,83,85,78,167,30,0,34,84,127,33,45,126,37,
242,46,57,194,252,54,62,164,199,157,38,101,154,181,114,15,229,172,92,210,204,
166,136,48,242,129,17,14,114,122,73,173,29,59,48,193,1,242,40,48,204,137,53,177,
208,140,138,63,254,105,32,11,105,2,96,101,147,74,204,8,115,26,77,228,65,210,232,
195,225,230,42,221,116,201,250,42,225,43,179,174,216,189,53,160,46,254,162,159,
89,29,89,40,131,74,143,246,175,80,35,0,196,3,115,116,241,19,3,92,118,254,224,
120,64,29,204,49,204,219,188,201,188,110,113,32,134,24,15,0,3,178,102,195,194,
28,245,188,47,106,52,244,20,77,6,175,147,207,99,106,16,52,166,18,14,134,185,
160,160,80,152,18,230,166,96,225,20,175,185,155,175,205,63,31,226,57,93,156,216,
65,27,47,241,56,111,113,65,212,13,10,61,23,7,141,216,67,67,49,207,232,26,7,106,
73,39,149,24,64,226,146,120,154,206,44,103,68,41,73,67,251,118,166,157,234,26,
93,0,184,226,192,143,236,38,9,152,22,14,12,89,56,24,145,245,93,236,37,193,25,
204,253,254,219,187,121,202,9,33,82,23,0,241,88,229,25,126,142,113,146,128,63,
104,149,159,165,145,162,224,39,43,185,92,165,33,69,140,115,141,129,30,62,144,
200,13,98,50,245,2,18,231,196,152,220,66,82,128,255,184,9,145,56,86,177,54,107,
101,146,9,78,186,146,182,128,167,140,9,0,34,200,37,69,214,107,233,228,23,234,68,
128,203,53,120,69,166,49,14,92,195,46,161,31,84,172,84,118,178,238,191,1,32,158,
109,66,111,17,251,14,113,108,115,91,204,132,49,0,216,200,158,37,117,21,100,27,
190,168,215,12,192,66,9,121,30,9,222,78,44,126,190,61,65,19,71,57,19,130,221,
140,32,182,85,50,20,126,0,144,185,204,66,210,91,32,252,152,74,158,164,74,193,94,
134,3,152,166,221,163,251,38,222,161,141,73,63,222,237,162,26,128,126,142,50,
110,206,174,68,47,95,114,204,45,27,5,168,163,137,18,74,177,120,164,218,158,169,
254,9,198,100,253,19,42,84,86,119,186,0,24,231,35,106,189,164,97,181,116,113,
151,79,46,186,36,162,6,64,51,121,196,27,61,133,198,57,165,40,149,242,60,215,43,
202,157,124,231,35,153,150,232,160,93,81,254,156,126,227,71,32,158,20,57,153,
139,99,15,101,216,40,160,142,195,178,217,54,114,124,24,53,202,215,30,147,177,
157,172,32,246,125,53,1,176,81,201,60,253,108,225,110,242,137,7,178,121,148,219,
105,230,56,243,84,144,69,131,215,119,207,114,108,137,231,20,179,222,88,0,81,20,
146,195,12,86,86,137,173,189,4,110,100,3,247,1,201,244,123,77,134,167,150,89,
219,55,113,214,104,0,16,181,236,105,133,69,14,100,222,179,209,223,57,34,107,235,
72,17,187,123,245,108,198,106,124,32,11,92,230,56,41,8,244,14,158,37,83,144,
233,121,51,34,113,224,162,36,208,29,108,165,76,65,166,51,225,15,64,73,160,59,
200,35,129,219,66,64,166,126,251,192,21,250,136,244,114,200,23,193,74,108,170,
84,168,36,208,116,70,152,4,242,249,57,72,50,85,7,176,176,56,74,118,246,249,216,
180,189,142,71,40,84,49,64,73,160,135,100,221,30,52,153,170,3,24,195,230,76,19,
188,199,215,211,68,147,227,243,28,213,157,64,167,151,16,173,86,50,85,247,129,
106,255,14,135,135,84,220,176,91,16,168,55,169,15,58,51,245,54,70,31,248,117,91,
98,150,59,21,160,229,218,7,164,46,105,80,26,148,46,74,251,252,184,142,80,43,13,
74,131,210,160,212,40,37,185,106,131,158,66,243,84,209,206,211,164,249,204,145,
47,115,128,175,252,35,208,18,172,110,118,245,208,17,68,102,234,15,11,205,82,77,
13,169,62,246,41,37,250,124,157,58,41,9,180,136,151,73,118,123,122,130,135,5,
153,238,102,131,78,52,106,231,188,246,112,57,198,55,66,47,35,221,131,173,110,
226,126,62,147,201,180,131,236,0,67,147,33,129,108,92,100,61,57,108,94,66,182,
73,138,123,56,191,6,188,45,111,8,0,11,105,178,86,46,52,101,24,44,160,80,214,
215,251,116,180,16,102,163,129,73,50,85,204,211,75,49,247,46,187,216,76,227,9,
160,151,98,74,195,19,64,20,219,217,200,20,54,215,237,169,128,158,155,14,0,162,
197,102,176,182,231,97,146,78,235,33,255,3,48,91,244,241,1,113,7,225,111,126,
211,112,200,215,19,64,52,208,7,128,72,43,26,248,65,195,235,138,99,214,5,115,0,
180,48,231,36,244,177,224,90,26,54,107,106,126,27,146,219,190,14,94,52,11,64,38,
157,33,48,255,61,163,226,212,114,146,206,17,166,130,48,126,136,23,88,161,222,
205,191,56,75,123,84,202,251,159,166,0,0,0,0,73,69,78,68,174,66,96,130};
static Fl_Image *image_language_64() {
  static Fl_Image *image = NULL;
  if (!image)
    image = new Fl_PNG_Image("language_64.png", idata_language_64, 1450);
  return image;
}

Fl_Choice *i18n_type_chooser=(Fl_Choice *)0;

Fl_Menu_Item menu_i18n_type_chooser[] = {
 {"None", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"GNU gettext", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"POSIX catgets", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Group *i18n_gnu_group=(Fl_Group *)0;

static void cb_i18n_gnu_group(Fl_Group* o, void* v) {
  propagate_load(o, v);
}

Fl_Input *i18n_gnu_include_input=(Fl_Input *)0;

static void cb_i18n_gnu_include_input(Fl_Input* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.i18n_gnu_include.c_str());
  } else {
    undo_checkpoint();
    g_project.i18n_gnu_include = o->value();
    set_modflag(1);
  }
}

Fl_Input *i18n_gnu_conditional_input=(Fl_Input *)0;

static void cb_i18n_gnu_conditional_input(Fl_Input* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.i18n_gnu_conditional.c_str());
  } else {
    undo_checkpoint();
    g_project.i18n_gnu_conditional = o->value();
    set_modflag(1);
  }
}

Fl_Input *i18n_gnu_function_input=(Fl_Input *)0;

static void cb_i18n_gnu_function_input(Fl_Input* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.i18n_gnu_function.c_str());
  } else {
    undo_checkpoint();
    g_project.i18n_gnu_function = o->value();
    set_modflag(1);
  }
}

Fl_Input *i18n_gnu_static_function_input=(Fl_Input *)0;

static void cb_i18n_gnu_static_function_input(Fl_Input* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.i18n_gnu_static_function.c_str());
  } else {
    undo_checkpoint();
    g_project.i18n_gnu_static_function = o->value();
    set_modflag(1);
  }
}

Fl_Group *i18n_posix_group=(Fl_Group *)0;

static void cb_i18n_posix_group(Fl_Group* o, void* v) {
  propagate_load(o, v);
}

Fl_Input *i18n_pos_include_input=(Fl_Input *)0;

static void cb_i18n_pos_include_input(Fl_Input* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.i18n_pos_include.c_str());
  } else {
    undo_checkpoint();
    g_project.i18n_pos_include = o->value();
    set_modflag(1);
  }
}

Fl_Input *i18n_pos_conditional_input=(Fl_Input *)0;

static void cb_i18n_pos_conditional_input(Fl_Input* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.i18n_pos_conditional.c_str());
  } else {
    undo_checkpoint();
    g_project.i18n_pos_conditional = o->value();
    set_modflag(1);
  }
}

Fl_Input *i18n_pos_file_input=(Fl_Input *)0;

static void cb_i18n_pos_file_input(Fl_Input* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.i18n_pos_file.c_str());
  } else {
    undo_checkpoint();
    g_project.i18n_pos_file = o->value();
    set_modflag(1);
  }
}

static void cb_c(Fl_Group* o, void* v) {
  propagate_load(o, v);
}

Fl_Int_Input *i18n_pos_set_input=(Fl_Int_Input *)0;

static void cb_i18n_pos_set_input(Fl_Int_Input* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.i18n_pos_set.c_str());
  } else {
    undo_checkpoint();
    g_project.i18n_pos_set = o->value();
    set_modflag(1);
  }
}

Fl_Group *w_settings_user_tab=(Fl_Group *)0;

static void cb_w_settings_user_tab(Fl_Group* o, void* v) {
  propagate_load(o, v);
}

static const unsigned char idata_user_circle_64[] =
{137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,96,0,0,0,64,8,6,0,0,0,
229,52,114,14,0,0,1,110,105,67,67,80,105,99,99,0,0,40,145,117,145,187,75,195,80,
20,198,127,182,74,69,171,14,138,136,56,68,80,113,168,32,10,226,168,117,232,82,
164,212,10,190,150,38,77,91,161,143,144,180,72,113,21,92,28,10,14,162,139,175,
193,255,64,87,193,85,65,16,20,65,196,205,221,215,34,18,207,53,66,69,244,134,155,
243,227,187,247,59,156,124,1,95,52,103,228,157,250,9,200,23,74,118,60,18,214,
230,230,23,180,192,35,65,90,233,100,132,222,164,225,88,147,177,88,148,127,215,
219,53,117,170,94,13,169,94,255,223,251,115,53,167,76,199,128,186,70,225,49,195,
178,75,194,50,13,209,149,146,165,120,67,184,195,200,38,83,194,123,194,33,91,6,
20,62,87,186,238,241,131,226,140,199,47,138,237,68,124,10,124,170,167,150,249,
193,250,15,54,178,118,94,120,80,184,47,159,43,27,223,243,168,47,9,154,133,217,
25,169,221,178,123,112,136,19,33,140,134,78,153,101,114,148,24,146,90,144,204,
254,246,13,127,249,166,41,138,199,144,183,69,5,91,28,25,178,226,13,137,90,150,
174,166,212,180,232,166,60,57,42,42,247,223,121,58,233,209,17,175,123,48,12,13,
247,174,251,220,15,129,77,248,168,186,238,251,190,235,126,28,128,255,14,78,11,
53,127,81,114,26,127,21,189,90,211,250,118,161,109,13,142,207,106,154,190,5,39,
235,208,117,107,37,237,228,151,228,151,237,75,167,225,233,8,90,230,161,253,18,
154,22,189,172,190,207,57,188,129,196,170,252,162,11,216,222,129,1,185,223,182,
244,9,79,172,104,46,25,119,193,26,0,0,0,9,112,72,89,115,0,0,59,14,0,0,59,14,1,
204,182,161,131,0,0,13,125,73,68,65,84,120,94,213,156,9,236,86,197,17,192,7,4,
20,177,10,8,2,162,96,16,209,130,40,136,82,4,27,174,214,139,195,8,8,166,73,1,5,
194,77,75,64,1,141,28,81,74,72,56,203,101,61,138,130,137,82,3,104,64,52,16,16,
218,130,28,22,149,163,9,1,4,148,163,30,92,162,92,94,157,223,203,247,253,243,142,
125,223,187,246,195,63,147,108,248,243,190,221,217,153,157,221,217,217,217,153,
45,35,25,225,231,159,127,206,136,193,220,188,76,153,50,21,244,151,22,90,218,
106,249,173,150,134,90,106,197,236,236,136,214,251,175,150,127,105,89,163,101,
147,210,121,62,102,219,68,213,148,206,68,245,173,87,70,0,182,138,18,87,86,203,
239,181,44,208,114,74,11,210,181,81,192,5,206,223,209,135,45,122,139,53,249,18,
9,201,6,51,218,225,229,90,254,164,229,128,165,1,47,36,52,250,24,166,165,162,
37,218,19,141,151,245,202,89,152,80,98,202,107,25,169,229,139,11,48,240,126,
161,252,79,251,28,14,13,25,121,200,52,166,153,21,88,218,101,168,186,179,141,82,
62,71,11,186,61,18,174,184,226,10,169,87,175,158,220,120,227,141,114,237,181,
215,202,149,87,94,41,149,42,85,114,218,125,247,221,119,242,205,55,223,200,161,
67,135,228,211,79,63,117,202,183,223,126,27,137,51,87,97,167,254,59,72,249,248,
103,220,6,238,122,89,247,128,11,46,0,37,248,50,101,96,154,150,1,90,66,251,47,91,
182,172,180,108,217,82,218,181,107,39,119,223,125,183,52,108,216,80,248,22,7,
126,250,233,39,217,185,115,167,108,216,176,65,214,172,89,35,27,55,110,20,190,21,
0,86,7,147,97,164,10,226,92,156,62,242,117,46,42,1,40,177,13,148,240,69,90,
154,132,49,89,163,70,13,233,213,171,151,116,235,214,77,106,213,138,107,244,20,
30,178,195,135,15,203,226,197,139,229,213,87,95,149,47,190,64,219,133,194,86,
253,165,135,10,97,79,92,33,92,52,2,80,66,239,81,166,150,105,169,108,98,174,118,
237,218,50,100,200,16,233,222,189,187,84,168,128,5,106,31,206,159,63,47,139,22,
45,146,89,179,102,201,145,35,88,170,70,56,166,95,59,169,16,54,196,161,224,162,
16,128,18,217,81,153,249,135,150,138,126,166,202,149,43,39,61,123,246,148,39,
158,120,66,208,243,23,2,206,156,57,35,243,230,205,147,217,179,103,203,247,223,
127,111,234,18,53,244,7,21,194,146,40,122,74,189,0,148,192,206,202,196,98,45,
229,252,204,176,169,206,157,59,87,26,53,106,20,197,103,81,126,223,190,125,187,
12,26,52,72,246,239,223,111,194,143,100,186,168,16,150,23,234,60,171,0,226,237,
106,41,217,87,226,56,193,190,97,26,252,78,157,58,201,59,239,188,243,139,13,62,
44,53,110,220,88,222,125,247,93,233,208,161,131,137,67,76,228,69,202,67,203,
148,236,199,106,86,52,43,40,183,225,110,82,42,2,58,191,95,191,126,242,204,51,
207,72,218,217,115,236,216,49,217,189,123,119,137,30,103,179,110,208,160,129,84,
169,82,37,22,211,254,74,88,72,207,62,251,172,188,244,210,75,166,246,236,9,205,
117,37,236,53,253,152,150,135,60,174,162,8,32,103,106,126,160,157,4,172,29,116,
253,176,97,28,68,147,1,231,141,101,203,150,201,194,133,11,101,203,150,45,242,
227,143,63,122,16,92,114,201,37,114,215,93,119,57,251,73,199,142,29,83,9,119,
230,204,153,50,101,202,20,19,97,255,209,143,173,76,38,106,105,21,192,92,37,120,
160,159,19,102,254,216,177,99,147,141,188,214,70,71,15,30,60,88,182,109,219,22,
171,109,211,166,77,157,13,182,78,157,58,177,234,187,43,77,152,48,33,108,37,204,
86,1,12,245,35,44,117,2,200,157,112,241,64,122,86,23,58,127,206,156,57,137,103,
38,179,189,79,159,62,114,252,248,241,68,131,89,181,106,85,121,249,229,151,229,
206,59,239,76,212,14,117,196,198,204,254,228,3,14,107,109,252,39,230,82,37,0,37,
6,75,135,195,76,99,55,241,55,220,112,131,179,217,37,53,51,63,255,252,115,71,
157,160,243,211,64,229,202,149,29,181,69,255,73,0,215,6,27,243,222,189,1,181,
143,219,162,169,10,161,196,118,45,109,2,24,161,4,122,148,40,118,254,242,229,203,
19,91,59,232,124,86,205,39,159,124,18,24,59,4,217,166,77,27,103,227,5,118,237,
218,37,235,214,173,51,250,127,238,184,227,14,121,235,173,183,18,175,60,76,212,
206,157,59,203,15,63,252,224,239,127,184,210,54,35,255,49,171,0,2,182,121,146,
153,226,174,171,132,224,82,126,210,223,190,127,255,254,137,7,31,28,8,205,52,248,
247,221,119,159,140,26,53,202,113,198,185,225,228,201,147,50,121,242,100,89,185,
114,165,231,251,214,173,91,29,117,194,74,74,2,152,168,143,63,254,184,188,240,
194,11,254,102,163,149,215,191,169,16,206,36,193,23,86,215,230,57,160,175,118,
114,141,187,35,220,11,105,44,30,112,224,183,241,3,131,255,220,115,207,5,6,159,
122,87,93,117,149,76,156,56,81,238,189,247,222,64,187,5,11,184,139,73,14,195,
135,15,151,154,53,107,250,27,214,208,15,125,146,99,51,183,176,34,0,157,17,224,
65,253,120,0,223,206,229,151,179,48,146,1,58,255,195,15,63,244,52,66,237,48,
243,11,45,121,126,163,78,222,77,157,71,192,70,126,226,196,137,100,68,104,109,
250,28,58,52,96,248,128,103,100,142,231,196,56,253,13,172,8,64,145,182,215,226,
177,249,170,87,175,46,143,60,242,72,42,2,209,233,126,59,31,157,239,87,59,38,228,
172,4,234,186,1,61,14,206,52,208,163,71,15,193,67,235,131,186,250,127,111,39,
105,144,107,27,91,2,248,163,191,127,244,231,165,151,94,154,138,44,147,203,56,
191,225,198,65,120,211,77,55,5,170,69,184,161,67,209,194,3,135,59,3,4,120,142,
67,155,245,21,160,75,145,81,126,216,141,152,139,147,174,93,187,166,161,199,105,
99,82,51,17,23,42,158,190,210,222,210,133,17,220,165,75,23,19,77,93,149,78,252,
69,153,192,198,10,248,141,82,224,241,35,115,147,149,229,50,229,154,107,60,123,
185,195,224,158,61,177,239,72,28,63,145,31,12,106,36,246,192,93,119,221,117,210,
188,121,115,127,253,95,233,135,192,199,216,72,115,21,109,8,160,157,191,83,174,
17,179,192,45,183,220,34,248,118,220,176,118,237,90,193,212,140,2,54,91,206,4,
110,224,44,114,243,205,55,71,53,45,248,123,8,79,217,24,213,30,109,8,0,151,179,7,
184,195,205,2,120,53,113,172,185,129,75,118,236,252,66,234,133,223,38,77,154,
228,92,210,187,129,217,203,169,56,11,220,115,15,23,122,1,8,240,158,180,15,27,2,
248,181,187,83,76,55,46,208,179,130,105,227,227,144,245,244,211,79,27,87,2,51,
127,244,232,209,178,122,245,234,64,215,33,155,104,34,18,185,52,242,155,183,138,
32,51,163,153,221,209,74,132,39,54,241,246,219,111,119,78,177,89,129,217,252,
208,67,15,201,71,31,125,20,64,197,64,180,110,221,186,68,173,228,93,17,254,153,
79,67,156,113,75,150,44,73,236,138,48,209,255,224,131,15,10,46,10,23,192,123,
166,73,108,205,21,145,39,138,184,29,27,128,37,196,117,37,46,132,163,71,143,122,
80,50,208,43,86,172,112,74,33,64,149,225,227,207,234,175,201,247,193,21,170,79,
0,153,39,112,38,233,153,152,39,104,202,22,96,125,224,82,198,181,156,20,104,
243,202,43,175,164,186,19,8,235,11,122,108,131,117,1,36,117,57,71,49,212,172,89,
51,199,165,140,87,51,46,160,118,112,192,37,105,19,7,183,97,15,136,211,172,96,
29,235,2,40,6,145,220,108,225,82,38,148,4,11,11,179,210,15,124,227,252,241,252,
243,207,59,58,191,24,179,213,246,228,130,7,235,123,64,230,41,17,130,0,61,206,
126,64,225,118,140,195,22,17,111,124,207,95,202,103,53,53,139,69,123,33,188,214,
5,96,178,68,108,51,198,230,106,56,153,218,238,38,128,47,65,192,111,108,90,172,
171,160,98,16,25,155,155,34,87,44,6,111,214,87,0,33,226,197,132,211,167,79,59,
234,135,59,131,252,69,61,43,2,171,7,47,104,154,251,135,184,244,22,131,55,235,2,
48,92,100,199,229,47,180,30,97,41,47,190,248,162,188,255,254,251,114,240,224,
193,80,119,4,251,193,245,215,95,47,109,219,182,21,66,96,234,214,197,109,111,15,
200,59,240,65,230,4,185,204,7,9,37,232,176,150,146,56,114,44,5,98,243,227,198,
242,23,26,30,240,112,195,69,60,80,82,23,51,194,224,84,142,255,200,134,107,132,
11,34,220,17,190,61,142,229,158,233,112,96,99,15,32,27,177,4,208,147,12,92,22,
56,123,246,172,60,245,212,83,242,192,3,15,56,23,243,73,7,159,190,105,243,241,
199,31,203,253,247,223,47,99,198,140,145,115,231,18,229,93,4,200,223,177,99,71,
192,201,167,149,60,188,167,225,217,134,0,72,5,245,192,7,31,16,149,152,14,208,
235,248,92,8,65,76,51,240,1,29,161,130,120,237,181,215,132,11,253,175,191,254,
58,29,81,218,106,253,250,245,166,182,169,210,154,220,136,108,168,32,92,178,30,
66,90,181,106,37,111,188,65,80,116,50,192,174,103,214,23,10,196,226,98,133,208,
67,14,90,220,255,2,220,19,16,196,133,227,238,203,47,191,12,237,180,90,181,106,
78,128,152,33,210,33,146,80,50,118,54,109,34,214,216,3,173,244,127,177,18,57,
194,58,176,33,0,210,89,240,150,149,220,138,161,255,89,5,73,252,66,232,214,246,
237,219,59,137,118,126,0,31,225,38,143,62,250,168,220,122,235,173,5,7,11,103,25,
194,199,117,109,90,65,108,210,171,86,173,50,185,150,67,241,178,241,115,202,246,
225,227,118,168,186,22,99,134,71,164,68,115,21,50,171,32,37,138,12,116,79,38,9,
247,183,228,100,37,129,199,30,123,204,56,248,184,33,8,27,39,30,40,106,240,233,
143,128,42,226,131,176,154,76,193,185,172,20,98,77,147,0,174,13,131,48,23,187,
67,20,147,224,115,215,205,44,128,28,178,133,126,2,230,207,159,47,108,166,113,
96,233,210,165,206,138,241,3,170,6,143,230,109,183,221,22,7,141,167,78,147,38,
77,4,26,76,109,209,231,111,191,253,118,44,156,108,222,33,129,93,1,158,99,33,
244,85,178,37,0,162,161,63,115,227,254,234,171,175,228,205,55,223,140,164,233,
212,169,83,142,149,226,7,14,85,248,242,227,196,2,133,117,194,30,65,66,30,126,
124,63,96,222,198,57,217,190,254,250,235,166,204,202,253,138,47,243,6,12,77,86,
4,160,75,145,36,220,169,126,38,97,62,202,55,132,247,210,95,135,211,236,212,
169,83,173,156,106,241,206,78,159,62,61,128,139,62,233,187,16,32,32,242,12,12,
48,37,199,115,228,4,139,170,96,69,0,185,78,136,98,245,228,126,146,10,58,99,70,
73,32,113,128,22,150,55,23,46,126,32,62,63,201,6,30,197,36,49,170,3,6,144,23,
238,5,246,137,66,106,114,218,180,105,166,217,207,19,7,127,143,234,51,238,239,
214,4,160,51,2,133,31,200,239,97,3,245,93,227,149,208,134,107,193,63,251,25,44,
194,1,109,3,56,253,66,197,175,68,184,139,9,56,125,179,135,24,224,47,182,34,163,
173,169,32,23,145,127,213,191,61,121,68,196,101,50,163,209,245,126,48,221,213,
226,195,241,199,4,217,16,6,201,223,36,6,198,161,129,119,39,6,14,28,104,202,13,
216,161,237,11,235,173,132,196,90,91,1,244,171,51,131,108,6,194,137,61,78,42,
156,105,36,231,249,195,11,113,154,229,55,72,108,125,254,38,41,34,73,24,98,92,
126,241,229,112,135,128,153,90,191,126,125,105,209,162,133,211,31,52,184,129,
190,71,140,24,33,159,125,230,177,41,28,246,180,12,180,97,122,186,251,203,124,16,
51,29,118,116,102,207,210,78,134,248,7,167,111,223,190,50,110,220,56,207,103,
102,27,106,136,213,192,204,47,198,224,187,59,164,143,124,228,53,127,95,125,245,
213,158,168,9,146,8,67,84,207,76,229,245,207,113,86,80,220,73,81,12,21,148,239,
155,55,128,200,21,243,0,251,1,166,101,30,80,79,60,27,192,236,71,0,89,6,159,246,
224,193,130,66,221,132,169,49,119,216,59,127,187,247,32,172,165,144,193,223,162,
52,7,178,127,146,12,116,88,221,162,172,0,58,211,1,169,175,255,224,60,9,196,148,
176,18,208,199,188,211,144,38,113,194,179,132,115,43,199,180,159,32,224,40,135,
30,2,195,84,29,63,126,124,216,224,227,102,33,81,59,112,25,144,227,51,147,28,
138,38,128,28,113,164,249,175,210,18,72,147,193,227,137,173,143,25,232,79,198,
200,196,81,130,198,172,24,226,255,209,249,239,189,247,158,169,229,105,253,216,
94,7,127,99,232,12,206,248,104,95,81,5,144,19,2,217,113,248,138,2,177,244,164,
143,114,24,194,103,195,83,50,134,140,196,4,195,25,191,42,171,165,98,197,138,114,
224,192,1,33,137,208,176,225,130,12,39,219,195,58,248,129,132,97,255,10,140,223,
115,176,102,209,5,224,18,2,15,53,5,86,130,251,185,26,234,70,157,156,211,50,203,
108,47,95,190,188,51,240,172,56,4,95,224,185,26,102,126,247,168,193,47,245,42,
200,55,83,80,71,60,216,100,140,51,196,71,79,66,28,15,54,1,172,6,27,234,137,217,
78,188,16,27,51,248,112,85,51,240,5,82,150,208,249,29,11,169,157,139,110,5,228,
9,214,193,32,114,151,149,208,44,108,38,147,29,211,187,119,111,33,45,136,83,49,
179,21,75,41,169,48,24,120,86,23,27,44,142,65,92,202,120,86,249,187,0,96,237,
240,100,217,190,184,43,45,107,224,239,5,81,65,190,25,67,78,25,46,139,193,90,10,
62,218,199,193,137,204,20,110,216,184,16,71,24,249,187,93,172,27,204,86,10,127,
163,98,242,129,0,12,60,41,77,60,218,71,190,192,230,205,155,163,172,33,14,89,156,
226,159,204,221,111,196,29,255,204,145,215,23,92,0,174,213,192,85,38,175,170,20,
190,226,202,53,96,38,115,114,165,224,211,193,213,236,126,182,146,107,73,110,211,
246,237,219,231,60,91,153,96,47,193,117,50,88,7,254,223,177,71,221,85,49,235,10,
72,211,167,167,13,179,47,109,81,68,88,70,188,152,139,23,213,198,19,197,73,112,
16,78,195,195,69,229,210,210,31,117,198,200,60,184,113,16,100,33,62,223,86,251,
225,49,63,92,23,232,222,36,131,152,166,46,125,160,254,46,179,68,123,156,97,42,
94,29,27,76,184,4,129,115,16,239,24,126,96,46,189,211,12,176,169,13,239,20,224,
195,7,119,169,122,188,251,23,219,3,162,166,68,46,9,154,60,92,82,65,243,207,215,
215,142,106,151,251,157,208,10,130,166,184,54,228,186,116,115,206,83,27,179,121,
252,106,89,247,128,255,3,60,207,245,248,165,38,113,147,0,0,0,0,73,69,78,68,174,
66,96,130};
static Fl_Image *image_user_circle_64() {
  static Fl_Image *image = NULL;
  if (!image)
    image = new Fl_PNG_Image("user_circle_64.png", idata_user_circle_64, 3909);
  return image;
}

Fl_Choice *w_settings_user_commenttext=(Fl_Choice *)0;

static void cb_Close(Fl_Button*, void*) {
  if (g_shell_config)
    g_shell_config->write(fluid_prefs, FD_STORE_USER);
  g_layout_list.write(fluid_prefs, FD_STORE_USER);
  settings_window->hide();
}

Fl_Double_Window* make_settings_window() {
  { settings_window = new Fl_Double_Window(340, 580, "FLUID Settings");
    settings_window->align(Fl_Align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE));
    { w_settings_tabs = new Fl_Tabs(10, 10, 320, 530);
      w_settings_tabs->selection_color((Fl_Color)12);
      w_settings_tabs->labelsize(11);
      w_settings_tabs->labelcolor(FL_WHITE);
      w_settings_tabs->callback((Fl_Callback*)cb_w_settings_tabs);
      { w_settings_general_tab = new Fl_Group(10, 60, 320, 480, "General");
        w_settings_general_tab->image( image_general_64() );
        w_settings_general_tab->image()->scale(36, 24, 0, 1);
        w_settings_general_tab->labelsize(11);
        { Fl_Group* o = new Fl_Group(120, 78, 130, 25);
          o->callback((Fl_Callback*)cb_);
          { scheme_choice = new Fl_Scheme_Choice(120, 78, 120, 25, "Scheme: ");
            scheme_choice->box(FL_UP_BOX);
            scheme_choice->down_box(FL_BORDER_BOX);
            scheme_choice->color(FL_BACKGROUND_COLOR);
            scheme_choice->selection_color(FL_SELECTION_COLOR);
            scheme_choice->labeltype(FL_NORMAL_LABEL);
            scheme_choice->labelfont(1);
            scheme_choice->labelsize(11);
            scheme_choice->labelcolor(FL_FOREGROUND_COLOR);
            scheme_choice->callback((Fl_Callback*)scheme_cb);
            scheme_choice->align(Fl_Align(FL_ALIGN_LEFT));
            scheme_choice->when(FL_WHEN_RELEASE);
            init_scheme();
          } // Fl_Scheme_Choice* scheme_choice
          { Fl_Box* o = new Fl_Box(240, 78, 10, 25);
            o->hide();
            Fl_Group::current()->resizable(o);
          } // Fl_Box* o
          o->end();
        } // Fl_Group* o
        { Fl_Box* o = new Fl_Box(120, 115, 0, 20, "Options: ");
          o->labelfont(1);
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_LEFT));
        } // Fl_Box* o
        { tooltips_button = new Fl_Check_Button(120, 115, 200, 20, "Show Tooltips");
          tooltips_button->down_box(FL_DOWN_BOX);
          tooltips_button->labelsize(11);
          tooltips_button->callback((Fl_Callback*)cb_tooltips_button);
          int b;
          fluid_prefs.get("show_tooltips", b, 1);
          tooltips_button->value(b);
          Fl_Tooltip::enable(b);
        } // Fl_Check_Button* tooltips_button
        { completion_button = new Fl_Check_Button(120, 135, 200, 20, "Show Completion Dialogs");
          completion_button->down_box(FL_DOWN_BOX);
          completion_button->labelsize(11);
          completion_button->callback((Fl_Callback*)cb_completion_button);
          int b;
          fluid_prefs.get("show_completion_dialogs", b, 1);
          completion_button->value(b);
        } // Fl_Check_Button* completion_button
        { openlast_button = new Fl_Check_Button(120, 155, 200, 20, "Open Previous File on Startup");
          openlast_button->down_box(FL_DOWN_BOX);
          openlast_button->labelsize(11);
          openlast_button->callback((Fl_Callback*)cb_openlast_button);
          int b;
          fluid_prefs.get("open_previous_file", b, 0);
          openlast_button->value(b);
        } // Fl_Check_Button* openlast_button
        { prevpos_button = new Fl_Check_Button(120, 175, 200, 20, "Remember Window Positions");
          prevpos_button->down_box(FL_DOWN_BOX);
          prevpos_button->labelsize(11);
          prevpos_button->callback((Fl_Callback*)cb_prevpos_button);
          int b;
          fluid_prefs.get("prev_window_pos", b, 1);
          prevpos_button->value(b);
        } // Fl_Check_Button* prevpos_button
        { show_comments_button = new Fl_Check_Button(120, 195, 200, 20, "Show Comments in Browser");
          show_comments_button->down_box(FL_DOWN_BOX);
          show_comments_button->labelsize(11);
          show_comments_button->callback((Fl_Callback*)cb_show_comments_button);
          fluid_prefs.get("show_comments", show_comments, 1);
          show_comments_button->value(show_comments);
        } // Fl_Check_Button* show_comments_button
        { Fl_Group* o = new Fl_Group(120, 225, 50, 20);
          o->callback((Fl_Callback*)cb_1);
          { recent_spinner = new Fl_Spinner(120, 225, 40, 20, "# Recent Files:");
            recent_spinner->labelfont(1);
            recent_spinner->labelsize(11);
            recent_spinner->maximum(10);
            recent_spinner->textsize(11);
            recent_spinner->callback((Fl_Callback*)cb_recent_spinner);
            recent_spinner->when(FL_WHEN_CHANGED);
            int c;
            fluid_prefs.get("recent_files", c, 5);
            recent_spinner->maximum(10);
            recent_spinner->value(c);
          } // Fl_Spinner* recent_spinner
          { Fl_Box* o = new Fl_Box(160, 225, 10, 20);
            o->hide();
            Fl_Group::current()->resizable(o);
          } // Fl_Box* o
          o->end();
        } // Fl_Group* o
        { use_external_editor_button = new Fl_Check_Button(120, 275, 200, 20, "Use for Code Nodes");
          use_external_editor_button->down_box(FL_DOWN_BOX);
          use_external_editor_button->labelsize(11);
          use_external_editor_button->callback((Fl_Callback*)cb_use_external_editor_button);
          fluid_prefs.get("use_external_editor", G_use_external_editor, 0);
          use_external_editor_button->value(G_use_external_editor);
        } // Fl_Check_Button* use_external_editor_button
        { editor_command_input = new Fl_Input(120, 255, 200, 20, "External Editor:");
          editor_command_input->tooltip("The editor command to open your external text editor.\nInclude any necessary "
"flags to ensure your editor does not background itself.\nExamples:\n    gvim -"
"f\n    gedit\n emacs");
          editor_command_input->labelfont(1);
          editor_command_input->labelsize(11);
          editor_command_input->textfont(4);
          editor_command_input->textsize(11);
          editor_command_input->callback((Fl_Callback*)cb_editor_command_input);
          editor_command_input->when(FL_WHEN_CHANGED);
          fluid_prefs.get("external_editor_command", G_external_editor_command, "", sizeof(G_external_editor_command)-1);
          editor_command_input->value(G_external_editor_command);
        } // Fl_Input* editor_command_input
        { Fl_Box* o = new Fl_Box(120, 300, 0, 20, "Overlays: ");
          o->labelfont(1);
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_LEFT));
        } // Fl_Box* o
        { Fl_Check_Button* o = guides_button = new Fl_Check_Button(120, 300, 200, 20, "Show Positioning Guides");
          guides_button->tooltip("show guides that help to position and resize widgets and enable snapping");
          guides_button->down_box(FL_DOWN_BOX);
          guides_button->labelsize(11);
          guides_button->callback((Fl_Callback*)toggle_guides_cb);
          o->value(show_guides);
        } // Fl_Check_Button* guides_button
        { Fl_Check_Button* o = restricted_button = new Fl_Check_Button(120, 320, 200, 20, "Show Restricted Areas");
          restricted_button->tooltip("show overlapping and out of bounds areas, show unfilled areas in Fl_Pack grou"
"ps");
          restricted_button->down_box(FL_DOWN_BOX);
          restricted_button->labelsize(11);
          restricted_button->callback((Fl_Callback*)toggle_restricted_cb);
          o->value(show_restricted);
        } // Fl_Check_Button* restricted_button
        { Fl_Check_Button* o = ghosted_outline_button = new Fl_Check_Button(120, 340, 200, 20, "Show Ghosted Group Outlines");
          ghosted_outline_button->tooltip("groups with no box type or flat boxtypes without contrast will be rendered wi"
"th a dim outline in the editing window only");
          ghosted_outline_button->down_box(FL_DOWN_BOX);
          ghosted_outline_button->labelsize(11);
          ghosted_outline_button->callback((Fl_Callback*)toggle_ghosted_outline_cb);
          o->value(show_ghosted_outline);
        } // Fl_Check_Button* ghosted_outline_button
        { Fl_Box* o = new Fl_Box(120, 530, 200, 10);
          o->hide();
          Fl_Group::current()->resizable(o);
        } // Fl_Box* o
        w_settings_general_tab->end();
        Fl_Group::current()->resizable(w_settings_general_tab);
      } // Fl_Group* w_settings_general_tab
      { w_settings_project_tab = new Fl_Group(10, 60, 320, 480, "Project");
        w_settings_project_tab->image( image_document_64() );
        w_settings_project_tab->image()->scale(36, 24, 0, 1);
        w_settings_project_tab->labelsize(11);
        w_settings_project_tab->callback((Fl_Callback*)cb_w_settings_project_tab);
        w_settings_project_tab->hide();
        { Fl_Group* o = new Fl_Group(100, 78, 220, 30);
          { Fl_Box* o = new Fl_Box(100, 78, 210, 30, "Use \"name.ext\" to set a file name\nor just \".ext\" to set extension.");
            o->labelsize(11);
            o->align(Fl_Align(132|FL_ALIGN_INSIDE));
          } // Fl_Box* o
          { Fl_Box* o = new Fl_Box(310, 78, 10, 30);
            o->hide();
            Fl_Group::current()->resizable(o);
          } // Fl_Box* o
          o->end();
        } // Fl_Group* o
        { header_file_input = new Fl_Input(100, 112, 220, 20, "Header File:");
          header_file_input->tooltip("The name of the generated header file.");
          header_file_input->box(FL_THIN_DOWN_BOX);
          header_file_input->labelfont(1);
          header_file_input->labelsize(11);
          header_file_input->textfont(4);
          header_file_input->textsize(11);
          header_file_input->callback((Fl_Callback*)cb_header_file_input, (void*)(1));
          header_file_input->when(FL_WHEN_CHANGED);
        } // Fl_Input* header_file_input
        { code_file_input = new Fl_Input(100, 137, 220, 20, "Code File:");
          code_file_input->tooltip("The name of the generated code file.");
          code_file_input->box(FL_THIN_DOWN_BOX);
          code_file_input->labelfont(1);
          code_file_input->labelsize(11);
          code_file_input->textfont(4);
          code_file_input->textsize(11);
          code_file_input->callback((Fl_Callback*)cb_code_file_input, (void*)(1));
          code_file_input->when(FL_WHEN_CHANGED);
        } // Fl_Input* code_file_input
        { include_H_from_C_button = new Fl_Check_Button(100, 162, 220, 20, "Include Header from Code");
          include_H_from_C_button->tooltip("Include the header file from the code file.");
          include_H_from_C_button->down_box(FL_DOWN_BOX);
          include_H_from_C_button->labelsize(11);
          include_H_from_C_button->callback((Fl_Callback*)cb_include_H_from_C_button);
        } // Fl_Check_Button* include_H_from_C_button
        { Fl_Box* o = new Fl_Box(100, 205, 0, 20, "Options: ");
          o->labelfont(1);
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_LEFT));
        } // Fl_Box* o
        { use_FL_COMMAND_button = new Fl_Check_Button(100, 205, 220, 20, "Menu shortcuts use FL_COMMAND");
          use_FL_COMMAND_button->tooltip("Replace FL_CTRL and FL_META with FL_COMMAND when generating menu shortcuts");
          use_FL_COMMAND_button->down_box(FL_DOWN_BOX);
          use_FL_COMMAND_button->labelsize(11);
          use_FL_COMMAND_button->callback((Fl_Callback*)cb_use_FL_COMMAND_button);
        } // Fl_Check_Button* use_FL_COMMAND_button
        { utf8_in_src_button = new Fl_Check_Button(100, 230, 220, 20, "allow Unicode UTF-8 in source code");
          utf8_in_src_button->tooltip("For older compilers, characters outside of the printable ASCII range are esca"
"ped using octal notation `\\0123`. If this option is checked, Fluid will write"
" UTF-8 characters unchanged.");
          utf8_in_src_button->down_box(FL_DOWN_BOX);
          utf8_in_src_button->labelsize(11);
          utf8_in_src_button->callback((Fl_Callback*)cb_utf8_in_src_button);
        } // Fl_Check_Button* utf8_in_src_button
        { avoid_early_includes_button = new Fl_Check_Button(100, 255, 220, 20, "avoid early include of Fl.H");
          avoid_early_includes_button->tooltip("Do not emit #include <FL//Fl.H> until it is needed by another include file.");
          avoid_early_includes_button->down_box(FL_DOWN_BOX);
          avoid_early_includes_button->labelsize(11);
          avoid_early_includes_button->callback((Fl_Callback*)cb_avoid_early_includes_button);
        } // Fl_Check_Button* avoid_early_includes_button
        { Fl_Box* o = new Fl_Box(100, 283, 0, 20, "Experimental: ");
          o->labelfont(1);
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_LEFT));
          o->hide();
        } // Fl_Box* o
        { // // Matt: disabled
          w_proj_mergeback = new Fl_Check_Button(100, 283, 220, 20, "generate MergeBack data");
          w_proj_mergeback->tooltip("MergeBack is a feature under construction that allows changes in code files t"
"o be merged back into the project file. Checking this option will generate add"
"itional data in code and project files.");
          w_proj_mergeback->down_box(FL_DOWN_BOX);
          w_proj_mergeback->labelsize(11);
          w_proj_mergeback->callback((Fl_Callback*)cb_w_proj_mergeback);
          w_proj_mergeback->hide();
        } // Fl_Check_Button* w_proj_mergeback
        { Fl_Box* o = new Fl_Box(100, 530, 220, 10);
          o->hide();
          Fl_Group::current()->resizable(o);
        } // Fl_Box* o
        w_settings_project_tab->end();
      } // Fl_Group* w_settings_project_tab
      { w_settings_layout_tab = new Fl_Group(10, 60, 320, 480, "Layout");
        w_settings_layout_tab->image( image_layout_64() );
        w_settings_layout_tab->image()->scale(36, 24, 0, 1);
        w_settings_layout_tab->labelsize(11);
        w_settings_layout_tab->callback((Fl_Callback*)cb_w_settings_layout_tab);
        w_settings_layout_tab->hide();
        { Fl_Box* o = new Fl_Box(25, 78, 60, 24, "Layout:");
          o->labelfont(1);
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { layout_choice = new Fl_Choice(85, 78, 187, 24);
          layout_choice->down_box(FL_BORDER_BOX);
          layout_choice->callback((Fl_Callback*)cb_layout_choice);
          layout_choice->menu(menu_layout_choice);
        } // Fl_Choice* layout_choice
        { Fl_Button* o = new Fl_Button(272, 78, 24, 24, "+");
          o->callback((Fl_Callback*)cb_2);
        } // Fl_Button* o
        { w_layout_menu = new Fl_Menu_Button(296, 78, 24, 24);
          w_layout_menu->callback((Fl_Callback*)cb_w_layout_menu);
            w_layout_menu_storage[0] = &menu_w_layout_menu[1];
            w_layout_menu_storage[1] = &menu_w_layout_menu[2];
            w_layout_menu_storage[2] = &menu_w_layout_menu[3];
            w_layout_menu_storage[3] = &menu_w_layout_menu[4];
          w_layout_menu->menu(menu_w_layout_menu);
        } // Fl_Menu_Button* w_layout_menu
        { Fl_Box* o = new Fl_Box(25, 107, 60, 20, "Preset:");
          o->labelfont(1);
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Group* o = new Fl_Group(85, 107, 235, 20);
          o->labelsize(11);
          o->callback((Fl_Callback*)propagate_load);
          { preset_choice[0] = new Fl_Button(85, 107, 78, 20, "Application");
            preset_choice[0]->type(102);
            preset_choice[0]->value(1);
            preset_choice[0]->compact(1);
            preset_choice[0]->selection_color(FL_DARK2);
            preset_choice[0]->labelsize(11);
            preset_choice[0]->callback((Fl_Callback*)edit_layout_preset_cb, (void*)(0));
          } // Fl_Button* preset_choice[0]
          { preset_choice[1] = new Fl_Button(163, 107, 79, 20, "Dialog");
            preset_choice[1]->type(102);
            preset_choice[1]->compact(1);
            preset_choice[1]->selection_color(FL_DARK2);
            preset_choice[1]->labelsize(11);
            preset_choice[1]->callback((Fl_Callback*)edit_layout_preset_cb, (void*)(1));
          } // Fl_Button* preset_choice[1]
          { preset_choice[2] = new Fl_Button(242, 107, 78, 20, "Toolbox");
            preset_choice[2]->type(102);
            preset_choice[2]->compact(1);
            preset_choice[2]->selection_color(FL_DARK2);
            preset_choice[2]->labelsize(11);
            preset_choice[2]->callback((Fl_Callback*)edit_layout_preset_cb, (void*)(2));
          } // Fl_Button* preset_choice[2]
          o->end();
        } // Fl_Group* o
        { Fl_Box* o = new Fl_Box(85, 132, 235, 20, "---- Window ----");
          o->labelfont(1);
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Box* o = new Fl_Box(25, 167, 60, 20, "Margins:");
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Value_Input* o = new Fl_Value_Input(85, 167, 55, 20, "Left:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Left);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Value_Input* o = new Fl_Value_Input(145, 167, 55, 20, "Top:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Top);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Value_Input* o = new Fl_Value_Input(205, 167, 55, 20, "Right:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Right);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Value_Input* o = new Fl_Value_Input(265, 167, 55, 20, "Bottom:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Bottom);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Box* o = new Fl_Box(32, 201, 53, 20, "Grid:");
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Value_Input* o = new Fl_Value_Input(85, 201, 55, 20, "Horizontal:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Horizontal);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Value_Input* o = new Fl_Value_Input(145, 201, 55, 20, "Vertical:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Vertical);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Box* o = new Fl_Box(85, 226, 235, 20, "---- Group ----");
          o->labelfont(1);
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Box* o = new Fl_Box(25, 261, 60, 20, "Margins:");
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Value_Input* o = new Fl_Value_Input(85, 261, 55, 20, "Left:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Left1);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Value_Input* o = new Fl_Value_Input(145, 261, 55, 20, "Top:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Top1);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Value_Input* o = new Fl_Value_Input(205, 261, 55, 20, "Right:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Right1);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Value_Input* o = new Fl_Value_Input(265, 261, 55, 20, "Bottom:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Bottom1);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Box* o = new Fl_Box(32, 295, 53, 20, "Grid:");
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Value_Input* o = new Fl_Value_Input(85, 295, 55, 20, "Horizontal:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Horizontal1);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Value_Input* o = new Fl_Value_Input(145, 295, 55, 20, "Vertical:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Vertical1);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Box* o = new Fl_Box(85, 320, 235, 20, "---- Tabs ----");
          o->labelfont(1);
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Box* o = new Fl_Box(25, 355, 60, 20, "Margins:");
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Value_Input* o = new Fl_Value_Input(85, 355, 55, 20, "Top:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Top2);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Value_Input* o = new Fl_Value_Input(145, 355, 55, 20, "Bottom:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Bottom2);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Box* o = new Fl_Box(85, 380, 235, 20, "---- Widget ----");
          o->labelfont(1);
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Box* o = new Fl_Box(25, 415, 60, 20, "Horizontal:");
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Value_Input* o = new Fl_Value_Input(85, 414, 55, 20, "Minimum:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Minimum);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Value_Input* o = new Fl_Value_Input(145, 414, 55, 20, "Increment:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Increment);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Value_Input* o = new Fl_Value_Input(205, 414, 55, 20, "Gap:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Gap);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Box* o = new Fl_Box(32, 440, 53, 20, "Vertical:");
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Value_Input* o = new Fl_Value_Input(85, 440, 55, 20);
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_3);
        } // Fl_Value_Input* o
        { Fl_Value_Input* o = new Fl_Value_Input(145, 440, 55, 20);
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_4);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Value_Input* o = new Fl_Value_Input(205, 440, 55, 20);
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_5);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Group* o = new Fl_Group(85, 465, 201, 20, "Label Font:");
          o->labelsize(11);
          o->callback((Fl_Callback*)propagate_load);
          o->align(Fl_Align(FL_ALIGN_LEFT));
          { Fl_Choice* o = new Fl_Choice(85, 465, 150, 20);
            o->tooltip("The style of the label text.");
            o->box(FL_THIN_UP_BOX);
            o->down_box(FL_BORDER_BOX);
            o->labelfont(1);
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_6);
            Fl_Group::current()->resizable(o);
            o->menu(fontmenu_w_default);
          } // Fl_Choice* o
          { Fl_Value_Input* o = new Fl_Value_Input(235, 465, 50, 20);
            o->tooltip("The size of the label text.");
            o->labelsize(11);
            o->minimum(1);
            o->maximum(1000);
            o->step(1);
            o->value(14);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_7);
          } // Fl_Value_Input* o
          o->end();
        } // Fl_Group* o
        { Fl_Group* o = new Fl_Group(85, 490, 200, 20, "Text Font:");
          o->labelsize(11);
          o->callback((Fl_Callback*)propagate_load);
          o->align(Fl_Align(FL_ALIGN_LEFT));
          { Fl_Choice* o = new Fl_Choice(85, 490, 150, 20);
            o->tooltip("The value text style.");
            o->box(FL_DOWN_BOX);
            o->down_box(FL_BORDER_BOX);
            o->labelfont(1);
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_8);
            o->menu(fontmenu_w_default);
          } // Fl_Choice* o
          { Fl_Value_Input* o = new Fl_Value_Input(235, 490, 50, 20);
            o->tooltip("The value text size.");
            o->labelsize(11);
            o->maximum(1000);
            o->step(1);
            o->value(14);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_9);
          } // Fl_Value_Input* o
          o->end();
        } // Fl_Group* o
        { Fl_Box* o = new Fl_Box(325, 535, 5, 5);
          o->hide();
          Fl_Group::current()->resizable(o);
        } // Fl_Box* o
        w_settings_layout_tab->end();
      } // Fl_Group* w_settings_layout_tab
      { w_settings_shell_tab = new Fl_Group(10, 60, 320, 480, "Shell");
        w_settings_shell_tab->image( image_shell_64() );
        w_settings_shell_tab->image()->scale(36, 24, 0, 1);
        w_settings_shell_tab->labelsize(11);
        w_settings_shell_tab->callback((Fl_Callback*)propagate_load);
        w_settings_shell_tab->hide();
        { Fl_Group* o = new Fl_Group(10, 90, 320, 132);
          o->callback((Fl_Callback*)propagate_load);
          { w_settings_shell_list = new Fl_Browser(100, 90, 220, 110, "Shell\ncommand\nlist:");
            w_settings_shell_list->type(3);
            w_settings_shell_list->labelfont(1);
            w_settings_shell_list->labelsize(11);
            w_settings_shell_list->textsize(13);
            w_settings_shell_list->callback((Fl_Callback*)cb_w_settings_shell_list);
            w_settings_shell_list->align(Fl_Align(FL_ALIGN_LEFT));
            Fl_Group::current()->resizable(w_settings_shell_list);
          } // Fl_Browser* w_settings_shell_list
          { w_settings_shell_toolbox = new Fl_Group(100, 200, 220, 22);
            w_settings_shell_toolbox->callback((Fl_Callback*)cb_w_settings_shell_toolbox);
            { Fl_Button* o = new Fl_Button(100, 200, 24, 22, "+");
              o->tooltip("insert a new shell command into the list after the selected command");
              o->labelfont(1);
              o->labelsize(11);
              o->callback((Fl_Callback*)cb_a);
            } // Fl_Button* o
            { w_settings_shell_dup = new Fl_Button(124, 200, 24, 22, "++");
              w_settings_shell_dup->tooltip("duplicate the selected shell command and insert it into the list");
              w_settings_shell_dup->labelfont(1);
              w_settings_shell_dup->labelsize(11);
              w_settings_shell_dup->callback((Fl_Callback*)cb_w_settings_shell_dup);
              w_settings_shell_dup->deactivate();
            } // Fl_Button* w_settings_shell_dup
            { w_settings_shell_remove = new Fl_Button(148, 200, 24, 22, "DEL");
              w_settings_shell_remove->tooltip("remove the selected shell command - this can not be undone");
              w_settings_shell_remove->labelsize(10);
              w_settings_shell_remove->callback((Fl_Callback*)cb_w_settings_shell_remove);
              w_settings_shell_remove->deactivate();
            } // Fl_Button* w_settings_shell_remove
            { w_settings_shell_menu = new Fl_Menu_Button(172, 200, 24, 22);
              w_settings_shell_menu->labelsize(11);
              w_settings_shell_menu->textsize(11);
              w_settings_shell_menu->menu(menu_w_settings_shell_menu);
            } // Fl_Menu_Button* w_settings_shell_menu
            { Fl_Box* o = new Fl_Box(253, 200, 13, 22);
              o->hide();
              Fl_Group::current()->resizable(o);
            } // Fl_Box* o
            { Fl_Button* o = new Fl_Button(246, 200, 24, 22, "T");
              o->tooltip("show terminal window");
              o->labelfont(5);
              o->labelsize(11);
              o->callback((Fl_Callback*)cb_T);
            } // Fl_Button* o
            { w_settings_shell_play = new Fl_Button(270, 200, 50, 22, "Run");
              w_settings_shell_play->tooltip("run the selected shell command");
              w_settings_shell_play->labelsize(11);
              w_settings_shell_play->callback((Fl_Callback*)cb_w_settings_shell_play);
              w_settings_shell_play->deactivate();
            } // Fl_Button* w_settings_shell_play
            w_settings_shell_toolbox->end();
          } // Fl_Group* w_settings_shell_toolbox
          o->end();
        } // Fl_Group* o
        { w_settings_shell_cmd = new Fl_Group(10, 235, 320, 291);
          w_settings_shell_cmd->callback((Fl_Callback*)cb_w_settings_shell_cmd);
          { Fl_Input* o = new Fl_Input(100, 246, 220, 20, "Name:");
            o->tooltip("file the shell command under this name in the shell command list");
            o->labelfont(1);
            o->labelsize(11);
            o->textfont(4);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_Name);
            o->when(FL_WHEN_RELEASE | FL_WHEN_CHANGED | FL_WHEN_ENTER_KEY);
          } // Fl_Input* o
          { Fl_Input* o = new Fl_Input(100, 272, 220, 20, "Menu Label:");
            o->tooltip("label text for the Shell menu in the main menu bar");
            o->labelfont(1);
            o->labelsize(11);
            o->textfont(4);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_Menu);
          } // Fl_Input* o
          { Fl_Group* o = new Fl_Group(100, 297, 140, 71);
            o->callback((Fl_Callback*)cb_b);
            { Fl_Shortcut_Button* o = new Fl_Shortcut_Button(100, 297, 130, 20, "Shortcut");
              o->tooltip("an optional keyboard shortcut to run this shell command");
              o->box(FL_UP_BOX);
              o->color(FL_BACKGROUND_COLOR);
              o->selection_color(FL_BACKGROUND_COLOR);
              o->labeltype(FL_NORMAL_LABEL);
              o->labelfont(0);
              o->labelsize(11);
              o->labelcolor(FL_FOREGROUND_COLOR);
              o->callback((Fl_Callback*)cb_Shortcut);
              o->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
              o->when(FL_WHEN_RELEASE);
            } // Fl_Shortcut_Button* o
            { Fl_Choice* o = new Fl_Choice(100, 322, 130, 20, "Store:");
              o->tooltip("store this shell command as a user setting or save it with the .fl project fi"
"le");
              o->down_box(FL_BORDER_BOX);
              o->labelfont(1);
              o->labelsize(11);
              o->textsize(11);
              o->callback((Fl_Callback*)cb_Store);
              o->menu(menu_Store);
            } // Fl_Choice* o
            { Fl_Choice* o = new Fl_Choice(100, 348, 130, 20, "Condition:");
              o->tooltip("add this command to the main menu bar only if this condition is true");
              o->down_box(FL_BORDER_BOX);
              o->labelfont(1);
              o->labelsize(11);
              o->textsize(11);
              o->callback((Fl_Callback*)cb_Condition);
              o->menu(menu_Condition);
            } // Fl_Choice* o
            { Fl_Box* o = new Fl_Box(230, 297, 10, 71);
              o->hide();
              Fl_Group::current()->resizable(o);
            } // Fl_Box* o
            o->end();
          } // Fl_Group* o
          { Fl_Input* o = new Fl_Input(230, 348, 90, 20, "Label:");
            o->labelfont(1);
            o->labelsize(11);
            o->textfont(4);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_Label);
            o->hide();
          } // Fl_Input* o
          { Fl_Group* o = new Fl_Group(100, 373, 220, 80);
            o->callback((Fl_Callback*)propagate_load);
            { Fl_Text_Editor* o = w_settings_shell_command = new Fl_Text_Editor(100, 373, 196, 80, "Shell script:");
              w_settings_shell_command->labelfont(1);
              w_settings_shell_command->labelsize(11);
              w_settings_shell_command->textfont(4);
              w_settings_shell_command->textsize(12);
              w_settings_shell_command->callback((Fl_Callback*)cb_w_settings_shell_command);
              w_settings_shell_command->align(Fl_Align(FL_ALIGN_LEFT));
              Fl_Group::current()->resizable(w_settings_shell_command);
              o->buffer(new Fl_Text_Buffer);
            } // Fl_Text_Editor* w_settings_shell_command
            { Fl_Group* o = new Fl_Group(296, 373, 24, 80);
              { w_settings_shell_text_macros = new Fl_Menu_Button(296, 373, 24, 22);
                w_settings_shell_text_macros->tooltip("a list of text replacements available for the shell script");
                w_settings_shell_text_macros->labelsize(11);
                w_settings_shell_text_macros->textsize(11);
                w_settings_shell_text_macros->callback((Fl_Callback*)cb_w_settings_shell_text_macros);
                w_settings_shell_text_macros->menu(menu_w_settings_shell_text_macros);
              } // Fl_Menu_Button* w_settings_shell_text_macros
              { Fl_Button* o = new Fl_Button(296, 395, 24, 22, "@+1fd_zoom");
                o->tooltip("open the big code editor");
                o->labelsize(11);
                o->callback((Fl_Callback*)cb_1fd_zoom);
              } // Fl_Button* o
              { Fl_Box* o = new Fl_Box(296, 417, 24, 10);
                o->hide();
                Fl_Group::current()->resizable(o);
              } // Fl_Box* o
              o->end();
            } // Fl_Group* o
            o->end();
            Fl_Group::current()->resizable(o);
          } // Fl_Group* o
          { Fl_Check_Button* o = new Fl_Check_Button(100, 458, 110, 20, "save .fl project file");
            o->tooltip("save the project to the .fl file before running the command");
            o->down_box(FL_DOWN_BOX);
            o->labelsize(11);
            o->callback((Fl_Callback*)cb_save);
          } // Fl_Check_Button* o
          { Fl_Check_Button* o = new Fl_Check_Button(100, 478, 110, 19, "save source code");
            o->tooltip("generate the source code and header file before running the command");
            o->down_box(FL_DOWN_BOX);
            o->labelsize(11);
            o->callback((Fl_Callback*)cb_save1);
          } // Fl_Check_Button* o
          { Fl_Check_Button* o = new Fl_Check_Button(100, 498, 110, 20, "save i18n strings");
            o->tooltip("save the internationalisation strings before running the command");
            o->down_box(FL_DOWN_BOX);
            o->labelsize(11);
            o->callback((Fl_Callback*)cb_save2);
          } // Fl_Check_Button* o
          { Fl_Check_Button* o = new Fl_Check_Button(214, 458, 106, 20, "show terminal");
            o->tooltip("show the terminal window when launching this script");
            o->down_box(FL_DOWN_BOX);
            o->labelsize(11);
            o->callback((Fl_Callback*)cb_show);
          } // Fl_Check_Button* o
          { Fl_Check_Button* o = new Fl_Check_Button(214, 478, 106, 19, "clear terminal");
            o->tooltip("clear the teminal window before running this script");
            o->down_box(FL_DOWN_BOX);
            o->labelsize(11);
            o->callback((Fl_Callback*)cb_clear);
          } // Fl_Check_Button* o
          { Fl_Check_Button* o = new Fl_Check_Button(214, 498, 106, 19, "clear term history");
            o->tooltip("clear the teminal history in the terminal window");
            o->down_box(FL_DOWN_BOX);
            o->labelsize(11);
            o->callback((Fl_Callback*)cb_clear1);
          } // Fl_Check_Button* o
          w_settings_shell_cmd->end();
          Fl_Group::current()->resizable(w_settings_shell_cmd);
        } // Fl_Group* w_settings_shell_cmd
        { Fl_Box* o = w_settings_shell_fd_project = new Fl_Box(20, 70, 16, 15);
          w_settings_shell_fd_project->bind_image( image_fd_project() );
          w_settings_shell_fd_project->labelsize(11);
          w_settings_shell_fd_project->hide();
          w_settings_shell_fd_project->deactivate();
          o->image()->scale(16, 16);
        } // Fl_Box* w_settings_shell_fd_project
        { Fl_Box* o = w_settings_shell_fd_user = new Fl_Box(20, 70, 16, 15);
          w_settings_shell_fd_user->bind_image( image_fd_user() );
          w_settings_shell_fd_user->labelsize(11);
          w_settings_shell_fd_user->hide();
          w_settings_shell_fd_user->deactivate();
          o->image()->scale(16, 16);
        } // Fl_Box* w_settings_shell_fd_user
        w_settings_shell_tab->end();
      } // Fl_Group* w_settings_shell_tab
      { w_settings_i18n_tab = new Fl_Group(10, 60, 320, 480, "Locale");
        w_settings_i18n_tab->image( image_language_64() );
        w_settings_i18n_tab->image()->scale(36, 24, 0, 1);
        w_settings_i18n_tab->labelsize(11);
        w_settings_i18n_tab->callback((Fl_Callback*)cb_w_settings_i18n_tab);
        w_settings_i18n_tab->hide();
        { Fl_Group* o = new Fl_Group(100, 78, 170, 20);
          o->callback((Fl_Callback*)propagate_load);
          { i18n_type_chooser = new Fl_Choice(100, 78, 160, 20, "i18n Library:");
            i18n_type_chooser->tooltip("Type of internationalization to use.");
            i18n_type_chooser->box(FL_THIN_UP_BOX);
            i18n_type_chooser->down_box(FL_BORDER_BOX);
            i18n_type_chooser->labelsize(11);
            i18n_type_chooser->textsize(11);
            i18n_type_chooser->callback((Fl_Callback*)i18n_type_cb);
            i18n_type_chooser->menu(menu_i18n_type_chooser);
          } // Fl_Choice* i18n_type_chooser
          { Fl_Box* o = new Fl_Box(260, 78, 10, 20);
            o->hide();
            Fl_Group::current()->resizable(o);
          } // Fl_Box* o
          o->end();
        } // Fl_Group* o
        { i18n_gnu_group = new Fl_Group(100, 103, 220, 95);
          i18n_gnu_group->callback((Fl_Callback*)cb_i18n_gnu_group);
          { i18n_gnu_include_input = new Fl_Input(100, 103, 220, 20, "#include:");
            i18n_gnu_include_input->tooltip("The include file for internationalization.");
            i18n_gnu_include_input->box(FL_THIN_DOWN_BOX);
            i18n_gnu_include_input->labelsize(11);
            i18n_gnu_include_input->textfont(4);
            i18n_gnu_include_input->textsize(11);
            i18n_gnu_include_input->callback((Fl_Callback*)cb_i18n_gnu_include_input);
          } // Fl_Input* i18n_gnu_include_input
          { i18n_gnu_conditional_input = new Fl_Input(100, 128, 220, 20, "Conditional:");
            i18n_gnu_conditional_input->tooltip("only include the header file if this preprocessor macro is defined, for examp"
"le FLTK_GETTEXT_FOUND");
            i18n_gnu_conditional_input->box(FL_THIN_DOWN_BOX);
            i18n_gnu_conditional_input->labelsize(11);
            i18n_gnu_conditional_input->textfont(4);
            i18n_gnu_conditional_input->textsize(11);
            i18n_gnu_conditional_input->callback((Fl_Callback*)cb_i18n_gnu_conditional_input);
          } // Fl_Input* i18n_gnu_conditional_input
          { i18n_gnu_function_input = new Fl_Input(100, 153, 220, 20, "Function:");
            i18n_gnu_function_input->tooltip("The function to call to translate labels and tooltips, usually \"gettext\" or"
" \"_\"");
            i18n_gnu_function_input->box(FL_THIN_DOWN_BOX);
            i18n_gnu_function_input->labelsize(11);
            i18n_gnu_function_input->textfont(4);
            i18n_gnu_function_input->textsize(11);
            i18n_gnu_function_input->callback((Fl_Callback*)cb_i18n_gnu_function_input);
          } // Fl_Input* i18n_gnu_function_input
          { i18n_gnu_static_function_input = new Fl_Input(100, 178, 220, 20, "Static Function:");
            i18n_gnu_static_function_input->tooltip("function to call to translate static text, The function to call to internatio"
"nalize labels and tooltips, usually \"gettext_noop\" or \"N_\"");
            i18n_gnu_static_function_input->box(FL_THIN_DOWN_BOX);
            i18n_gnu_static_function_input->labelsize(11);
            i18n_gnu_static_function_input->textfont(4);
            i18n_gnu_static_function_input->textsize(11);
            i18n_gnu_static_function_input->callback((Fl_Callback*)cb_i18n_gnu_static_function_input);
          } // Fl_Input* i18n_gnu_static_function_input
          i18n_gnu_group->end();
        } // Fl_Group* i18n_gnu_group
        { i18n_posix_group = new Fl_Group(100, 103, 220, 95);
          i18n_posix_group->callback((Fl_Callback*)cb_i18n_posix_group);
          i18n_posix_group->hide();
          { i18n_pos_include_input = new Fl_Input(100, 103, 220, 20, "#include:");
            i18n_pos_include_input->tooltip("The include file for internationalization.");
            i18n_pos_include_input->box(FL_THIN_DOWN_BOX);
            i18n_pos_include_input->labelsize(11);
            i18n_pos_include_input->textfont(4);
            i18n_pos_include_input->textsize(11);
            i18n_pos_include_input->callback((Fl_Callback*)cb_i18n_pos_include_input);
          } // Fl_Input* i18n_pos_include_input
          { i18n_pos_conditional_input = new Fl_Input(100, 128, 220, 20, "Conditional:");
            i18n_pos_conditional_input->tooltip("only include the header file if this preprocessor macro is defined, for examp"
"le FLTK_GETTEXT_FOUND");
            i18n_pos_conditional_input->box(FL_THIN_DOWN_BOX);
            i18n_pos_conditional_input->labelsize(11);
            i18n_pos_conditional_input->textfont(4);
            i18n_pos_conditional_input->textsize(11);
            i18n_pos_conditional_input->callback((Fl_Callback*)cb_i18n_pos_conditional_input);
          } // Fl_Input* i18n_pos_conditional_input
          { i18n_pos_file_input = new Fl_Input(100, 153, 220, 20, "Catalog:");
            i18n_pos_file_input->tooltip("The name of the message catalog.");
            i18n_pos_file_input->box(FL_THIN_DOWN_BOX);
            i18n_pos_file_input->labelsize(11);
            i18n_pos_file_input->textfont(4);
            i18n_pos_file_input->textsize(11);
            i18n_pos_file_input->callback((Fl_Callback*)cb_i18n_pos_file_input);
          } // Fl_Input* i18n_pos_file_input
          { Fl_Group* o = new Fl_Group(100, 178, 90, 20);
            o->callback((Fl_Callback*)cb_c);
            { i18n_pos_set_input = new Fl_Int_Input(100, 178, 80, 20, "Set:");
              i18n_pos_set_input->tooltip("The message set number.");
              i18n_pos_set_input->type(2);
              i18n_pos_set_input->box(FL_THIN_DOWN_BOX);
              i18n_pos_set_input->labelsize(11);
              i18n_pos_set_input->textfont(4);
              i18n_pos_set_input->textsize(11);
              i18n_pos_set_input->callback((Fl_Callback*)cb_i18n_pos_set_input);
            } // Fl_Int_Input* i18n_pos_set_input
            { Fl_Box* o = new Fl_Box(180, 178, 10, 20);
              o->hide();
              Fl_Group::current()->resizable(o);
            } // Fl_Box* o
            o->end();
          } // Fl_Group* o
          i18n_posix_group->end();
        } // Fl_Group* i18n_posix_group
        { Fl_Box* o = new Fl_Box(100, 530, 220, 10);
          o->hide();
          Fl_Group::current()->resizable(o);
        } // Fl_Box* o
        w_settings_i18n_tab->end();
      } // Fl_Group* w_settings_i18n_tab
      { w_settings_user_tab = new Fl_Group(10, 60, 320, 480, "User");
        w_settings_user_tab->image( image_user_circle_64() );
        w_settings_user_tab->image()->scale(36, 24, 0, 1);
        w_settings_user_tab->labelsize(11);
        w_settings_user_tab->callback((Fl_Callback*)cb_w_settings_user_tab);
        w_settings_user_tab->hide();
        { Fl_Box* o = new Fl_Box(100, 84, 220, 20, "---- Widget Browser ----");
          o->labelfont(1);
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Group* o = new Fl_Group(100, 112, 220, 20);
          o->callback((Fl_Callback*)propagate_load);
          { Fl_Choice* o = new Fl_Choice(100, 112, 151, 20, "Label:");
            o->box(FL_THIN_UP_BOX);
            o->down_box(FL_BORDER_BOX);
            o->labelfont(1);
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_Comments, (void*)(&Widget_Browser::label_font));
            Fl_Group::current()->resizable(o);
            o->menu(fontmenu);
          } // Fl_Choice* o
          { Fl_Button* o = new Fl_Button(251, 112, 51, 20);
            o->labelsize(11);
            o->callback((Fl_Callback*)cb_Color_Chip, (void*)(&Widget_Browser::label_color));
          } // Fl_Button* o
          { Fl_Menu_Button* o = new Fl_Menu_Button(302, 112, 18, 20);
            o->callback((Fl_Callback*)cb_Color_Choice, (void*)(&Widget_Browser::label_color));
            o->menu(colormenu);
          } // Fl_Menu_Button* o
          o->end();
        } // Fl_Group* o
        { Fl_Group* o = new Fl_Group(100, 137, 220, 20);
          o->callback((Fl_Callback*)propagate_load);
          { Fl_Choice* o = new Fl_Choice(100, 137, 151, 20, "Class:");
            o->box(FL_THIN_UP_BOX);
            o->down_box(FL_BORDER_BOX);
            o->labelfont(1);
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_Comments, (void*)(&Widget_Browser::class_font));
            Fl_Group::current()->resizable(o);
            o->menu(fontmenu);
          } // Fl_Choice* o
          { Fl_Button* o = new Fl_Button(251, 137, 51, 20);
            o->labelsize(11);
            o->callback((Fl_Callback*)cb_Color_Chip, (void*)(&Widget_Browser::class_color));
          } // Fl_Button* o
          { Fl_Menu_Button* o = new Fl_Menu_Button(302, 137, 18, 20);
            o->callback((Fl_Callback*)cb_Color_Choice, (void*)(&Widget_Browser::class_color));
            o->menu(colormenu);
          } // Fl_Menu_Button* o
          o->end();
        } // Fl_Group* o
        { Fl_Group* o = new Fl_Group(100, 162, 220, 20);
          o->callback((Fl_Callback*)propagate_load);
          { Fl_Choice* o = new Fl_Choice(100, 162, 151, 20, "Function:");
            o->box(FL_THIN_UP_BOX);
            o->down_box(FL_BORDER_BOX);
            o->labelfont(1);
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_Comments, (void*)(&Widget_Browser::func_font));
            Fl_Group::current()->resizable(o);
            o->menu(fontmenu);
          } // Fl_Choice* o
          { Fl_Button* o = new Fl_Button(251, 162, 51, 20);
            o->labelsize(11);
            o->callback((Fl_Callback*)cb_Color_Chip, (void*)(&Widget_Browser::func_color));
          } // Fl_Button* o
          { Fl_Menu_Button* o = new Fl_Menu_Button(302, 162, 18, 20);
            o->callback((Fl_Callback*)cb_Color_Choice, (void*)(&Widget_Browser::func_color));
            o->menu(colormenu);
          } // Fl_Menu_Button* o
          o->end();
        } // Fl_Group* o
        { Fl_Group* o = new Fl_Group(100, 187, 220, 20);
          o->callback((Fl_Callback*)propagate_load);
          { Fl_Choice* o = new Fl_Choice(100, 187, 151, 20, "Name:");
            o->box(FL_THIN_UP_BOX);
            o->down_box(FL_BORDER_BOX);
            o->labelfont(1);
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_Comments, (void*)(&Widget_Browser::name_font));
            Fl_Group::current()->resizable(o);
            o->menu(fontmenu);
          } // Fl_Choice* o
          { Fl_Button* o = new Fl_Button(251, 187, 51, 20);
            o->labelsize(11);
            o->callback((Fl_Callback*)cb_Color_Chip, (void*)(&Widget_Browser::name_color));
          } // Fl_Button* o
          { Fl_Menu_Button* o = new Fl_Menu_Button(302, 187, 18, 20);
            o->callback((Fl_Callback*)cb_Color_Choice, (void*)(&Widget_Browser::name_color));
            o->menu(colormenu);
          } // Fl_Menu_Button* o
          o->end();
        } // Fl_Group* o
        { Fl_Group* o = new Fl_Group(100, 212, 220, 20);
          o->callback((Fl_Callback*)propagate_load);
          { Fl_Choice* o = new Fl_Choice(100, 212, 151, 20, "Code:");
            o->box(FL_THIN_UP_BOX);
            o->down_box(FL_BORDER_BOX);
            o->labelfont(1);
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_Comments, (void*)(&Widget_Browser::code_font));
            Fl_Group::current()->resizable(o);
            o->menu(fontmenu);
          } // Fl_Choice* o
          { Fl_Button* o = new Fl_Button(251, 212, 51, 20);
            o->labelsize(11);
            o->callback((Fl_Callback*)cb_Color_Chip, (void*)(&Widget_Browser::code_color));
          } // Fl_Button* o
          { Fl_Menu_Button* o = new Fl_Menu_Button(302, 212, 18, 20);
            o->callback((Fl_Callback*)cb_Color_Choice, (void*)(&Widget_Browser::code_color));
            o->menu(colormenu);
          } // Fl_Menu_Button* o
          o->end();
        } // Fl_Group* o
        { Fl_Group* o = new Fl_Group(100, 237, 220, 20);
          o->callback((Fl_Callback*)propagate_load);
          { Fl_Choice* o = w_settings_user_commenttext = new Fl_Choice(100, 237, 151, 20, "Comments:");
            w_settings_user_commenttext->box(FL_THIN_UP_BOX);
            w_settings_user_commenttext->down_box(FL_BORDER_BOX);
            w_settings_user_commenttext->labelfont(1);
            w_settings_user_commenttext->labelsize(11);
            w_settings_user_commenttext->textsize(11);
            w_settings_user_commenttext->callback((Fl_Callback*)cb_Comments, (void*)(&Widget_Browser::comment_font));
            Fl_Group::current()->resizable(w_settings_user_commenttext);
            o->menu(fontmenu);
          } // Fl_Choice* w_settings_user_commenttext
          { Fl_Button* o = new Fl_Button(251, 237, 51, 20);
            o->labelsize(11);
            o->callback((Fl_Callback*)cb_Color_Chip, (void*)(&Widget_Browser::comment_color));
          } // Fl_Button* o
          { Fl_Menu_Button* o = new Fl_Menu_Button(302, 237, 18, 20);
            o->callback((Fl_Callback*)cb_Color_Choice, (void*)(&Widget_Browser::comment_color));
            o->menu(colormenu);
          } // Fl_Menu_Button* o
          o->end();
        } // Fl_Group* o
        w_settings_user_tab->end();
      } // Fl_Group* w_settings_user_tab
      w_settings_tabs->end();
      Fl_Group::current()->resizable(w_settings_tabs);
    } // Fl_Tabs* w_settings_tabs
    { Fl_Group* o = new Fl_Group(10, 550, 320, 20);
      { Fl_Button* o = new Fl_Button(230, 550, 100, 20, "Close");
        o->tooltip("Close this dialog.");
        o->labelsize(11);
        o->callback((Fl_Callback*)cb_Close);
      } // Fl_Button* o
      { Fl_Box* o = new Fl_Box(220, 550, 10, 20);
        o->hide();
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      o->end();
    } // Fl_Group* o
    settings_window->size_range(340, 580);
    settings_window->end();
  } // Fl_Double_Window* settings_window
  w_settings_tabs->do_callback(w_settings_tabs, LOAD);
  return settings_window;
}

Fl_Double_Window *shell_run_window=(Fl_Double_Window *)0;

Fl_Terminal *shell_run_terminal=(Fl_Terminal *)0;

static void cb_Clear(Fl_Button*, void*) {
  // clear screen, clear scrollback, home cursor
  shell_run_terminal->append("\033[2J\033[3J\033[H");
}

Fl_Return_Button *shell_run_button=(Fl_Return_Button *)0;

static void cb_shell_run_button(Fl_Return_Button*, void*) {
  Fl_Preferences pos(fluid_prefs, "shell_run_Window_pos");
  pos.set("x", shell_run_window->x());
  pos.set("y", shell_run_window->y());
  pos.set("w", shell_run_window->w());
  pos.set("h", shell_run_window->h());
  shell_run_window->hide();
}

Fl_Double_Window* make_shell_window() {
  { shell_run_window = new Fl_Double_Window(555, 430, "Shell Command Output");
    shell_run_window->align(Fl_Align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE));
    { shell_run_terminal = new Fl_Terminal(10, 10, 535, 375);
      Fl_Group::current()->resizable(shell_run_terminal);
      shell_run_terminal->ansi(1);
      shell_run_terminal->history_lines(1000);
    } // Fl_Terminal* shell_run_terminal
    { Fl_Group* o = new Fl_Group(10, 395, 535, 25);
      { Fl_Button* o = new Fl_Button(10, 395, 94, 25, "Clear");
        o->callback((Fl_Callback*)cb_Clear);
      } // Fl_Button* o
      { Fl_Box* o = new Fl_Box(104, 395, 341, 25);
        o->hide();
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      { shell_run_button = new Fl_Return_Button(445, 395, 100, 25, "Close");
        shell_run_button->callback((Fl_Callback*)cb_shell_run_button);
      } // Fl_Return_Button* shell_run_button
      o->end();
    } // Fl_Group* o
    shell_run_window->end();
  } // Fl_Double_Window* shell_run_window
  return shell_run_window;
}
Fl_Menu_Item *w_layout_menu_storage[4];
