/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-bcm57xx-struct.h"
#include "fu-byte-array.h"
#include "fu-bytes.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"
/**
 * fu_struct_bcm57xx_nvram_header_ref: (skip):
 **/
FuStructBcm57xxNvramHeader *
fu_struct_bcm57xx_nvram_header_ref(FuStructBcm57xxNvramHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_bcm57xx_nvram_header_unref: (skip):
 **/
void
fu_struct_bcm57xx_nvram_header_unref(FuStructBcm57xxNvramHeader *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructBcm57xxNvramHeader refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_bcm57xx_nvram_header_new_internal: (skip):
 **/
static FuStructBcm57xxNvramHeader *
fu_struct_bcm57xx_nvram_header_new_internal(void)
{
    FuStructBcm57xxNvramHeader *st = g_new0(FuStructBcm57xxNvramHeader, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_bcm57xx_nvram_header_get_magic: (skip):
 **/
guint32
fu_struct_bcm57xx_nvram_header_get_magic(const FuStructBcm57xxNvramHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_BIG_ENDIAN);
}
/**
 * fu_struct_bcm57xx_nvram_header_get_phys_addr: (skip):
 **/
guint32
fu_struct_bcm57xx_nvram_header_get_phys_addr(const FuStructBcm57xxNvramHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_BIG_ENDIAN);
}
/**
 * fu_struct_bcm57xx_nvram_header_get_size_wrds: (skip):
 **/
guint32
fu_struct_bcm57xx_nvram_header_get_size_wrds(const FuStructBcm57xxNvramHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_BIG_ENDIAN);
}
/**
 * fu_struct_bcm57xx_nvram_header_get_offset: (skip):
 **/
guint32
fu_struct_bcm57xx_nvram_header_get_offset(const FuStructBcm57xxNvramHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_BIG_ENDIAN);
}
/**
 * fu_struct_bcm57xx_nvram_header_get_crc: (skip):
 **/
guint32
fu_struct_bcm57xx_nvram_header_get_crc(const FuStructBcm57xxNvramHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 16, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_bcm57xx_nvram_header_to_string: (skip):
 **/
static gchar *
fu_struct_bcm57xx_nvram_header_to_string(const FuStructBcm57xxNvramHeader *st)
{
    g_autoptr(GString) str = g_string_new("FuStructBcm57xxNvramHeader:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  magic: 0x%x\n",
                           (guint) fu_struct_bcm57xx_nvram_header_get_magic(st));
    g_string_append_printf(str, "  phys_addr: 0x%x\n",
                           (guint) fu_struct_bcm57xx_nvram_header_get_phys_addr(st));
    g_string_append_printf(str, "  size_wrds: 0x%x\n",
                           (guint) fu_struct_bcm57xx_nvram_header_get_size_wrds(st));
    g_string_append_printf(str, "  offset: 0x%x\n",
                           (guint) fu_struct_bcm57xx_nvram_header_get_offset(st));
    g_string_append_printf(str, "  crc: 0x%x\n",
                           (guint) fu_struct_bcm57xx_nvram_header_get_crc(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_bcm57xx_nvram_header_validate_internal(FuStructBcm57xxNvramHeader *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_bcm57xx_nvram_header_parse_internal(FuStructBcm57xxNvramHeader *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_bcm57xx_nvram_header_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_bcm57xx_nvram_header_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_bcm57xx_nvram_header_parse_stream: (skip):
 **/
FuStructBcm57xxNvramHeader *
fu_struct_bcm57xx_nvram_header_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructBcm57xxNvramHeader) st = fu_struct_bcm57xx_nvram_header_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 20, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructBcm57xxNvramHeader failed read of 0x%x: ", (guint) 20);
        return NULL;
    }
    if (st->buf->len != 20) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructBcm57xxNvramHeader requested 0x%x and got 0x%x",
                    (guint) 20,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_bcm57xx_nvram_header_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_bcm57xx_nvram_directory_ref: (skip):
 **/
FuStructBcm57xxNvramDirectory *
fu_struct_bcm57xx_nvram_directory_ref(FuStructBcm57xxNvramDirectory *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_bcm57xx_nvram_directory_unref: (skip):
 **/
void
fu_struct_bcm57xx_nvram_directory_unref(FuStructBcm57xxNvramDirectory *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructBcm57xxNvramDirectory refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_bcm57xx_nvram_directory_new_internal: (skip):
 **/
static FuStructBcm57xxNvramDirectory *
fu_struct_bcm57xx_nvram_directory_new_internal(void)
{
    FuStructBcm57xxNvramDirectory *st = g_new0(FuStructBcm57xxNvramDirectory, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_bcm57xx_nvram_directory_get_addr: (skip):
 **/
guint32
fu_struct_bcm57xx_nvram_directory_get_addr(const FuStructBcm57xxNvramDirectory *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_BIG_ENDIAN);
}
/**
 * fu_struct_bcm57xx_nvram_directory_get_size_wrds: (skip):
 **/
guint32
fu_struct_bcm57xx_nvram_directory_get_size_wrds(const FuStructBcm57xxNvramDirectory *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_BIG_ENDIAN);
}
/**
 * fu_struct_bcm57xx_nvram_directory_get_offset: (skip):
 **/
guint32
fu_struct_bcm57xx_nvram_directory_get_offset(const FuStructBcm57xxNvramDirectory *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_bcm57xx_nvram_directory_to_string: (skip):
 **/
static gchar *
fu_struct_bcm57xx_nvram_directory_to_string(const FuStructBcm57xxNvramDirectory *st)
{
    g_autoptr(GString) str = g_string_new("FuStructBcm57xxNvramDirectory:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  addr: 0x%x\n",
                           (guint) fu_struct_bcm57xx_nvram_directory_get_addr(st));
    g_string_append_printf(str, "  size_wrds: 0x%x\n",
                           (guint) fu_struct_bcm57xx_nvram_directory_get_size_wrds(st));
    g_string_append_printf(str, "  offset: 0x%x\n",
                           (guint) fu_struct_bcm57xx_nvram_directory_get_offset(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_bcm57xx_nvram_directory_validate_internal(FuStructBcm57xxNvramDirectory *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_bcm57xx_nvram_directory_parse_internal(FuStructBcm57xxNvramDirectory *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_bcm57xx_nvram_directory_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_bcm57xx_nvram_directory_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_bcm57xx_nvram_directory_parse_stream: (skip):
 **/
FuStructBcm57xxNvramDirectory *
fu_struct_bcm57xx_nvram_directory_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructBcm57xxNvramDirectory) st = fu_struct_bcm57xx_nvram_directory_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 12, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructBcm57xxNvramDirectory failed read of 0x%x: ", (guint) 12);
        return NULL;
    }
    if (st->buf->len != 12) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructBcm57xxNvramDirectory requested 0x%x and got 0x%x",
                    (guint) 12,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_bcm57xx_nvram_directory_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_bcm57xx_nvram_info_ref: (skip):
 **/
FuStructBcm57xxNvramInfo *
fu_struct_bcm57xx_nvram_info_ref(FuStructBcm57xxNvramInfo *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_bcm57xx_nvram_info_unref: (skip):
 **/
void
fu_struct_bcm57xx_nvram_info_unref(FuStructBcm57xxNvramInfo *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructBcm57xxNvramInfo refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_bcm57xx_nvram_info_new_internal: (skip):
 **/
static FuStructBcm57xxNvramInfo *
fu_struct_bcm57xx_nvram_info_new_internal(void)
{
    FuStructBcm57xxNvramInfo *st = g_new0(FuStructBcm57xxNvramInfo, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_bcm57xx_nvram_info_get_mac_addr: (skip):
 **/
guint32
fu_struct_bcm57xx_nvram_info_get_mac_addr(const FuStructBcm57xxNvramInfo *st, guint idx)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0 + (sizeof(guint32) * idx),
                                        G_BIG_ENDIAN);
}
/**
 * fu_struct_bcm57xx_nvram_info_get_device: (skip):
 **/
guint16
fu_struct_bcm57xx_nvram_info_get_device(const FuStructBcm57xxNvramInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 44, G_BIG_ENDIAN);
}
/**
 * fu_struct_bcm57xx_nvram_info_get_vendor: (skip):
 **/
guint16
fu_struct_bcm57xx_nvram_info_get_vendor(const FuStructBcm57xxNvramInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 46, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_bcm57xx_nvram_info_set_mac_addr: (skip):
 **/
void
fu_struct_bcm57xx_nvram_info_set_mac_addr(FuStructBcm57xxNvramInfo *st, guint idx, guint32 value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(idx < 11);
    fu_memwrite_uint32(st->buf->data + 0 + (sizeof(guint32) * idx),
                                  value,
                                  G_BIG_ENDIAN);
}
/**
 * fu_struct_bcm57xx_nvram_info_set_device: (skip):
 **/
void
fu_struct_bcm57xx_nvram_info_set_device(FuStructBcm57xxNvramInfo *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 44, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_bcm57xx_nvram_info_set_vendor: (skip):
 **/
void
fu_struct_bcm57xx_nvram_info_set_vendor(FuStructBcm57xxNvramInfo *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 46, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_bcm57xx_nvram_info_new: (skip):
 **/
FuStructBcm57xxNvramInfo *
fu_struct_bcm57xx_nvram_info_new(void)
{
    FuStructBcm57xxNvramInfo *st = fu_struct_bcm57xx_nvram_info_new_internal();
    st->buf = g_byte_array_sized_new(140);
    fu_byte_array_set_size(st->buf, 140, 0x0);
    return st;
}
/**
 * fu_struct_bcm57xx_nvram_info_to_string: (skip):
 **/
static gchar *
fu_struct_bcm57xx_nvram_info_to_string(const FuStructBcm57xxNvramInfo *st)
{
    g_autoptr(GString) str = g_string_new("FuStructBcm57xxNvramInfo:\n");
    g_return_val_if_fail(st != NULL, NULL);
    for (guint i = 0; i < 11; i++) {
        g_string_append_printf(str, "  mac_addr[%u]: 0x%x\n",
                               i, (guint) fu_struct_bcm57xx_nvram_info_get_mac_addr(st, i));
    }
    g_string_append_printf(str, "  device: 0x%x\n",
                           (guint) fu_struct_bcm57xx_nvram_info_get_device(st));
    g_string_append_printf(str, "  vendor: 0x%x\n",
                           (guint) fu_struct_bcm57xx_nvram_info_get_vendor(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_bcm57xx_nvram_info_to_bytes: (skip):
 **/
GBytes *
fu_struct_bcm57xx_nvram_info_to_bytes(const FuStructBcm57xxNvramInfo *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return g_bytes_new(st->buf->data, st->buf->len);
}
static gboolean
fu_struct_bcm57xx_nvram_info_validate_internal(FuStructBcm57xxNvramInfo *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_bcm57xx_nvram_info_parse_internal(FuStructBcm57xxNvramInfo *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_bcm57xx_nvram_info_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_bcm57xx_nvram_info_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_bcm57xx_nvram_info_parse_stream: (skip):
 **/
FuStructBcm57xxNvramInfo *
fu_struct_bcm57xx_nvram_info_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructBcm57xxNvramInfo) st = fu_struct_bcm57xx_nvram_info_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 140, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructBcm57xxNvramInfo failed read of 0x%x: ", (guint) 140);
        return NULL;
    }
    if (st->buf->len != 140) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructBcm57xxNvramInfo requested 0x%x and got 0x%x",
                    (guint) 140,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_bcm57xx_nvram_info_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
