/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_vco_f = R"doc(VCO - Voltage controlled oscillator.

input: float stream of control voltages; output: float oscillator output

Constructor Specific Documentation:

VCO - Voltage controlled oscillator.

Args:
    sampling_rate : sampling rate (Hz)
    sensitivity : units are radians/sec/volt
    amplitude : output amplitude)doc";


static const char* __doc_gr_blocks_vco_f_vco_f = R"doc()doc";


static const char* __doc_gr_blocks_vco_f_make = R"doc(VCO - Voltage controlled oscillator.

input: float stream of control voltages; output: float oscillator output

Constructor Specific Documentation:

VCO - Voltage controlled oscillator.

Args:
    sampling_rate : sampling rate (Hz)
    sensitivity : units are radians/sec/volt
    amplitude : output amplitude)doc";
