/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, filter, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_filter_single_pole_iir_filter_ff = R"doc(single pole IIR filter with float input, float output

The input and output satisfy a difference equation of the form 


 
y[n] - (1-alpha) y[n-1] = alpha x[n]



with the corresponding rational system function 


 
H(z) = \\ frac{alpha}{1 - (1-alpha) z^{-1}}



Note that some texts define the system function with a + in the denominator. If you're using that convention, you'll need to negate the feedback tap.

Constructor Specific Documentation:



Args:
    alpha : 
    vlen : )doc";


static const char* __doc_gr_filter_single_pole_iir_filter_ff_single_pole_iir_filter_ff_0 =
    R"doc()doc";


static const char* __doc_gr_filter_single_pole_iir_filter_ff_single_pole_iir_filter_ff_1 =
    R"doc()doc";


static const char* __doc_gr_filter_single_pole_iir_filter_ff_make = R"doc(single pole IIR filter with float input, float output

The input and output satisfy a difference equation of the form 


 
y[n] - (1-alpha) y[n-1] = alpha x[n]



with the corresponding rational system function 


 
H(z) = \\ frac{alpha}{1 - (1-alpha) z^{-1}}



Note that some texts define the system function with a + in the denominator. If you're using that convention, you'll need to negate the feedback tap.

Constructor Specific Documentation:



Args:
    alpha : 
    vlen : )doc";


static const char* __doc_gr_filter_single_pole_iir_filter_ff_set_taps = R"doc()doc";
