/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_message_strobe = R"doc(Send message at defined interval.

Takes a PMT message and sends it out every  milliseconds. Useful for testing/debugging the message system.

Constructor Specific Documentation:

Make a message stobe block to send message  every  milliseconds.

Args:
    msg : The message to send as a PMT.
    period_ms : the time period in milliseconds in which to send .)doc";


static const char* __doc_gr_blocks_message_strobe_message_strobe_0 = R"doc()doc";


static const char* __doc_gr_blocks_message_strobe_message_strobe_1 = R"doc()doc";


static const char* __doc_gr_blocks_message_strobe_make = R"doc(Send message at defined interval.

Takes a PMT message and sends it out every  milliseconds. Useful for testing/debugging the message system.

Constructor Specific Documentation:

Make a message stobe block to send message  every  milliseconds.

Args:
    msg : The message to send as a PMT.
    period_ms : the time period in milliseconds in which to send .)doc";


static const char* __doc_gr_blocks_message_strobe_set_msg = R"doc(Reset the message being sent.)doc";


static const char* __doc_gr_blocks_message_strobe_msg = R"doc(Get the value of the message being sent.)doc";


static const char* __doc_gr_blocks_message_strobe_set_period = R"doc(Reset the sending interval.)doc";


static const char* __doc_gr_blocks_message_strobe_period = R"doc(Get the time interval of the strobe.)doc";
