/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_lfsr = R"doc(Fibonacci Linear Feedback Shift Register using specified polynomial mask.

Generates a maximal length pseudo-random sequence of length 2^degree-1, if supplied with a primitive polynomial.


Constructor: digital::lfsr(int mask, int seed, int reg_len);



Some common masks might be: x^4 + x^3 + x^0 = 0x19, K=3 x^5 + x^3 + x^0 = 0x29, K=4 x^6 + x^5 + x^0 = 0x61, K=5



see  for more explanation.


next_bit() - Standard LFSR operation 


next_bit_scramble(unsigned char input) - Scramble an input stream 


next_bit_descramble(unsigned char input) - Descramble an input stream 


See  for operation of these last two functions (see multiplicative scrambler.)

Args:
    mask : - polynomial coefficients representing the locations of feedback taps from a shift register which are xor'ed together to form the new high order bit.
    seed : - the initialization vector placed into the register during initialization. Low order bit corresponds to x^0 coefficient  the first to be shifted as output.
    reg_len : - specifies the length of the feedback shift register to be used. During each iteration, the register is rightshifted one and the new bit is placed in bit reg_len. reg_len should generally be at least order(mask) + 1)doc";


static const char* __doc_gr_digital_lfsr_lfsr_0 = R"doc()doc";


static const char* __doc_gr_digital_lfsr_lfsr_1 = R"doc()doc";


static const char* __doc_gr_digital_lfsr_next_bit = R"doc()doc";


static const char* __doc_gr_digital_lfsr_next_bit_scramble = R"doc()doc";


static const char* __doc_gr_digital_lfsr_next_bit_descramble = R"doc()doc";


static const char* __doc_gr_digital_lfsr_reset = R"doc(Reset shift register to initial seed value)doc";


static const char* __doc_gr_digital_lfsr_pre_shift = R"doc(Rotate the register through x number of bits where we are just throwing away the results to get queued up correctly)doc";


static const char* __doc_gr_digital_lfsr_mask = R"doc()doc";
