/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, dtv, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_dtv_dvbt_reed_solomon_enc = R"doc(Reed Solomon encoder.

ETSI EN 300 744 Clause 4.3.2 
RS(N=204,K=239,T=8).

Constructor Specific Documentation:

Create a Reed Solomon encoder.

Args:
    p : characteristic of GF(p^m).
    m : we use GF(p^m).
    gfpoly : Generator Polynomial.
    n : length of codeword of RS coder.
    k : length of information sequence of RS encoder.
    t : number of corrected errors.
    s : shortened length.
    blocks : number of blocks to process at once.)doc";


static const char* __doc_gr_dtv_dvbt_reed_solomon_enc_dvbt_reed_solomon_enc = R"doc()doc";


static const char* __doc_gr_dtv_dvbt_reed_solomon_enc_make = R"doc(Reed Solomon encoder.

ETSI EN 300 744 Clause 4.3.2 
RS(N=204,K=239,T=8).

Constructor Specific Documentation:

Create a Reed Solomon encoder.

Args:
    p : characteristic of GF(p^m).
    m : we use GF(p^m).
    gfpoly : Generator Polynomial.
    n : length of codeword of RS coder.
    k : length of information sequence of RS encoder.
    t : number of corrected errors.
    s : shortened length.
    blocks : number of blocks to process at once.)doc";
