{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Container for AtkPlug objects from other processes
-- 
-- Together with t'GI.Atk.Objects.Plug.Plug', t'GI.Atk.Objects.Socket.Socket' provides the ability to embed
-- accessibles from one process into another in a fashion that is
-- transparent to assistive technologies. t'GI.Atk.Objects.Socket.Socket' works as the
-- container of t'GI.Atk.Objects.Plug.Plug', embedding it using the method
-- 'GI.Atk.Objects.Socket.socketEmbed'. Any accessible contained in the t'GI.Atk.Objects.Plug.Plug' will
-- appear to the assistive technologies as being inside the
-- application that created the t'GI.Atk.Objects.Socket.Socket'.
-- 
-- The communication between a t'GI.Atk.Objects.Socket.Socket' and a t'GI.Atk.Objects.Plug.Plug' is done by
-- the IPC layer of the accessibility framework, normally implemented
-- by the D-Bus based implementation of AT-SPI (at-spi2). If that is
-- the case, at-spi-atk2 is the responsible to implement the abstract
-- methods 'GI.Atk.Objects.Plug.plugGetId' and 'GI.Atk.Objects.Socket.socketEmbed', so an ATK
-- implementor shouldn\'t reimplement them. The process that contains
-- the t'GI.Atk.Objects.Plug.Plug' is responsible to send the ID returned by
-- @/atk_plug_id()/@ to the process that contains the t'GI.Atk.Objects.Socket.Socket', so it
-- could call the method 'GI.Atk.Objects.Socket.socketEmbed' in order to embed it.
-- 
-- For the same reasons, an implementor doesn\'t need to implement
-- 'GI.Atk.Objects.Object.objectGetNAccessibleChildren' and
-- 'GI.Atk.Objects.Object.objectRefAccessibleChild'. All the logic related to those
-- functions will be implemented by the IPC layer.
-- 
-- See [class/@atkPlug@/]

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Objects.Socket
    ( 

-- * Exported types
    Socket(..)                              ,
    IsSocket                                ,
    toSocket                                ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addRelationship]("GI.Atk.Objects.Object#g:method:addRelationship"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [contains]("GI.Atk.Interfaces.Component#g:method:contains"), [embed]("GI.Atk.Objects.Socket#g:method:embed"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Atk.Interfaces.Component#g:method:grabFocus"), [initialize]("GI.Atk.Objects.Object#g:method:initialize"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isOccupied]("GI.Atk.Objects.Socket#g:method:isOccupied"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [notifyStateChange]("GI.Atk.Objects.Object#g:method:notifyStateChange"), [peekParent]("GI.Atk.Objects.Object#g:method:peekParent"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refAccessibleAtPoint]("GI.Atk.Interfaces.Component#g:method:refAccessibleAtPoint"), [refAccessibleChild]("GI.Atk.Objects.Object#g:method:refAccessibleChild"), [refRelationSet]("GI.Atk.Objects.Object#g:method:refRelationSet"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [refStateSet]("GI.Atk.Objects.Object#g:method:refStateSet"), [removeFocusHandler]("GI.Atk.Interfaces.Component#g:method:removeFocusHandler"), [removePropertyChangeHandler]("GI.Atk.Objects.Object#g:method:removePropertyChangeHandler"), [removeRelationship]("GI.Atk.Objects.Object#g:method:removeRelationship"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [scrollTo]("GI.Atk.Interfaces.Component#g:method:scrollTo"), [scrollToPoint]("GI.Atk.Interfaces.Component#g:method:scrollToPoint"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleId]("GI.Atk.Objects.Object#g:method:getAccessibleId"), [getAlpha]("GI.Atk.Interfaces.Component#g:method:getAlpha"), [getAttributes]("GI.Atk.Objects.Object#g:method:getAttributes"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDescription]("GI.Atk.Objects.Object#g:method:getDescription"), [getExtents]("GI.Atk.Interfaces.Component#g:method:getExtents"), [getHelpText]("GI.Atk.Objects.Object#g:method:getHelpText"), [getIndexInParent]("GI.Atk.Objects.Object#g:method:getIndexInParent"), [getLayer]("GI.Atk.Objects.Object#g:method:getLayer"), [getMdiZorder]("GI.Atk.Objects.Object#g:method:getMdiZorder"), [getNAccessibleChildren]("GI.Atk.Objects.Object#g:method:getNAccessibleChildren"), [getName]("GI.Atk.Objects.Object#g:method:getName"), [getObjectLocale]("GI.Atk.Objects.Object#g:method:getObjectLocale"), [getParent]("GI.Atk.Objects.Object#g:method:getParent"), [getPosition]("GI.Atk.Interfaces.Component#g:method:getPosition"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRole]("GI.Atk.Objects.Object#g:method:getRole"), [getSize]("GI.Atk.Interfaces.Component#g:method:getSize").
-- 
-- ==== Setters
-- [setAccessibleId]("GI.Atk.Objects.Object#g:method:setAccessibleId"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDescription]("GI.Atk.Objects.Object#g:method:setDescription"), [setExtents]("GI.Atk.Interfaces.Component#g:method:setExtents"), [setHelpText]("GI.Atk.Objects.Object#g:method:setHelpText"), [setName]("GI.Atk.Objects.Object#g:method:setName"), [setParent]("GI.Atk.Objects.Object#g:method:setParent"), [setPosition]("GI.Atk.Interfaces.Component#g:method:setPosition"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setRole]("GI.Atk.Objects.Object#g:method:setRole"), [setSize]("GI.Atk.Interfaces.Component#g:method:setSize").

#if defined(ENABLE_OVERLOADING)
    ResolveSocketMethod                     ,
#endif

-- ** embed #method:embed#

#if defined(ENABLE_OVERLOADING)
    SocketEmbedMethodInfo                   ,
#endif
    socketEmbed                             ,


-- ** isOccupied #method:isOccupied#

#if defined(ENABLE_OVERLOADING)
    SocketIsOccupiedMethodInfo              ,
#endif
    socketIsOccupied                        ,


-- ** new #method:new#

    socketNew                               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Atk.Enums as Atk.Enums
import {-# SOURCE #-} qualified GI.Atk.Interfaces.Component as Atk.Component
import {-# SOURCE #-} qualified GI.Atk.Objects.Object as Atk.Object
import {-# SOURCE #-} qualified GI.Atk.Objects.Relation as Atk.Relation
import {-# SOURCE #-} qualified GI.Atk.Objects.RelationSet as Atk.RelationSet
import {-# SOURCE #-} qualified GI.Atk.Objects.StateSet as Atk.StateSet
import {-# SOURCE #-} qualified GI.Atk.Structs.PropertyValues as Atk.PropertyValues
import {-# SOURCE #-} qualified GI.Atk.Structs.Rectangle as Atk.Rectangle
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.ValueArray as GObject.ValueArray

#else
import {-# SOURCE #-} qualified GI.Atk.Interfaces.Component as Atk.Component
import {-# SOURCE #-} qualified GI.Atk.Objects.Object as Atk.Object
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- | Memory-managed wrapper type.
newtype Socket = Socket (SP.ManagedPtr Socket)
    deriving (Eq)

instance SP.ManagedPtrNewtype Socket where
    toManagedPtr (Socket p) = p

foreign import ccall "atk_socket_get_type"
    c_atk_socket_get_type :: IO B.Types.GType

instance B.Types.TypedObject Socket where
    glibType = c_atk_socket_get_type

instance B.Types.GObject Socket

-- | Type class for types which can be safely cast to t'Socket', for instance with `toSocket`.
class (SP.GObject o, O.IsDescendantOf Socket o) => IsSocket o
instance (SP.GObject o, O.IsDescendantOf Socket o) => IsSocket o

instance O.HasParentTypes Socket
type instance O.ParentTypes Socket = '[Atk.Object.Object, GObject.Object.Object, Atk.Component.Component]

-- | Cast to t'Socket', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toSocket :: (MIO.MonadIO m, IsSocket o) => o -> m Socket
toSocket = MIO.liftIO . B.ManagedPtr.unsafeCastTo Socket

-- | Convert t'Socket' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Socket) where
    gvalueGType_ = c_atk_socket_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Socket)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Socket)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Socket ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSocketMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSocketMethod "addRelationship" o = Atk.Object.ObjectAddRelationshipMethodInfo
    ResolveSocketMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSocketMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSocketMethod "contains" o = Atk.Component.ComponentContainsMethodInfo
    ResolveSocketMethod "embed" o = SocketEmbedMethodInfo
    ResolveSocketMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSocketMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSocketMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSocketMethod "grabFocus" o = Atk.Component.ComponentGrabFocusMethodInfo
    ResolveSocketMethod "initialize" o = Atk.Object.ObjectInitializeMethodInfo
    ResolveSocketMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSocketMethod "isOccupied" o = SocketIsOccupiedMethodInfo
    ResolveSocketMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSocketMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSocketMethod "notifyStateChange" o = Atk.Object.ObjectNotifyStateChangeMethodInfo
    ResolveSocketMethod "peekParent" o = Atk.Object.ObjectPeekParentMethodInfo
    ResolveSocketMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSocketMethod "refAccessibleAtPoint" o = Atk.Component.ComponentRefAccessibleAtPointMethodInfo
    ResolveSocketMethod "refAccessibleChild" o = Atk.Object.ObjectRefAccessibleChildMethodInfo
    ResolveSocketMethod "refRelationSet" o = Atk.Object.ObjectRefRelationSetMethodInfo
    ResolveSocketMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSocketMethod "refStateSet" o = Atk.Object.ObjectRefStateSetMethodInfo
    ResolveSocketMethod "removeFocusHandler" o = Atk.Component.ComponentRemoveFocusHandlerMethodInfo
    ResolveSocketMethod "removePropertyChangeHandler" o = Atk.Object.ObjectRemovePropertyChangeHandlerMethodInfo
    ResolveSocketMethod "removeRelationship" o = Atk.Object.ObjectRemoveRelationshipMethodInfo
    ResolveSocketMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSocketMethod "scrollTo" o = Atk.Component.ComponentScrollToMethodInfo
    ResolveSocketMethod "scrollToPoint" o = Atk.Component.ComponentScrollToPointMethodInfo
    ResolveSocketMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSocketMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSocketMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSocketMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSocketMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSocketMethod "getAccessibleId" o = Atk.Object.ObjectGetAccessibleIdMethodInfo
    ResolveSocketMethod "getAlpha" o = Atk.Component.ComponentGetAlphaMethodInfo
    ResolveSocketMethod "getAttributes" o = Atk.Object.ObjectGetAttributesMethodInfo
    ResolveSocketMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSocketMethod "getDescription" o = Atk.Object.ObjectGetDescriptionMethodInfo
    ResolveSocketMethod "getExtents" o = Atk.Component.ComponentGetExtentsMethodInfo
    ResolveSocketMethod "getHelpText" o = Atk.Object.ObjectGetHelpTextMethodInfo
    ResolveSocketMethod "getIndexInParent" o = Atk.Object.ObjectGetIndexInParentMethodInfo
    ResolveSocketMethod "getLayer" o = Atk.Object.ObjectGetLayerMethodInfo
    ResolveSocketMethod "getMdiZorder" o = Atk.Object.ObjectGetMdiZorderMethodInfo
    ResolveSocketMethod "getNAccessibleChildren" o = Atk.Object.ObjectGetNAccessibleChildrenMethodInfo
    ResolveSocketMethod "getName" o = Atk.Object.ObjectGetNameMethodInfo
    ResolveSocketMethod "getObjectLocale" o = Atk.Object.ObjectGetObjectLocaleMethodInfo
    ResolveSocketMethod "getParent" o = Atk.Object.ObjectGetParentMethodInfo
    ResolveSocketMethod "getPosition" o = Atk.Component.ComponentGetPositionMethodInfo
    ResolveSocketMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSocketMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSocketMethod "getRole" o = Atk.Object.ObjectGetRoleMethodInfo
    ResolveSocketMethod "getSize" o = Atk.Component.ComponentGetSizeMethodInfo
    ResolveSocketMethod "setAccessibleId" o = Atk.Object.ObjectSetAccessibleIdMethodInfo
    ResolveSocketMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSocketMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSocketMethod "setDescription" o = Atk.Object.ObjectSetDescriptionMethodInfo
    ResolveSocketMethod "setExtents" o = Atk.Component.ComponentSetExtentsMethodInfo
    ResolveSocketMethod "setHelpText" o = Atk.Object.ObjectSetHelpTextMethodInfo
    ResolveSocketMethod "setName" o = Atk.Object.ObjectSetNameMethodInfo
    ResolveSocketMethod "setParent" o = Atk.Object.ObjectSetParentMethodInfo
    ResolveSocketMethod "setPosition" o = Atk.Component.ComponentSetPositionMethodInfo
    ResolveSocketMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSocketMethod "setRole" o = Atk.Object.ObjectSetRoleMethodInfo
    ResolveSocketMethod "setSize" o = Atk.Component.ComponentSetSizeMethodInfo
    ResolveSocketMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSocketMethod t Socket, O.OverloadedMethod info Socket p) => OL.IsLabel t (Socket -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSocketMethod t Socket, O.OverloadedMethod info Socket p, R.HasField t Socket p) => R.HasField t Socket p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSocketMethod t Socket, O.OverloadedMethodInfo info Socket) => OL.IsLabel t (O.MethodProxy info Socket) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Socket
type instance O.AttributeList Socket = SocketAttributeList
type SocketAttributeList = ('[ '("accessibleComponentLayer", Atk.Object.ObjectAccessibleComponentLayerPropertyInfo), '("accessibleComponentMdiZorder", Atk.Object.ObjectAccessibleComponentMdiZorderPropertyInfo), '("accessibleDescription", Atk.Object.ObjectAccessibleDescriptionPropertyInfo), '("accessibleHelpText", Atk.Object.ObjectAccessibleHelpTextPropertyInfo), '("accessibleHypertextNlinks", Atk.Object.ObjectAccessibleHypertextNlinksPropertyInfo), '("accessibleId", Atk.Object.ObjectAccessibleIdPropertyInfo), '("accessibleName", Atk.Object.ObjectAccessibleNamePropertyInfo), '("accessibleParent", Atk.Object.ObjectAccessibleParentPropertyInfo), '("accessibleRole", Atk.Object.ObjectAccessibleRolePropertyInfo), '("accessibleTableCaption", Atk.Object.ObjectAccessibleTableCaptionPropertyInfo), '("accessibleTableCaptionObject", Atk.Object.ObjectAccessibleTableCaptionObjectPropertyInfo), '("accessibleTableColumnDescription", Atk.Object.ObjectAccessibleTableColumnDescriptionPropertyInfo), '("accessibleTableColumnHeader", Atk.Object.ObjectAccessibleTableColumnHeaderPropertyInfo), '("accessibleTableRowDescription", Atk.Object.ObjectAccessibleTableRowDescriptionPropertyInfo), '("accessibleTableRowHeader", Atk.Object.ObjectAccessibleTableRowHeaderPropertyInfo), '("accessibleTableSummary", Atk.Object.ObjectAccessibleTableSummaryPropertyInfo), '("accessibleValue", Atk.Object.ObjectAccessibleValuePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Socket = SocketSignalList
type SocketSignalList = ('[ '("activeDescendantChanged", Atk.Object.ObjectActiveDescendantChangedSignalInfo), '("announcement", Atk.Object.ObjectAnnouncementSignalInfo), '("attributeChanged", Atk.Object.ObjectAttributeChangedSignalInfo), '("boundsChanged", Atk.Component.ComponentBoundsChangedSignalInfo), '("childrenChanged", Atk.Object.ObjectChildrenChangedSignalInfo), '("focusEvent", Atk.Object.ObjectFocusEventSignalInfo), '("notification", Atk.Object.ObjectNotificationSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("propertyChange", Atk.Object.ObjectPropertyChangeSignalInfo), '("stateChange", Atk.Object.ObjectStateChangeSignalInfo), '("visibleDataChanged", Atk.Object.ObjectVisibleDataChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Socket::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Atk" , name = "Socket" })
-- throws : False
-- Skip return : False

foreign import ccall "atk_socket_new" atk_socket_new :: 
    IO (Ptr Socket)

-- | Creates a new t'GI.Atk.Objects.Socket.Socket'.
socketNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Socket
    -- ^ __Returns:__ the newly created t'GI.Atk.Objects.Socket.Socket' instance
socketNew  = liftIO $ do
    result <- atk_socket_new
    checkUnexpectedReturnNULL "socketNew" result
    result' <- (wrapObject Socket) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Socket::embed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "obj"
--           , argType = TInterface Name { namespace = "Atk" , name = "Socket" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkSocket" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "plug_id"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the ID of an #AtkPlug"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "atk_socket_embed" atk_socket_embed :: 
    Ptr Socket ->                           -- obj : TInterface (Name {namespace = "Atk", name = "Socket"})
    CString ->                              -- plug_id : TBasicType TUTF8
    IO ()

-- | Embeds the children of an t'GI.Atk.Objects.Plug.Plug' as the children of the
-- t'GI.Atk.Objects.Socket.Socket'. The plug may be in the same process or in a different
-- process.
-- 
-- The class item used by this function should be filled in by the IPC
-- layer (usually at-spi2-atk). The implementor of the AtkSocket
-- should call this function and pass the id for the plug as returned
-- by 'GI.Atk.Objects.Plug.plugGetId'.  It is the responsibility of the application
-- to pass the plug id on to the process implementing the t'GI.Atk.Objects.Socket.Socket'
-- as needed.
-- 
-- /Since: 1.30/
socketEmbed ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocket a) =>
    a
    -- ^ /@obj@/: an t'GI.Atk.Objects.Socket.Socket'
    -> T.Text
    -- ^ /@plugId@/: the ID of an t'GI.Atk.Objects.Plug.Plug'
    -> m ()
socketEmbed obj plugId = liftIO $ do
    obj' <- unsafeManagedPtrCastPtr obj
    plugId' <- textToCString plugId
    atk_socket_embed obj' plugId'
    touchManagedPtr obj
    freeMem plugId'
    return ()

#if defined(ENABLE_OVERLOADING)
data SocketEmbedMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsSocket a) => O.OverloadedMethod SocketEmbedMethodInfo a signature where
    overloadedMethod = socketEmbed

instance O.OverloadedMethodInfo SocketEmbedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Socket.socketEmbed",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Socket.html#v:socketEmbed"
        })


#endif

-- method Socket::is_occupied
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "obj"
--           , argType = TInterface Name { namespace = "Atk" , name = "Socket" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkSocket" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "atk_socket_is_occupied" atk_socket_is_occupied :: 
    Ptr Socket ->                           -- obj : TInterface (Name {namespace = "Atk", name = "Socket"})
    IO CInt

-- | Determines whether or not the socket has an embedded plug.
-- 
-- /Since: 1.30/
socketIsOccupied ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocket a) =>
    a
    -- ^ /@obj@/: an t'GI.Atk.Objects.Socket.Socket'
    -> m Bool
    -- ^ __Returns:__ TRUE if a plug is embedded in the socket
socketIsOccupied obj = liftIO $ do
    obj' <- unsafeManagedPtrCastPtr obj
    result <- atk_socket_is_occupied obj'
    let result' = (/= 0) result
    touchManagedPtr obj
    return result'

#if defined(ENABLE_OVERLOADING)
data SocketIsOccupiedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsSocket a) => O.OverloadedMethod SocketIsOccupiedMethodInfo a signature where
    overloadedMethod = socketIsOccupied

instance O.OverloadedMethodInfo SocketIsOccupiedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Socket.socketIsOccupied",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Socket.html#v:socketIsOccupied"
        })


#endif


