{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GEmblemedIcon@ is an implementation of t'GI.Gio.Interfaces.Icon.Icon' that supports
-- adding an emblem to an icon. Adding multiple emblems to an
-- icon is ensured via 'GI.Gio.Objects.EmblemedIcon.emblemedIconAddEmblem'.
-- 
-- Note that @GEmblemedIcon@ allows no control over the position
-- of the emblems. See also t'GI.Gio.Objects.Emblem.Emblem' for more information.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.EmblemedIcon
    ( 

-- * Exported types
    EmblemedIcon(..)                        ,
    IsEmblemedIcon                          ,
    toEmblemedIcon                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addEmblem]("GI.Gio.Objects.EmblemedIcon#g:method:addEmblem"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [clearEmblems]("GI.Gio.Objects.EmblemedIcon#g:method:clearEmblems"), [equal]("GI.Gio.Interfaces.Icon#g:method:equal"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hash]("GI.Gio.Interfaces.Icon#g:method:hash"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [serialize]("GI.Gio.Interfaces.Icon#g:method:serialize"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [toString]("GI.Gio.Interfaces.Icon#g:method:toString"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getEmblems]("GI.Gio.Objects.EmblemedIcon#g:method:getEmblems"), [getIcon]("GI.Gio.Objects.EmblemedIcon#g:method:getIcon"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveEmblemedIconMethod               ,
#endif

-- ** addEmblem #method:addEmblem#

#if defined(ENABLE_OVERLOADING)
    EmblemedIconAddEmblemMethodInfo         ,
#endif
    emblemedIconAddEmblem                   ,


-- ** clearEmblems #method:clearEmblems#

#if defined(ENABLE_OVERLOADING)
    EmblemedIconClearEmblemsMethodInfo      ,
#endif
    emblemedIconClearEmblems                ,


-- ** getEmblems #method:getEmblems#

#if defined(ENABLE_OVERLOADING)
    EmblemedIconGetEmblemsMethodInfo        ,
#endif
    emblemedIconGetEmblems                  ,


-- ** getIcon #method:getIcon#

#if defined(ENABLE_OVERLOADING)
    EmblemedIconGetIconMethodInfo           ,
#endif
    emblemedIconGetIcon                     ,


-- ** new #method:new#

    emblemedIconNew                         ,




 -- * Properties


-- ** gicon #attr:gicon#
-- | The t'GI.Gio.Interfaces.Icon.Icon' to attach emblems to.
-- 
-- /Since: 2.18/

#if defined(ENABLE_OVERLOADING)
    EmblemedIconGiconPropertyInfo           ,
#endif
    constructEmblemedIconGicon              ,
#if defined(ENABLE_OVERLOADING)
    emblemedIconGicon                       ,
#endif
    getEmblemedIconGicon                    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gio.Objects.Emblem as Gio.Emblem

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gio.Objects.Emblem as Gio.Emblem

#endif

-- | Memory-managed wrapper type.
newtype EmblemedIcon = EmblemedIcon (SP.ManagedPtr EmblemedIcon)
    deriving (Eq)

instance SP.ManagedPtrNewtype EmblemedIcon where
    toManagedPtr (EmblemedIcon p) = p

foreign import ccall "g_emblemed_icon_get_type"
    c_g_emblemed_icon_get_type :: IO B.Types.GType

instance B.Types.TypedObject EmblemedIcon where
    glibType = c_g_emblemed_icon_get_type

instance B.Types.GObject EmblemedIcon

-- | Type class for types which can be safely cast to t'EmblemedIcon', for instance with `toEmblemedIcon`.
class (SP.GObject o, O.IsDescendantOf EmblemedIcon o) => IsEmblemedIcon o
instance (SP.GObject o, O.IsDescendantOf EmblemedIcon o) => IsEmblemedIcon o

instance O.HasParentTypes EmblemedIcon
type instance O.ParentTypes EmblemedIcon = '[GObject.Object.Object, Gio.Icon.Icon]

-- | Cast to t'EmblemedIcon', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toEmblemedIcon :: (MIO.MonadIO m, IsEmblemedIcon o) => o -> m EmblemedIcon
toEmblemedIcon = MIO.liftIO . B.ManagedPtr.unsafeCastTo EmblemedIcon

-- | Convert t'EmblemedIcon' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe EmblemedIcon) where
    gvalueGType_ = c_g_emblemed_icon_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr EmblemedIcon)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr EmblemedIcon)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject EmblemedIcon ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveEmblemedIconMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEmblemedIconMethod "addEmblem" o = EmblemedIconAddEmblemMethodInfo
    ResolveEmblemedIconMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveEmblemedIconMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveEmblemedIconMethod "clearEmblems" o = EmblemedIconClearEmblemsMethodInfo
    ResolveEmblemedIconMethod "equal" o = Gio.Icon.IconEqualMethodInfo
    ResolveEmblemedIconMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveEmblemedIconMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveEmblemedIconMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveEmblemedIconMethod "hash" o = Gio.Icon.IconHashMethodInfo
    ResolveEmblemedIconMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveEmblemedIconMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveEmblemedIconMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveEmblemedIconMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveEmblemedIconMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveEmblemedIconMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveEmblemedIconMethod "serialize" o = Gio.Icon.IconSerializeMethodInfo
    ResolveEmblemedIconMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveEmblemedIconMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveEmblemedIconMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveEmblemedIconMethod "toString" o = Gio.Icon.IconToStringMethodInfo
    ResolveEmblemedIconMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveEmblemedIconMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveEmblemedIconMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveEmblemedIconMethod "getEmblems" o = EmblemedIconGetEmblemsMethodInfo
    ResolveEmblemedIconMethod "getIcon" o = EmblemedIconGetIconMethodInfo
    ResolveEmblemedIconMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveEmblemedIconMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveEmblemedIconMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveEmblemedIconMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveEmblemedIconMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveEmblemedIconMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEmblemedIconMethod t EmblemedIcon, O.OverloadedMethod info EmblemedIcon p) => OL.IsLabel t (EmblemedIcon -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEmblemedIconMethod t EmblemedIcon, O.OverloadedMethod info EmblemedIcon p, R.HasField t EmblemedIcon p) => R.HasField t EmblemedIcon p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEmblemedIconMethod t EmblemedIcon, O.OverloadedMethodInfo info EmblemedIcon) => OL.IsLabel t (O.MethodProxy info EmblemedIcon) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "gicon"
   -- Type: TInterface (Name {namespace = "Gio", name = "Icon"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@gicon@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' emblemedIcon #gicon
-- @
getEmblemedIconGicon :: (MonadIO m, IsEmblemedIcon o) => o -> m (Maybe Gio.Icon.Icon)
getEmblemedIconGicon obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "gicon" Gio.Icon.Icon

-- | Construct a t'GValueConstruct' with valid value for the “@gicon@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructEmblemedIconGicon :: (IsEmblemedIcon o, MIO.MonadIO m, Gio.Icon.IsIcon a) => a -> m (GValueConstruct o)
constructEmblemedIconGicon val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "gicon" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data EmblemedIconGiconPropertyInfo
instance AttrInfo EmblemedIconGiconPropertyInfo where
    type AttrAllowedOps EmblemedIconGiconPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint EmblemedIconGiconPropertyInfo = IsEmblemedIcon
    type AttrSetTypeConstraint EmblemedIconGiconPropertyInfo = Gio.Icon.IsIcon
    type AttrTransferTypeConstraint EmblemedIconGiconPropertyInfo = Gio.Icon.IsIcon
    type AttrTransferType EmblemedIconGiconPropertyInfo = Gio.Icon.Icon
    type AttrGetType EmblemedIconGiconPropertyInfo = (Maybe Gio.Icon.Icon)
    type AttrLabel EmblemedIconGiconPropertyInfo = "gicon"
    type AttrOrigin EmblemedIconGiconPropertyInfo = EmblemedIcon
    attrGet = getEmblemedIconGicon
    attrSet = undefined
    attrTransfer _ v = do
        unsafeCastTo Gio.Icon.Icon v
    attrConstruct = constructEmblemedIconGicon
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.EmblemedIcon.gicon"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-EmblemedIcon.html#g:attr:gicon"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EmblemedIcon
type instance O.AttributeList EmblemedIcon = EmblemedIconAttributeList
type EmblemedIconAttributeList = ('[ '("gicon", EmblemedIconGiconPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
emblemedIconGicon :: AttrLabelProxy "gicon"
emblemedIconGicon = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList EmblemedIcon = EmblemedIconSignalList
type EmblemedIconSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method EmblemedIcon::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "icon"
--           , argType = TInterface Name { namespace = "Gio" , name = "Icon" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GIcon" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "emblem"
--           , argType = TInterface Name { namespace = "Gio" , name = "Emblem" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GEmblem, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "EmblemedIcon" })
-- throws : False
-- Skip return : False

foreign import ccall "g_emblemed_icon_new" g_emblemed_icon_new :: 
    Ptr Gio.Icon.Icon ->                    -- icon : TInterface (Name {namespace = "Gio", name = "Icon"})
    Ptr Gio.Emblem.Emblem ->                -- emblem : TInterface (Name {namespace = "Gio", name = "Emblem"})
    IO (Ptr EmblemedIcon)

-- | Creates a new emblemed icon for /@icon@/ with the emblem /@emblem@/.
-- 
-- /Since: 2.18/
emblemedIconNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.Icon.IsIcon a, Gio.Emblem.IsEmblem b) =>
    a
    -- ^ /@icon@/: a t'GI.Gio.Interfaces.Icon.Icon'
    -> Maybe (b)
    -- ^ /@emblem@/: a t'GI.Gio.Objects.Emblem.Emblem', or 'P.Nothing'
    -> m EmblemedIcon
    -- ^ __Returns:__ a new t'GI.Gio.Interfaces.Icon.Icon'
emblemedIconNew icon emblem = liftIO $ do
    icon' <- unsafeManagedPtrCastPtr icon
    maybeEmblem <- case emblem of
        Nothing -> return FP.nullPtr
        Just jEmblem -> do
            jEmblem' <- unsafeManagedPtrCastPtr jEmblem
            return jEmblem'
    result <- g_emblemed_icon_new icon' maybeEmblem
    checkUnexpectedReturnNULL "emblemedIconNew" result
    result' <- (wrapObject EmblemedIcon) result
    touchManagedPtr icon
    whenJust emblem touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method EmblemedIcon::add_emblem
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "emblemed"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "EmblemedIcon" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GEmblemedIcon" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "emblem"
--           , argType = TInterface Name { namespace = "Gio" , name = "Emblem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GEmblem" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_emblemed_icon_add_emblem" g_emblemed_icon_add_emblem :: 
    Ptr EmblemedIcon ->                     -- emblemed : TInterface (Name {namespace = "Gio", name = "EmblemedIcon"})
    Ptr Gio.Emblem.Emblem ->                -- emblem : TInterface (Name {namespace = "Gio", name = "Emblem"})
    IO ()

-- | Adds /@emblem@/ to the t'GI.GLib.Structs.List.List' of @/GEmblems/@.
-- 
-- /Since: 2.18/
emblemedIconAddEmblem ::
    (B.CallStack.HasCallStack, MonadIO m, IsEmblemedIcon a, Gio.Emblem.IsEmblem b) =>
    a
    -- ^ /@emblemed@/: a t'GI.Gio.Objects.EmblemedIcon.EmblemedIcon'
    -> b
    -- ^ /@emblem@/: a t'GI.Gio.Objects.Emblem.Emblem'
    -> m ()
emblemedIconAddEmblem emblemed emblem = liftIO $ do
    emblemed' <- unsafeManagedPtrCastPtr emblemed
    emblem' <- unsafeManagedPtrCastPtr emblem
    g_emblemed_icon_add_emblem emblemed' emblem'
    touchManagedPtr emblemed
    touchManagedPtr emblem
    return ()

#if defined(ENABLE_OVERLOADING)
data EmblemedIconAddEmblemMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsEmblemedIcon a, Gio.Emblem.IsEmblem b) => O.OverloadedMethod EmblemedIconAddEmblemMethodInfo a signature where
    overloadedMethod = emblemedIconAddEmblem

instance O.OverloadedMethodInfo EmblemedIconAddEmblemMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.EmblemedIcon.emblemedIconAddEmblem",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-EmblemedIcon.html#v:emblemedIconAddEmblem"
        })


#endif

-- method EmblemedIcon::clear_emblems
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "emblemed"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "EmblemedIcon" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GEmblemedIcon" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_emblemed_icon_clear_emblems" g_emblemed_icon_clear_emblems :: 
    Ptr EmblemedIcon ->                     -- emblemed : TInterface (Name {namespace = "Gio", name = "EmblemedIcon"})
    IO ()

-- | Removes all the emblems from /@icon@/.
-- 
-- /Since: 2.28/
emblemedIconClearEmblems ::
    (B.CallStack.HasCallStack, MonadIO m, IsEmblemedIcon a) =>
    a
    -- ^ /@emblemed@/: a t'GI.Gio.Objects.EmblemedIcon.EmblemedIcon'
    -> m ()
emblemedIconClearEmblems emblemed = liftIO $ do
    emblemed' <- unsafeManagedPtrCastPtr emblemed
    g_emblemed_icon_clear_emblems emblemed'
    touchManagedPtr emblemed
    return ()

#if defined(ENABLE_OVERLOADING)
data EmblemedIconClearEmblemsMethodInfo
instance (signature ~ (m ()), MonadIO m, IsEmblemedIcon a) => O.OverloadedMethod EmblemedIconClearEmblemsMethodInfo a signature where
    overloadedMethod = emblemedIconClearEmblems

instance O.OverloadedMethodInfo EmblemedIconClearEmblemsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.EmblemedIcon.emblemedIconClearEmblems",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-EmblemedIcon.html#v:emblemedIconClearEmblems"
        })


#endif

-- method EmblemedIcon::get_emblems
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "emblemed"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "EmblemedIcon" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GEmblemedIcon" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList (TInterface Name { namespace = "Gio" , name = "Emblem" }))
-- throws : False
-- Skip return : False

foreign import ccall "g_emblemed_icon_get_emblems" g_emblemed_icon_get_emblems :: 
    Ptr EmblemedIcon ->                     -- emblemed : TInterface (Name {namespace = "Gio", name = "EmblemedIcon"})
    IO (Ptr (GList (Ptr Gio.Emblem.Emblem)))

-- | Gets the list of emblems for the /@icon@/.
-- 
-- /Since: 2.18/
emblemedIconGetEmblems ::
    (B.CallStack.HasCallStack, MonadIO m, IsEmblemedIcon a) =>
    a
    -- ^ /@emblemed@/: a t'GI.Gio.Objects.EmblemedIcon.EmblemedIcon'
    -> m [Gio.Emblem.Emblem]
    -- ^ __Returns:__ a t'GI.GLib.Structs.List.List' of
    --     @/GEmblems/@ that is owned by /@emblemed@/
emblemedIconGetEmblems emblemed = liftIO $ do
    emblemed' <- unsafeManagedPtrCastPtr emblemed
    result <- g_emblemed_icon_get_emblems emblemed'
    result' <- unpackGList result
    result'' <- mapM (newObject Gio.Emblem.Emblem) result'
    touchManagedPtr emblemed
    return result''

#if defined(ENABLE_OVERLOADING)
data EmblemedIconGetEmblemsMethodInfo
instance (signature ~ (m [Gio.Emblem.Emblem]), MonadIO m, IsEmblemedIcon a) => O.OverloadedMethod EmblemedIconGetEmblemsMethodInfo a signature where
    overloadedMethod = emblemedIconGetEmblems

instance O.OverloadedMethodInfo EmblemedIconGetEmblemsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.EmblemedIcon.emblemedIconGetEmblems",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-EmblemedIcon.html#v:emblemedIconGetEmblems"
        })


#endif

-- method EmblemedIcon::get_icon
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "emblemed"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "EmblemedIcon" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GEmblemedIcon" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Icon" })
-- throws : False
-- Skip return : False

foreign import ccall "g_emblemed_icon_get_icon" g_emblemed_icon_get_icon :: 
    Ptr EmblemedIcon ->                     -- emblemed : TInterface (Name {namespace = "Gio", name = "EmblemedIcon"})
    IO (Ptr Gio.Icon.Icon)

-- | Gets the main icon for /@emblemed@/.
-- 
-- /Since: 2.18/
emblemedIconGetIcon ::
    (B.CallStack.HasCallStack, MonadIO m, IsEmblemedIcon a) =>
    a
    -- ^ /@emblemed@/: a t'GI.Gio.Objects.EmblemedIcon.EmblemedIcon'
    -> m Gio.Icon.Icon
    -- ^ __Returns:__ a t'GI.Gio.Interfaces.Icon.Icon' that is owned by /@emblemed@/
emblemedIconGetIcon emblemed = liftIO $ do
    emblemed' <- unsafeManagedPtrCastPtr emblemed
    result <- g_emblemed_icon_get_icon emblemed'
    checkUnexpectedReturnNULL "emblemedIconGetIcon" result
    result' <- (newObject Gio.Icon.Icon) result
    touchManagedPtr emblemed
    return result'

#if defined(ENABLE_OVERLOADING)
data EmblemedIconGetIconMethodInfo
instance (signature ~ (m Gio.Icon.Icon), MonadIO m, IsEmblemedIcon a) => O.OverloadedMethod EmblemedIconGetIconMethodInfo a signature where
    overloadedMethod = emblemedIconGetIcon

instance O.OverloadedMethodInfo EmblemedIconGetIconMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.EmblemedIcon.emblemedIconGetIcon",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-EmblemedIcon.html#v:emblemedIconGetIcon"
        })


#endif


