{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A size.
-- 
-- /Since: 1.0/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Graphene.Structs.Size
    ( 

-- * Exported types
    Size(..)                                ,
    newZeroSize                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [equal]("GI.Graphene.Structs.Size#g:method:equal"), [free]("GI.Graphene.Structs.Size#g:method:free"), [init]("GI.Graphene.Structs.Size#g:method:init"), [initFromSize]("GI.Graphene.Structs.Size#g:method:initFromSize"), [interpolate]("GI.Graphene.Structs.Size#g:method:interpolate"), [scale]("GI.Graphene.Structs.Size#g:method:scale").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveSizeMethod                       ,
#endif

-- ** alloc #method:alloc#

    sizeAlloc                               ,


-- ** equal #method:equal#

#if defined(ENABLE_OVERLOADING)
    SizeEqualMethodInfo                     ,
#endif
    sizeEqual                               ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    SizeFreeMethodInfo                      ,
#endif
    sizeFree                                ,


-- ** init #method:init#

#if defined(ENABLE_OVERLOADING)
    SizeInitMethodInfo                      ,
#endif
    sizeInit                                ,


-- ** initFromSize #method:initFromSize#

#if defined(ENABLE_OVERLOADING)
    SizeInitFromSizeMethodInfo              ,
#endif
    sizeInitFromSize                        ,


-- ** interpolate #method:interpolate#

#if defined(ENABLE_OVERLOADING)
    SizeInterpolateMethodInfo               ,
#endif
    sizeInterpolate                         ,


-- ** scale #method:scale#

#if defined(ENABLE_OVERLOADING)
    SizeScaleMethodInfo                     ,
#endif
    sizeScale                               ,


-- ** zero #method:zero#

    sizeZero                                ,




 -- * Properties


-- ** height #attr:height#
-- | the height

    getSizeHeight                           ,
    setSizeHeight                           ,
#if defined(ENABLE_OVERLOADING)
    size_height                             ,
#endif


-- ** width #attr:width#
-- | the width

    getSizeWidth                            ,
    setSizeWidth                            ,
#if defined(ENABLE_OVERLOADING)
    size_width                              ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype Size = Size (SP.ManagedPtr Size)
    deriving (Eq)

instance SP.ManagedPtrNewtype Size where
    toManagedPtr (Size p) = p

foreign import ccall "graphene_size_get_type" c_graphene_size_get_type :: 
    IO GType

type instance O.ParentTypes Size = '[]
instance O.HasParentTypes Size

instance B.Types.TypedObject Size where
    glibType = c_graphene_size_get_type

instance B.Types.GBoxed Size

-- | Convert t'Size' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Size) where
    gvalueGType_ = c_graphene_size_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr Size)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr Size)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed Size ptr
        else return P.Nothing
        
    

-- | Construct a t'Size' struct initialized to zero.
newZeroSize :: MonadIO m => m Size
newZeroSize = liftIO $ callocBoxedBytes 8 >>= wrapBoxed Size

instance tag ~ 'AttrSet => Constructible Size tag where
    new _ attrs = do
        o <- newZeroSize
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@width@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' size #width
-- @
getSizeWidth :: MonadIO m => Size -> m Float
getSizeWidth s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CFloat
    let val' = realToFrac val
    return val'

-- | Set the value of the “@width@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' size [ #width 'Data.GI.Base.Attributes.:=' value ]
-- @
setSizeWidth :: MonadIO m => Size -> Float -> m ()
setSizeWidth s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 0) (val' :: CFloat)

#if defined(ENABLE_OVERLOADING)
data SizeWidthFieldInfo
instance AttrInfo SizeWidthFieldInfo where
    type AttrBaseTypeConstraint SizeWidthFieldInfo = (~) Size
    type AttrAllowedOps SizeWidthFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint SizeWidthFieldInfo = (~) Float
    type AttrTransferTypeConstraint SizeWidthFieldInfo = (~)Float
    type AttrTransferType SizeWidthFieldInfo = Float
    type AttrGetType SizeWidthFieldInfo = Float
    type AttrLabel SizeWidthFieldInfo = "width"
    type AttrOrigin SizeWidthFieldInfo = Size
    attrGet = getSizeWidth
    attrSet = setSizeWidth
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Size.width"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Size.html#g:attr:width"
        })

size_width :: AttrLabelProxy "width"
size_width = AttrLabelProxy

#endif


-- | Get the value of the “@height@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' size #height
-- @
getSizeHeight :: MonadIO m => Size -> m Float
getSizeHeight s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO CFloat
    let val' = realToFrac val
    return val'

-- | Set the value of the “@height@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' size [ #height 'Data.GI.Base.Attributes.:=' value ]
-- @
setSizeHeight :: MonadIO m => Size -> Float -> m ()
setSizeHeight s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 4) (val' :: CFloat)

#if defined(ENABLE_OVERLOADING)
data SizeHeightFieldInfo
instance AttrInfo SizeHeightFieldInfo where
    type AttrBaseTypeConstraint SizeHeightFieldInfo = (~) Size
    type AttrAllowedOps SizeHeightFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint SizeHeightFieldInfo = (~) Float
    type AttrTransferTypeConstraint SizeHeightFieldInfo = (~)Float
    type AttrTransferType SizeHeightFieldInfo = Float
    type AttrGetType SizeHeightFieldInfo = Float
    type AttrLabel SizeHeightFieldInfo = "height"
    type AttrOrigin SizeHeightFieldInfo = Size
    attrGet = getSizeHeight
    attrSet = setSizeHeight
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Size.height"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Size.html#g:attr:height"
        })

size_height :: AttrLabelProxy "height"
size_height = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Size
type instance O.AttributeList Size = SizeAttributeList
type SizeAttributeList = ('[ '("width", SizeWidthFieldInfo), '("height", SizeHeightFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method Size::alloc
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Size" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_size_alloc" graphene_size_alloc :: 
    IO (Ptr Size)

-- | Allocates a new t'GI.Graphene.Structs.Size.Size'.
-- 
-- The contents of the returned value are undefined.
-- 
-- /Since: 1.0/
sizeAlloc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Size
    -- ^ __Returns:__ the newly allocated t'GI.Graphene.Structs.Size.Size'
sizeAlloc  = liftIO $ do
    result <- graphene_size_alloc
    checkUnexpectedReturnNULL "sizeAlloc" result
    result' <- (wrapBoxed Size) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Size::equal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Size" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_size_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Size" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_size_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_size_equal" graphene_size_equal :: 
    Ptr Size ->                             -- a : TInterface (Name {namespace = "Graphene", name = "Size"})
    Ptr Size ->                             -- b : TInterface (Name {namespace = "Graphene", name = "Size"})
    IO CInt

-- | Checks whether the two give t'GI.Graphene.Structs.Size.Size' are equal.
-- 
-- /Since: 1.0/
sizeEqual ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Size
    -- ^ /@a@/: a t'GI.Graphene.Structs.Size.Size'
    -> Size
    -- ^ /@b@/: a t'GI.Graphene.Structs.Size.Size'
    -> m Bool
    -- ^ __Returns:__ @true@ if the sizes are equal
sizeEqual a b = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    result <- graphene_size_equal a' b'
    let result' = (/= 0) result
    touchManagedPtr a
    touchManagedPtr b
    return result'

#if defined(ENABLE_OVERLOADING)
data SizeEqualMethodInfo
instance (signature ~ (Size -> m Bool), MonadIO m) => O.OverloadedMethod SizeEqualMethodInfo Size signature where
    overloadedMethod = sizeEqual

instance O.OverloadedMethodInfo SizeEqualMethodInfo Size where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Size.sizeEqual",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Size.html#v:sizeEqual"
        })


#endif

-- method Size::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "s"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Size" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_size_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_size_free" graphene_size_free :: 
    Ptr Size ->                             -- s : TInterface (Name {namespace = "Graphene", name = "Size"})
    IO ()

-- | Frees the resources allocated by 'GI.Graphene.Structs.Size.sizeAlloc'.
-- 
-- /Since: 1.0/
sizeFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Size
    -- ^ /@s@/: a t'GI.Graphene.Structs.Size.Size'
    -> m ()
sizeFree s = liftIO $ do
    s' <- unsafeManagedPtrGetPtr s
    graphene_size_free s'
    touchManagedPtr s
    return ()

#if defined(ENABLE_OVERLOADING)
data SizeFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod SizeFreeMethodInfo Size signature where
    overloadedMethod = sizeFree

instance O.OverloadedMethodInfo SizeFreeMethodInfo Size where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Size.sizeFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Size.html#v:sizeFree"
        })


#endif

-- method Size::init
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "s"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Size" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_size_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the width" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the height" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Size" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_size_init" graphene_size_init :: 
    Ptr Size ->                             -- s : TInterface (Name {namespace = "Graphene", name = "Size"})
    CFloat ->                               -- width : TBasicType TFloat
    CFloat ->                               -- height : TBasicType TFloat
    IO (Ptr Size)

-- | Initializes a t'GI.Graphene.Structs.Size.Size' using the given /@width@/ and /@height@/.
-- 
-- /Since: 1.0/
sizeInit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Size
    -- ^ /@s@/: a t'GI.Graphene.Structs.Size.Size'
    -> Float
    -- ^ /@width@/: the width
    -> Float
    -- ^ /@height@/: the height
    -> m Size
    -- ^ __Returns:__ the initialized t'GI.Graphene.Structs.Size.Size'
sizeInit s width height = liftIO $ do
    s' <- unsafeManagedPtrGetPtr s
    let width' = realToFrac width
    let height' = realToFrac height
    result <- graphene_size_init s' width' height'
    checkUnexpectedReturnNULL "sizeInit" result
    result' <- (newBoxed Size) result
    touchManagedPtr s
    return result'

#if defined(ENABLE_OVERLOADING)
data SizeInitMethodInfo
instance (signature ~ (Float -> Float -> m Size), MonadIO m) => O.OverloadedMethod SizeInitMethodInfo Size signature where
    overloadedMethod = sizeInit

instance O.OverloadedMethodInfo SizeInitMethodInfo Size where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Size.sizeInit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Size.html#v:sizeInit"
        })


#endif

-- method Size::init_from_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "s"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Size" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_size_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "src"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Size" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_size_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Size" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_size_init_from_size" graphene_size_init_from_size :: 
    Ptr Size ->                             -- s : TInterface (Name {namespace = "Graphene", name = "Size"})
    Ptr Size ->                             -- src : TInterface (Name {namespace = "Graphene", name = "Size"})
    IO (Ptr Size)

-- | Initializes a t'GI.Graphene.Structs.Size.Size' using the width and height of
-- the given /@src@/.
-- 
-- /Since: 1.0/
sizeInitFromSize ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Size
    -- ^ /@s@/: a t'GI.Graphene.Structs.Size.Size'
    -> Size
    -- ^ /@src@/: a t'GI.Graphene.Structs.Size.Size'
    -> m Size
    -- ^ __Returns:__ the initialized t'GI.Graphene.Structs.Size.Size'
sizeInitFromSize s src = liftIO $ do
    s' <- unsafeManagedPtrGetPtr s
    src' <- unsafeManagedPtrGetPtr src
    result <- graphene_size_init_from_size s' src'
    checkUnexpectedReturnNULL "sizeInitFromSize" result
    result' <- (newBoxed Size) result
    touchManagedPtr s
    touchManagedPtr src
    return result'

#if defined(ENABLE_OVERLOADING)
data SizeInitFromSizeMethodInfo
instance (signature ~ (Size -> m Size), MonadIO m) => O.OverloadedMethod SizeInitFromSizeMethodInfo Size signature where
    overloadedMethod = sizeInitFromSize

instance O.OverloadedMethodInfo SizeInitFromSizeMethodInfo Size where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Size.sizeInitFromSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Size.html#v:sizeInitFromSize"
        })


#endif

-- method Size::interpolate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Size" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_size_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Size" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_size_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "factor"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the linear interpolation factor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Size" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the interpolated size"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_size_interpolate" graphene_size_interpolate :: 
    Ptr Size ->                             -- a : TInterface (Name {namespace = "Graphene", name = "Size"})
    Ptr Size ->                             -- b : TInterface (Name {namespace = "Graphene", name = "Size"})
    CDouble ->                              -- factor : TBasicType TDouble
    Ptr Size ->                             -- res : TInterface (Name {namespace = "Graphene", name = "Size"})
    IO ()

-- | Linearly interpolates the two given t'GI.Graphene.Structs.Size.Size' using the given
-- interpolation /@factor@/.
-- 
-- /Since: 1.0/
sizeInterpolate ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Size
    -- ^ /@a@/: a t'GI.Graphene.Structs.Size.Size'
    -> Size
    -- ^ /@b@/: a t'GI.Graphene.Structs.Size.Size'
    -> Double
    -- ^ /@factor@/: the linear interpolation factor
    -> m (Size)
sizeInterpolate a b factor = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    let factor' = realToFrac factor
    res <- SP.callocBoxedBytes 8 :: IO (Ptr Size)
    graphene_size_interpolate a' b' factor' res
    res' <- (wrapBoxed Size) res
    touchManagedPtr a
    touchManagedPtr b
    return res'

#if defined(ENABLE_OVERLOADING)
data SizeInterpolateMethodInfo
instance (signature ~ (Size -> Double -> m (Size)), MonadIO m) => O.OverloadedMethod SizeInterpolateMethodInfo Size signature where
    overloadedMethod = sizeInterpolate

instance O.OverloadedMethodInfo SizeInterpolateMethodInfo Size where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Size.sizeInterpolate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Size.html#v:sizeInterpolate"
        })


#endif

-- method Size::scale
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "s"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Size" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_size_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "factor"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the scaling factor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Size" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the scaled size"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_size_scale" graphene_size_scale :: 
    Ptr Size ->                             -- s : TInterface (Name {namespace = "Graphene", name = "Size"})
    CFloat ->                               -- factor : TBasicType TFloat
    Ptr Size ->                             -- res : TInterface (Name {namespace = "Graphene", name = "Size"})
    IO ()

-- | Scales the components of a t'GI.Graphene.Structs.Size.Size' using the given /@factor@/.
-- 
-- /Since: 1.0/
sizeScale ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Size
    -- ^ /@s@/: a t'GI.Graphene.Structs.Size.Size'
    -> Float
    -- ^ /@factor@/: the scaling factor
    -> m (Size)
sizeScale s factor = liftIO $ do
    s' <- unsafeManagedPtrGetPtr s
    let factor' = realToFrac factor
    res <- SP.callocBoxedBytes 8 :: IO (Ptr Size)
    graphene_size_scale s' factor' res
    res' <- (wrapBoxed Size) res
    touchManagedPtr s
    return res'

#if defined(ENABLE_OVERLOADING)
data SizeScaleMethodInfo
instance (signature ~ (Float -> m (Size)), MonadIO m) => O.OverloadedMethod SizeScaleMethodInfo Size signature where
    overloadedMethod = sizeScale

instance O.OverloadedMethodInfo SizeScaleMethodInfo Size where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Size.sizeScale",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Size.html#v:sizeScale"
        })


#endif

-- method Size::zero
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Size" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_size_zero" graphene_size_zero :: 
    IO (Ptr Size)

-- | A constant pointer to a zero t'GI.Graphene.Structs.Size.Size', useful for
-- equality checks and interpolations.
-- 
-- /Since: 1.0/
sizeZero ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Size
    -- ^ __Returns:__ a constant size
sizeZero  = liftIO $ do
    result <- graphene_size_zero
    checkUnexpectedReturnNULL "sizeZero" result
    result' <- (newBoxed Size) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveSizeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSizeMethod "equal" o = SizeEqualMethodInfo
    ResolveSizeMethod "free" o = SizeFreeMethodInfo
    ResolveSizeMethod "init" o = SizeInitMethodInfo
    ResolveSizeMethod "initFromSize" o = SizeInitFromSizeMethodInfo
    ResolveSizeMethod "interpolate" o = SizeInterpolateMethodInfo
    ResolveSizeMethod "scale" o = SizeScaleMethodInfo
    ResolveSizeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSizeMethod t Size, O.OverloadedMethod info Size p) => OL.IsLabel t (Size -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSizeMethod t Size, O.OverloadedMethod info Size p, R.HasField t Size p) => R.HasField t Size p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSizeMethod t Size, O.OverloadedMethodInfo info Size) => OL.IsLabel t (O.MethodProxy info Size) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


