// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        v6.33.2
// source: contrib/envoy/extensions/load_balancing_policies/peak_ewma/v3alpha/peak_ewma.proto

package v3alpha

import (
	_ "github.com/cncf/xds/go/udpa/annotations"
	_ "github.com/cncf/xds/go/xds/annotations/v3"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// [#protodoc-title: Peak EWMA Load Balancer Configuration]
// Configuration for the Peak EWMA (Exponentially Weighted Moving Average) load balancing policy.
//
// This policy implements a latency-aware variant of the Power of Two Choices (P2C) algorithm.
// It selects the best host from two randomly chosen candidates based on a cost function:
// `Cost = RTT_peak_ewma * (active_requests + 1)`.
//
// The Peak EWMA algorithm is designed to:
// - Automatically route traffic away from slow or overloaded hosts
// - Adapt to changing host performance without manual configuration
// - Provide low-latency request routing with O(1) host selection complexity
// - Work effectively in heterogeneous environments with varying host capabilities
//
// RTT measurements are automatically collected from HTTP request timing and used to update
// the EWMA for each host. This provides real-time performance feedback for routing decisions.
//
// Important: This load balancer only considers latency and load when selecting hosts. It does
// not handle host health or error responses - these should be managed by Envoy's health checking
// and outlier detection systems. Peak EWMA operates on the pool of healthy hosts as determined
// by these other systems.
//
// [#extension: envoy.load_balancing_policies.peak_ewma]
// [#next-free-field: 6]
type PeakEwma struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The decay time for the RTT EWMA calculation. This specifies the time window over which
	// latency observations are considered relevant. After this duration, older measurements
	// have exponentially decayed to half their original weight.
	//
	// The Peak EWMA algorithm uses this to calculate the EWMA time constant (tau):
	// `tau = decay_time_nanos`, and the EWMA reaches its half-life after `tau * ln(2)`.
	//
	// This parameter is more intuitive than a raw smoothing factor as it directly relates
	// to the time duration over which you want to observe latency trends.
	//
	// If not specified, defaults to 10 seconds (following Finagle's default).
	DecayTime *durationpb.Duration `protobuf:"bytes,1,opt,name=decay_time,json=decayTime,proto3" json:"decay_time,omitempty"`
	// The interval at which EWMA data is aggregated from worker threads to the main thread.
	// This controls the frequency of cross-thread synchronization for the per-thread aggregation model.
	//
	// A shorter interval provides more up-to-date cross-worker information but increases
	// synchronization overhead. A longer interval reduces overhead but may cause workers
	// to operate with staler information about other workers' latency observations.
	//
	// If not specified, defaults to 100 milliseconds.
	AggregationInterval *durationpb.Duration `protobuf:"bytes,2,opt,name=aggregation_interval,json=aggregationInterval,proto3" json:"aggregation_interval,omitempty"`
	// Maximum RTT samples to buffer per host per worker thread before overwriting oldest samples.
	// This bounds memory usage while allowing burst traffic handling.
	//
	// Buffer capacity formula: max_samples_per_host / aggregation_interval = RPS capacity per host per worker
	// Memory formula: max_samples_per_host × num_hosts × num_workers × 16 bytes
	// Memory usage per worker = max_samples_per_host × num_hosts × 16 bytes
	//
	// If not specified, defaults to 1,000 samples per host per worker.
	MaxSamplesPerHost *wrapperspb.UInt32Value `protobuf:"bytes,3,opt,name=max_samples_per_host,json=maxSamplesPerHost,proto3" json:"max_samples_per_host,omitempty"`
	// Default RTT value to use for hosts that don't have measured RTT yet.
	// This provides a baseline for cost calculations until actual measurements are available.
	//
	// This value is critical for initial load balancing decisions when hosts first join
	// the cluster or when RTT measurements are temporarily unavailable. It should reflect
	// the expected baseline latency for your environment:
	//
	// If not specified, defaults to 10 milliseconds.
	DefaultRtt *durationpb.Duration `protobuf:"bytes,4,opt,name=default_rtt,json=defaultRtt,proto3" json:"default_rtt,omitempty"`
	// Penalty cost assigned to hosts that cannot provide valid cost calculations.
	// This is used when a host has no RTT measurements or is unhealthy, ensuring
	// the Power of Two Choices algorithm will prefer hosts with known performance.
	//
	// You probably should not change this value.
	//
	// The penalty should be significantly higher than any realistic RTT-based cost
	// to ensure hosts with unknown performance are strongly deprioritized while
	// still allowing them to receive traffic if no better alternatives exist.
	//
	// If not specified, defaults to 1,000,000.0 (1 million).
	PenaltyValue  *wrapperspb.DoubleValue `protobuf:"bytes,5,opt,name=penalty_value,json=penaltyValue,proto3" json:"penalty_value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PeakEwma) Reset() {
	*x = PeakEwma{}
	mi := &file_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PeakEwma) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeakEwma) ProtoMessage() {}

func (x *PeakEwma) ProtoReflect() protoreflect.Message {
	mi := &file_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeakEwma.ProtoReflect.Descriptor instead.
func (*PeakEwma) Descriptor() ([]byte, []int) {
	return file_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto_rawDescGZIP(), []int{0}
}

func (x *PeakEwma) GetDecayTime() *durationpb.Duration {
	if x != nil {
		return x.DecayTime
	}
	return nil
}

func (x *PeakEwma) GetAggregationInterval() *durationpb.Duration {
	if x != nil {
		return x.AggregationInterval
	}
	return nil
}

func (x *PeakEwma) GetMaxSamplesPerHost() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxSamplesPerHost
	}
	return nil
}

func (x *PeakEwma) GetDefaultRtt() *durationpb.Duration {
	if x != nil {
		return x.DefaultRtt
	}
	return nil
}

func (x *PeakEwma) GetPenaltyValue() *wrapperspb.DoubleValue {
	if x != nil {
		return x.PenaltyValue
	}
	return nil
}

var File_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto protoreflect.FileDescriptor

const file_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto_rawDesc = "" +
	"\n" +
	"Rcontrib/envoy/extensions/load_balancing_policies/peak_ewma/v3alpha/peak_ewma.proto\x12:envoy.extensions.load_balancing_policies.peak_ewma.v3alpha\x1a\x1egoogle/protobuf/duration.proto\x1a\x1egoogle/protobuf/wrappers.proto\x1a\x1fxds/annotations/v3/status.proto\x1a\x1dudpa/annotations/status.proto\"\xea\x02\n" +
	"\bPeakEwma\x128\n" +
	"\n" +
	"decay_time\x18\x01 \x01(\v2\x19.google.protobuf.DurationR\tdecayTime\x12L\n" +
	"\x14aggregation_interval\x18\x02 \x01(\v2\x19.google.protobuf.DurationR\x13aggregationInterval\x12M\n" +
	"\x14max_samples_per_host\x18\x03 \x01(\v2\x1c.google.protobuf.UInt32ValueR\x11maxSamplesPerHost\x12:\n" +
	"\vdefault_rtt\x18\x04 \x01(\v2\x19.google.protobuf.DurationR\n" +
	"defaultRtt\x12A\n" +
	"\rpenalty_value\x18\x05 \x01(\v2\x1c.google.protobuf.DoubleValueR\fpenaltyValue:\b\xd2Ƥ\xe1\x06\x02\b\x01B\xd6\x01\xba\x80\xc8\xd1\x06\x02\x10\x02\xd2Ƥ\xe1\x06\x02\b\x01\n" +
	"Hio.envoyproxy.envoy.extensions.load_balancing_policies.peak_ewma.v3alphaB\rPeakEwmaProtoP\x01Zigithub.com/envoyproxy/go-control-plane/contrib/envoy/extensions/load_balancing_policies/peak_ewma/v3alphab\x06proto3"

var (
	file_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto_rawDescOnce sync.Once
	file_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto_rawDescData []byte
)

func file_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto_rawDescGZIP() []byte {
	file_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto_rawDescOnce.Do(func() {
		file_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto_rawDesc), len(file_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto_rawDesc)))
	})
	return file_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto_rawDescData
}

var file_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto_goTypes = []any{
	(*PeakEwma)(nil),               // 0: envoy.extensions.load_balancing_policies.peak_ewma.v3alpha.PeakEwma
	(*durationpb.Duration)(nil),    // 1: google.protobuf.Duration
	(*wrapperspb.UInt32Value)(nil), // 2: google.protobuf.UInt32Value
	(*wrapperspb.DoubleValue)(nil), // 3: google.protobuf.DoubleValue
}
var file_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto_depIdxs = []int32{
	1, // 0: envoy.extensions.load_balancing_policies.peak_ewma.v3alpha.PeakEwma.decay_time:type_name -> google.protobuf.Duration
	1, // 1: envoy.extensions.load_balancing_policies.peak_ewma.v3alpha.PeakEwma.aggregation_interval:type_name -> google.protobuf.Duration
	2, // 2: envoy.extensions.load_balancing_policies.peak_ewma.v3alpha.PeakEwma.max_samples_per_host:type_name -> google.protobuf.UInt32Value
	1, // 3: envoy.extensions.load_balancing_policies.peak_ewma.v3alpha.PeakEwma.default_rtt:type_name -> google.protobuf.Duration
	3, // 4: envoy.extensions.load_balancing_policies.peak_ewma.v3alpha.PeakEwma.penalty_value:type_name -> google.protobuf.DoubleValue
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() {
	file_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto_init()
}
func file_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto_init() {
	if File_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto_rawDesc), len(file_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto_goTypes,
		DependencyIndexes: file_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto_depIdxs,
		MessageInfos:      file_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto_msgTypes,
	}.Build()
	File_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto = out.File
	file_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto_goTypes = nil
	file_contrib_envoy_extensions_load_balancing_policies_peak_ewma_v3alpha_peak_ewma_proto_depIdxs = nil
}
