//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: contrib/envoy/extensions/private_key_providers/qat/v3alpha/qat.proto

package v3alpha

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on QatPrivateKeyMethodConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *QatPrivateKeyMethodConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on QatPrivateKeyMethodConfig with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// QatPrivateKeyMethodConfigMultiError, or nil if none found.
func (m *QatPrivateKeyMethodConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *QatPrivateKeyMethodConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetPrivateKey()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, QatPrivateKeyMethodConfigValidationError{
					field:  "PrivateKey",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, QatPrivateKeyMethodConfigValidationError{
					field:  "PrivateKey",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPrivateKey()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return QatPrivateKeyMethodConfigValidationError{
				field:  "PrivateKey",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetPollDelay() == nil {
		err := QatPrivateKeyMethodConfigValidationError{
			field:  "PollDelay",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if d := m.GetPollDelay(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = QatPrivateKeyMethodConfigValidationError{
				field:  "PollDelay",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gte := time.Duration(0*time.Second + 1000000*time.Nanosecond)

			if dur < gte {
				err := QatPrivateKeyMethodConfigValidationError{
					field:  "PollDelay",
					reason: "value must be greater than or equal to 1ms",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if len(errors) > 0 {
		return QatPrivateKeyMethodConfigMultiError(errors)
	}

	return nil
}

// QatPrivateKeyMethodConfigMultiError is an error wrapping multiple validation
// errors returned by QatPrivateKeyMethodConfig.ValidateAll() if the
// designated constraints aren't met.
type QatPrivateKeyMethodConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m QatPrivateKeyMethodConfigMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m QatPrivateKeyMethodConfigMultiError) AllErrors() []error { return m }

// QatPrivateKeyMethodConfigValidationError is the validation error returned by
// QatPrivateKeyMethodConfig.Validate if the designated constraints aren't met.
type QatPrivateKeyMethodConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e QatPrivateKeyMethodConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e QatPrivateKeyMethodConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e QatPrivateKeyMethodConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e QatPrivateKeyMethodConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e QatPrivateKeyMethodConfigValidationError) ErrorName() string {
	return "QatPrivateKeyMethodConfigValidationError"
}

// Error satisfies the builtin error interface
func (e QatPrivateKeyMethodConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sQatPrivateKeyMethodConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = QatPrivateKeyMethodConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = QatPrivateKeyMethodConfigValidationError{}
