//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/filters/udp/udp_proxy/v3/udp_proxy.proto

package udp_proxyv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on UdpProxyConfig with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *UdpProxyConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on UdpProxyConfig with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in UdpProxyConfigMultiError,
// or nil if none found.
func (m *UdpProxyConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *UdpProxyConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetStatPrefix()) < 1 {
		err := UdpProxyConfigValidationError{
			field:  "StatPrefix",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetIdleTimeout()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, UdpProxyConfigValidationError{
					field:  "IdleTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, UdpProxyConfigValidationError{
					field:  "IdleTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetIdleTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return UdpProxyConfigValidationError{
				field:  "IdleTimeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for UseOriginalSrcIp

	if len(m.GetHashPolicies()) > 1 {
		err := UdpProxyConfigValidationError{
			field:  "HashPolicies",
			reason: "value must contain no more than 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetHashPolicies() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UdpProxyConfigValidationError{
						field:  fmt.Sprintf("HashPolicies[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UdpProxyConfigValidationError{
						field:  fmt.Sprintf("HashPolicies[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UdpProxyConfigValidationError{
					field:  fmt.Sprintf("HashPolicies[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetUpstreamSocketConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, UdpProxyConfigValidationError{
					field:  "UpstreamSocketConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, UdpProxyConfigValidationError{
					field:  "UpstreamSocketConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetUpstreamSocketConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return UdpProxyConfigValidationError{
				field:  "UpstreamSocketConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for UsePerPacketLoadBalancing

	for idx, item := range m.GetAccessLog() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UdpProxyConfigValidationError{
						field:  fmt.Sprintf("AccessLog[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UdpProxyConfigValidationError{
						field:  fmt.Sprintf("AccessLog[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UdpProxyConfigValidationError{
					field:  fmt.Sprintf("AccessLog[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetProxyAccessLog() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UdpProxyConfigValidationError{
						field:  fmt.Sprintf("ProxyAccessLog[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UdpProxyConfigValidationError{
						field:  fmt.Sprintf("ProxyAccessLog[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UdpProxyConfigValidationError{
					field:  fmt.Sprintf("ProxyAccessLog[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetSessionFilters() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UdpProxyConfigValidationError{
						field:  fmt.Sprintf("SessionFilters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UdpProxyConfigValidationError{
						field:  fmt.Sprintf("SessionFilters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UdpProxyConfigValidationError{
					field:  fmt.Sprintf("SessionFilters[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetTunnelingConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, UdpProxyConfigValidationError{
					field:  "TunnelingConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, UdpProxyConfigValidationError{
					field:  "TunnelingConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTunnelingConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return UdpProxyConfigValidationError{
				field:  "TunnelingConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetAccessLogOptions()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, UdpProxyConfigValidationError{
					field:  "AccessLogOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, UdpProxyConfigValidationError{
					field:  "AccessLogOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAccessLogOptions()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return UdpProxyConfigValidationError{
				field:  "AccessLogOptions",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	oneofRouteSpecifierPresent := false
	switch v := m.RouteSpecifier.(type) {
	case *UdpProxyConfig_Cluster:
		if v == nil {
			err := UdpProxyConfigValidationError{
				field:  "RouteSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofRouteSpecifierPresent = true

		if utf8.RuneCountInString(m.GetCluster()) < 1 {
			err := UdpProxyConfigValidationError{
				field:  "Cluster",
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	case *UdpProxyConfig_Matcher:
		if v == nil {
			err := UdpProxyConfigValidationError{
				field:  "RouteSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofRouteSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetMatcher()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UdpProxyConfigValidationError{
						field:  "Matcher",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UdpProxyConfigValidationError{
						field:  "Matcher",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetMatcher()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UdpProxyConfigValidationError{
					field:  "Matcher",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofRouteSpecifierPresent {
		err := UdpProxyConfigValidationError{
			field:  "RouteSpecifier",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return UdpProxyConfigMultiError(errors)
	}

	return nil
}

// UdpProxyConfigMultiError is an error wrapping multiple validation errors
// returned by UdpProxyConfig.ValidateAll() if the designated constraints
// aren't met.
type UdpProxyConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UdpProxyConfigMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UdpProxyConfigMultiError) AllErrors() []error { return m }

// UdpProxyConfigValidationError is the validation error returned by
// UdpProxyConfig.Validate if the designated constraints aren't met.
type UdpProxyConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UdpProxyConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UdpProxyConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UdpProxyConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UdpProxyConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UdpProxyConfigValidationError) ErrorName() string { return "UdpProxyConfigValidationError" }

// Error satisfies the builtin error interface
func (e UdpProxyConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUdpProxyConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UdpProxyConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UdpProxyConfigValidationError{}

// Validate checks the field values on UdpProxyConfig_HashPolicy with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *UdpProxyConfig_HashPolicy) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on UdpProxyConfig_HashPolicy with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// UdpProxyConfig_HashPolicyMultiError, or nil if none found.
func (m *UdpProxyConfig_HashPolicy) ValidateAll() error {
	return m.validate(true)
}

func (m *UdpProxyConfig_HashPolicy) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofPolicySpecifierPresent := false
	switch v := m.PolicySpecifier.(type) {
	case *UdpProxyConfig_HashPolicy_SourceIp:
		if v == nil {
			err := UdpProxyConfig_HashPolicyValidationError{
				field:  "PolicySpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofPolicySpecifierPresent = true

		if m.GetSourceIp() != true {
			err := UdpProxyConfig_HashPolicyValidationError{
				field:  "SourceIp",
				reason: "value must equal true",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	case *UdpProxyConfig_HashPolicy_Key:
		if v == nil {
			err := UdpProxyConfig_HashPolicyValidationError{
				field:  "PolicySpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofPolicySpecifierPresent = true

		if utf8.RuneCountInString(m.GetKey()) < 1 {
			err := UdpProxyConfig_HashPolicyValidationError{
				field:  "Key",
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofPolicySpecifierPresent {
		err := UdpProxyConfig_HashPolicyValidationError{
			field:  "PolicySpecifier",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return UdpProxyConfig_HashPolicyMultiError(errors)
	}

	return nil
}

// UdpProxyConfig_HashPolicyMultiError is an error wrapping multiple validation
// errors returned by UdpProxyConfig_HashPolicy.ValidateAll() if the
// designated constraints aren't met.
type UdpProxyConfig_HashPolicyMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UdpProxyConfig_HashPolicyMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UdpProxyConfig_HashPolicyMultiError) AllErrors() []error { return m }

// UdpProxyConfig_HashPolicyValidationError is the validation error returned by
// UdpProxyConfig_HashPolicy.Validate if the designated constraints aren't met.
type UdpProxyConfig_HashPolicyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UdpProxyConfig_HashPolicyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UdpProxyConfig_HashPolicyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UdpProxyConfig_HashPolicyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UdpProxyConfig_HashPolicyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UdpProxyConfig_HashPolicyValidationError) ErrorName() string {
	return "UdpProxyConfig_HashPolicyValidationError"
}

// Error satisfies the builtin error interface
func (e UdpProxyConfig_HashPolicyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUdpProxyConfig_HashPolicy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UdpProxyConfig_HashPolicyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UdpProxyConfig_HashPolicyValidationError{}

// Validate checks the field values on UdpProxyConfig_SessionFilter with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *UdpProxyConfig_SessionFilter) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on UdpProxyConfig_SessionFilter with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// UdpProxyConfig_SessionFilterMultiError, or nil if none found.
func (m *UdpProxyConfig_SessionFilter) ValidateAll() error {
	return m.validate(true)
}

func (m *UdpProxyConfig_SessionFilter) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := UdpProxyConfig_SessionFilterValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	switch v := m.ConfigType.(type) {
	case *UdpProxyConfig_SessionFilter_TypedConfig:
		if v == nil {
			err := UdpProxyConfig_SessionFilterValidationError{
				field:  "ConfigType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetTypedConfig()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UdpProxyConfig_SessionFilterValidationError{
						field:  "TypedConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UdpProxyConfig_SessionFilterValidationError{
						field:  "TypedConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetTypedConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UdpProxyConfig_SessionFilterValidationError{
					field:  "TypedConfig",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *UdpProxyConfig_SessionFilter_ConfigDiscovery:
		if v == nil {
			err := UdpProxyConfig_SessionFilterValidationError{
				field:  "ConfigType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetConfigDiscovery()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UdpProxyConfig_SessionFilterValidationError{
						field:  "ConfigDiscovery",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UdpProxyConfig_SessionFilterValidationError{
						field:  "ConfigDiscovery",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetConfigDiscovery()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UdpProxyConfig_SessionFilterValidationError{
					field:  "ConfigDiscovery",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return UdpProxyConfig_SessionFilterMultiError(errors)
	}

	return nil
}

// UdpProxyConfig_SessionFilterMultiError is an error wrapping multiple
// validation errors returned by UdpProxyConfig_SessionFilter.ValidateAll() if
// the designated constraints aren't met.
type UdpProxyConfig_SessionFilterMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UdpProxyConfig_SessionFilterMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UdpProxyConfig_SessionFilterMultiError) AllErrors() []error { return m }

// UdpProxyConfig_SessionFilterValidationError is the validation error returned
// by UdpProxyConfig_SessionFilter.Validate if the designated constraints
// aren't met.
type UdpProxyConfig_SessionFilterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UdpProxyConfig_SessionFilterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UdpProxyConfig_SessionFilterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UdpProxyConfig_SessionFilterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UdpProxyConfig_SessionFilterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UdpProxyConfig_SessionFilterValidationError) ErrorName() string {
	return "UdpProxyConfig_SessionFilterValidationError"
}

// Error satisfies the builtin error interface
func (e UdpProxyConfig_SessionFilterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUdpProxyConfig_SessionFilter.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UdpProxyConfig_SessionFilterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UdpProxyConfig_SessionFilterValidationError{}

// Validate checks the field values on UdpProxyConfig_UdpTunnelingConfig with
// the rules defined in the proto definition for this message. If any rules
// are violated, the first error encountered is returned, or nil if there are
// no violations.
func (m *UdpProxyConfig_UdpTunnelingConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on UdpProxyConfig_UdpTunnelingConfig
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// UdpProxyConfig_UdpTunnelingConfigMultiError, or nil if none found.
func (m *UdpProxyConfig_UdpTunnelingConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *UdpProxyConfig_UdpTunnelingConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetProxyHost()) < 1 {
		err := UdpProxyConfig_UdpTunnelingConfigValidationError{
			field:  "ProxyHost",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetProxyPort()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, UdpProxyConfig_UdpTunnelingConfigValidationError{
					field:  "ProxyPort",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, UdpProxyConfig_UdpTunnelingConfigValidationError{
					field:  "ProxyPort",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetProxyPort()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return UdpProxyConfig_UdpTunnelingConfigValidationError{
				field:  "ProxyPort",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if utf8.RuneCountInString(m.GetTargetHost()) < 1 {
		err := UdpProxyConfig_UdpTunnelingConfigValidationError{
			field:  "TargetHost",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if val := m.GetDefaultTargetPort(); val <= 0 || val > 65535 {
		err := UdpProxyConfig_UdpTunnelingConfigValidationError{
			field:  "DefaultTargetPort",
			reason: "value must be inside range (0, 65535]",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for UsePost

	// no validation rules for PostPath

	if all {
		switch v := interface{}(m.GetRetryOptions()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, UdpProxyConfig_UdpTunnelingConfigValidationError{
					field:  "RetryOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, UdpProxyConfig_UdpTunnelingConfigValidationError{
					field:  "RetryOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRetryOptions()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return UdpProxyConfig_UdpTunnelingConfigValidationError{
				field:  "RetryOptions",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(m.GetHeadersToAdd()) > 1000 {
		err := UdpProxyConfig_UdpTunnelingConfigValidationError{
			field:  "HeadersToAdd",
			reason: "value must contain no more than 1000 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetHeadersToAdd() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UdpProxyConfig_UdpTunnelingConfigValidationError{
						field:  fmt.Sprintf("HeadersToAdd[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UdpProxyConfig_UdpTunnelingConfigValidationError{
						field:  fmt.Sprintf("HeadersToAdd[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UdpProxyConfig_UdpTunnelingConfigValidationError{
					field:  fmt.Sprintf("HeadersToAdd[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetBufferOptions()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, UdpProxyConfig_UdpTunnelingConfigValidationError{
					field:  "BufferOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, UdpProxyConfig_UdpTunnelingConfigValidationError{
					field:  "BufferOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetBufferOptions()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return UdpProxyConfig_UdpTunnelingConfigValidationError{
				field:  "BufferOptions",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for PropagateResponseHeaders

	// no validation rules for PropagateResponseTrailers

	if len(errors) > 0 {
		return UdpProxyConfig_UdpTunnelingConfigMultiError(errors)
	}

	return nil
}

// UdpProxyConfig_UdpTunnelingConfigMultiError is an error wrapping multiple
// validation errors returned by
// UdpProxyConfig_UdpTunnelingConfig.ValidateAll() if the designated
// constraints aren't met.
type UdpProxyConfig_UdpTunnelingConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UdpProxyConfig_UdpTunnelingConfigMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UdpProxyConfig_UdpTunnelingConfigMultiError) AllErrors() []error { return m }

// UdpProxyConfig_UdpTunnelingConfigValidationError is the validation error
// returned by UdpProxyConfig_UdpTunnelingConfig.Validate if the designated
// constraints aren't met.
type UdpProxyConfig_UdpTunnelingConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UdpProxyConfig_UdpTunnelingConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UdpProxyConfig_UdpTunnelingConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UdpProxyConfig_UdpTunnelingConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UdpProxyConfig_UdpTunnelingConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UdpProxyConfig_UdpTunnelingConfigValidationError) ErrorName() string {
	return "UdpProxyConfig_UdpTunnelingConfigValidationError"
}

// Error satisfies the builtin error interface
func (e UdpProxyConfig_UdpTunnelingConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUdpProxyConfig_UdpTunnelingConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UdpProxyConfig_UdpTunnelingConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UdpProxyConfig_UdpTunnelingConfigValidationError{}

// Validate checks the field values on UdpProxyConfig_UdpAccessLogOptions with
// the rules defined in the proto definition for this message. If any rules
// are violated, the first error encountered is returned, or nil if there are
// no violations.
func (m *UdpProxyConfig_UdpAccessLogOptions) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on UdpProxyConfig_UdpAccessLogOptions
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// UdpProxyConfig_UdpAccessLogOptionsMultiError, or nil if none found.
func (m *UdpProxyConfig_UdpAccessLogOptions) ValidateAll() error {
	return m.validate(true)
}

func (m *UdpProxyConfig_UdpAccessLogOptions) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if d := m.GetAccessLogFlushInterval(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = UdpProxyConfig_UdpAccessLogOptionsValidationError{
				field:  "AccessLogFlushInterval",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gte := time.Duration(0*time.Second + 1000000*time.Nanosecond)

			if dur < gte {
				err := UdpProxyConfig_UdpAccessLogOptionsValidationError{
					field:  "AccessLogFlushInterval",
					reason: "value must be greater than or equal to 1ms",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	// no validation rules for FlushAccessLogOnTunnelConnected

	if len(errors) > 0 {
		return UdpProxyConfig_UdpAccessLogOptionsMultiError(errors)
	}

	return nil
}

// UdpProxyConfig_UdpAccessLogOptionsMultiError is an error wrapping multiple
// validation errors returned by
// UdpProxyConfig_UdpAccessLogOptions.ValidateAll() if the designated
// constraints aren't met.
type UdpProxyConfig_UdpAccessLogOptionsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UdpProxyConfig_UdpAccessLogOptionsMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UdpProxyConfig_UdpAccessLogOptionsMultiError) AllErrors() []error { return m }

// UdpProxyConfig_UdpAccessLogOptionsValidationError is the validation error
// returned by UdpProxyConfig_UdpAccessLogOptions.Validate if the designated
// constraints aren't met.
type UdpProxyConfig_UdpAccessLogOptionsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UdpProxyConfig_UdpAccessLogOptionsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UdpProxyConfig_UdpAccessLogOptionsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UdpProxyConfig_UdpAccessLogOptionsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UdpProxyConfig_UdpAccessLogOptionsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UdpProxyConfig_UdpAccessLogOptionsValidationError) ErrorName() string {
	return "UdpProxyConfig_UdpAccessLogOptionsValidationError"
}

// Error satisfies the builtin error interface
func (e UdpProxyConfig_UdpAccessLogOptionsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUdpProxyConfig_UdpAccessLogOptions.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UdpProxyConfig_UdpAccessLogOptionsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UdpProxyConfig_UdpAccessLogOptionsValidationError{}

// Validate checks the field values on
// UdpProxyConfig_UdpTunnelingConfig_BufferOptions with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *UdpProxyConfig_UdpTunnelingConfig_BufferOptions) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// UdpProxyConfig_UdpTunnelingConfig_BufferOptions with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in
// UdpProxyConfig_UdpTunnelingConfig_BufferOptionsMultiError, or nil if none found.
func (m *UdpProxyConfig_UdpTunnelingConfig_BufferOptions) ValidateAll() error {
	return m.validate(true)
}

func (m *UdpProxyConfig_UdpTunnelingConfig_BufferOptions) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetMaxBufferedDatagrams()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, UdpProxyConfig_UdpTunnelingConfig_BufferOptionsValidationError{
					field:  "MaxBufferedDatagrams",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, UdpProxyConfig_UdpTunnelingConfig_BufferOptionsValidationError{
					field:  "MaxBufferedDatagrams",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMaxBufferedDatagrams()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return UdpProxyConfig_UdpTunnelingConfig_BufferOptionsValidationError{
				field:  "MaxBufferedDatagrams",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetMaxBufferedBytes()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, UdpProxyConfig_UdpTunnelingConfig_BufferOptionsValidationError{
					field:  "MaxBufferedBytes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, UdpProxyConfig_UdpTunnelingConfig_BufferOptionsValidationError{
					field:  "MaxBufferedBytes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMaxBufferedBytes()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return UdpProxyConfig_UdpTunnelingConfig_BufferOptionsValidationError{
				field:  "MaxBufferedBytes",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return UdpProxyConfig_UdpTunnelingConfig_BufferOptionsMultiError(errors)
	}

	return nil
}

// UdpProxyConfig_UdpTunnelingConfig_BufferOptionsMultiError is an error
// wrapping multiple validation errors returned by
// UdpProxyConfig_UdpTunnelingConfig_BufferOptions.ValidateAll() if the
// designated constraints aren't met.
type UdpProxyConfig_UdpTunnelingConfig_BufferOptionsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UdpProxyConfig_UdpTunnelingConfig_BufferOptionsMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UdpProxyConfig_UdpTunnelingConfig_BufferOptionsMultiError) AllErrors() []error { return m }

// UdpProxyConfig_UdpTunnelingConfig_BufferOptionsValidationError is the
// validation error returned by
// UdpProxyConfig_UdpTunnelingConfig_BufferOptions.Validate if the designated
// constraints aren't met.
type UdpProxyConfig_UdpTunnelingConfig_BufferOptionsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UdpProxyConfig_UdpTunnelingConfig_BufferOptionsValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e UdpProxyConfig_UdpTunnelingConfig_BufferOptionsValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e UdpProxyConfig_UdpTunnelingConfig_BufferOptionsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UdpProxyConfig_UdpTunnelingConfig_BufferOptionsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UdpProxyConfig_UdpTunnelingConfig_BufferOptionsValidationError) ErrorName() string {
	return "UdpProxyConfig_UdpTunnelingConfig_BufferOptionsValidationError"
}

// Error satisfies the builtin error interface
func (e UdpProxyConfig_UdpTunnelingConfig_BufferOptionsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUdpProxyConfig_UdpTunnelingConfig_BufferOptions.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UdpProxyConfig_UdpTunnelingConfig_BufferOptionsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UdpProxyConfig_UdpTunnelingConfig_BufferOptionsValidationError{}

// Validate checks the field values on
// UdpProxyConfig_UdpTunnelingConfig_RetryOptions with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *UdpProxyConfig_UdpTunnelingConfig_RetryOptions) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// UdpProxyConfig_UdpTunnelingConfig_RetryOptions with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in
// UdpProxyConfig_UdpTunnelingConfig_RetryOptionsMultiError, or nil if none found.
func (m *UdpProxyConfig_UdpTunnelingConfig_RetryOptions) ValidateAll() error {
	return m.validate(true)
}

func (m *UdpProxyConfig_UdpTunnelingConfig_RetryOptions) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetMaxConnectAttempts()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, UdpProxyConfig_UdpTunnelingConfig_RetryOptionsValidationError{
					field:  "MaxConnectAttempts",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, UdpProxyConfig_UdpTunnelingConfig_RetryOptionsValidationError{
					field:  "MaxConnectAttempts",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMaxConnectAttempts()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return UdpProxyConfig_UdpTunnelingConfig_RetryOptionsValidationError{
				field:  "MaxConnectAttempts",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetBackoffOptions()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, UdpProxyConfig_UdpTunnelingConfig_RetryOptionsValidationError{
					field:  "BackoffOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, UdpProxyConfig_UdpTunnelingConfig_RetryOptionsValidationError{
					field:  "BackoffOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetBackoffOptions()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return UdpProxyConfig_UdpTunnelingConfig_RetryOptionsValidationError{
				field:  "BackoffOptions",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return UdpProxyConfig_UdpTunnelingConfig_RetryOptionsMultiError(errors)
	}

	return nil
}

// UdpProxyConfig_UdpTunnelingConfig_RetryOptionsMultiError is an error
// wrapping multiple validation errors returned by
// UdpProxyConfig_UdpTunnelingConfig_RetryOptions.ValidateAll() if the
// designated constraints aren't met.
type UdpProxyConfig_UdpTunnelingConfig_RetryOptionsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UdpProxyConfig_UdpTunnelingConfig_RetryOptionsMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UdpProxyConfig_UdpTunnelingConfig_RetryOptionsMultiError) AllErrors() []error { return m }

// UdpProxyConfig_UdpTunnelingConfig_RetryOptionsValidationError is the
// validation error returned by
// UdpProxyConfig_UdpTunnelingConfig_RetryOptions.Validate if the designated
// constraints aren't met.
type UdpProxyConfig_UdpTunnelingConfig_RetryOptionsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UdpProxyConfig_UdpTunnelingConfig_RetryOptionsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UdpProxyConfig_UdpTunnelingConfig_RetryOptionsValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e UdpProxyConfig_UdpTunnelingConfig_RetryOptionsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UdpProxyConfig_UdpTunnelingConfig_RetryOptionsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UdpProxyConfig_UdpTunnelingConfig_RetryOptionsValidationError) ErrorName() string {
	return "UdpProxyConfig_UdpTunnelingConfig_RetryOptionsValidationError"
}

// Error satisfies the builtin error interface
func (e UdpProxyConfig_UdpTunnelingConfig_RetryOptionsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUdpProxyConfig_UdpTunnelingConfig_RetryOptions.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UdpProxyConfig_UdpTunnelingConfig_RetryOptionsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UdpProxyConfig_UdpTunnelingConfig_RetryOptionsValidationError{}
