
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kaboutcomponent_wrapper.h"

// Argument includes
#include <QString>
#include <kaboutdata.h>
#include <qobject.h>
#include <qobjectdefs.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KAboutComponent_Type = nullptr;
static PyTypeObject *Sbk_KAboutComponent_TypeF(void)
{
    return _Sbk_KAboutComponent_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KAboutComponent_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KAboutComponent >()))
        return -1;

    ::KAboutComponent *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[5];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 5));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutComponent_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOO:KAboutComponent", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KAboutComponent::KAboutComponent(KAboutComponent)
    // 1: KAboutComponent::KAboutComponent(const QString&=,const QString&=,const QString&=,const QString&=,KAboutLicense::LicenseKey=)
    // 2: KAboutComponent::KAboutComponent(QString,QString,QString,QString,QString)
    if (numArgs == 0) {
        overloadId = 1; // KAboutComponent(QString,QString,QString,QString,KAboutLicense::LicenseKey)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // KAboutComponent(QString,QString,QString,QString,KAboutLicense::LicenseKey)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // KAboutComponent(QString,QString,QString,QString,KAboutLicense::LicenseKey)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 1; // KAboutComponent(QString,QString,QString,QString,KAboutLicense::LicenseKey)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 1; // KAboutComponent(QString,QString,QString,QString,KAboutLicense::LicenseKey)
                    } else if (numArgs == 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[4])))) {
                        overloadId = 2; // KAboutComponent(QString,QString,QString,QString,QString)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_LicenseKey_IDX])))->converter, (pyArgs[4])))) {
                        overloadId = 1; // KAboutComponent(QString,QString,QString,QString,KAboutLicense::LicenseKey)
                    }
                }
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutComponent_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KAboutComponent(KAboutComponent)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutComponent_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KAboutComponent_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KAboutComponent(const KAboutComponent &other)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutComponent_IDX]);
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KAboutComponent cppArg0_local;
            ::KAboutComponent *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // KAboutComponent(KAboutComponent)
                cptr = new ::KAboutComponent(*cppArg0);
            }
            break;
        }
        case 1: // KAboutComponent(const QString &name, const QString &description, const QString &version, const QString &webAddress, KAboutLicense::LicenseKey licenseType)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[5] = {{"name", 0}, {"description", 1}, {"version", 2}, {"webAddress", 3}, {"licenseType", 4}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 5, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0]))))
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))
                    || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3]))))
                    || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_LicenseKey_IDX])))->converter, (pyArgs[4]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutComponent_IDX]);
                }
            }
            ::QString cppArg0 = QString();
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2 = QString();
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3 = QString();
            if (pythonToCpp[3])
                pythonToCpp[3](pyArgs[3], &cppArg3);
            ::KAboutLicense::LicenseKey cppArg4(KAboutLicense::Unknown);
            if (pythonToCpp[4])
                pythonToCpp[4](pyArgs[4], &cppArg4);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KAboutComponent(QString,QString,QString,QString,KAboutLicense::LicenseKey)
                cptr = new ::KAboutComponent(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 2: // KAboutComponent(const QString &name, const QString &description, const QString &version, const QString &webAddress, const QString &pathToLicenseFile)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutComponent_IDX]);
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QString cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KAboutComponent(QString,QString,QString,QString,QString)
                cptr = new ::KAboutComponent(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KAboutComponent >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutComponent_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KAboutComponentFunc_description(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutComponent *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutComponent_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // description()const
        QString cppResult = const_cast<const ::KAboutComponent *>(cppSelf)->description();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutComponentFunc_license(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutComponent *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutComponent_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // license()const
        KAboutLicense cppResult = const_cast<const ::KAboutComponent *>(cppSelf)->license();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutComponentFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutComponent *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutComponent_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // name()const
        QString cppResult = const_cast<const ::KAboutComponent *>(cppSelf)->name();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutComponentFunc_version(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutComponent *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutComponent_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // version()const
        QString cppResult = const_cast<const ::KAboutComponent *>(cppSelf)->version();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutComponentFunc_webAddress(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutComponent *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutComponent_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // webAddress()const
        QString cppResult = const_cast<const ::KAboutComponent *>(cppSelf)->webAddress();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutComponent__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::KAboutComponent *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutComponent_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutComponent_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_KAboutComponent_PropertyStrings[] = {
    "description:",
    "licenses:license",
    "name:",
    "version:",
    "webAddress:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KAboutComponent_methods[] = {
    {"description", reinterpret_cast<PyCFunction>(Sbk_KAboutComponentFunc_description), METH_NOARGS, nullptr},
    {"license", reinterpret_cast<PyCFunction>(Sbk_KAboutComponentFunc_license), METH_NOARGS, nullptr},
    {"name", reinterpret_cast<PyCFunction>(Sbk_KAboutComponentFunc_name), METH_NOARGS, nullptr},
    {"version", reinterpret_cast<PyCFunction>(Sbk_KAboutComponentFunc_version), METH_NOARGS, nullptr},
    {"webAddress", reinterpret_cast<PyCFunction>(Sbk_KAboutComponentFunc_webAddress), METH_NOARGS, nullptr},
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_KAboutComponent__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KAboutComponent_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KAboutComponent_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KAboutComponent_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KAboutComponent_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KAboutComponent_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KAboutComponent_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KAboutComponent_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KAboutComponent_spec = {
    "1:KCoreAddons.KAboutComponent",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KAboutComponent_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KAboutComponent_PythonToCpp_KAboutComponent_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KAboutComponent_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KAboutComponent_PythonToCpp_KAboutComponent_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KAboutComponent_TypeF()))
        return KAboutComponent_PythonToCpp_KAboutComponent_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KAboutComponent_PTR_CppToPython_KAboutComponent(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KAboutComponent_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KAboutComponent_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *KAboutComponent_COPY_CppToPython_KAboutComponent(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::KAboutComponent *>(cppIn);
    return Shiboken::Object::newObject(Sbk_KAboutComponent_TypeF(), new ::KAboutComponent(*source), true, true);
}

// Python to C++ copy conversion.
static void KAboutComponent_PythonToCpp_KAboutComponent_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::KAboutComponent *>(cppOut) = *reinterpret_cast< ::KAboutComponent *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutComponent_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_KAboutComponent_PythonToCpp_KAboutComponent_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_KAboutComponent_TypeF()))
        return KAboutComponent_PythonToCpp_KAboutComponent_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KAboutComponent_SignatureStrings[] = {
    "2:KCoreAddons.KAboutComponent(self,other:KCoreAddons.KAboutComponent,*:KeywordOnly=None,name:QString=None,description:QString=None,webAddress:QString=None,licenses:KAboutLicense=None,version:QString=None)",
    "1:KCoreAddons.KAboutComponent(self,name:QString=QString(),description:QString=QString(),version:QString=QString(),webAddress:QString=QString(),licenseType:KCoreAddons.KAboutLicense.LicenseKey=KAboutLicense.Unknown,*:KeywordOnly=None,name:QString=None,description:QString=None,webAddress:QString=None,licenses:KAboutLicense=None,version:QString=None)",
    "0:KCoreAddons.KAboutComponent(self,name:QString,description:QString,version:QString,webAddress:QString,pathToLicenseFile:QString,*:KeywordOnly=None,name:QString=None,description:QString=None,webAddress:QString=None,licenses:KAboutLicense=None,version:QString=None)",
    "KCoreAddons.KAboutComponent.description(self)->QString",
    "KCoreAddons.KAboutComponent.license(self)->KCoreAddons.KAboutLicense",
    "KCoreAddons.KAboutComponent.name(self)->QString",
    "KCoreAddons.KAboutComponent.version(self)->QString",
    "KCoreAddons.KAboutComponent.webAddress(self)->QString",
    "KCoreAddons.KAboutComponent.__copy__(self)->typing._Self",
    nullptr}; // Sentinel
#else
static constexpr size_t KAboutComponent_SignatureByteSize = 255;
static constexpr uint8_t KAboutComponent_SignatureBytes[255] = {
    0x78, 0xda, 0xcd, 0x52, 0xc1, 0x8a, 0xc2, 0x30, 0x10, 0xbd, 0xfb, 0x25, 0x56, 0xba, 0x45, 0x3d,
    0x16, 0x5c, 0x10, 0x61, 0x2f, 0x15, 0x45, 0xd4, 0x73, 0xd0, 0x76, 0xd4, 0xb0, 0x75, 0x26, 0x24,
    0xd9, 0x2d, 0xf9, 0x7b, 0xa3, 0x8d, 0x64, 0x5b, 0xb2, 0x95, 0xde, 0x3c, 0x0d, 0x33, 0x2f, 0xef,
    0xcd, 0x9b, 0x47, 0xa6, 0x69, 0xb6, 0x20, 0x09, 0xf3, 0xa2, 0x20, 0x54, 0x49, 0x36, 0x3f, 0xd2,
    0x8f, 0x5e, 0xd0, 0x55, 0x10, 0x02, 0xea, 0xa1, 0x82, 0xf2, 0x14, 0x93, 0xbe, 0x80, 0xec, 0x7a,
    0x16, 0x8f, 0xd2, 0x0c, 0x4c, 0x45, 0xb2, 0x58, 0x63, 0x69, 0x66, 0x2b, 0x3b, 0x8c, 0xf1, 0x70,
    0x85, 0x74, 0xb3, 0xd5, 0x92, 0xe3, 0xb9, 0x9e, 0x14, 0xa0, 0x72, 0xc9, 0x85, 0xe6, 0x84, 0x4d,
    0xa0, 0x82, 0xa3, 0xd5, 0x95, 0xa0, 0x54, 0x73, 0x5e, 0xf2, 0x1c, 0x50, 0x81, 0x4a, 0xeb, 0x75,
    0xcb, 0xba, 0xad, 0xb1, 0x5f, 0x90, 0xaa, 0x2d, 0x14, 0x0d, 0x26, 0xaf, 0x8f, 0x69, 0xf8, 0x72,
    0x75, 0x18, 0x05, 0xcd, 0x79, 0xb4, 0xbd, 0xcd, 0x23, 0x01, 0xef, 0x1e, 0x74, 0x07, 0xec, 0x8c,
    0x80, 0x80, 0x31, 0x77, 0x4f, 0xe2, 0xaa, 0x4d, 0x70, 0xd6, 0x04, 0xf6, 0xf8, 0x8d, 0x54, 0xe1,
    0xdb, 0xa4, 0x3b, 0xee, 0x97, 0x6e, 0xc8, 0x52, 0x5b, 0x39, 0xe0, 0x2e, 0x16, 0x07, 0x7d, 0xd9,
    0x91, 0xf3, 0xf3, 0xc5, 0x4b, 0x2f, 0xf8, 0x2e, 0x41, 0x74, 0xc4, 0x90, 0xfc, 0x59, 0xff, 0x88,
    0x24, 0xfa, 0xf8, 0x74, 0xe4, 0x4e, 0x9a, 0x33, 0xf1, 0xa4, 0xfc, 0xfb, 0x5b, 0x3a, 0x45, 0xee,
    0x61, 0xf4, 0x59, 0xea, 0xae, 0xeb, 0x43, 0xf1, 0x21, 0xf6, 0x61, 0x31, 0x96, 0x93, 0x30, 0x8c,
    0x3d, 0x39, 0xda, 0x08, 0x4b, 0x49, 0xd8, 0xd6, 0xb6, 0x83, 0x1b, 0x59, 0x50, 0xab, 0xaa
};
#endif

PyTypeObject *init_KAboutComponent(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KAboutComponent_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KAboutComponent_IDX].type;

    Shiboken::AutoDecRef Sbk_KAboutComponent_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KAboutComponent_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KAboutComponent",
        "KAboutComponent",
        &Sbk_KAboutComponent_spec,
        &Shiboken::callCppDestructor< ::KAboutComponent >,
        Sbk_KAboutComponent_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = _Sbk_KAboutComponent_Type; // references _Sbk_KAboutComponent_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KAboutComponent_SignatureStrings);
#else
    InitSignatureBytes(pyType, KAboutComponent_SignatureBytes, KAboutComponent_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KAboutComponent_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KAboutComponent_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KAboutComponent_PythonToCpp_KAboutComponent_PTR,
        is_KAboutComponent_PythonToCpp_KAboutComponent_PTR_Convertible,
        KAboutComponent_PTR_CppToPython_KAboutComponent,
        KAboutComponent_COPY_CppToPython_KAboutComponent);

    Shiboken::Conversions::registerConverterName(converter, "KAboutComponent");
    Shiboken::Conversions::registerConverterName(converter, "KAboutComponent*");
    Shiboken::Conversions::registerConverterName(converter, "KAboutComponent&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KAboutComponent).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        KAboutComponent_PythonToCpp_KAboutComponent_COPY,
        is_KAboutComponent_PythonToCpp_KAboutComponent_COPY_Convertible);

    qRegisterMetaType< ::KAboutComponent >("KAboutComponent");

    return pyType;
}
