#ifndef SBK_KWORDMACROEXPANDERWRAPPER_H
#define SBK_KWORDMACROEXPANDERWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kmacroexpander.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

class KWordMacroExpanderWrapper : public KWordMacroExpander
{
public:
    KWordMacroExpanderWrapper(::QChar c = QLatin1Char('%'));
    KWordMacroExpanderWrapper(const KWordMacroExpanderWrapper &) = delete;
    KWordMacroExpanderWrapper& operator=(const KWordMacroExpanderWrapper &) = delete;
    KWordMacroExpanderWrapper(KWordMacroExpanderWrapper &&) = delete;
    KWordMacroExpanderWrapper& operator=(KWordMacroExpanderWrapper &&) = delete;
    ~KWordMacroExpanderWrapper() override;

    int expandEscapedMacro(const ::QString & str, int pos, ::QStringList & ret) override;
    bool expandMacro(const ::QString & str, ::QStringList & ret) override;
    static bool sbk_o_expandMacro(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QString & str, ::QStringList & ret);
    int expandPlainMacro(const ::QString & str, int pos, ::QStringList & ret) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 3> m_PyMethodCache = {nullptr, nullptr, nullptr};
};

#endif // SBK_KWORDMACROEXPANDERWRAPPER_H
