// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
	"github.com/go-acme/jdcloud-sdk-go/core"
	domainservice "github.com/go-acme/jdcloud-sdk-go/services/domainservice/models"
)

type CreateUserViewRequest struct {
	core.JDCloudRequest

	/* 地域ID  */
	RegionId string `json:"regionId"`

	/* 域名ID，请使用describeDomains接口获取。  */
	DomainId string `json:"domainId"`

	/* 添加自定义线路的参数  */
	Req *domainservice.AddView `json:"req"`
}

/*
 * param regionId: 地域ID (Required)
 * param domainId: 域名ID，请使用describeDomains接口获取。 (Required)
 * param req: 添加自定义线路的参数 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewCreateUserViewRequest(
	regionId string,
	domainId string,
	req *domainservice.AddView,
) *CreateUserViewRequest {

	return &CreateUserViewRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}/UserView",
			Method:  "POST",
			Header:  nil,
			Version: "v2",
		},
		RegionId: regionId,
		DomainId: domainId,
		Req:      req,
	}
}

/*
 * param regionId: 地域ID (Required)
 * param domainId: 域名ID，请使用describeDomains接口获取。 (Required)
 * param req: 添加自定义线路的参数 (Required)
 */
func NewCreateUserViewRequestWithAllParams(
	regionId string,
	domainId string,
	req *domainservice.AddView,
) *CreateUserViewRequest {

	return &CreateUserViewRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}/UserView",
			Method:  "POST",
			Header:  nil,
			Version: "v2",
		},
		RegionId: regionId,
		DomainId: domainId,
		Req:      req,
	}
}

/* This constructor has better compatible ability when API parameters changed */
func NewCreateUserViewRequestWithoutParam() *CreateUserViewRequest {

	return &CreateUserViewRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}/UserView",
			Method:  "POST",
			Header:  nil,
			Version: "v2",
		},
	}
}

/* param regionId: 地域ID(Required) */
func (r *CreateUserViewRequest) SetRegionId(regionId string) {
	r.RegionId = regionId
}

/* param domainId: 域名ID，请使用describeDomains接口获取。(Required) */
func (r *CreateUserViewRequest) SetDomainId(domainId string) {
	r.DomainId = domainId
}

/* param req: 添加自定义线路的参数(Required) */
func (r *CreateUserViewRequest) SetReq(req *domainservice.AddView) {
	r.Req = req
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r CreateUserViewRequest) GetRegionId() string {
	return r.RegionId
}

type CreateUserViewResponse struct {
	RequestID string               `json:"requestId"`
	Error     core.ErrorResponse   `json:"error"`
	Result    CreateUserViewResult `json:"result"`
}

type CreateUserViewResult struct {
	Data domainservice.Userview `json:"data"`
}
