
#include "ooxml/resourceids.hxx"
#include "OOXMLFactory_shared-math.hxx"
#include "ooxml/OOXMLFastHelper.hxx"
#include "oox/token/tokens.hxx"

#ifdef _MSC_VER
#pragma warning(disable:4060) // switch statement contains no 'case' or 'default' labels
#pragma warning(disable:4065) // switch statement contains 'default' but no 'case' labels
#pragma warning(disable:4702) // unreachable code
#endif

namespace writerfilter {
namespace ooxml {

using namespace com::sun::star;

/// @cond GENERATED

OOXMLFactory_shared_math::OOXMLFactory_shared_math()
{
}

OOXMLFactory_shared_math::~OOXMLFactory_shared_math()
{
}

OOXMLFactory_ns::Pointer_t OOXMLFactory_shared_math::m_pInstance;

OOXMLFactory_ns::Pointer_t OOXMLFactory_shared_math::getInstance()
{
    if (!m_pInstance)
        m_pInstance = new OOXMLFactory_shared_math();

    return m_pInstance;
}

const AttributeInfo* OOXMLFactory_shared_math::getAttributeInfoArray(Id nId)
{
    switch (nId)
    {
    case NN_shared_math|DEFINE_CT_Integer255:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_officeMath|oox::XML_val, ResourceType::Integer, NN_shared_math|DEFINE_ST_Integer255 },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_shared_math|DEFINE_CT_Integer2:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_officeMath|oox::XML_val, ResourceType::Integer, NN_shared_math|DEFINE_ST_Integer2 },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_shared_math|DEFINE_CT_SpacingRule:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_officeMath|oox::XML_val, ResourceType::Integer, NN_shared_math|DEFINE_ST_SpacingRule },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_shared_math|DEFINE_CT_UnSignedInteger:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_officeMath|oox::XML_val, ResourceType::Integer, NN_shared_math|DEFINE_ST_UnSignedInteger },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_shared_math|DEFINE_CT_Char:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_officeMath|oox::XML_val, ResourceType::String, NN_shared_math|DEFINE_ST_Char },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_shared_math|DEFINE_CT_OnOff:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_officeMath|oox::XML_val, ResourceType::List, NN_shared_math|DEFINE_ST_OnOff },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_shared_math|DEFINE_CT_String:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_officeMath|oox::XML_val, ResourceType::String, NN_shared_math|DEFINE_ST_String },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_shared_math|DEFINE_CT_XAlign:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_officeMath|oox::XML_val, ResourceType::List, NN_shared_math|DEFINE_ST_XAlign },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_shared_math|DEFINE_CT_YAlign:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_officeMath|oox::XML_val, ResourceType::List, NN_shared_math|DEFINE_ST_YAlign },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_shared_math|DEFINE_CT_Shp:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_officeMath|oox::XML_val, ResourceType::List, NN_shared_math|DEFINE_ST_Shp },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_shared_math|DEFINE_CT_FType:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_officeMath|oox::XML_val, ResourceType::List, NN_shared_math|DEFINE_ST_FType },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_shared_math|DEFINE_CT_LimLoc:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_officeMath|oox::XML_val, ResourceType::List, NN_shared_math|DEFINE_ST_LimLoc },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_shared_math|DEFINE_CT_TopBot:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_officeMath|oox::XML_val, ResourceType::List, NN_shared_math|DEFINE_ST_TopBot },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_shared_math|DEFINE_CT_Script:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_officeMath|oox::XML_val, ResourceType::List, NN_shared_math|DEFINE_ST_Script },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_shared_math|DEFINE_CT_Style:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_officeMath|oox::XML_val, ResourceType::List, NN_shared_math|DEFINE_ST_Style },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_shared_math|DEFINE_CT_ManualBreak:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_officeMath|oox::XML_alnAt, ResourceType::Integer, NN_shared_math|DEFINE_ST_Integer255 },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_shared_math|DEFINE_CT_Text:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_xml|oox::XML_space, ResourceType::String, 0 },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_shared_math|DEFINE_CT_OMathJc:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_officeMath|oox::XML_val, ResourceType::String, NN_shared_math|DEFINE_ST_Jc },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_shared_math|DEFINE_CT_TwipsMeasure:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_officeMath|oox::XML_val, ResourceType::TwipsMeasure_asSigned, NN_shared_math|DEFINE_ST_TwipsMeasure },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_shared_math|DEFINE_CT_BreakBin:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_officeMath|oox::XML_val, ResourceType::List, NN_shared_math|DEFINE_ST_BreakBin },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_shared_math|DEFINE_CT_BreakBinSub:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_officeMath|oox::XML_val, ResourceType::List, NN_shared_math|DEFINE_ST_BreakBinSub },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    default:
        break;
    }

    return NULL;
}

bool OOXMLFactory_shared_math::getListValue(Id nId, std::string_view aValue, sal_uInt32& rOutValue)
{
    (void) aValue;
    (void) rOutValue;

    switch (nId)
    {
    case NN_shared_math|DEFINE_ST_OnOff:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'o':
            if (aValue == "on") { rOutValue = NS_ooxml::LN_Value_math_ST_OnOff_on; }
            else if (aValue == "off") { rOutValue = NS_ooxml::LN_Value_math_ST_OnOff_off; }
            else { return false; }
            return true;
        }
        return false;
    case NN_shared_math|DEFINE_ST_XAlign:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'c':
            if (aValue == "center") { rOutValue = NS_ooxml::LN_Value_math_ST_XAlign_center; }
            else { return false; }
            return true;
        case 'l':
            if (aValue == "left") { rOutValue = NS_ooxml::LN_Value_math_ST_XAlign_left; }
            else { return false; }
            return true;
        case 'r':
            if (aValue == "right") { rOutValue = NS_ooxml::LN_Value_math_ST_XAlign_right; }
            else { return false; }
            return true;
        }
        return false;
    case NN_shared_math|DEFINE_ST_YAlign:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'b':
            if (aValue == "bot") { rOutValue = NS_ooxml::LN_Value_math_ST_YAlign_bot; }
            else { return false; }
            return true;
        case 'c':
            if (aValue == "center") { rOutValue = NS_ooxml::LN_Value_math_ST_YAlign_center; }
            else { return false; }
            return true;
        case 't':
            if (aValue == "top") { rOutValue = NS_ooxml::LN_Value_math_ST_YAlign_top; }
            else { return false; }
            return true;
        }
        return false;
    case NN_shared_math|DEFINE_ST_Shp:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'c':
            if (aValue == "centered") { rOutValue = NS_ooxml::LN_Value_math_ST_Shp_centered; }
            else { return false; }
            return true;
        case 'm':
            if (aValue == "match") { rOutValue = NS_ooxml::LN_Value_math_ST_Shp_match; }
            else { return false; }
            return true;
        }
        return false;
    case NN_shared_math|DEFINE_ST_FType:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'b':
            if (aValue == "bar") { rOutValue = NS_ooxml::LN_Value_math_ST_FType_bar; }
            else { return false; }
            return true;
        case 'l':
            if (aValue == "lin") { rOutValue = NS_ooxml::LN_Value_math_ST_FType_lin; }
            else { return false; }
            return true;
        case 'n':
            if (aValue == "noBar") { rOutValue = NS_ooxml::LN_Value_math_ST_FType_noBar; }
            else { return false; }
            return true;
        case 's':
            if (aValue == "skw") { rOutValue = NS_ooxml::LN_Value_math_ST_FType_skw; }
            else { return false; }
            return true;
        }
        return false;
    case NN_shared_math|DEFINE_ST_LimLoc:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 's':
            if (aValue == "subSup") { rOutValue = NS_ooxml::LN_Value_math_ST_LimLoc_subSup; }
            else { return false; }
            return true;
        case 'u':
            if (aValue == "undOvr") { rOutValue = NS_ooxml::LN_Value_math_ST_LimLoc_undOvr; }
            else { return false; }
            return true;
        }
        return false;
    case NN_shared_math|DEFINE_ST_TopBot:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'b':
            if (aValue == "bot") { rOutValue = NS_ooxml::LN_Value_math_ST_TopBot_bot; }
            else { return false; }
            return true;
        case 't':
            if (aValue == "top") { rOutValue = NS_ooxml::LN_Value_math_ST_TopBot_top; }
            else { return false; }
            return true;
        }
        return false;
    case NN_shared_math|DEFINE_ST_Script:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'd':
            if (aValue == "double-struck") { rOutValue = NS_ooxml::LN_Value_math_ST_Script_doublemstruck; }
            else { return false; }
            return true;
        case 'f':
            if (aValue == "fraktur") { rOutValue = NS_ooxml::LN_Value_math_ST_Script_fraktur; }
            else { return false; }
            return true;
        case 'm':
            if (aValue == "monospace") { rOutValue = NS_ooxml::LN_Value_math_ST_Script_monospace; }
            else { return false; }
            return true;
        case 'r':
            if (aValue == "roman") { rOutValue = NS_ooxml::LN_Value_math_ST_Script_roman; }
            else { return false; }
            return true;
        case 's':
            if (aValue == "script") { rOutValue = NS_ooxml::LN_Value_math_ST_Script_script; }
            else if (aValue == "sans-serif") { rOutValue = NS_ooxml::LN_Value_math_ST_Script_sansmserif; }
            else { return false; }
            return true;
        }
        return false;
    case NN_shared_math|DEFINE_ST_Style:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'b':
            if (aValue == "b") { rOutValue = NS_ooxml::LN_Value_ST_Style_b; }
            else if (aValue == "bi") { rOutValue = NS_ooxml::LN_Value_ST_Style_bi; }
            else { return false; }
            return true;
        case 'i':
            if (aValue == "i") { rOutValue = NS_ooxml::LN_Value_ST_Style_i; }
            else { return false; }
            return true;
        case 'p':
            if (aValue == "p") { rOutValue = NS_ooxml::LN_Value_ST_Style_p; }
            else { return false; }
            return true;
        }
        return false;
    case NN_shared_math|DEFINE_ST_BreakBin:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'a':
            if (aValue == "after") { rOutValue = NS_ooxml::LN_Value_math_ST_BreakBin_after; }
            else { return false; }
            return true;
        case 'b':
            if (aValue == "before") { rOutValue = NS_ooxml::LN_Value_math_ST_BreakBin_before; }
            else { return false; }
            return true;
        case 'r':
            if (aValue == "repeat") { rOutValue = NS_ooxml::LN_Value_math_ST_BreakBin_repeat; }
            else { return false; }
            return true;
        }
        return false;
    case NN_shared_math|DEFINE_ST_BreakBinSub:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case '+':
            if (aValue == "+-") { rOutValue = NS_ooxml::LN_Value_math_ST_BreakBinSub_pm; }
            else { return false; }
            return true;
        case '-':
            if (aValue == "--") { rOutValue = NS_ooxml::LN_Value_math_ST_BreakBinSub_mm; }
            else if (aValue == "-+") { rOutValue = NS_ooxml::LN_Value_math_ST_BreakBinSub_mp; }
            else { return false; }
            return true;
        }
        return false;
    default:
        break;
    }

    return false;
}

bool OOXMLFactory_shared_math::getElementId(Id nDefine, Id nId, ResourceType& rOutResource, Id& rOutElement)
{
    (void) rOutResource;
    (void) rOutElement;

    switch (nDefine)
    {
    case NN_shared_math|DEFINE_EG_ScriptStyle:
        switch (nId)
        {
        case oox::NMSP_officeMath|oox::XML_scr: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_Script; break;
        case oox::NMSP_officeMath|oox::XML_sty: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_Style; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_CT_RPR:
        switch (nId)
        {
        case oox::NMSP_officeMath|oox::XML_aln: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        case oox::NMSP_officeMath|oox::XML_lit: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        case oox::NMSP_officeMath|oox::XML_nor: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        case oox::NMSP_officeMath|oox::XML_scr: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_Script; break;
        case oox::NMSP_officeMath|oox::XML_sty: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_Style; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_CT_R:
        switch (nId)
        {
        case oox::NMSP_doc|oox::XML_annotationRef: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_Empty; break;
        case oox::NMSP_doc|oox::XML_br: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_Br; break;
        case oox::NMSP_doc|oox::XML_commentReference: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_CommentRef; break;
        case oox::NMSP_doc|oox::XML_continuationSeparator: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_FtnEdnCont; break;
        case oox::NMSP_doc|oox::XML_cr: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_Cr; break;
        case oox::NMSP_doc|oox::XML_dayLong: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_Empty; break;
        case oox::NMSP_doc|oox::XML_dayShort: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_Empty; break;
        case oox::NMSP_doc|oox::XML_delInstrText: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_delInstrText; break;
        case oox::NMSP_doc|oox::XML_delText: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_delText; break;
        case oox::NMSP_doc|oox::XML_drawing: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_Drawing; break;
        case oox::NMSP_doc|oox::XML_endnoteRef: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_FtnEdnRefChar; break;
        case oox::NMSP_doc|oox::XML_endnoteReference: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_FtnEdnRef; break;
        case oox::NMSP_doc|oox::XML_fldChar: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_FldChar; break;
        case oox::NMSP_doc|oox::XML_footnoteRef: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_FtnEdnRefChar; break;
        case oox::NMSP_doc|oox::XML_footnoteReference: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_FtnEdnRef; break;
        case oox::NMSP_doc|oox::XML_instrText: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_instrText; break;
        case oox::NMSP_doc|oox::XML_lastRenderedPageBreak: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_Empty; break;
        case oox::NMSP_doc|oox::XML_monthLong: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_Empty; break;
        case oox::NMSP_doc|oox::XML_monthShort: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_Empty; break;
        case oox::NMSP_doc|oox::XML_noBreakHyphen: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_Empty; break;
        case oox::NMSP_doc|oox::XML_object: rOutResource = ResourceType::Shape; rOutElement = NN_wml|DEFINE_CT_Object; break;
        case oox::NMSP_doc|oox::XML_pgNum: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_PgNum; break;
        case oox::NMSP_doc|oox::XML_pict: rOutResource = ResourceType::Shape; rOutElement = NN_wml|DEFINE_CT_Picture; break;
        case oox::NMSP_doc|oox::XML_ptab: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_PTab; break;
        case oox::NMSP_doc|oox::XML_r: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_R; break;
        case oox::NMSP_doc|oox::XML_rPr: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_RPr; break;
        case oox::NMSP_doc|oox::XML_ruby: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_Ruby; break;
        case oox::NMSP_doc|oox::XML_separator: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_FtnEdnSep; break;
        case oox::NMSP_doc|oox::XML_softHyphen: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_Empty; break;
        case oox::NMSP_doc|oox::XML_sym: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_Sym; break;
        case oox::NMSP_doc|oox::XML_t: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_Text; break;
        case oox::NMSP_doc|oox::XML_tab: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_Tab; break;
        case oox::NMSP_doc|oox::XML_yearLong: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_Empty; break;
        case oox::NMSP_doc|oox::XML_yearShort: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_Empty; break;
        case oox::NMSP_officeMath|oox::XML_t: rOutResource = ResourceType::Stream; rOutElement = NN_shared_math|DEFINE_CT_Text; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_CT_CtrlPr:
        switch (nId)
        {
        case oox::NMSP_doc|oox::XML_del: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_RPrChange; break;
        case oox::NMSP_doc|oox::XML_ins: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_RPrChange; break;
        case oox::NMSP_doc|oox::XML_rPr: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_RPr; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_CT_AccPr:
        switch (nId)
        {
        case oox::NMSP_officeMath|oox::XML_chr: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_Char; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_CT_BarPr:
        switch (nId)
        {
        case oox::NMSP_officeMath|oox::XML_pos: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_TopBot; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_CT_BoxPr:
        switch (nId)
        {
        case oox::NMSP_officeMath|oox::XML_aln: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        case oox::NMSP_officeMath|oox::XML_diff: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        case oox::NMSP_officeMath|oox::XML_noBreak: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        case oox::NMSP_officeMath|oox::XML_opEmu: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_CT_BorderBoxPr:
        switch (nId)
        {
        case oox::NMSP_officeMath|oox::XML_hideBot: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        case oox::NMSP_officeMath|oox::XML_hideLeft: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        case oox::NMSP_officeMath|oox::XML_hideRight: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        case oox::NMSP_officeMath|oox::XML_hideTop: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        case oox::NMSP_officeMath|oox::XML_strikeBLTR: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        case oox::NMSP_officeMath|oox::XML_strikeH: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        case oox::NMSP_officeMath|oox::XML_strikeTLBR: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        case oox::NMSP_officeMath|oox::XML_strikeV: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_CT_DPr:
        switch (nId)
        {
        case oox::NMSP_officeMath|oox::XML_begChr: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_Char; break;
        case oox::NMSP_officeMath|oox::XML_endChr: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_Char; break;
        case oox::NMSP_officeMath|oox::XML_grow: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        case oox::NMSP_officeMath|oox::XML_sepChr: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_Char; break;
        case oox::NMSP_officeMath|oox::XML_shp: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_Shp; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_CT_EqArrPr:
        switch (nId)
        {
        case oox::NMSP_officeMath|oox::XML_baseJc: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_YAlign; break;
        case oox::NMSP_officeMath|oox::XML_maxDist: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        case oox::NMSP_officeMath|oox::XML_objDist: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        case oox::NMSP_officeMath|oox::XML_rSp: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_UnSignedInteger; break;
        case oox::NMSP_officeMath|oox::XML_rSpRule: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_SpacingRule; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_CT_FPr:
        switch (nId)
        {
        case oox::NMSP_officeMath|oox::XML_type: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_FType; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_CT_GroupChrPr:
        switch (nId)
        {
        case oox::NMSP_officeMath|oox::XML_chr: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_Char; break;
        case oox::NMSP_officeMath|oox::XML_pos: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_TopBot; break;
        case oox::NMSP_officeMath|oox::XML_vertJc: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_TopBot; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_CT_MCPr:
        switch (nId)
        {
        case oox::NMSP_officeMath|oox::XML_count: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_Integer255; break;
        case oox::NMSP_officeMath|oox::XML_mcJc: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_XAlign; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_CT_MPr:
        switch (nId)
        {
        case oox::NMSP_officeMath|oox::XML_baseJc: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_YAlign; break;
        case oox::NMSP_officeMath|oox::XML_cGp: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_UnSignedInteger; break;
        case oox::NMSP_officeMath|oox::XML_cGpRule: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_SpacingRule; break;
        case oox::NMSP_officeMath|oox::XML_cSp: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_UnSignedInteger; break;
        case oox::NMSP_officeMath|oox::XML_plcHide: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        case oox::NMSP_officeMath|oox::XML_rSp: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_UnSignedInteger; break;
        case oox::NMSP_officeMath|oox::XML_rSpRule: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_SpacingRule; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_CT_NaryPr:
        switch (nId)
        {
        case oox::NMSP_officeMath|oox::XML_chr: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_Char; break;
        case oox::NMSP_officeMath|oox::XML_grow: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        case oox::NMSP_officeMath|oox::XML_limLoc: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_LimLoc; break;
        case oox::NMSP_officeMath|oox::XML_subHide: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        case oox::NMSP_officeMath|oox::XML_supHide: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_CT_PhantPr:
        switch (nId)
        {
        case oox::NMSP_officeMath|oox::XML_show: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        case oox::NMSP_officeMath|oox::XML_transp: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        case oox::NMSP_officeMath|oox::XML_zeroAsc: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        case oox::NMSP_officeMath|oox::XML_zeroDesc: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        case oox::NMSP_officeMath|oox::XML_zeroWid: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_CT_RadPr:
        switch (nId)
        {
        case oox::NMSP_officeMath|oox::XML_degHide: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_CT_SSubSupPr:
        switch (nId)
        {
        case oox::NMSP_officeMath|oox::XML_alnScr: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_EG_OMathMathElements:
        switch (nId)
        {
        case oox::NMSP_officeMath|oox::XML_r: rOutResource = ResourceType::Stream; rOutElement = NN_shared_math|DEFINE_CT_R; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_EG_OMathElements:
        switch (nId)
        {
        case oox::NMSP_doc|oox::XML_bookmarkEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_MarkupRangeBookmark; break;
        case oox::NMSP_doc|oox::XML_bookmarkStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_Bookmark; break;
        case oox::NMSP_doc|oox::XML_commentRangeEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_MarkupRangeCommentEnd; break;
        case oox::NMSP_doc|oox::XML_commentRangeStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_MarkupRangeCommentStart; break;
        case oox::NMSP_doc|oox::XML_customXmlDelRangeEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_Markup; break;
        case oox::NMSP_doc|oox::XML_customXmlDelRangeStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_TrackChange; break;
        case oox::NMSP_doc|oox::XML_customXmlInsRangeEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_Markup; break;
        case oox::NMSP_doc|oox::XML_customXmlInsRangeStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_TrackChange; break;
        case oox::NMSP_doc|oox::XML_customXmlMoveFromRangeEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_Markup; break;
        case oox::NMSP_doc|oox::XML_customXmlMoveFromRangeStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_TrackChange; break;
        case oox::NMSP_doc|oox::XML_customXmlMoveToRangeEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_Markup; break;
        case oox::NMSP_doc|oox::XML_customXmlMoveToRangeStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_TrackChange; break;
        case oox::NMSP_doc|oox::XML_del: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_RunTrackChange; break;
        case oox::NMSP_doc|oox::XML_ins: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_RunTrackChange; break;
        case oox::NMSP_doc|oox::XML_moveFrom: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_RunTrackChange; break;
        case oox::NMSP_doc|oox::XML_moveFromRangeEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_MarkupRangeBookmark; break;
        case oox::NMSP_doc|oox::XML_moveFromRangeStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_MoveBookmark; break;
        case oox::NMSP_doc|oox::XML_moveTo: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_RunTrackChange; break;
        case oox::NMSP_doc|oox::XML_moveToRangeEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_MarkupRangeBookmark; break;
        case oox::NMSP_doc|oox::XML_moveToRangeStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_MoveBookmark; break;
        case oox::NMSP_doc|oox::XML_permEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_PermEnd; break;
        case oox::NMSP_doc|oox::XML_permStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_PermStart; break;
        case oox::NMSP_officeMath|oox::XML_oMath: rOutResource = ResourceType::Math; rOutElement = NN_shared_math|DEFINE_CT_OMath; break;
        case oox::NMSP_officeMath|oox::XML_oMathPara: rOutResource = ResourceType::Stream; rOutElement = NN_shared_math|DEFINE_CT_OMathPara; break;
        case oox::NMSP_officeMath|oox::XML_r: rOutResource = ResourceType::Stream; rOutElement = NN_shared_math|DEFINE_CT_R; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_CT_OMathArgPr:
        switch (nId)
        {
        case oox::NMSP_officeMath|oox::XML_argSz: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_Integer2; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_CT_OMathArg:
        switch (nId)
        {
        case oox::NMSP_doc|oox::XML_bookmarkEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_MarkupRangeBookmark; break;
        case oox::NMSP_doc|oox::XML_bookmarkStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_Bookmark; break;
        case oox::NMSP_doc|oox::XML_commentRangeEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_MarkupRangeCommentEnd; break;
        case oox::NMSP_doc|oox::XML_commentRangeStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_MarkupRangeCommentStart; break;
        case oox::NMSP_doc|oox::XML_customXmlDelRangeEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_Markup; break;
        case oox::NMSP_doc|oox::XML_customXmlDelRangeStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_TrackChange; break;
        case oox::NMSP_doc|oox::XML_customXmlInsRangeEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_Markup; break;
        case oox::NMSP_doc|oox::XML_customXmlInsRangeStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_TrackChange; break;
        case oox::NMSP_doc|oox::XML_customXmlMoveFromRangeEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_Markup; break;
        case oox::NMSP_doc|oox::XML_customXmlMoveFromRangeStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_TrackChange; break;
        case oox::NMSP_doc|oox::XML_customXmlMoveToRangeEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_Markup; break;
        case oox::NMSP_doc|oox::XML_customXmlMoveToRangeStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_TrackChange; break;
        case oox::NMSP_doc|oox::XML_del: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_RunTrackChange; break;
        case oox::NMSP_doc|oox::XML_ins: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_RunTrackChange; break;
        case oox::NMSP_doc|oox::XML_moveFrom: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_RunTrackChange; break;
        case oox::NMSP_doc|oox::XML_moveFromRangeEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_MarkupRangeBookmark; break;
        case oox::NMSP_doc|oox::XML_moveFromRangeStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_MoveBookmark; break;
        case oox::NMSP_doc|oox::XML_moveTo: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_RunTrackChange; break;
        case oox::NMSP_doc|oox::XML_moveToRangeEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_MarkupRangeBookmark; break;
        case oox::NMSP_doc|oox::XML_moveToRangeStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_MoveBookmark; break;
        case oox::NMSP_doc|oox::XML_permEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_PermEnd; break;
        case oox::NMSP_doc|oox::XML_permStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_PermStart; break;
        case oox::NMSP_officeMath|oox::XML_oMath: rOutResource = ResourceType::Math; rOutElement = NN_shared_math|DEFINE_CT_OMath; break;
        case oox::NMSP_officeMath|oox::XML_oMathPara: rOutResource = ResourceType::Stream; rOutElement = NN_shared_math|DEFINE_CT_OMathPara; break;
        case oox::NMSP_officeMath|oox::XML_r: rOutResource = ResourceType::Stream; rOutElement = NN_shared_math|DEFINE_CT_R; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_CT_OMathParaPr:
        switch (nId)
        {
        case oox::NMSP_officeMath|oox::XML_jc: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OMathJc; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_CT_MathPr:
        switch (nId)
        {
        case oox::NMSP_officeMath|oox::XML_brkBin: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_BreakBin; break;
        case oox::NMSP_officeMath|oox::XML_brkBinSub: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_BreakBinSub; break;
        case oox::NMSP_officeMath|oox::XML_defJc: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OMathJc; break;
        case oox::NMSP_officeMath|oox::XML_dispDef: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        case oox::NMSP_officeMath|oox::XML_intLim: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_LimLoc; break;
        case oox::NMSP_officeMath|oox::XML_interSp: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_TwipsMeasure; break;
        case oox::NMSP_officeMath|oox::XML_intraSp: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_TwipsMeasure; break;
        case oox::NMSP_officeMath|oox::XML_lMargin: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_TwipsMeasure; break;
        case oox::NMSP_officeMath|oox::XML_mathFont: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_String; break;
        case oox::NMSP_officeMath|oox::XML_naryLim: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_LimLoc; break;
        case oox::NMSP_officeMath|oox::XML_postSp: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_TwipsMeasure; break;
        case oox::NMSP_officeMath|oox::XML_preSp: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_TwipsMeasure; break;
        case oox::NMSP_officeMath|oox::XML_rMargin: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_TwipsMeasure; break;
        case oox::NMSP_officeMath|oox::XML_smallFrac: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        case oox::NMSP_officeMath|oox::XML_wrapIndent: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_TwipsMeasure; break;
        case oox::NMSP_officeMath|oox::XML_wrapRight: rOutResource = ResourceType::Value; rOutElement = NN_shared_math|DEFINE_CT_OnOff; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_CT_OMathPara:
        switch (nId)
        {
        case oox::NMSP_officeMath|oox::XML_oMath: rOutResource = ResourceType::Math; rOutElement = NN_shared_math|DEFINE_CT_OMath; break;
        case oox::NMSP_officeMath|oox::XML_oMathParaPr: rOutResource = ResourceType::Properties; rOutElement = NN_shared_math|DEFINE_CT_OMathParaPr; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_CT_OMath:
        switch (nId)
        {
        case oox::NMSP_doc|oox::XML_bookmarkEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_MarkupRangeBookmark; break;
        case oox::NMSP_doc|oox::XML_bookmarkStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_Bookmark; break;
        case oox::NMSP_doc|oox::XML_commentRangeEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_MarkupRangeCommentEnd; break;
        case oox::NMSP_doc|oox::XML_commentRangeStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_MarkupRangeCommentStart; break;
        case oox::NMSP_doc|oox::XML_customXmlDelRangeEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_Markup; break;
        case oox::NMSP_doc|oox::XML_customXmlDelRangeStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_TrackChange; break;
        case oox::NMSP_doc|oox::XML_customXmlInsRangeEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_Markup; break;
        case oox::NMSP_doc|oox::XML_customXmlInsRangeStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_TrackChange; break;
        case oox::NMSP_doc|oox::XML_customXmlMoveFromRangeEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_Markup; break;
        case oox::NMSP_doc|oox::XML_customXmlMoveFromRangeStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_TrackChange; break;
        case oox::NMSP_doc|oox::XML_customXmlMoveToRangeEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_Markup; break;
        case oox::NMSP_doc|oox::XML_customXmlMoveToRangeStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_TrackChange; break;
        case oox::NMSP_doc|oox::XML_del: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_RunTrackChange; break;
        case oox::NMSP_doc|oox::XML_ins: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_RunTrackChange; break;
        case oox::NMSP_doc|oox::XML_moveFrom: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_RunTrackChange; break;
        case oox::NMSP_doc|oox::XML_moveFromRangeEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_MarkupRangeBookmark; break;
        case oox::NMSP_doc|oox::XML_moveFromRangeStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_MoveBookmark; break;
        case oox::NMSP_doc|oox::XML_moveTo: rOutResource = ResourceType::Stream; rOutElement = NN_wml|DEFINE_CT_RunTrackChange; break;
        case oox::NMSP_doc|oox::XML_moveToRangeEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_MarkupRangeBookmark; break;
        case oox::NMSP_doc|oox::XML_moveToRangeStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_MoveBookmark; break;
        case oox::NMSP_doc|oox::XML_permEnd: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_PermEnd; break;
        case oox::NMSP_doc|oox::XML_permStart: rOutResource = ResourceType::Properties; rOutElement = NN_wml|DEFINE_CT_PermStart; break;
        case oox::NMSP_officeMath|oox::XML_oMath: rOutResource = ResourceType::Math; rOutElement = NN_shared_math|DEFINE_CT_OMath; break;
        case oox::NMSP_officeMath|oox::XML_oMathPara: rOutResource = ResourceType::Stream; rOutElement = NN_shared_math|DEFINE_CT_OMathPara; break;
        case oox::NMSP_officeMath|oox::XML_r: rOutResource = ResourceType::Stream; rOutElement = NN_shared_math|DEFINE_CT_R; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_oMathPara:
        switch (nId)
        {
        case oox::NMSP_officeMath|oox::XML_oMathPara: rOutResource = ResourceType::Stream; rOutElement = NN_shared_math|DEFINE_CT_OMathPara; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_oMath:
        switch (nId)
        {
        case oox::NMSP_officeMath|oox::XML_oMath: rOutResource = ResourceType::Math; rOutElement = NN_shared_math|DEFINE_CT_OMath; break;
        default: return false;
        }
        return true;
    case NN_shared_math|DEFINE_oMathParaPr:
        switch (nId)
        {
        case oox::NMSP_officeMath|oox::XML_oMathParaPr: rOutResource = ResourceType::Properties; rOutElement = NN_shared_math|DEFINE_CT_OMathParaPr; break;
        default: return false;
        }
        return true;
    default:
        switch (nId)
        {
        /* start: oMathPara*/
        case oox::NMSP_officeMath|oox::XML_oMathPara: rOutResource = ResourceType::Stream; rOutElement = NN_shared_math|DEFINE_CT_OMathPara; break;
        /* start: oMath*/
        case oox::NMSP_officeMath|oox::XML_oMath: rOutResource = ResourceType::Math; rOutElement = NN_shared_math|DEFINE_CT_OMath; break;
        default: return false;
        }
        return true;
    }
}

void OOXMLFactory_shared_math::startAction(OOXMLFastContextHandler* pHandler)
{
    sal_uInt32 nDefine = pHandler->getDefine();
    switch (nDefine)
    {
    case NN_shared_math|DEFINE_CT_Integer255:
        pHandler->setDefaultIntegerValue();
        break;
    
    case NN_shared_math|DEFINE_CT_Integer2:
        pHandler->setDefaultIntegerValue();
        break;
    
    case NN_shared_math|DEFINE_CT_SpacingRule:
        pHandler->setDefaultIntegerValue();
        break;
    
    case NN_shared_math|DEFINE_CT_UnSignedInteger:
        pHandler->setDefaultIntegerValue();
        break;
    
    case NN_shared_math|DEFINE_CT_Char:
        pHandler->setDefaultStringValue();
        break;
    
    case NN_shared_math|DEFINE_CT_OnOff:
        pHandler->setDefaultBooleanValue();
        break;
    
    case NN_shared_math|DEFINE_CT_String:
        pHandler->setDefaultStringValue();
        break;
    
    case NN_shared_math|DEFINE_CT_TwipsMeasure:
        pHandler->setDefaultIntegerValue();
        break;

    default:
        break;
    }
}

void OOXMLFactory_shared_math::charactersAction(OOXMLFastContextHandler*, const OUString&)
{
}

Id OOXMLFactory_shared_math::getResourceId(Id nDefine, sal_Int32 nToken)
{
    (void) nDefine;
    (void) nToken;

    switch (nDefine)
    {
    case NN_shared_math|DEFINE_CT_Integer255:
        switch (nToken)
        {
        case oox::NMSP_officeMath|oox::XML_val: return NS_ooxml::LN_CT_Integer255_val;
        }
        break;
    case NN_shared_math|DEFINE_CT_Integer2:
        switch (nToken)
        {
        case oox::NMSP_officeMath|oox::XML_val: return NS_ooxml::LN_CT_Integer2_val;
        }
        break;
    case NN_shared_math|DEFINE_CT_SpacingRule:
        switch (nToken)
        {
        case oox::NMSP_officeMath|oox::XML_val: return NS_ooxml::LN_CT_SpacingRule_val;
        }
        break;
    case NN_shared_math|DEFINE_CT_UnSignedInteger:
        switch (nToken)
        {
        case oox::NMSP_officeMath|oox::XML_val: return NS_ooxml::LN_CT_UnSignedInteger_val;
        }
        break;
    case NN_shared_math|DEFINE_CT_Char:
        switch (nToken)
        {
        case oox::NMSP_officeMath|oox::XML_val: return NS_ooxml::LN_CT_Char_val;
        }
        break;
    case NN_shared_math|DEFINE_CT_OnOff:
        switch (nToken)
        {
        case oox::NMSP_officeMath|oox::XML_val: return NS_ooxml::LN_CT_OnOff_val;
        }
        break;
    case NN_shared_math|DEFINE_CT_String:
        switch (nToken)
        {
        case oox::NMSP_officeMath|oox::XML_val: return NS_ooxml::LN_CT_String_val;
        }
        break;
    case NN_shared_math|DEFINE_CT_XAlign:
        switch (nToken)
        {
        case oox::NMSP_officeMath|oox::XML_val: return NS_ooxml::LN_CT_XAlign_val;
        }
        break;
    case NN_shared_math|DEFINE_CT_YAlign:
        switch (nToken)
        {
        case oox::NMSP_officeMath|oox::XML_val: return NS_ooxml::LN_CT_YAlign_val;
        }
        break;
    case NN_shared_math|DEFINE_CT_Shp:
        switch (nToken)
        {
        case oox::NMSP_officeMath|oox::XML_val: return NS_ooxml::LN_CT_Shp_val;
        }
        break;
    case NN_shared_math|DEFINE_CT_FType:
        switch (nToken)
        {
        case oox::NMSP_officeMath|oox::XML_val: return NS_ooxml::LN_CT_FType_val;
        }
        break;
    case NN_shared_math|DEFINE_CT_LimLoc:
        switch (nToken)
        {
        case oox::NMSP_officeMath|oox::XML_val: return NS_ooxml::LN_CT_LimLoc_val;
        }
        break;
    case NN_shared_math|DEFINE_CT_TopBot:
        switch (nToken)
        {
        case oox::NMSP_officeMath|oox::XML_val: return NS_ooxml::LN_CT_TopBot_val;
        }
        break;
    case NN_shared_math|DEFINE_CT_Script:
        switch (nToken)
        {
        case oox::NMSP_officeMath|oox::XML_val: return NS_ooxml::LN_CT_Script_val;
        }
        break;
    case NN_shared_math|DEFINE_CT_Style:
        switch (nToken)
        {
        case oox::NMSP_officeMath|oox::XML_val: return NS_ooxml::LN_CT_Style_val;
        }
        break;
    case NN_shared_math|DEFINE_CT_R:
        switch (nToken)
        {
        case oox::NMSP_doc|oox::XML_annotationRef: return NS_ooxml::LN_EG_RunInnerContent_annotationRef;
        case oox::NMSP_doc|oox::XML_br: return NS_ooxml::LN_EG_RunInnerContent_br;
        case oox::NMSP_doc|oox::XML_commentReference: return NS_ooxml::LN_EG_RunInnerContent_commentReference;
        case oox::NMSP_doc|oox::XML_continuationSeparator: return NS_ooxml::LN_EG_RunInnerContent_continuationSeparator;
        case oox::NMSP_doc|oox::XML_cr: return NS_ooxml::LN_EG_RunInnerContent_cr;
        case oox::NMSP_doc|oox::XML_dayLong: return NS_ooxml::LN_EG_RunInnerContent_dayLong;
        case oox::NMSP_doc|oox::XML_dayShort: return NS_ooxml::LN_EG_RunInnerContent_dayShort;
        case oox::NMSP_doc|oox::XML_delInstrText: return NS_ooxml::LN_EG_RunInnerContent_delInstrText;
        case oox::NMSP_doc|oox::XML_delText: return NS_ooxml::LN_EG_RunInnerContent_delText;
        case oox::NMSP_doc|oox::XML_drawing: return NS_ooxml::LN_EG_RunInnerContent_drawing;
        case oox::NMSP_doc|oox::XML_endnoteRef: return NS_ooxml::LN_EG_RunInnerContent_endnoteRef;
        case oox::NMSP_doc|oox::XML_endnoteReference: return NS_ooxml::LN_EG_RunInnerContent_endnoteReference;
        case oox::NMSP_doc|oox::XML_fldChar: return NS_ooxml::LN_EG_RunInnerContent_fldChar;
        case oox::NMSP_doc|oox::XML_footnoteRef: return NS_ooxml::LN_EG_RunInnerContent_footnoteRef;
        case oox::NMSP_doc|oox::XML_footnoteReference: return NS_ooxml::LN_EG_RunInnerContent_footnoteReference;
        case oox::NMSP_doc|oox::XML_instrText: return NS_ooxml::LN_EG_RunInnerContent_instrText;
        case oox::NMSP_doc|oox::XML_lastRenderedPageBreak: return NS_ooxml::LN_EG_RunInnerContent_lastRenderedPageBreak;
        case oox::NMSP_doc|oox::XML_monthLong: return NS_ooxml::LN_EG_RunInnerContent_monthLong;
        case oox::NMSP_doc|oox::XML_monthShort: return NS_ooxml::LN_EG_RunInnerContent_monthShort;
        case oox::NMSP_doc|oox::XML_noBreakHyphen: return NS_ooxml::LN_EG_RunInnerContent_noBreakHyphen;
        case oox::NMSP_doc|oox::XML_object: return NS_ooxml::LN_EG_RunInnerContent_object;
        case oox::NMSP_doc|oox::XML_pgNum: return NS_ooxml::LN_EG_RunInnerContent_pgNum;
        case oox::NMSP_doc|oox::XML_pict: return NS_ooxml::LN_EG_RunInnerContent_pict;
        case oox::NMSP_doc|oox::XML_ptab: return NS_ooxml::LN_EG_RunInnerContent_ptab;
        case oox::NMSP_doc|oox::XML_r: return NS_ooxml::LN_EG_RunInnerContent_r;
        case oox::NMSP_doc|oox::XML_ruby: return NS_ooxml::LN_EG_RunInnerContent_ruby;
        case oox::NMSP_doc|oox::XML_separator: return NS_ooxml::LN_EG_RunInnerContent_separator;
        case oox::NMSP_doc|oox::XML_softHyphen: return NS_ooxml::LN_EG_RunInnerContent_softHyphen;
        case oox::NMSP_doc|oox::XML_sym: return NS_ooxml::LN_EG_RunInnerContent_sym;
        case oox::NMSP_doc|oox::XML_t: return NS_ooxml::LN_EG_RunInnerContent_t;
        case oox::NMSP_doc|oox::XML_tab: return NS_ooxml::LN_EG_RunInnerContent_tab;
        case oox::NMSP_doc|oox::XML_yearLong: return NS_ooxml::LN_EG_RunInnerContent_yearLong;
        case oox::NMSP_doc|oox::XML_yearShort: return NS_ooxml::LN_EG_RunInnerContent_yearShort;
        }
        break;
    case NN_shared_math|DEFINE_EG_OMathElements:
        switch (nToken)
        {
        case oox::NMSP_doc|oox::XML_bookmarkEnd: return NS_ooxml::LN_EG_RangeMarkupElements_bookmarkEnd;
        case oox::NMSP_doc|oox::XML_bookmarkStart: return NS_ooxml::LN_EG_RangeMarkupElements_bookmarkStart;
        case oox::NMSP_doc|oox::XML_commentRangeEnd: return NS_ooxml::LN_EG_RangeMarkupElements_commentRangeEnd;
        case oox::NMSP_doc|oox::XML_commentRangeStart: return NS_ooxml::LN_EG_RangeMarkupElements_commentRangeStart;
        case oox::NMSP_doc|oox::XML_customXmlDelRangeEnd: return NS_ooxml::LN_EG_RangeMarkupElements_customXmlDelRangeEnd;
        case oox::NMSP_doc|oox::XML_customXmlDelRangeStart: return NS_ooxml::LN_EG_RangeMarkupElements_customXmlDelRangeStart;
        case oox::NMSP_doc|oox::XML_customXmlInsRangeEnd: return NS_ooxml::LN_EG_RangeMarkupElements_customXmlInsRangeEnd;
        case oox::NMSP_doc|oox::XML_customXmlInsRangeStart: return NS_ooxml::LN_EG_RangeMarkupElements_customXmlInsRangeStart;
        case oox::NMSP_doc|oox::XML_customXmlMoveFromRangeEnd: return NS_ooxml::LN_EG_RangeMarkupElements_customXmlMoveFromRangeEnd;
        case oox::NMSP_doc|oox::XML_customXmlMoveFromRangeStart: return NS_ooxml::LN_EG_RangeMarkupElements_customXmlMoveFromRangeStart;
        case oox::NMSP_doc|oox::XML_customXmlMoveToRangeEnd: return NS_ooxml::LN_EG_RangeMarkupElements_customXmlMoveToRangeEnd;
        case oox::NMSP_doc|oox::XML_customXmlMoveToRangeStart: return NS_ooxml::LN_EG_RangeMarkupElements_customXmlMoveToRangeStart;
        case oox::NMSP_doc|oox::XML_del: return NS_ooxml::LN_EG_RunLevelElts_del;
        case oox::NMSP_doc|oox::XML_ins: return NS_ooxml::LN_EG_RunLevelElts_ins;
        case oox::NMSP_doc|oox::XML_moveFrom: return NS_ooxml::LN_EG_RunLevelElts_moveFrom;
        case oox::NMSP_doc|oox::XML_moveFromRangeEnd: return NS_ooxml::LN_EG_RangeMarkupElements_moveFromRangeEnd;
        case oox::NMSP_doc|oox::XML_moveFromRangeStart: return NS_ooxml::LN_EG_RangeMarkupElements_moveFromRangeStart;
        case oox::NMSP_doc|oox::XML_moveTo: return NS_ooxml::LN_EG_RunLevelElts_moveTo;
        case oox::NMSP_doc|oox::XML_moveToRangeEnd: return NS_ooxml::LN_EG_RangeMarkupElements_moveToRangeEnd;
        case oox::NMSP_doc|oox::XML_moveToRangeStart: return NS_ooxml::LN_EG_RangeMarkupElements_moveToRangeStart;
        case oox::NMSP_doc|oox::XML_permEnd: return NS_ooxml::LN_EG_RunLevelElts_permEnd;
        case oox::NMSP_doc|oox::XML_permStart: return NS_ooxml::LN_EG_RunLevelElts_permStart;
        case oox::NMSP_doc|oox::XML_proofErr: return NS_ooxml::LN_EG_RunLevelElts_proofErr;
        }
        break;
    case NN_shared_math|DEFINE_CT_OMathArg:
        switch (nToken)
        {
        case oox::NMSP_doc|oox::XML_bookmarkEnd: return NS_ooxml::LN_EG_RangeMarkupElements_bookmarkEnd;
        case oox::NMSP_doc|oox::XML_bookmarkStart: return NS_ooxml::LN_EG_RangeMarkupElements_bookmarkStart;
        case oox::NMSP_doc|oox::XML_commentRangeEnd: return NS_ooxml::LN_EG_RangeMarkupElements_commentRangeEnd;
        case oox::NMSP_doc|oox::XML_commentRangeStart: return NS_ooxml::LN_EG_RangeMarkupElements_commentRangeStart;
        case oox::NMSP_doc|oox::XML_customXmlDelRangeEnd: return NS_ooxml::LN_EG_RangeMarkupElements_customXmlDelRangeEnd;
        case oox::NMSP_doc|oox::XML_customXmlDelRangeStart: return NS_ooxml::LN_EG_RangeMarkupElements_customXmlDelRangeStart;
        case oox::NMSP_doc|oox::XML_customXmlInsRangeEnd: return NS_ooxml::LN_EG_RangeMarkupElements_customXmlInsRangeEnd;
        case oox::NMSP_doc|oox::XML_customXmlInsRangeStart: return NS_ooxml::LN_EG_RangeMarkupElements_customXmlInsRangeStart;
        case oox::NMSP_doc|oox::XML_customXmlMoveFromRangeEnd: return NS_ooxml::LN_EG_RangeMarkupElements_customXmlMoveFromRangeEnd;
        case oox::NMSP_doc|oox::XML_customXmlMoveFromRangeStart: return NS_ooxml::LN_EG_RangeMarkupElements_customXmlMoveFromRangeStart;
        case oox::NMSP_doc|oox::XML_customXmlMoveToRangeEnd: return NS_ooxml::LN_EG_RangeMarkupElements_customXmlMoveToRangeEnd;
        case oox::NMSP_doc|oox::XML_customXmlMoveToRangeStart: return NS_ooxml::LN_EG_RangeMarkupElements_customXmlMoveToRangeStart;
        case oox::NMSP_doc|oox::XML_del: return NS_ooxml::LN_EG_RunLevelElts_del;
        case oox::NMSP_doc|oox::XML_ins: return NS_ooxml::LN_EG_RunLevelElts_ins;
        case oox::NMSP_doc|oox::XML_moveFrom: return NS_ooxml::LN_EG_RunLevelElts_moveFrom;
        case oox::NMSP_doc|oox::XML_moveFromRangeEnd: return NS_ooxml::LN_EG_RangeMarkupElements_moveFromRangeEnd;
        case oox::NMSP_doc|oox::XML_moveFromRangeStart: return NS_ooxml::LN_EG_RangeMarkupElements_moveFromRangeStart;
        case oox::NMSP_doc|oox::XML_moveTo: return NS_ooxml::LN_EG_RunLevelElts_moveTo;
        case oox::NMSP_doc|oox::XML_moveToRangeEnd: return NS_ooxml::LN_EG_RangeMarkupElements_moveToRangeEnd;
        case oox::NMSP_doc|oox::XML_moveToRangeStart: return NS_ooxml::LN_EG_RangeMarkupElements_moveToRangeStart;
        case oox::NMSP_doc|oox::XML_permEnd: return NS_ooxml::LN_EG_RunLevelElts_permEnd;
        case oox::NMSP_doc|oox::XML_permStart: return NS_ooxml::LN_EG_RunLevelElts_permStart;
        case oox::NMSP_doc|oox::XML_proofErr: return NS_ooxml::LN_EG_RunLevelElts_proofErr;
        }
        break;
    case NN_shared_math|DEFINE_CT_OMathJc:
        switch (nToken)
        {
        case oox::NMSP_officeMath|oox::XML_val: return NS_ooxml::LN_CT_OMathJc_val;
        }
        break;
    case NN_shared_math|DEFINE_CT_TwipsMeasure:
        switch (nToken)
        {
        case oox::NMSP_officeMath|oox::XML_val: return NS_ooxml::LN_CT_TwipsMeasure_val;
        }
        break;
    case NN_shared_math|DEFINE_CT_BreakBin:
        switch (nToken)
        {
        case oox::NMSP_officeMath|oox::XML_val: return NS_ooxml::LN_CT_BreakBin_val;
        }
        break;
    case NN_shared_math|DEFINE_CT_BreakBinSub:
        switch (nToken)
        {
        case oox::NMSP_officeMath|oox::XML_val: return NS_ooxml::LN_CT_BreakBinSub_val;
        }
        break;
    case NN_shared_math|DEFINE_CT_OMath:
        switch (nToken)
        {
        case oox::NMSP_doc|oox::XML_bookmarkEnd: return NS_ooxml::LN_EG_RangeMarkupElements_bookmarkEnd;
        case oox::NMSP_doc|oox::XML_bookmarkStart: return NS_ooxml::LN_EG_RangeMarkupElements_bookmarkStart;
        case oox::NMSP_doc|oox::XML_commentRangeEnd: return NS_ooxml::LN_EG_RangeMarkupElements_commentRangeEnd;
        case oox::NMSP_doc|oox::XML_commentRangeStart: return NS_ooxml::LN_EG_RangeMarkupElements_commentRangeStart;
        case oox::NMSP_doc|oox::XML_customXmlDelRangeEnd: return NS_ooxml::LN_EG_RangeMarkupElements_customXmlDelRangeEnd;
        case oox::NMSP_doc|oox::XML_customXmlDelRangeStart: return NS_ooxml::LN_EG_RangeMarkupElements_customXmlDelRangeStart;
        case oox::NMSP_doc|oox::XML_customXmlInsRangeEnd: return NS_ooxml::LN_EG_RangeMarkupElements_customXmlInsRangeEnd;
        case oox::NMSP_doc|oox::XML_customXmlInsRangeStart: return NS_ooxml::LN_EG_RangeMarkupElements_customXmlInsRangeStart;
        case oox::NMSP_doc|oox::XML_customXmlMoveFromRangeEnd: return NS_ooxml::LN_EG_RangeMarkupElements_customXmlMoveFromRangeEnd;
        case oox::NMSP_doc|oox::XML_customXmlMoveFromRangeStart: return NS_ooxml::LN_EG_RangeMarkupElements_customXmlMoveFromRangeStart;
        case oox::NMSP_doc|oox::XML_customXmlMoveToRangeEnd: return NS_ooxml::LN_EG_RangeMarkupElements_customXmlMoveToRangeEnd;
        case oox::NMSP_doc|oox::XML_customXmlMoveToRangeStart: return NS_ooxml::LN_EG_RangeMarkupElements_customXmlMoveToRangeStart;
        case oox::NMSP_doc|oox::XML_del: return NS_ooxml::LN_EG_RunLevelElts_del;
        case oox::NMSP_doc|oox::XML_ins: return NS_ooxml::LN_EG_RunLevelElts_ins;
        case oox::NMSP_doc|oox::XML_moveFrom: return NS_ooxml::LN_EG_RunLevelElts_moveFrom;
        case oox::NMSP_doc|oox::XML_moveFromRangeEnd: return NS_ooxml::LN_EG_RangeMarkupElements_moveFromRangeEnd;
        case oox::NMSP_doc|oox::XML_moveFromRangeStart: return NS_ooxml::LN_EG_RangeMarkupElements_moveFromRangeStart;
        case oox::NMSP_doc|oox::XML_moveTo: return NS_ooxml::LN_EG_RunLevelElts_moveTo;
        case oox::NMSP_doc|oox::XML_moveToRangeEnd: return NS_ooxml::LN_EG_RangeMarkupElements_moveToRangeEnd;
        case oox::NMSP_doc|oox::XML_moveToRangeStart: return NS_ooxml::LN_EG_RangeMarkupElements_moveToRangeStart;
        case oox::NMSP_doc|oox::XML_permEnd: return NS_ooxml::LN_EG_RunLevelElts_permEnd;
        case oox::NMSP_doc|oox::XML_permStart: return NS_ooxml::LN_EG_RunLevelElts_permStart;
        case oox::NMSP_doc|oox::XML_proofErr: return NS_ooxml::LN_EG_RunLevelElts_proofErr;
        }
        break;
    default:
        switch (nToken)
        {
        }
        break;
    }
    return 0;
}

void OOXMLFactory_shared_math::attributeAction(OOXMLFastContextHandler* _pHandler, Token_t nToken, const OOXMLValue& pValue)
{
    switch (_pHandler->getDefine())
    {
    case NN_shared_math|DEFINE_CT_Integer255:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::NMSP_officeMath|oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    case NN_shared_math|DEFINE_CT_Integer2:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::NMSP_officeMath|oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    case NN_shared_math|DEFINE_CT_SpacingRule:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::NMSP_officeMath|oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    case NN_shared_math|DEFINE_CT_UnSignedInteger:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::NMSP_officeMath|oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    case NN_shared_math|DEFINE_CT_Char:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::NMSP_officeMath|oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    case NN_shared_math|DEFINE_CT_OnOff:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::NMSP_officeMath|oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    case NN_shared_math|DEFINE_CT_String:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::NMSP_officeMath|oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    case NN_shared_math|DEFINE_CT_XAlign:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::NMSP_officeMath|oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    case NN_shared_math|DEFINE_CT_YAlign:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::NMSP_officeMath|oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    case NN_shared_math|DEFINE_CT_Shp:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::NMSP_officeMath|oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    case NN_shared_math|DEFINE_CT_FType:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::NMSP_officeMath|oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    case NN_shared_math|DEFINE_CT_LimLoc:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::NMSP_officeMath|oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    case NN_shared_math|DEFINE_CT_TopBot:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::NMSP_officeMath|oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    case NN_shared_math|DEFINE_CT_Script:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::NMSP_officeMath|oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    case NN_shared_math|DEFINE_CT_Style:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::NMSP_officeMath|oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    case NN_shared_math|DEFINE_CT_OMathJc:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::NMSP_officeMath|oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    case NN_shared_math|DEFINE_CT_TwipsMeasure:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::NMSP_officeMath|oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    case NN_shared_math|DEFINE_CT_BreakBin:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::NMSP_officeMath|oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    case NN_shared_math|DEFINE_CT_BreakBinSub:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::NMSP_officeMath|oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    default:
        break;
    }
}

/// @endcond
}}
