#ifndef INCLUDED_OFFICECFG_OFFICE_LINGUISTIC_HXX
#define INCLUDED_OFFICECFG_OFFICE_LINGUISTIC_HXX

#include "sal/config.h"

#include <optional>
#include "com/sun/star/uno/Sequence.hxx"
#include "rtl/ustring.h"
#include "rtl/ustring.hxx"
#include "sal/types.h"
#include "comphelper/configuration.hxx"

namespace officecfg { namespace Office { namespace Linguistic {

struct Images: public comphelper::ConfigurationGroup< Images> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/Images"_ustr); return PATH; }

struct ServiceNameEntries: public comphelper::ConfigurationSet< ServiceNameEntries> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/Images/ServiceNameEntries"_ustr); return PATH; }
private:
    ServiceNameEntries(); // not defined
    ~ServiceNameEntries(); // not defined
};

struct VendorImages: public comphelper::ConfigurationSet< VendorImages> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/Images/VendorImages"_ustr); return PATH; }
private:
    VendorImages(); // not defined
    ~VendorImages(); // not defined
};

private:
    Images(); // not defined
    ~Images(); // not defined
};

struct General: public comphelper::ConfigurationGroup< General> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/General"_ustr); return PATH; }

struct UILocale: public comphelper::ConfigurationProperty<UILocale, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/General/UILocale"_ustr); return PATH; }
private:
    UILocale(); // not defined
    ~UILocale(); // not defined
};

struct IsIgnoreControlCharacters: public comphelper::ConfigurationProperty<IsIgnoreControlCharacters, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/General/IsIgnoreControlCharacters"_ustr); return PATH; }
private:
    IsIgnoreControlCharacters(); // not defined
    ~IsIgnoreControlCharacters(); // not defined
};

struct DefaultLocale: public comphelper::ConfigurationProperty<DefaultLocale, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/General/DefaultLocale"_ustr); return PATH; }
private:
    DefaultLocale(); // not defined
    ~DefaultLocale(); // not defined
};

struct DefaultLocale_CJK: public comphelper::ConfigurationProperty<DefaultLocale_CJK, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/General/DefaultLocale_CJK"_ustr); return PATH; }
private:
    DefaultLocale_CJK(); // not defined
    ~DefaultLocale_CJK(); // not defined
};

struct DefaultLocale_CTL: public comphelper::ConfigurationProperty<DefaultLocale_CTL, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/General/DefaultLocale_CTL"_ustr); return PATH; }
private:
    DefaultLocale_CTL(); // not defined
    ~DefaultLocale_CTL(); // not defined
};

struct DictionaryList: public comphelper::ConfigurationGroup< DictionaryList> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/General/DictionaryList"_ustr); return PATH; }

struct ActiveDictionaries: public comphelper::ConfigurationProperty<ActiveDictionaries, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/General/DictionaryList/ActiveDictionaries"_ustr); return PATH; }
private:
    ActiveDictionaries(); // not defined
    ~ActiveDictionaries(); // not defined
};

struct IsUseDictionaryList: public comphelper::ConfigurationProperty<IsUseDictionaryList, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/General/DictionaryList/IsUseDictionaryList"_ustr); return PATH; }
private:
    IsUseDictionaryList(); // not defined
    ~IsUseDictionaryList(); // not defined
};

private:
    DictionaryList(); // not defined
    ~DictionaryList(); // not defined
};

private:
    General(); // not defined
    ~General(); // not defined
};

struct TextConversion: public comphelper::ConfigurationGroup< TextConversion> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/TextConversion"_ustr); return PATH; }

struct ActiveConversionDictionaries: public comphelper::ConfigurationProperty<ActiveConversionDictionaries, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/TextConversion/ActiveConversionDictionaries"_ustr); return PATH; }
private:
    ActiveConversionDictionaries(); // not defined
    ~ActiveConversionDictionaries(); // not defined
};

struct IsIgnorePostPositionalWord: public comphelper::ConfigurationProperty<IsIgnorePostPositionalWord, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/TextConversion/IsIgnorePostPositionalWord"_ustr); return PATH; }
private:
    IsIgnorePostPositionalWord(); // not defined
    ~IsIgnorePostPositionalWord(); // not defined
};

struct IsAutoCloseDialog: public comphelper::ConfigurationProperty<IsAutoCloseDialog, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/TextConversion/IsAutoCloseDialog"_ustr); return PATH; }
private:
    IsAutoCloseDialog(); // not defined
    ~IsAutoCloseDialog(); // not defined
};

struct IsShowEntriesRecentlyUsedFirst: public comphelper::ConfigurationProperty<IsShowEntriesRecentlyUsedFirst, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/TextConversion/IsShowEntriesRecentlyUsedFirst"_ustr); return PATH; }
private:
    IsShowEntriesRecentlyUsedFirst(); // not defined
    ~IsShowEntriesRecentlyUsedFirst(); // not defined
};

struct IsAutoReplaceUniqueEntries: public comphelper::ConfigurationProperty<IsAutoReplaceUniqueEntries, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/TextConversion/IsAutoReplaceUniqueEntries"_ustr); return PATH; }
private:
    IsAutoReplaceUniqueEntries(); // not defined
    ~IsAutoReplaceUniqueEntries(); // not defined
};

struct IsDirectionToSimplified: public comphelper::ConfigurationProperty<IsDirectionToSimplified, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/TextConversion/IsDirectionToSimplified"_ustr); return PATH; }
private:
    IsDirectionToSimplified(); // not defined
    ~IsDirectionToSimplified(); // not defined
};

struct IsUseCharacterVariants: public comphelper::ConfigurationProperty<IsUseCharacterVariants, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/TextConversion/IsUseCharacterVariants"_ustr); return PATH; }
private:
    IsUseCharacterVariants(); // not defined
    ~IsUseCharacterVariants(); // not defined
};

struct IsTranslateCommonTerms: public comphelper::ConfigurationProperty<IsTranslateCommonTerms, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/TextConversion/IsTranslateCommonTerms"_ustr); return PATH; }
private:
    IsTranslateCommonTerms(); // not defined
    ~IsTranslateCommonTerms(); // not defined
};

struct IsReverseMapping: public comphelper::ConfigurationProperty<IsReverseMapping, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/TextConversion/IsReverseMapping"_ustr); return PATH; }
private:
    IsReverseMapping(); // not defined
    ~IsReverseMapping(); // not defined
};

private:
    TextConversion(); // not defined
    ~TextConversion(); // not defined
};

struct SpellChecking: public comphelper::ConfigurationGroup< SpellChecking> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/SpellChecking"_ustr); return PATH; }

struct IsSpellUpperCase: public comphelper::ConfigurationProperty<IsSpellUpperCase, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/SpellChecking/IsSpellUpperCase"_ustr); return PATH; }
private:
    IsSpellUpperCase(); // not defined
    ~IsSpellUpperCase(); // not defined
};

struct IsSpellWithDigits: public comphelper::ConfigurationProperty<IsSpellWithDigits, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/SpellChecking/IsSpellWithDigits"_ustr); return PATH; }
private:
    IsSpellWithDigits(); // not defined
    ~IsSpellWithDigits(); // not defined
};

struct IsSpellAuto: public comphelper::ConfigurationProperty<IsSpellAuto, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/SpellChecking/IsSpellAuto"_ustr); return PATH; }
private:
    IsSpellAuto(); // not defined
    ~IsSpellAuto(); // not defined
};

struct IsSpellSpecial: public comphelper::ConfigurationProperty<IsSpellSpecial, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/SpellChecking/IsSpellSpecial"_ustr); return PATH; }
private:
    IsSpellSpecial(); // not defined
    ~IsSpellSpecial(); // not defined
};

struct IsSpellClosedCompound: public comphelper::ConfigurationProperty<IsSpellClosedCompound, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/SpellChecking/IsSpellClosedCompound"_ustr); return PATH; }
private:
    IsSpellClosedCompound(); // not defined
    ~IsSpellClosedCompound(); // not defined
};

struct IsSpellHyphenatedCompound: public comphelper::ConfigurationProperty<IsSpellHyphenatedCompound, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/SpellChecking/IsSpellHyphenatedCompound"_ustr); return PATH; }
private:
    IsSpellHyphenatedCompound(); // not defined
    ~IsSpellHyphenatedCompound(); // not defined
};

struct IsReverseDirection: public comphelper::ConfigurationProperty<IsReverseDirection, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/SpellChecking/IsReverseDirection"_ustr); return PATH; }
private:
    IsReverseDirection(); // not defined
    ~IsReverseDirection(); // not defined
};

private:
    SpellChecking(); // not defined
    ~SpellChecking(); // not defined
};

struct GrammarChecking: public comphelper::ConfigurationGroup< GrammarChecking> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/GrammarChecking"_ustr); return PATH; }

struct IsAutoCheck: public comphelper::ConfigurationProperty<IsAutoCheck, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/GrammarChecking/IsAutoCheck"_ustr); return PATH; }
private:
    IsAutoCheck(); // not defined
    ~IsAutoCheck(); // not defined
};

struct IsInteractiveCheck: public comphelper::ConfigurationProperty<IsInteractiveCheck, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/GrammarChecking/IsInteractiveCheck"_ustr); return PATH; }
private:
    IsInteractiveCheck(); // not defined
    ~IsInteractiveCheck(); // not defined
};

struct LanguageTool: public comphelper::ConfigurationGroup< LanguageTool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/GrammarChecking/LanguageTool"_ustr); return PATH; }

struct BaseURL: public comphelper::ConfigurationProperty<BaseURL, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/GrammarChecking/LanguageTool/BaseURL"_ustr); return PATH; }
private:
    BaseURL(); // not defined
    ~BaseURL(); // not defined
};

struct Username: public comphelper::ConfigurationProperty<Username, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/GrammarChecking/LanguageTool/Username"_ustr); return PATH; }
private:
    Username(); // not defined
    ~Username(); // not defined
};

struct ApiKey: public comphelper::ConfigurationProperty<ApiKey, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/GrammarChecking/LanguageTool/ApiKey"_ustr); return PATH; }
private:
    ApiKey(); // not defined
    ~ApiKey(); // not defined
};

struct IsEnabled: public comphelper::ConfigurationProperty<IsEnabled, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/GrammarChecking/LanguageTool/IsEnabled"_ustr); return PATH; }
private:
    IsEnabled(); // not defined
    ~IsEnabled(); // not defined
};

struct SSLCertVerify: public comphelper::ConfigurationProperty<SSLCertVerify, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/GrammarChecking/LanguageTool/SSLCertVerify"_ustr); return PATH; }
private:
    SSLCertVerify(); // not defined
    ~SSLCertVerify(); // not defined
};

struct RestProtocol: public comphelper::ConfigurationProperty<RestProtocol, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/GrammarChecking/LanguageTool/RestProtocol"_ustr); return PATH; }
private:
    RestProtocol(); // not defined
    ~RestProtocol(); // not defined
};

private:
    LanguageTool(); // not defined
    ~LanguageTool(); // not defined
};

private:
    GrammarChecking(); // not defined
    ~GrammarChecking(); // not defined
};

struct Translation: public comphelper::ConfigurationGroup< Translation> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/Translation"_ustr); return PATH; }

struct Deepl: public comphelper::ConfigurationGroup< Deepl> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/Translation/Deepl"_ustr); return PATH; }

struct ApiURL: public comphelper::ConfigurationProperty<ApiURL, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/Translation/Deepl/ApiURL"_ustr); return PATH; }
private:
    ApiURL(); // not defined
    ~ApiURL(); // not defined
};

struct AuthKey: public comphelper::ConfigurationProperty<AuthKey, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/Translation/Deepl/AuthKey"_ustr); return PATH; }
private:
    AuthKey(); // not defined
    ~AuthKey(); // not defined
};

private:
    Deepl(); // not defined
    ~Deepl(); // not defined
};

private:
    Translation(); // not defined
    ~Translation(); // not defined
};

struct Hyphenation: public comphelper::ConfigurationGroup< Hyphenation> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/Hyphenation"_ustr); return PATH; }

struct MinLeading: public comphelper::ConfigurationProperty<MinLeading, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/Hyphenation/MinLeading"_ustr); return PATH; }
private:
    MinLeading(); // not defined
    ~MinLeading(); // not defined
};

struct MinTrailing: public comphelper::ConfigurationProperty<MinTrailing, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/Hyphenation/MinTrailing"_ustr); return PATH; }
private:
    MinTrailing(); // not defined
    ~MinTrailing(); // not defined
};

struct MinWordLength: public comphelper::ConfigurationProperty<MinWordLength, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/Hyphenation/MinWordLength"_ustr); return PATH; }
private:
    MinWordLength(); // not defined
    ~MinWordLength(); // not defined
};

struct IsHyphSpecial: public comphelper::ConfigurationProperty<IsHyphSpecial, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/Hyphenation/IsHyphSpecial"_ustr); return PATH; }
private:
    IsHyphSpecial(); // not defined
    ~IsHyphSpecial(); // not defined
};

struct IsHyphAuto: public comphelper::ConfigurationProperty<IsHyphAuto, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/Hyphenation/IsHyphAuto"_ustr); return PATH; }
private:
    IsHyphAuto(); // not defined
    ~IsHyphAuto(); // not defined
};

private:
    Hyphenation(); // not defined
    ~Hyphenation(); // not defined
};

struct ServiceManager: public comphelper::ConfigurationGroup< ServiceManager> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/ServiceManager"_ustr); return PATH; }

struct Dictionaries: public comphelper::ConfigurationSet< Dictionaries> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/ServiceManager/Dictionaries"_ustr); return PATH; }
private:
    Dictionaries(); // not defined
    ~Dictionaries(); // not defined
};

struct SpellCheckers: public comphelper::ConfigurationSet< SpellCheckers> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/ServiceManager/SpellCheckers"_ustr); return PATH; }
private:
    SpellCheckers(); // not defined
    ~SpellCheckers(); // not defined
};

struct Hyphenators: public comphelper::ConfigurationSet< Hyphenators> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/ServiceManager/Hyphenators"_ustr); return PATH; }
private:
    Hyphenators(); // not defined
    ~Hyphenators(); // not defined
};

struct Thesauri: public comphelper::ConfigurationSet< Thesauri> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/ServiceManager/Thesauri"_ustr); return PATH; }
private:
    Thesauri(); // not defined
    ~Thesauri(); // not defined
};

struct DisabledDictionaries: public comphelper::ConfigurationProperty<DisabledDictionaries, std::optional<com::sun::star::uno::Sequence<OUString> > > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/ServiceManager/DisabledDictionaries"_ustr); return PATH; }
private:
    DisabledDictionaries(); // not defined
    ~DisabledDictionaries(); // not defined
};

struct GrammarCheckers: public comphelper::ConfigurationSet< GrammarCheckers> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/ServiceManager/GrammarCheckers"_ustr); return PATH; }
private:
    GrammarCheckers(); // not defined
    ~GrammarCheckers(); // not defined
};

struct DataFilesChangedCheckValue: public comphelper::ConfigurationProperty<DataFilesChangedCheckValue, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Linguistic/ServiceManager/DataFilesChangedCheckValue"_ustr); return PATH; }
private:
    DataFilesChangedCheckValue(); // not defined
    ~DataFilesChangedCheckValue(); // not defined
};

private:
    ServiceManager(); // not defined
    ~ServiceManager(); // not defined
};

} } }

#endif
