#ifndef INCLUDED_OFFICECFG_OFFICE_SECURITY_HXX
#define INCLUDED_OFFICECFG_OFFICE_SECURITY_HXX

#include "sal/config.h"

#include <optional>
#include "rtl/ustring.h"
#include "rtl/ustring.hxx"
#include "sal/types.h"
#include "comphelper/configuration.hxx"

namespace officecfg { namespace Office { namespace Security {

struct Hyperlinks: public comphelper::ConfigurationGroup< Hyperlinks> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Security/Hyperlinks"_ustr); return PATH; }

struct Open: public comphelper::ConfigurationProperty<Open, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Security/Hyperlinks/Open"_ustr); return PATH; }
private:
    Open(); // not defined
    ~Open(); // not defined
};

private:
    Hyperlinks(); // not defined
    ~Hyperlinks(); // not defined
};

struct HiddenContent: public comphelper::ConfigurationGroup< HiddenContent> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Security/HiddenContent"_ustr); return PATH; }

struct RemoveHiddenContent: public comphelper::ConfigurationProperty<RemoveHiddenContent, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Security/HiddenContent/RemoveHiddenContent"_ustr); return PATH; }
private:
    RemoveHiddenContent(); // not defined
    ~RemoveHiddenContent(); // not defined
};

private:
    HiddenContent(); // not defined
    ~HiddenContent(); // not defined
};

struct Net: public comphelper::ConfigurationGroup< Net> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Security/Net"_ustr); return PATH; }

struct AllowInsecureImpressRemoteWiFi: public comphelper::ConfigurationProperty<AllowInsecureImpressRemoteWiFi, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Security/Net/AllowInsecureImpressRemoteWiFi"_ustr); return PATH; }
private:
    AllowInsecureImpressRemoteWiFi(); // not defined
    ~AllowInsecureImpressRemoteWiFi(); // not defined
};

struct AllowInsecureProtocols: public comphelper::ConfigurationProperty<AllowInsecureProtocols, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Security/Net/AllowInsecureProtocols"_ustr); return PATH; }
private:
    AllowInsecureProtocols(); // not defined
    ~AllowInsecureProtocols(); // not defined
};

struct AllowInsecureUNORemoteProtocol: public comphelper::ConfigurationProperty<AllowInsecureUNORemoteProtocol, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Security/Net/AllowInsecureUNORemoteProtocol"_ustr); return PATH; }
private:
    AllowInsecureUNORemoteProtocol(); // not defined
    ~AllowInsecureUNORemoteProtocol(); // not defined
};

private:
    Net(); // not defined
    ~Net(); // not defined
};

} } }

#endif
