#include "nv_push_cla16f.h"

#include <stdio.h>





const char *P_PARSE_NVA06F_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVA06F_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                                   const char *prefix) ATTRIBUTE_COLD;

const char*
P_PARSE_NVA16F_MTHD(uint16_t idx)
{
    switch (idx) {

  
    default:

    return P_PARSE_NVA06F_MTHD(idx);

                            case NVA16F_SEMAPHORED:
        return "NVA16F_SEMAPHORED";
                        case NVA16F_WFI:
        return "NVA16F_WFI";
        
    }
}

void
P_DUMP_NVA16F_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {

  
    default:

    P_DUMP_NVA06F_MTHD_DATA(fp, idx, data, prefix);
    break;

                          
    case NVA16F_SEMAPHORED:

    
        parsed = (data >> 0) & ((1u << 5) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVA16F_SEMAPHORED_OPERATION_ACQUIRE:
            fprintf(fp, "ACQUIRE\n");
            break;
        case NVA16F_SEMAPHORED_OPERATION_RELEASE:
            fprintf(fp, "RELEASE\n");
            break;
        case NVA16F_SEMAPHORED_OPERATION_ACQ_GEQ:
            fprintf(fp, "ACQ_GEQ\n");
            break;
        case NVA16F_SEMAPHORED_OPERATION_ACQ_AND:
            fprintf(fp, "ACQ_AND\n");
            break;
        case NVA16F_SEMAPHORED_OPERATION_REDUCTION:
            fprintf(fp, "REDUCTION\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.ACQUIRE_SWITCH = ", prefix);
        switch (parsed) {
        case NVA16F_SEMAPHORED_ACQUIRE_SWITCH_DISABLED:
            fprintf(fp, "DISABLED\n");
            break;
        case NVA16F_SEMAPHORED_ACQUIRE_SWITCH_ENABLED:
            fprintf(fp, "ENABLED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 1) - 1);
        fprintf(fp, "%s.RELEASE_WFI = ", prefix);
        switch (parsed) {
        case NVA16F_SEMAPHORED_RELEASE_WFI_EN:
            fprintf(fp, "EN\n");
            break;
        case NVA16F_SEMAPHORED_RELEASE_WFI_DIS:
            fprintf(fp, "DIS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 24) & ((1u << 1) - 1);
        fprintf(fp, "%s.RELEASE_SIZE = ", prefix);
        switch (parsed) {
        case NVA16F_SEMAPHORED_RELEASE_SIZE_16BYTE:
            fprintf(fp, "16BYTE\n");
            break;
        case NVA16F_SEMAPHORED_RELEASE_SIZE_4BYTE:
            fprintf(fp, "4BYTE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 27) & ((1u << 4) - 1);
        fprintf(fp, "%s.REDUCTION = ", prefix);
        switch (parsed) {
        case NVA16F_SEMAPHORED_REDUCTION_MIN:
            fprintf(fp, "MIN\n");
            break;
        case NVA16F_SEMAPHORED_REDUCTION_MAX:
            fprintf(fp, "MAX\n");
            break;
        case NVA16F_SEMAPHORED_REDUCTION_XOR:
            fprintf(fp, "XOR\n");
            break;
        case NVA16F_SEMAPHORED_REDUCTION_AND:
            fprintf(fp, "AND\n");
            break;
        case NVA16F_SEMAPHORED_REDUCTION_OR:
            fprintf(fp, "OR\n");
            break;
        case NVA16F_SEMAPHORED_REDUCTION_ADD:
            fprintf(fp, "ADD\n");
            break;
        case NVA16F_SEMAPHORED_REDUCTION_INC:
            fprintf(fp, "INC\n");
            break;
        case NVA16F_SEMAPHORED_REDUCTION_DEC:
            fprintf(fp, "DEC\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 31) & ((1u << 1) - 1);
        fprintf(fp, "%s.FORMAT = ", prefix);
        switch (parsed) {
        case NVA16F_SEMAPHORED_FORMAT_SIGNED:
            fprintf(fp, "SIGNED\n");
            break;
        case NVA16F_SEMAPHORED_FORMAT_UNSIGNED:
            fprintf(fp, "UNSIGNED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                      
    case NVA16F_WFI:

    
        parsed = data;
        fprintf(fp, "%s.HANDLE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
            }
}
