// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "src/node/inspector/protocol/Target.h"

#include "src/node/inspector/protocol/Protocol.h"

#include "crdtp/cbor.h"
#include "crdtp/find_by_first.h"
#include "crdtp/span.h"

namespace node {
namespace inspector {
namespace protocol {
namespace Target {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Target";
const char Metainfo::commandPrefix[] = "Target.";
const char Metainfo::version[] = "1.0";



CRDTP_BEGIN_DESERIALIZER(TargetInfo)
    CRDTP_DESERIALIZE_FIELD("attached", m_attached),
    CRDTP_DESERIALIZE_FIELD("canAccessOpener", m_canAccessOpener),
    CRDTP_DESERIALIZE_FIELD("targetId", m_targetId),
    CRDTP_DESERIALIZE_FIELD("title", m_title),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(TargetInfo)
    CRDTP_SERIALIZE_FIELD("targetId", m_targetId);
    CRDTP_SERIALIZE_FIELD("type", m_type);
    CRDTP_SERIALIZE_FIELD("title", m_title);
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("attached", m_attached);
    CRDTP_SERIALIZE_FIELD("canAccessOpener", m_canAccessOpener);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::targetCreated(std::unique_ptr<protocol::Target::TargetInfo> targetInfo)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("targetInfo"), targetInfo);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Target.targetCreated", serializer.Finish()));
}

void Frontend::attachedToTarget(const String& sessionId, std::unique_ptr<protocol::Target::TargetInfo> targetInfo, bool waitingForDebugger)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("sessionId"), sessionId);
    serializer.AddField(crdtp::MakeSpan("targetInfo"), targetInfo);
    serializer.AddField(crdtp::MakeSpan("waitingForDebugger"), waitingForDebugger);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Target.attachedToTarget", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void setAutoAttach(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("setAutoAttach"),
          &DomainDispatcherImpl::setAutoAttach
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {

struct setAutoAttachParams : public crdtp::DeserializableProtocolObject<setAutoAttachParams> {
    bool autoAttach;
    bool waitForDebuggerOnStart;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setAutoAttachParams)
    CRDTP_DESERIALIZE_FIELD("autoAttach", autoAttach),
    CRDTP_DESERIALIZE_FIELD("waitForDebuggerOnStart", waitForDebuggerOnStart),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setAutoAttach(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setAutoAttachParams params;
    if (!setAutoAttachParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setAutoAttach(params.autoAttach, params.waitForDebuggerOnStart);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Target.setAutoAttach"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Target"), SortedRedirects(), std::move(dispatcher));
}

} // Target
} // namespace node
} // namespace inspector
} // namespace protocol
