// python wrapper for vtkCPDataDescription
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkCPDataDescription.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkCPDataDescription(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkCPDataDescription_ClassNew(); }


static PyObject *
PyvtkCPDataDescription_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkCPDataDescription::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPDataDescription_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPDataDescription *op = static_cast<vtkCPDataDescription *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkCPDataDescription::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPDataDescription_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkCPDataDescription *tempr = vtkCPDataDescription::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPDataDescription_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPDataDescription *op = static_cast<vtkCPDataDescription *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkCPDataDescription *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkCPDataDescription::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPDataDescription_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkCPDataDescription::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPDataDescription_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPDataDescription *op = static_cast<vtkCPDataDescription *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkCPDataDescription::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPDataDescription_SetTimeData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTimeData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPDataDescription *op = static_cast<vtkCPDataDescription *>(vp);

  double temp0;
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetTimeData(temp0, temp1);
    }
    else
    {
      op->vtkCPDataDescription::SetTimeData(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPDataDescription_GetTimeStep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeStep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPDataDescription *op = static_cast<vtkCPDataDescription *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetTimeStep() :
      op->vtkCPDataDescription::GetTimeStep());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPDataDescription_GetTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPDataDescription *op = static_cast<vtkCPDataDescription *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetTime() :
      op->vtkCPDataDescription::GetTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPDataDescription_SetForceOutput(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForceOutput");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPDataDescription *op = static_cast<vtkCPDataDescription *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForceOutput(temp0);
    }
    else
    {
      op->vtkCPDataDescription::SetForceOutput(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPDataDescription_ForceOutputOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ForceOutputOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPDataDescription *op = static_cast<vtkCPDataDescription *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ForceOutputOn();
    }
    else
    {
      op->vtkCPDataDescription::ForceOutputOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPDataDescription_ForceOutputOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ForceOutputOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPDataDescription *op = static_cast<vtkCPDataDescription *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ForceOutputOff();
    }
    else
    {
      op->vtkCPDataDescription::ForceOutputOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPDataDescription_GetForceOutput(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceOutput");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPDataDescription *op = static_cast<vtkCPDataDescription *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetForceOutput() :
      op->vtkCPDataDescription::GetForceOutput());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPDataDescription_AddInput(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddInput");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPDataDescription *op = static_cast<vtkCPDataDescription *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->AddInput(temp0);
    }
    else
    {
      op->vtkCPDataDescription::AddInput(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPDataDescription_GetNumberOfInputDescriptions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfInputDescriptions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPDataDescription *op = static_cast<vtkCPDataDescription *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNumberOfInputDescriptions() :
      op->vtkCPDataDescription::GetNumberOfInputDescriptions());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPDataDescription_ResetInputDescriptions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetInputDescriptions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPDataDescription *op = static_cast<vtkCPDataDescription *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ResetInputDescriptions();
    }
    else
    {
      op->vtkCPDataDescription::ResetInputDescriptions();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPDataDescription_ResetAll(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetAll");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPDataDescription *op = static_cast<vtkCPDataDescription *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ResetAll();
    }
    else
    {
      op->vtkCPDataDescription::ResetAll();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPDataDescription_GetInputDescription(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInputDescription");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPDataDescription *op = static_cast<vtkCPDataDescription *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkCPInputDataDescription *tempr = (ap.IsBound() ?
      op->GetInputDescription(temp0) :
      op->vtkCPDataDescription::GetInputDescription(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPDataDescription_GetInputDescriptionName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInputDescriptionName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPDataDescription *op = static_cast<vtkCPDataDescription *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetInputDescriptionName(temp0) :
      op->vtkCPDataDescription::GetInputDescriptionName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPDataDescription_GetInputDescriptionByName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInputDescriptionByName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPDataDescription *op = static_cast<vtkCPDataDescription *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkCPInputDataDescription *tempr = (ap.IsBound() ?
      op->GetInputDescriptionByName(temp0) :
      op->vtkCPDataDescription::GetInputDescriptionByName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPDataDescription_GetIfGridIsNecessary(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIfGridIsNecessary");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPDataDescription *op = static_cast<vtkCPDataDescription *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetIfGridIsNecessary(temp0) :
      op->vtkCPDataDescription::GetIfGridIsNecessary(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPDataDescription_GetIfAnyGridNecessary(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIfAnyGridNecessary");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPDataDescription *op = static_cast<vtkCPDataDescription *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetIfAnyGridNecessary() :
      op->vtkCPDataDescription::GetIfAnyGridNecessary());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPDataDescription_SetUserData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUserData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPDataDescription *op = static_cast<vtkCPDataDescription *>(vp);

  vtkFieldData *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkFieldData"))
  {
    if (ap.IsBound())
    {
      op->SetUserData(temp0);
    }
    else
    {
      op->vtkCPDataDescription::SetUserData(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPDataDescription_GetUserData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUserData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPDataDescription *op = static_cast<vtkCPDataDescription *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkFieldData *tempr = (ap.IsBound() ?
      op->GetUserData() :
      op->vtkCPDataDescription::GetUserData());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPDataDescription_Copy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Copy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPDataDescription *op = static_cast<vtkCPDataDescription *>(vp);

  vtkCPDataDescription *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkCPDataDescription"))
  {
    if (ap.IsBound())
    {
      op->Copy(temp0);
    }
    else
    {
      op->vtkCPDataDescription::Copy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkCPDataDescription_Methods[] = {
  {"IsTypeOf", PyvtkCPDataDescription_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkCPDataDescription_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkCPDataDescription_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkCPDataDescription\nC++: static vtkCPDataDescription *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkCPDataDescription_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkCPDataDescription\nC++: vtkCPDataDescription *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkCPDataDescription_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkCPDataDescription_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetTimeData", PyvtkCPDataDescription_SetTimeData, METH_VARARGS,
   "SetTimeData(self, time:float, timeStep:int) -> None\nC++: void SetTimeData(double time, vtkIdType timeStep)\n\nSet the time step and current simulation time.\n"},
  {"GetTimeStep", PyvtkCPDataDescription_GetTimeStep, METH_VARARGS,
   "GetTimeStep(self) -> int\nC++: virtual vtkIdType GetTimeStep()\n\nGet the current time step that should be set in the adaptor.\n"},
  {"GetTime", PyvtkCPDataDescription_GetTime, METH_VARARGS,
   "GetTime(self) -> float\nC++: virtual double GetTime()\n\nGet the current time that should be set in the adaptor.\n"},
  {"SetForceOutput", PyvtkCPDataDescription_SetForceOutput, METH_VARARGS,
   "SetForceOutput(self, _arg:bool) -> None\nC++: virtual void SetForceOutput(bool _arg)\n\nSpecify whether or not to force output of all coprocessing\npipelines. This is meant to be set in the adaptor and used in the\ncoprocessing pipeline.  Default is false.  If this is true then\nGetIsGridNecessary() and GetIfAnyGridIsNecessary() will return\ntrue.\n"},
  {"ForceOutputOn", PyvtkCPDataDescription_ForceOutputOn, METH_VARARGS,
   "ForceOutputOn(self) -> None\nC++: virtual void ForceOutputOn()\n\nSpecify whether or not to force output of all coprocessing\npipelines. This is meant to be set in the adaptor and used in the\ncoprocessing pipeline.  Default is false.  If this is true then\nGetIsGridNecessary() and GetIfAnyGridIsNecessary() will return\ntrue.\n"},
  {"ForceOutputOff", PyvtkCPDataDescription_ForceOutputOff, METH_VARARGS,
   "ForceOutputOff(self) -> None\nC++: virtual void ForceOutputOff()\n\n"},
  {"GetForceOutput", PyvtkCPDataDescription_GetForceOutput, METH_VARARGS,
   "GetForceOutput(self) -> bool\nC++: virtual bool GetForceOutput()\n\nReturn whether or not output is forced for all coprocessing\npipelines.\n"},
  {"AddInput", PyvtkCPDataDescription_AddInput, METH_VARARGS,
   "AddInput(self, gridName:str) -> None\nC++: void AddInput(const char *gridName)\n\nAdd names for grids produced by the simulation. This allocates a\nnew vtkCPInputDataDescription for that grid, if a grid by that\nname does not already exist.\n"},
  {"GetNumberOfInputDescriptions", PyvtkCPDataDescription_GetNumberOfInputDescriptions, METH_VARARGS,
   "GetNumberOfInputDescriptions(self) -> int\nC++: unsigned int GetNumberOfInputDescriptions()\n\nReturns the number of input descriptions.\n"},
  {"ResetInputDescriptions", PyvtkCPDataDescription_ResetInputDescriptions, METH_VARARGS,
   "ResetInputDescriptions(self) -> None\nC++: void ResetInputDescriptions()\n\nReset the names of the fields that are needed, the required\nmeshes, etc. that are stored in the vtkCPInputDescriptions.\n"},
  {"ResetAll", PyvtkCPDataDescription_ResetAll, METH_VARARGS,
   "ResetAll(self) -> None\nC++: void ResetAll()\n\nReset the names of the fields that are needed, the required\nmeshes, etc. that are stored in the vtkCPInputDescriptions as\nwell as the time information and output forcing.  Automatically\ncalled after vtkCPProcessor::CoProcess() is called.\n"},
  {"GetInputDescription", PyvtkCPDataDescription_GetInputDescription, METH_VARARGS,
   "GetInputDescription(self, __a:int) -> vtkCPInputDataDescription\nC++: vtkCPInputDataDescription *GetInputDescription(unsigned int)\n\nProvides access to a grid description using the index.\n"},
  {"GetInputDescriptionName", PyvtkCPDataDescription_GetInputDescriptionName, METH_VARARGS,
   "GetInputDescriptionName(self, __a:int) -> str\nC++: const char *GetInputDescriptionName(unsigned int)\n\nProvides the name for the input description at the given index.\n"},
  {"GetInputDescriptionByName", PyvtkCPDataDescription_GetInputDescriptionByName, METH_VARARGS,
   "GetInputDescriptionByName(self, __a:str)\n    -> vtkCPInputDataDescription\nC++: vtkCPInputDataDescription *GetInputDescriptionByName(\n    const char *)\n\nProvides access to a grid description using the grid name.\n"},
  {"GetIfGridIsNecessary", PyvtkCPDataDescription_GetIfGridIsNecessary, METH_VARARGS,
   "GetIfGridIsNecessary(self, __a:str) -> bool\nC++: bool GetIfGridIsNecessary(const char *)\n\nReturns true if the grid is necessary, given the grid's name.\n"},
  {"GetIfAnyGridNecessary", PyvtkCPDataDescription_GetIfAnyGridNecessary, METH_VARARGS,
   "GetIfAnyGridNecessary(self) -> bool\nC++: bool GetIfAnyGridNecessary()\n\nReturns true if any of the grids is necessary.\n"},
  {"SetUserData", PyvtkCPDataDescription_SetUserData, METH_VARARGS,
   "SetUserData(self, UserData:vtkFieldData) -> None\nC++: void SetUserData(vtkFieldData *UserData)\n\nSet user defined information that can be passed from the adaptor\nto the coprocessing pipelines.\n"},
  {"GetUserData", PyvtkCPDataDescription_GetUserData, METH_VARARGS,
   "GetUserData(self) -> vtkFieldData\nC++: virtual vtkFieldData *GetUserData()\n\nSet user defined information that can be passed from the adaptor\nto the coprocessing pipelines.\n"},
  {"Copy", PyvtkCPDataDescription_Copy, METH_VARARGS,
   "Copy(self, __a:vtkCPDataDescription) -> None\nC++: void Copy(vtkCPDataDescription *)\n\nCopy of dataDescription. Does a deep copy of the data members but\na shallow copy of the vtkDataObjects.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkCPDataDescription_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("force_output"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCPDataDescription_GetForceOutput(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCPDataDescription_SetForceOutput(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCPDataDescription_SetForceOutput(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetForceOutput/SetForceOutput\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("user_data"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCPDataDescription_GetUserData(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCPDataDescription_SetUserData(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCPDataDescription_SetUserData(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUserData/SetUserData\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("time_step"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCPDataDescription_GetTimeStep(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTimeStep\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCPDataDescription_GetTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("if_any_grid_necessary"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCPDataDescription_GetIfAnyGridNecessary(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetIfAnyGridNecessary\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_input_descriptions"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCPDataDescription_GetNumberOfInputDescriptions(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfInputDescriptions\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkCPDataDescription_Doc =
  "vtkCPDataDescription - @ingroup CoProcessing\n\n"
  "Superclass: vtkObject\n\n"
  "This class provides the description of the data for the coprocessor\n"
  "pipelines.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkCPDataDescription_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVCatalyst.vtkCPDataDescription", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkCPDataDescription_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkCPDataDescription_StaticNew()
{
  return vtkCPDataDescription::New();
}

PyObject *PyvtkCPDataDescription_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkCPDataDescription_Type, PyvtkCPDataDescription_Methods,
    "vtkCPDataDescription",
 &PyvtkCPDataDescription_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkCPDataDescription_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkCPDataDescription(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkCPDataDescription_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkCPDataDescription", o) != 0)
  {
    Py_DECREF(o);
  }

}

