// python wrapper for vtkPVContourFilter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVContourFilter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVContourFilter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVContourFilter_ClassNew(); }


static PyObject *
PyvtkPVContourFilter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVContourFilter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVContourFilter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVContourFilter *op = static_cast<vtkPVContourFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVContourFilter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVContourFilter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVContourFilter *tempr = vtkPVContourFilter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVContourFilter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVContourFilter *op = static_cast<vtkPVContourFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVContourFilter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVContourFilter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVContourFilter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVContourFilter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVContourFilter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVContourFilter *op = static_cast<vtkPVContourFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVContourFilter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVContourFilter_GetHTGStrategy3D(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHTGStrategy3D");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVContourFilter *op = static_cast<vtkPVContourFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetHTGStrategy3D() :
      op->vtkPVContourFilter::GetHTGStrategy3D());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVContourFilter_SetHTGStrategy3D(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHTGStrategy3D");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVContourFilter *op = static_cast<vtkPVContourFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHTGStrategy3D(temp0);
    }
    else
    {
      op->vtkPVContourFilter::SetHTGStrategy3D(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVContourFilter_GetHTGStrategy3DMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHTGStrategy3DMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVContourFilter *op = static_cast<vtkPVContourFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetHTGStrategy3DMinValue() :
      op->vtkPVContourFilter::GetHTGStrategy3DMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVContourFilter_GetHTGStrategy3DMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHTGStrategy3DMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVContourFilter *op = static_cast<vtkPVContourFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetHTGStrategy3DMaxValue() :
      op->vtkPVContourFilter::GetHTGStrategy3DMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVContourFilter_SetUseImplicitArraysHTG(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseImplicitArraysHTG");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVContourFilter *op = static_cast<vtkPVContourFilter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseImplicitArraysHTG(temp0);
    }
    else
    {
      op->vtkPVContourFilter::SetUseImplicitArraysHTG(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVContourFilter_GetUseImplicitArraysHTG(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseImplicitArraysHTG");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVContourFilter *op = static_cast<vtkPVContourFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseImplicitArraysHTG() :
      op->vtkPVContourFilter::GetUseImplicitArraysHTG());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVContourFilter_UseImplicitArraysHTGOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseImplicitArraysHTGOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVContourFilter *op = static_cast<vtkPVContourFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseImplicitArraysHTGOn();
    }
    else
    {
      op->vtkPVContourFilter::UseImplicitArraysHTGOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVContourFilter_UseImplicitArraysHTGOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseImplicitArraysHTGOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVContourFilter *op = static_cast<vtkPVContourFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseImplicitArraysHTGOff();
    }
    else
    {
      op->vtkPVContourFilter::UseImplicitArraysHTGOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVContourFilter_Methods[] = {
  {"IsTypeOf", PyvtkPVContourFilter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVContourFilter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVContourFilter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVContourFilter\nC++: static vtkPVContourFilter *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVContourFilter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVContourFilter\nC++: vtkPVContourFilter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVContourFilter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVContourFilter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetHTGStrategy3D", PyvtkPVContourFilter_GetHTGStrategy3D, METH_VARARGS,
   "GetHTGStrategy3D(self) -> int\nC++: virtual int GetHTGStrategy3D()\n\nGet/set the contour strategy to apply in case of a HTG input. By\ndefault, the strategy is vtkHyperTreeGridContour::USE_VOXELS.\nThis method is time-efficient but can lead to bad results in the\n3D case, where generated dual cells can be concave.\nvtkHyperTreeGridContour::USE_DECOMPOSED_POLYHEDRA allows better\nresults in such cases (3D HTGs only). It takes advantage of the\nvtkPolyhedronUtilities::Decompose method to generate better\ncontours. The dowside is that this method is much slower than\nvtkHyperTreeGridContour::USE_VOXELS.\n\n@attention This option only concerns HTG inputs.\n"},
  {"SetHTGStrategy3D", PyvtkPVContourFilter_SetHTGStrategy3D, METH_VARARGS,
   "SetHTGStrategy3D(self, _arg:int) -> None\nC++: virtual void SetHTGStrategy3D(int _arg)\n\n"},
  {"GetHTGStrategy3DMinValue", PyvtkPVContourFilter_GetHTGStrategy3DMinValue, METH_VARARGS,
   "GetHTGStrategy3DMinValue(self) -> int\nC++: virtual int GetHTGStrategy3DMinValue()\n\n"},
  {"GetHTGStrategy3DMaxValue", PyvtkPVContourFilter_GetHTGStrategy3DMaxValue, METH_VARARGS,
   "GetHTGStrategy3DMaxValue(self) -> int\nC++: virtual int GetHTGStrategy3DMaxValue()\n\n"},
  {"SetUseImplicitArraysHTG", PyvtkPVContourFilter_SetUseImplicitArraysHTG, METH_VARARGS,
   "SetUseImplicitArraysHTG(self, _arg:bool) -> None\nC++: virtual void SetUseImplicitArraysHTG(bool _arg)\n\nSet/Get wether or not the filter should use implicit arrays to\nstore the output contour values (stored as point data of the\noutput contour). Since these values are the same fo each\nisosurface, some memory can be saved by storing each value only\nonce unsing an indexed array.\n\n@attention This option only concerns HTG inputs.@attention This\noption have no effect if there is more than 256 contour values.\n"},
  {"GetUseImplicitArraysHTG", PyvtkPVContourFilter_GetUseImplicitArraysHTG, METH_VARARGS,
   "GetUseImplicitArraysHTG(self) -> bool\nC++: virtual bool GetUseImplicitArraysHTG()\n\n"},
  {"UseImplicitArraysHTGOn", PyvtkPVContourFilter_UseImplicitArraysHTGOn, METH_VARARGS,
   "UseImplicitArraysHTGOn(self) -> None\nC++: virtual void UseImplicitArraysHTGOn()\n\n"},
  {"UseImplicitArraysHTGOff", PyvtkPVContourFilter_UseImplicitArraysHTGOff, METH_VARARGS,
   "UseImplicitArraysHTGOff(self) -> None\nC++: virtual void UseImplicitArraysHTGOff()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVContourFilter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("htg_strategy3d"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVContourFilter_GetHTGStrategy3D(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVContourFilter_SetHTGStrategy3D(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVContourFilter_SetHTGStrategy3D(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetHTGStrategy3D/SetHTGStrategy3D\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_implicit_arrays_htg"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVContourFilter_GetUseImplicitArraysHTG(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVContourFilter_SetUseImplicitArraysHTG(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVContourFilter_SetUseImplicitArraysHTG(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseImplicitArraysHTG/SetUseImplicitArraysHTG\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVContourFilter_Doc =
  "vtkPVContourFilter - generate isosurfaces/isolines from scalar values\n\n"
  "Superclass: vtkContourFilter\n\n"
  "vtkPVContourFilter is an extension to vtkContourFilter. It adds the\n"
  "ability to generate isosurfaces / isolines for AMR dataset.\n\n"
  "vtkPVContourFilter also handles cleaning up interpolation error in\n"
  "the output scalars array when `ComputeScalars` is set to true. For\n"
  "each requested contour value, the output scalar array may have an\n"
  "error introduced due to interpolation along an edge. This filter\n"
  "fixes that error so that for all points generated from a particular\n"
  "contour value, the scalar array will have exactly the same value.\n\n"
  "@warning\n"
  "Certain flags in vtkAMRDualContour are assumed to be ON.\n\n"
  "@sa\n"
  "vtkContourFilter vtkAMRDualContour\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVContourFilter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersGeneral.vtkPVContourFilter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVContourFilter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVContourFilter_StaticNew()
{
  return vtkPVContourFilter::New();
}

PyObject *PyvtkPVContourFilter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVContourFilter_Type, PyvtkPVContourFilter_Methods,
    "vtkPVContourFilter",
 &PyvtkPVContourFilter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkContourFilter");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVContourFilter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVContourFilter(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVContourFilter_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVContourFilter", o) != 0)
  {
    Py_DECREF(o);
  }

}

