// components/autofill/core/common/mojom/autofill_types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_AUTOFILL_CORE_COMMON_MOJOM_AUTOFILL_TYPES_MOJOM_SHARED_H_
#define COMPONENTS_AUTOFILL_CORE_COMMON_MOJOM_AUTOFILL_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/autofill/core/common/mojom/autofill_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/text_direction.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"







namespace autofill::mojom {
class FrameTokenDataView;

class FrameTokenWithPredecessorDataView;

class FormRendererIdDataView;

class FieldRendererIdDataView;

class SelectOptionDataView;

class SectionAutocompleteDataView;

class SectionFieldIdentifierDataView;

class SectionDataView;

class AutocompleteParsingResultDataView;

class FormFieldDataDataView;

class FormFieldData_FillDataDataView;

class ButtonTitleInfoDataView;

class FormDataDataView;

class FormFieldDataPredictionsDataView;

class FormDataPredictionsDataView;

class PasswordAndMetadataDataView;

class PasswordFormFillDataDataView;

class PasswordFormGenerationDataDataView;

class PasswordGenerationUIDataDataView;

class PasswordSuggestionRequestDataView;

class ParsingResultDataView;

class SectionValueDataView;


}  // autofill::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::autofill::mojom::FrameTokenDataView> {
  using Data = ::autofill::mojom::internal::FrameToken_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::FrameTokenWithPredecessorDataView> {
  using Data = ::autofill::mojom::internal::FrameTokenWithPredecessor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::FormRendererIdDataView> {
  using Data = ::autofill::mojom::internal::FormRendererId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::FieldRendererIdDataView> {
  using Data = ::autofill::mojom::internal::FieldRendererId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::SelectOptionDataView> {
  using Data = ::autofill::mojom::internal::SelectOption_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::SectionAutocompleteDataView> {
  using Data = ::autofill::mojom::internal::SectionAutocomplete_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::SectionFieldIdentifierDataView> {
  using Data = ::autofill::mojom::internal::SectionFieldIdentifier_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::SectionDataView> {
  using Data = ::autofill::mojom::internal::Section_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::AutocompleteParsingResultDataView> {
  using Data = ::autofill::mojom::internal::AutocompleteParsingResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::FormFieldDataDataView> {
  using Data = ::autofill::mojom::internal::FormFieldData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::FormFieldData_FillDataDataView> {
  using Data = ::autofill::mojom::internal::FormFieldData_FillData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::ButtonTitleInfoDataView> {
  using Data = ::autofill::mojom::internal::ButtonTitleInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::FormDataDataView> {
  using Data = ::autofill::mojom::internal::FormData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::FormFieldDataPredictionsDataView> {
  using Data = ::autofill::mojom::internal::FormFieldDataPredictions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::FormDataPredictionsDataView> {
  using Data = ::autofill::mojom::internal::FormDataPredictions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::PasswordAndMetadataDataView> {
  using Data = ::autofill::mojom::internal::PasswordAndMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::PasswordFormFillDataDataView> {
  using Data = ::autofill::mojom::internal::PasswordFormFillData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::PasswordFormGenerationDataDataView> {
  using Data = ::autofill::mojom::internal::PasswordFormGenerationData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::PasswordGenerationUIDataDataView> {
  using Data = ::autofill::mojom::internal::PasswordGenerationUIData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::PasswordSuggestionRequestDataView> {
  using Data = ::autofill::mojom::internal::PasswordSuggestionRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::ParsingResultDataView> {
  using Data = ::autofill::mojom::internal::ParsingResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::autofill::mojom::SectionValueDataView> {
  using Data = ::autofill::mojom::internal::SectionValue_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace autofill::mojom {


enum class FormControlType : int32_t {
  
  kContentEditable = 0,
  
  kInputCheckbox = 1,
  
  kInputEmail = 2,
  
  kInputMonth = 3,
  
  kInputNumber = 4,
  
  kInputPassword = 5,
  
  kInputRadio = 6,
  
  kInputSearch = 7,
  
  kInputTelephone = 8,
  
  kInputText = 9,
  
  kInputUrl = 10,
  
  kSelectOne = 11,
  
  kSelectMultiple = 12,
  
  kTextArea = 14,
  kMinValue = 0,
  kMaxValue = 14,
};

 std::ostream& operator<<(std::ostream& os, FormControlType value);
inline bool IsKnownEnumValue(FormControlType value) {
  return internal::FormControlType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class HtmlFieldMode : int32_t {
  
  kNone = 0,
  
  kBilling = 1,
  
  kShipping = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, HtmlFieldMode value);
inline bool IsKnownEnumValue(HtmlFieldMode value) {
  return internal::HtmlFieldMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class HtmlFieldType : int32_t {
  
  kUnspecified = 0,
  
  kName = 1,
  
  kHonorificPrefix = 2,
  
  kGivenName = 3,
  
  kAdditionalName = 4,
  
  kFamilyName = 5,
  
  kOrganization = 6,
  
  kStreetAddress = 7,
  
  kAddressLine1 = 8,
  
  kAddressLine2 = 9,
  
  kAddressLine3 = 10,
  
  kAddressLevel1 = 11,
  
  kAddressLevel2 = 12,
  
  kAddressLevel3 = 13,
  
  kCountryCode = 14,
  
  kCountryName = 15,
  
  kPostalCode = 16,
  
  kCreditCardNameFull = 18,
  
  kCreditCardNameFirst = 19,
  
  kCreditCardNameLast = 20,
  
  kCreditCardNumber = 21,
  
  kCreditCardExp = 22,
  
  kCreditCardExpMonth = 23,
  
  kCreditCardExpYear = 24,
  
  kCreditCardVerificationCode = 25,
  
  kCreditCardType = 26,
  
  kTel = 27,
  
  kTelCountryCode = 28,
  
  kTelNational = 29,
  
  kTelAreaCode = 30,
  
  kTelLocal = 31,
  
  kTelLocalPrefix = 32,
  
  kTelLocalSuffix = 33,
  
  kTelExtension = 34,
  
  kEmail = 35,
  
  kBirthdateDay = 36,
  
  kBirthdateMonth = 37,
  
  kBirthdateYear = 38,
  
  kTransactionAmount = 39,
  
  kTransactionCurrency = 40,
  
  kAdditionalNameInitial = 41,
  
  kCreditCardExpDate2DigitYear = 42,
  
  kCreditCardExpDate4DigitYear = 43,
  
  kCreditCardExp2DigitYear = 44,
  
  kCreditCardExp4DigitYear = 45,
  
  kOneTimeCode = 47,
  
  kMerchantPromoCode = 48,
  
  kIban = 49,
  
  kUnrecognized = 50,
  kMinValue = 0,
  kMaxValue = 50,
};

 std::ostream& operator<<(std::ostream& os, HtmlFieldType value);
inline bool IsKnownEnumValue(HtmlFieldType value) {
  return internal::HtmlFieldType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SubmissionIndicatorEvent : int32_t {
  
  NONE = 0,
  
  HTML_FORM_SUBMISSION = 1,
  
  SAME_DOCUMENT_NAVIGATION = 2,
  
  XHR_SUCCEEDED = 3,
  
  FRAME_DETACHED = 4,
  
  PROBABLE_FORM_SUBMISSION = 10,
  
  CHANGE_PASSWORD_FORM_CLEARED = 11,
  
  DOM_MUTATION_AFTER_AUTOFILL = 12,
  kMinValue = 0,
  kMaxValue = 12,
};

 std::ostream& operator<<(std::ostream& os, SubmissionIndicatorEvent value);
inline bool IsKnownEnumValue(SubmissionIndicatorEvent value) {
  return internal::SubmissionIndicatorEvent_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SubmissionSource : int32_t {
  
  NONE = 0,
  
  SAME_DOCUMENT_NAVIGATION = 1,
  
  XHR_SUCCEEDED = 2,
  
  FRAME_DETACHED = 3,
  
  PROBABLY_FORM_SUBMITTED = 4,
  
  FORM_SUBMISSION = 5,
  
  DOM_MUTATION_AFTER_AUTOFILL = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, SubmissionSource value);
inline bool IsKnownEnumValue(SubmissionSource value) {
  return internal::SubmissionSource_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FocusedFieldType : int32_t {
  
  kUnknown = 0,
  
  kUnfillableElement = 1,
  
  kFillableTextArea = 2,
  
  kFillableSearchField = 3,
  
  kFillableNonSearchField = 4,
  
  kFillableWebauthnTaggedField = 5,
  
  kFillableUsernameField = 6,
  
  kFillablePasswordField = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

 std::ostream& operator<<(std::ostream& os, FocusedFieldType value);
inline bool IsKnownEnumValue(FocusedFieldType value) {
  return internal::FocusedFieldType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ButtonTitleType : int32_t {
  
  NONE = 0,
  
  BUTTON_ELEMENT_SUBMIT_TYPE = 1,
  
  BUTTON_ELEMENT_BUTTON_TYPE = 2,
  
  INPUT_ELEMENT_SUBMIT_TYPE = 3,
  
  INPUT_ELEMENT_BUTTON_TYPE = 4,
  
  HYPERLINK = 5,
  
  DIV = 6,
  
  SPAN = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

 std::ostream& operator<<(std::ostream& os, ButtonTitleType value);
inline bool IsKnownEnumValue(ButtonTitleType value) {
  return internal::ButtonTitleType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SubmissionReadinessState : int32_t {
  
  kNoInformation = 0,
  
  kError = 1,
  
  kNoUsernameField = 2,
  
  kFieldBetweenUsernameAndPassword = 3,
  
  kFieldAfterPasswordField = 4,
  
  kEmptyFields = 5,
  
  kMoreThanTwoFields = 6,
  
  kTwoFields = 7,
  
  kNoPasswordField = 8,
  
  kLikelyHasCaptcha = 9,
  kMinValue = 0,
  kMaxValue = 9,
};

 std::ostream& operator<<(std::ostream& os, SubmissionReadinessState value);
inline bool IsKnownEnumValue(SubmissionReadinessState value) {
  return internal::SubmissionReadinessState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AutofillSuggestionAvailability : int32_t {
  
  kNoSuggestions = 0,
  
  kAutofillAvailable = 1,
  
  kAutocompleteAvailable = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, AutofillSuggestionAvailability value);
inline bool IsKnownEnumValue(AutofillSuggestionAvailability value) {
  return internal::AutofillSuggestionAvailability_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ActionPersistence : int32_t {
  
  kFill = 0,
  
  kPreview = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, ActionPersistence value);
inline bool IsKnownEnumValue(ActionPersistence value) {
  return internal::ActionPersistence_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FormActionType : int32_t {
  
  kFill = 0,
  
  kUndo = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, FormActionType value);
inline bool IsKnownEnumValue(FormActionType value) {
  return internal::FormActionType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FieldActionType : int32_t {
  
  kReplaceAll = 0,
  
  kReplaceSelection = 1,
  
  kSelectAll = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, FieldActionType value);
inline bool IsKnownEnumValue(FieldActionType value) {
  return internal::FieldActionType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AutofillSuggestionTriggerSource : int32_t {
  
  kUnspecified = 0,
  
  kFormControlElementClicked = 1,
  
  kTextareaFocusedWithoutClick = 2,
  
  kContentEditableClicked = 3,
  
  kTextFieldValueChanged = 4,
  
  kTextFieldDidReceiveKeyDown = 5,
  
  kOpenTextDataListChooser = 6,
  
  kShowCardsFromAccount = 7,
  
  kPasswordManager = 8,
  
  kiOS = 9,
  
  kManualFallbackPasswords = 12,
  
  kManualFallbackPlusAddresses = 13,
  
  kShowPromptAfterDialogClosedNonManualFallback = 14,
  
  kComposeDialogLostFocus = 15,
  
  kComposeDelayedProactiveNudge = 16,
  
  kPasswordManagerProcessedFocusedField = 17,
  
  kAutofillAi = 18,
  
  kPlusAddressUpdatedInBrowserProcess = 19,
  kMinValue = 0,
  kMaxValue = 19,
};

 std::ostream& operator<<(std::ostream& os, AutofillSuggestionTriggerSource value);
inline bool IsKnownEnumValue(AutofillSuggestionTriggerSource value) {
  return internal::AutofillSuggestionTriggerSource_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FormFieldData_CheckStatus : int32_t {
  
  kNotCheckable = 0,
  
  kCheckableButUnchecked = 1,
  
  kChecked = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, FormFieldData_CheckStatus value);
inline bool IsKnownEnumValue(FormFieldData_CheckStatus value) {
  return internal::FormFieldData_CheckStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FormFieldData_RoleAttribute : int32_t {
  
  kPresentation = 0,
  
  kOther = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, FormFieldData_RoleAttribute value);
inline bool IsKnownEnumValue(FormFieldData_RoleAttribute value) {
  return internal::FormFieldData_RoleAttribute_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FormFieldData_LabelSource : int32_t {
  
  kUnknown = 0,
  
  kLabelTag = 1,
  
  kPTag = 2,
  
  kDivTable = 3,
  
  kTdTag = 4,
  
  kDdTag = 5,
  
  kLiTag = 6,
  
  kPlaceHolder = 7,
  
  kAriaLabel = 8,
  
  kCombined = 9,
  
  kValue = 10,
  
  kForId = 11,
  
  kForName = 12,
  
  kForShadowHostId = 13,
  
  kForShadowHostName = 14,
  
  kOverlayingLabel = 15,
  
  kDefaultSelectText = 16,
  kMinValue = 0,
  kMaxValue = 16,
};

 std::ostream& operator<<(std::ostream& os, FormFieldData_LabelSource value);
inline bool IsKnownEnumValue(FormFieldData_LabelSource value) {
  return internal::FormFieldData_LabelSource_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class FrameTokenDataView {
 public:
  FrameTokenDataView() = default;

  FrameTokenDataView(
      internal::FrameToken_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) {
    
    auto* pointer = data_->token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  bool is_local() const {
    return data_->is_local;
  }
 private:
  internal::FrameToken_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FrameTokenWithPredecessorDataView {
 public:
  FrameTokenWithPredecessorDataView() = default;

  FrameTokenWithPredecessorDataView(
      internal::FrameTokenWithPredecessor_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTokenDataView(
      FrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) {
    
    auto* pointer = data_->token.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FrameTokenDataView>(
        pointer, output, message_);
  }
  int32_t predecessor() const {
    return data_->predecessor;
  }
 private:
  internal::FrameTokenWithPredecessor_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FormRendererIdDataView {
 public:
  FormRendererIdDataView() = default;

  FormRendererIdDataView(
      internal::FormRendererId_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t id() const {
    return data_->id;
  }
 private:
  internal::FormRendererId_Data* data_ = nullptr;
};


class FieldRendererIdDataView {
 public:
  FieldRendererIdDataView() = default;

  FieldRendererIdDataView(
      internal::FieldRendererId_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t id() const {
    return data_->id;
  }
 private:
  internal::FieldRendererId_Data* data_ = nullptr;
};


class SelectOptionDataView {
 public:
  SelectOptionDataView() = default;

  SelectOptionDataView(
      internal::SelectOption_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) {
    
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::SelectOption_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SectionAutocompleteDataView {
 public:
  SectionAutocompleteDataView() = default;

  SectionAutocompleteDataView(
      internal::SectionAutocomplete_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSectionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSection(UserType* output) {
    
    auto* pointer = data_->section.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadHtmlFieldMode(UserType* output) const {
    auto data_value = data_->html_field_mode;
    return mojo::internal::Deserialize<::autofill::mojom::HtmlFieldMode>(
        data_value, output);
  }
  HtmlFieldMode html_field_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::autofill::mojom::HtmlFieldMode>(data_->html_field_mode));
  }
 private:
  internal::SectionAutocomplete_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SectionFieldIdentifierDataView {
 public:
  SectionFieldIdentifierDataView() = default;

  SectionFieldIdentifierDataView(
      internal::SectionFieldIdentifier_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFieldNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFieldName(UserType* output) {
    
    auto* pointer = data_->field_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint64_t local_frame_id() const {
    return data_->local_frame_id;
  }
  inline void GetFieldRendererIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFieldRendererId(UserType* output) {
    
    auto* pointer = data_->field_renderer_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::SectionFieldIdentifier_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SectionDataView {
 public:
  SectionDataView() = default;

  SectionDataView(
      internal::Section_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      SectionValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = !data_->value.is_null() ? &data_->value : nullptr;
    return mojo::internal::Deserialize<::autofill::mojom::SectionValueDataView>(
        pointer, output, message_);
  }
 private:
  internal::Section_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AutocompleteParsingResultDataView {
 public:
  AutocompleteParsingResultDataView() = default;

  AutocompleteParsingResultDataView(
      internal::AutocompleteParsingResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSectionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSection(UserType* output) {
    
    auto* pointer = data_->section.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::autofill::mojom::HtmlFieldMode>(
        data_value, output);
  }
  HtmlFieldMode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::autofill::mojom::HtmlFieldMode>(data_->mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFieldType(UserType* output) const {
    auto data_value = data_->field_type;
    return mojo::internal::Deserialize<::autofill::mojom::HtmlFieldType>(
        data_value, output);
  }
  HtmlFieldType field_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::autofill::mojom::HtmlFieldType>(data_->field_type));
  }
  bool webauthn() const {
    return data_->webauthn;
  }
 private:
  internal::AutocompleteParsingResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FormFieldDataDataView {
 public:
  FormFieldDataDataView() = default;

  FormFieldDataDataView(
      internal::FormFieldData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLabelDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetIdAttributeDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIdAttribute(UserType* output) {
    
    auto* pointer = data_->id_attribute.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetNameAttributeDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNameAttribute(UserType* output) {
    
    auto* pointer = data_->name_attribute.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetSelectedTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectedText(UserType* output) {
    
    auto* pointer = data_->selected_text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFormControlType(UserType* output) const {
    auto data_value = data_->form_control_type;
    return mojo::internal::Deserialize<::autofill::mojom::FormControlType>(
        data_value, output);
  }
  FormControlType form_control_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::autofill::mojom::FormControlType>(data_->form_control_type));
  }
  inline void GetAutocompleteAttributeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAutocompleteAttribute(UserType* output) {
    
    auto* pointer = data_->autocomplete_attribute.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetParsedAutocompleteDataView(
      AutocompleteParsingResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParsedAutocomplete(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::autofill::mojom::AutocompleteParsingResultDataView, UserType>(),
    "Attempting to read the optional `parsed_autocomplete` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadParsedAutocomplete` instead "
    "of `ReadParsedAutocomplete if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->parsed_autocomplete.Get();
    return mojo::internal::Deserialize<::autofill::mojom::AutocompleteParsingResultDataView>(
        pointer, output, message_);
  }
  inline void GetPlaceholderDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPlaceholder(UserType* output) {
    
    auto* pointer = data_->placeholder.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetCssClassesDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCssClasses(UserType* output) {
    
    auto* pointer = data_->css_classes.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetAriaLabelDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAriaLabel(UserType* output) {
    
    auto* pointer = data_->aria_label.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetAriaDescriptionDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAriaDescription(UserType* output) {
    
    auto* pointer = data_->aria_description.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetRendererIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRendererId(UserType* output) {
    
    auto* pointer = data_->renderer_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
  inline void GetHostFormIdDataView(
      FormRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHostFormId(UserType* output) {
    
    auto* pointer = data_->host_form_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FormRendererIdDataView>(
        pointer, output, message_);
  }
  uint32_t properties_mask() const {
    return data_->properties_mask;
  }
  int32_t form_control_ax_id() const {
    return data_->form_control_ax_id;
  }
  uint64_t max_length() const {
    return data_->max_length;
  }
  bool is_user_edited() const {
    return data_->is_user_edited;
  }
  bool is_autofilled() const {
    return data_->is_autofilled;
  }
  inline void GetSectionDataView(
      SectionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSection(UserType* output) {
    
    auto* pointer = data_->section.Get();
    return mojo::internal::Deserialize<::autofill::mojom::SectionDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCheckStatus(UserType* output) const {
    auto data_value = data_->check_status;
    return mojo::internal::Deserialize<::autofill::mojom::FormFieldData_CheckStatus>(
        data_value, output);
  }
  FormFieldData_CheckStatus check_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::autofill::mojom::FormFieldData_CheckStatus>(data_->check_status));
  }
  bool is_focusable() const {
    return data_->is_focusable;
  }
  bool is_visible() const {
    return data_->is_visible;
  }
  bool should_autocomplete() const {
    return data_->should_autocomplete;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRole(UserType* output) const {
    auto data_value = data_->role;
    return mojo::internal::Deserialize<::autofill::mojom::FormFieldData_RoleAttribute>(
        data_value, output);
  }
  FormFieldData_RoleAttribute role() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::autofill::mojom::FormFieldData_RoleAttribute>(data_->role));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTextDirection(UserType* output) const {
    auto data_value = data_->text_direction;
    return mojo::internal::Deserialize<::mojo_base::mojom::TextDirection>(
        data_value, output);
  }
  ::mojo_base::mojom::TextDirection text_direction() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::TextDirection>(data_->text_direction));
  }
  bool is_enabled() const {
    return data_->is_enabled;
  }
  bool is_readonly() const {
    return data_->is_readonly;
  }
  inline void GetUserInputDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserInput(UserType* output) {
    
    auto* pointer = data_->user_input.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  bool allows_writing_suggestions() const {
    return data_->allows_writing_suggestions;
  }
  inline void GetOptionsDataView(
      mojo::ArrayDataView<SelectOptionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptions(UserType* output) {
    
    auto* pointer = data_->options.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::autofill::mojom::SelectOptionDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLabelSource(UserType* output) const {
    auto data_value = data_->label_source;
    return mojo::internal::Deserialize<::autofill::mojom::FormFieldData_LabelSource>(
        data_value, output);
  }
  FormFieldData_LabelSource label_source() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::autofill::mojom::FormFieldData_LabelSource>(data_->label_source));
  }
  inline void GetBoundsDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBounds(UserType* output) {
    
    auto* pointer = data_->bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  inline void GetDatalistOptionsDataView(
      mojo::ArrayDataView<SelectOptionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDatalistOptions(UserType* output) {
    
    auto* pointer = data_->datalist_options.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::autofill::mojom::SelectOptionDataView>>(
        pointer, output, message_);
  }
  bool force_override() const {
    return data_->force_override;
  }
 private:
  internal::FormFieldData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FormFieldData_FillDataDataView {
 public:
  FormFieldData_FillDataDataView() = default;

  FormFieldData_FillDataDataView(
      internal::FormFieldData_FillData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetRendererIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRendererId(UserType* output) {
    
    auto* pointer = data_->renderer_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
  inline void GetHostFormIdDataView(
      FormRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHostFormId(UserType* output) {
    
    auto* pointer = data_->host_form_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FormRendererIdDataView>(
        pointer, output, message_);
  }
  bool is_autofilled() const {
    return data_->is_autofilled;
  }
  bool force_override() const {
    return data_->force_override;
  }
 private:
  internal::FormFieldData_FillData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ButtonTitleInfoDataView {
 public:
  ButtonTitleInfoDataView() = default;

  ButtonTitleInfoDataView(
      internal::ButtonTitleInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::autofill::mojom::ButtonTitleType>(
        data_value, output);
  }
  ButtonTitleType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::autofill::mojom::ButtonTitleType>(data_->type));
  }
 private:
  internal::ButtonTitleInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FormDataDataView {
 public:
  FormDataDataView() = default;

  FormDataDataView(
      internal::FormData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdAttributeDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIdAttribute(UserType* output) {
    
    auto* pointer = data_->id_attribute.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetNameAttributeDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNameAttribute(UserType* output) {
    
    auto* pointer = data_->name_attribute.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetButtonTitlesDataView(
      mojo::ArrayDataView<ButtonTitleInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadButtonTitles(UserType* output) {
    
    auto* pointer = data_->button_titles.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::autofill::mojom::ButtonTitleInfoDataView>>(
        pointer, output, message_);
  }
  inline void GetActionDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAction(UserType* output) {
    
    auto* pointer = data_->action.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool is_action_empty() const {
    return data_->is_action_empty;
  }
  inline void GetRendererIdDataView(
      FormRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRendererId(UserType* output) {
    
    auto* pointer = data_->renderer_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FormRendererIdDataView>(
        pointer, output, message_);
  }
  inline void GetChildFramesDataView(
      mojo::ArrayDataView<FrameTokenWithPredecessorDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChildFrames(UserType* output) {
    
    auto* pointer = data_->child_frames.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::autofill::mojom::FrameTokenWithPredecessorDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSubmissionEvent(UserType* output) const {
    auto data_value = data_->submission_event;
    return mojo::internal::Deserialize<::autofill::mojom::SubmissionIndicatorEvent>(
        data_value, output);
  }
  SubmissionIndicatorEvent submission_event() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::autofill::mojom::SubmissionIndicatorEvent>(data_->submission_event));
  }
  inline void GetFieldsDataView(
      mojo::ArrayDataView<FormFieldDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFields(UserType* output) {
    
    auto* pointer = data_->fields.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::autofill::mojom::FormFieldDataDataView>>(
        pointer, output, message_);
  }
  inline void GetUsernamePredictionsDataView(
      mojo::ArrayDataView<FieldRendererIdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsernamePredictions(UserType* output) {
    
    auto* pointer = data_->username_predictions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::autofill::mojom::FieldRendererIdDataView>>(
        pointer, output, message_);
  }
  bool is_gaia_with_skip_save_password_form() const {
    return data_->is_gaia_with_skip_save_password_form;
  }
  bool likely_contains_captcha() const {
    return data_->likely_contains_captcha;
  }
 private:
  internal::FormData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FormFieldDataPredictionsDataView {
 public:
  FormFieldDataPredictionsDataView() = default;

  FormFieldDataPredictionsDataView(
      internal::FormFieldDataPredictions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHostFormSignatureDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHostFormSignature(UserType* output) {
    
    auto* pointer = data_->host_form_signature.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSignatureDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSignature(UserType* output) {
    
    auto* pointer = data_->signature.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetHeuristicTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeuristicType(UserType* output) {
    
    auto* pointer = data_->heuristic_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetServerTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServerType(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `server_type` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadServerType` instead "
    "of `ReadServerType if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->server_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetHtmlTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHtmlType(UserType* output) {
    
    auto* pointer = data_->html_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetOverallTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOverallType(UserType* output) {
    
    auto* pointer = data_->overall_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetParseableNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParseableName(UserType* output) {
    
    auto* pointer = data_->parseable_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetParseableLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParseableLabel(UserType* output) {
    
    auto* pointer = data_->parseable_label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSectionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSection(UserType* output) {
    
    auto* pointer = data_->section.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t rank() const {
    return data_->rank;
  }
  uint32_t rank_in_signature_group() const {
    return data_->rank_in_signature_group;
  }
  uint32_t rank_in_host_form() const {
    return data_->rank_in_host_form;
  }
  uint32_t rank_in_host_form_signature_group() const {
    return data_->rank_in_host_form_signature_group;
  }
 private:
  internal::FormFieldDataPredictions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FormDataPredictionsDataView {
 public:
  FormDataPredictionsDataView() = default;

  FormDataPredictionsDataView(
      internal::FormDataPredictions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      FormDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FormDataDataView>(
        pointer, output, message_);
  }
  inline void GetSignatureDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSignature(UserType* output) {
    
    auto* pointer = data_->signature.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAlternativeSignatureDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAlternativeSignature(UserType* output) {
    
    auto* pointer = data_->alternative_signature.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFieldsDataView(
      mojo::ArrayDataView<FormFieldDataPredictionsDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFields(UserType* output) {
    
    auto* pointer = data_->fields.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::autofill::mojom::FormFieldDataPredictionsDataView>>(
        pointer, output, message_);
  }
 private:
  internal::FormDataPredictions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PasswordAndMetadataDataView {
 public:
  PasswordAndMetadataDataView() = default;

  PasswordAndMetadataDataView(
      internal::PasswordAndMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUsernameValueDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsernameValue(UserType* output) {
    
    auto* pointer = data_->username_value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetPasswordValueDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPasswordValue(UserType* output) {
    
    auto* pointer = data_->password_value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetRealmDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRealm(UserType* output) {
    
    auto* pointer = data_->realm.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool uses_account_store() const {
    return data_->uses_account_store;
  }
  bool is_grouped_affiliation() const {
    return data_->is_grouped_affiliation;
  }
 private:
  internal::PasswordAndMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PasswordFormFillDataDataView {
 public:
  PasswordFormFillDataDataView() = default;

  PasswordFormFillDataDataView(
      internal::PasswordFormFillData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFormRendererIdDataView(
      FormRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormRendererId(UserType* output) {
    
    auto* pointer = data_->form_renderer_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FormRendererIdDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetUsernameElementRendererIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsernameElementRendererId(UserType* output) {
    
    auto* pointer = data_->username_element_renderer_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
  inline void GetPasswordElementRendererIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPasswordElementRendererId(UserType* output) {
    
    auto* pointer = data_->password_element_renderer_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
  bool username_may_use_prefilled_placeholder() const {
    return data_->username_may_use_prefilled_placeholder;
  }
  inline void GetPreferredLoginDataView(
      PasswordAndMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPreferredLogin(UserType* output) {
    
    auto* pointer = data_->preferred_login.Get();
    return mojo::internal::Deserialize<::autofill::mojom::PasswordAndMetadataDataView>(
        pointer, output, message_);
  }
  inline void GetAdditionalLoginsDataView(
      mojo::ArrayDataView<PasswordAndMetadataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdditionalLogins(UserType* output) {
    
    auto* pointer = data_->additional_logins.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::autofill::mojom::PasswordAndMetadataDataView>>(
        pointer, output, message_);
  }
  bool wait_for_username() const {
    return data_->wait_for_username;
  }
  inline void GetSuggestionBannedFieldsDataView(
      mojo::ArrayDataView<FieldRendererIdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSuggestionBannedFields(UserType* output) {
    
    auto* pointer = data_->suggestion_banned_fields.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::autofill::mojom::FieldRendererIdDataView>>(
        pointer, output, message_);
  }
  bool notify_browser_of_successful_filling() const {
    return data_->notify_browser_of_successful_filling;
  }
 private:
  internal::PasswordFormFillData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PasswordFormGenerationDataDataView {
 public:
  PasswordFormGenerationDataDataView() = default;

  PasswordFormGenerationDataDataView(
      internal::PasswordFormGenerationData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNewPasswordRendererIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNewPasswordRendererId(UserType* output) {
    
    auto* pointer = data_->new_password_renderer_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
  inline void GetConfirmationPasswordRendererIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfirmationPasswordRendererId(UserType* output) {
    
    auto* pointer = data_->confirmation_password_renderer_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::PasswordFormGenerationData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PasswordGenerationUIDataDataView {
 public:
  PasswordGenerationUIDataDataView() = default;

  PasswordGenerationUIDataDataView(
      internal::PasswordGenerationUIData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBoundsDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBounds(UserType* output) {
    
    auto* pointer = data_->bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  int32_t max_length() const {
    return data_->max_length;
  }
  inline void GetGenerationElementDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGenerationElement(UserType* output) {
    
    auto* pointer = data_->generation_element.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetGenerationElementIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGenerationElementId(UserType* output) {
    
    auto* pointer = data_->generation_element_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
  bool is_generation_element_password_type() const {
    return data_->is_generation_element_password_type;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTextDirection(UserType* output) const {
    auto data_value = data_->text_direction;
    return mojo::internal::Deserialize<::mojo_base::mojom::TextDirection>(
        data_value, output);
  }
  ::mojo_base::mojom::TextDirection text_direction() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::TextDirection>(data_->text_direction));
  }
  inline void GetFormDataDataView(
      FormDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormData(UserType* output) {
    
    auto* pointer = data_->form_data.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FormDataDataView>(
        pointer, output, message_);
  }
  bool generation_rejected() const {
    return data_->generation_rejected;
  }
 private:
  internal::PasswordGenerationUIData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PasswordSuggestionRequestDataView {
 public:
  PasswordSuggestionRequestDataView() = default;

  PasswordSuggestionRequestDataView(
      internal::PasswordSuggestionRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetElementIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadElementId(UserType* output) {
    
    auto* pointer = data_->element_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
  inline void GetFormDataDataView(
      FormDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormData(UserType* output) {
    
    auto* pointer = data_->form_data.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FormDataDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTriggerSource(UserType* output) const {
    auto data_value = data_->trigger_source;
    return mojo::internal::Deserialize<::autofill::mojom::AutofillSuggestionTriggerSource>(
        data_value, output);
  }
  AutofillSuggestionTriggerSource trigger_source() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::autofill::mojom::AutofillSuggestionTriggerSource>(data_->trigger_source));
  }
  uint64_t username_field_index() const {
    return data_->username_field_index;
  }
  uint64_t password_field_index() const {
    return data_->password_field_index;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTextDirection(UserType* output) const {
    auto data_value = data_->text_direction;
    return mojo::internal::Deserialize<::mojo_base::mojom::TextDirection>(
        data_value, output);
  }
  ::mojo_base::mojom::TextDirection text_direction() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::TextDirection>(data_->text_direction));
  }
  inline void GetTypedUsernameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTypedUsername(UserType* output) {
    
    auto* pointer = data_->typed_username.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  bool show_webauthn_credentials() const {
    return data_->show_webauthn_credentials;
  }
  inline void GetBoundsDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBounds(UserType* output) {
    
    auto* pointer = data_->bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
 private:
  internal::PasswordSuggestionRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ParsingResultDataView {
 public:
  ParsingResultDataView() = default;

  ParsingResultDataView(
      internal::ParsingResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUsernameRendererIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsernameRendererId(UserType* output) {
    
    auto* pointer = data_->username_renderer_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
  inline void GetPasswordRendererIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPasswordRendererId(UserType* output) {
    
    auto* pointer = data_->password_renderer_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
  inline void GetNewPasswordRendererIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNewPasswordRendererId(UserType* output) {
    
    auto* pointer = data_->new_password_renderer_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
  inline void GetConfirmPasswordRendererIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfirmPasswordRendererId(UserType* output) {
    
    auto* pointer = data_->confirm_password_renderer_id.Get();
    return mojo::internal::Deserialize<::autofill::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::ParsingResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SectionValueDataView {
 public:
  using Tag = internal::SectionValue_Data::SectionValue_Tag;

  SectionValueDataView() = default;

  SectionValueDataView(
      internal::SectionValue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_default_section() const { return data_->tag == Tag::kDefaultSection; }
  bool default_section() const {
    CHECK(is_default_section());
    return data_->data.f_default_section;
  }
  bool is_autocomplete() const { return data_->tag == Tag::kAutocomplete; }
  inline void GetAutocompleteDataView(
      SectionAutocompleteDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadAutocomplete(UserType* output) const {
    
    CHECK(is_autocomplete());
    return mojo::internal::Deserialize<::autofill::mojom::SectionAutocompleteDataView>(
        data_->data.f_autocomplete.Get(), output, message_);
  }
  bool is_field_identifier() const { return data_->tag == Tag::kFieldIdentifier; }
  inline void GetFieldIdentifierDataView(
      SectionFieldIdentifierDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFieldIdentifier(UserType* output) const {
    
    CHECK(is_field_identifier());
    return mojo::internal::Deserialize<::autofill::mojom::SectionFieldIdentifierDataView>(
        data_->data.f_field_identifier.Get(), output, message_);
  }

 private:
  internal::SectionValue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // autofill::mojom

namespace std {

template <>
struct hash<::autofill::mojom::FormControlType>
    : public mojo::internal::EnumHashImpl<::autofill::mojom::FormControlType> {};

template <>
struct hash<::autofill::mojom::HtmlFieldMode>
    : public mojo::internal::EnumHashImpl<::autofill::mojom::HtmlFieldMode> {};

template <>
struct hash<::autofill::mojom::HtmlFieldType>
    : public mojo::internal::EnumHashImpl<::autofill::mojom::HtmlFieldType> {};

template <>
struct hash<::autofill::mojom::SubmissionIndicatorEvent>
    : public mojo::internal::EnumHashImpl<::autofill::mojom::SubmissionIndicatorEvent> {};

template <>
struct hash<::autofill::mojom::SubmissionSource>
    : public mojo::internal::EnumHashImpl<::autofill::mojom::SubmissionSource> {};

template <>
struct hash<::autofill::mojom::FocusedFieldType>
    : public mojo::internal::EnumHashImpl<::autofill::mojom::FocusedFieldType> {};

template <>
struct hash<::autofill::mojom::ButtonTitleType>
    : public mojo::internal::EnumHashImpl<::autofill::mojom::ButtonTitleType> {};

template <>
struct hash<::autofill::mojom::SubmissionReadinessState>
    : public mojo::internal::EnumHashImpl<::autofill::mojom::SubmissionReadinessState> {};

template <>
struct hash<::autofill::mojom::AutofillSuggestionAvailability>
    : public mojo::internal::EnumHashImpl<::autofill::mojom::AutofillSuggestionAvailability> {};

template <>
struct hash<::autofill::mojom::ActionPersistence>
    : public mojo::internal::EnumHashImpl<::autofill::mojom::ActionPersistence> {};

template <>
struct hash<::autofill::mojom::FormActionType>
    : public mojo::internal::EnumHashImpl<::autofill::mojom::FormActionType> {};

template <>
struct hash<::autofill::mojom::FieldActionType>
    : public mojo::internal::EnumHashImpl<::autofill::mojom::FieldActionType> {};

template <>
struct hash<::autofill::mojom::AutofillSuggestionTriggerSource>
    : public mojo::internal::EnumHashImpl<::autofill::mojom::AutofillSuggestionTriggerSource> {};

template <>
struct hash<::autofill::mojom::FormFieldData_CheckStatus>
    : public mojo::internal::EnumHashImpl<::autofill::mojom::FormFieldData_CheckStatus> {};

template <>
struct hash<::autofill::mojom::FormFieldData_RoleAttribute>
    : public mojo::internal::EnumHashImpl<::autofill::mojom::FormFieldData_RoleAttribute> {};

template <>
struct hash<::autofill::mojom::FormFieldData_LabelSource>
    : public mojo::internal::EnumHashImpl<::autofill::mojom::FormFieldData_LabelSource> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::FormControlType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::autofill::mojom::FormControlType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::autofill::mojom::FormControlType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::HtmlFieldMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::autofill::mojom::HtmlFieldMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::autofill::mojom::HtmlFieldMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::HtmlFieldType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::autofill::mojom::HtmlFieldType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::autofill::mojom::HtmlFieldType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::SubmissionIndicatorEvent, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::autofill::mojom::SubmissionIndicatorEvent, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::autofill::mojom::SubmissionIndicatorEvent>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::SubmissionSource, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::autofill::mojom::SubmissionSource, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::autofill::mojom::SubmissionSource>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::FocusedFieldType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::autofill::mojom::FocusedFieldType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::autofill::mojom::FocusedFieldType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::ButtonTitleType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::autofill::mojom::ButtonTitleType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::autofill::mojom::ButtonTitleType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::SubmissionReadinessState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::autofill::mojom::SubmissionReadinessState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::autofill::mojom::SubmissionReadinessState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::AutofillSuggestionAvailability, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::autofill::mojom::AutofillSuggestionAvailability, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::autofill::mojom::AutofillSuggestionAvailability>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::ActionPersistence, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::autofill::mojom::ActionPersistence, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::autofill::mojom::ActionPersistence>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::FormActionType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::autofill::mojom::FormActionType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::autofill::mojom::FormActionType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::FieldActionType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::autofill::mojom::FieldActionType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::autofill::mojom::FieldActionType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::AutofillSuggestionTriggerSource, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::autofill::mojom::AutofillSuggestionTriggerSource, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::autofill::mojom::AutofillSuggestionTriggerSource>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::FormFieldData_CheckStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::autofill::mojom::FormFieldData_CheckStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::autofill::mojom::FormFieldData_CheckStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::FormFieldData_RoleAttribute, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::autofill::mojom::FormFieldData_RoleAttribute, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::autofill::mojom::FormFieldData_RoleAttribute>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::FormFieldData_LabelSource, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::autofill::mojom::FormFieldData_LabelSource, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::autofill::mojom::FormFieldData_LabelSource>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::FrameTokenDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::FrameTokenDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::FrameToken_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::token(input)) in_token = Traits::token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->token)::BaseType> token_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_token, token_fragment);
    fragment->token.Set(
        token_fragment.is_null() ? nullptr : token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null token in FrameToken struct");
    fragment->is_local = Traits::is_local(input);
  }

  static bool Deserialize(::autofill::mojom::internal::FrameToken_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::autofill::mojom::FrameTokenDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::FrameTokenWithPredecessorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::FrameTokenWithPredecessorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::FrameTokenWithPredecessor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::token(input)) in_token = Traits::token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->token)::BaseType> token_fragment(
            fragment.message());
    mojo::internal::Serialize<::autofill::mojom::FrameTokenDataView>(
        in_token, token_fragment);
    fragment->token.Set(
        token_fragment.is_null() ? nullptr : token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null token in FrameTokenWithPredecessor struct");
    fragment->predecessor = Traits::predecessor(input);
  }

  static bool Deserialize(::autofill::mojom::internal::FrameTokenWithPredecessor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::autofill::mojom::FrameTokenWithPredecessorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::FormRendererIdDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::FormRendererIdDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::FormRendererId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->id = Traits::id(input);
  }

  static bool Deserialize(::autofill::mojom::internal::FormRendererId_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::autofill::mojom::FormRendererIdDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::FieldRendererIdDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::FieldRendererIdDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::FieldRendererId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->id = Traits::id(input);
  }

  static bool Deserialize(::autofill::mojom::internal::FieldRendererId_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::autofill::mojom::FieldRendererIdDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::SelectOptionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::SelectOptionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::SelectOption_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_value, value_fragment);
    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in SelectOption struct");
    decltype(Traits::text(input)) in_text = Traits::text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text)::BaseType> text_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_text, text_fragment);
    fragment->text.Set(
        text_fragment.is_null() ? nullptr : text_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->text.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text in SelectOption struct");
  }

  static bool Deserialize(::autofill::mojom::internal::SelectOption_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::autofill::mojom::SelectOptionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::SectionAutocompleteDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::SectionAutocompleteDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::SectionAutocomplete_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::section(input)) in_section = Traits::section(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->section)::BaseType> section_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_section, section_fragment);
    fragment->section.Set(
        section_fragment.is_null() ? nullptr : section_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->section.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null section in SectionAutocomplete struct");
    mojo::internal::Serialize<::autofill::mojom::HtmlFieldMode>(
        Traits::html_field_mode(input), &fragment->html_field_mode);
  }

  static bool Deserialize(::autofill::mojom::internal::SectionAutocomplete_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::autofill::mojom::SectionAutocompleteDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::SectionFieldIdentifierDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::SectionFieldIdentifierDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::SectionFieldIdentifier_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::field_name(input)) in_field_name = Traits::field_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->field_name)::BaseType> field_name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_field_name, field_name_fragment);
    fragment->field_name.Set(
        field_name_fragment.is_null() ? nullptr : field_name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->field_name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null field_name in SectionFieldIdentifier struct");
    fragment->local_frame_id = Traits::local_frame_id(input);
    decltype(Traits::field_renderer_id(input)) in_field_renderer_id = Traits::field_renderer_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->field_renderer_id)::BaseType> field_renderer_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
        in_field_renderer_id, field_renderer_id_fragment);
    fragment->field_renderer_id.Set(
        field_renderer_id_fragment.is_null() ? nullptr : field_renderer_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->field_renderer_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null field_renderer_id in SectionFieldIdentifier struct");
  }

  static bool Deserialize(::autofill::mojom::internal::SectionFieldIdentifier_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::autofill::mojom::SectionFieldIdentifierDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::SectionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::SectionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::Section_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<decltype(fragment->value)>
        value_fragment(fragment.message());
    value_fragment.Claim(&fragment->value);
    mojo::internal::Serialize<::autofill::mojom::SectionValueDataView>(
        in_value, value_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in Section struct");
  }

  static bool Deserialize(::autofill::mojom::internal::Section_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::autofill::mojom::SectionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::AutocompleteParsingResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::AutocompleteParsingResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::AutocompleteParsingResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::section(input)) in_section = Traits::section(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->section)::BaseType> section_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_section, section_fragment);
    fragment->section.Set(
        section_fragment.is_null() ? nullptr : section_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->section.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null section in AutocompleteParsingResult struct");
    mojo::internal::Serialize<::autofill::mojom::HtmlFieldMode>(
        Traits::mode(input), &fragment->mode);
    mojo::internal::Serialize<::autofill::mojom::HtmlFieldType>(
        Traits::field_type(input), &fragment->field_type);
    fragment->webauthn = Traits::webauthn(input);
  }

  static bool Deserialize(::autofill::mojom::internal::AutocompleteParsingResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::autofill::mojom::AutocompleteParsingResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::FormFieldDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::FormFieldDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::FormFieldData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_label, label_fragment);
    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->label.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null label in FormFieldData struct");
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in FormFieldData struct");
    decltype(Traits::id_attribute(input)) in_id_attribute = Traits::id_attribute(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id_attribute)::BaseType> id_attribute_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_id_attribute, id_attribute_fragment);
    fragment->id_attribute.Set(
        id_attribute_fragment.is_null() ? nullptr : id_attribute_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->id_attribute.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id_attribute in FormFieldData struct");
    decltype(Traits::name_attribute(input)) in_name_attribute = Traits::name_attribute(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name_attribute)::BaseType> name_attribute_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_name_attribute, name_attribute_fragment);
    fragment->name_attribute.Set(
        name_attribute_fragment.is_null() ? nullptr : name_attribute_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name_attribute.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name_attribute in FormFieldData struct");
    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_value, value_fragment);
    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in FormFieldData struct");
    decltype(Traits::selected_text(input)) in_selected_text = Traits::selected_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->selected_text)::BaseType> selected_text_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_selected_text, selected_text_fragment);
    fragment->selected_text.Set(
        selected_text_fragment.is_null() ? nullptr : selected_text_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->selected_text.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null selected_text in FormFieldData struct");
    mojo::internal::Serialize<::autofill::mojom::FormControlType>(
        Traits::form_control_type(input), &fragment->form_control_type);
    decltype(Traits::autocomplete_attribute(input)) in_autocomplete_attribute = Traits::autocomplete_attribute(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->autocomplete_attribute)::BaseType> autocomplete_attribute_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_autocomplete_attribute, autocomplete_attribute_fragment);
    fragment->autocomplete_attribute.Set(
        autocomplete_attribute_fragment.is_null() ? nullptr : autocomplete_attribute_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->autocomplete_attribute.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null autocomplete_attribute in FormFieldData struct");
    decltype(Traits::parsed_autocomplete(input)) in_parsed_autocomplete = Traits::parsed_autocomplete(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->parsed_autocomplete)::BaseType> parsed_autocomplete_fragment(
            fragment.message());
    mojo::internal::Serialize<::autofill::mojom::AutocompleteParsingResultDataView>(
        in_parsed_autocomplete, parsed_autocomplete_fragment);
    fragment->parsed_autocomplete.Set(
        parsed_autocomplete_fragment.is_null() ? nullptr : parsed_autocomplete_fragment.data());
    decltype(Traits::placeholder(input)) in_placeholder = Traits::placeholder(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->placeholder)::BaseType> placeholder_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_placeholder, placeholder_fragment);
    fragment->placeholder.Set(
        placeholder_fragment.is_null() ? nullptr : placeholder_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->placeholder.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null placeholder in FormFieldData struct");
    decltype(Traits::css_classes(input)) in_css_classes = Traits::css_classes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->css_classes)::BaseType> css_classes_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_css_classes, css_classes_fragment);
    fragment->css_classes.Set(
        css_classes_fragment.is_null() ? nullptr : css_classes_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->css_classes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null css_classes in FormFieldData struct");
    decltype(Traits::aria_label(input)) in_aria_label = Traits::aria_label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->aria_label)::BaseType> aria_label_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_aria_label, aria_label_fragment);
    fragment->aria_label.Set(
        aria_label_fragment.is_null() ? nullptr : aria_label_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->aria_label.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null aria_label in FormFieldData struct");
    decltype(Traits::aria_description(input)) in_aria_description = Traits::aria_description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->aria_description)::BaseType> aria_description_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_aria_description, aria_description_fragment);
    fragment->aria_description.Set(
        aria_description_fragment.is_null() ? nullptr : aria_description_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->aria_description.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null aria_description in FormFieldData struct");
    decltype(Traits::renderer_id(input)) in_renderer_id = Traits::renderer_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->renderer_id)::BaseType> renderer_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
        in_renderer_id, renderer_id_fragment);
    fragment->renderer_id.Set(
        renderer_id_fragment.is_null() ? nullptr : renderer_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->renderer_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null renderer_id in FormFieldData struct");
    decltype(Traits::host_form_id(input)) in_host_form_id = Traits::host_form_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->host_form_id)::BaseType> host_form_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::autofill::mojom::FormRendererIdDataView>(
        in_host_form_id, host_form_id_fragment);
    fragment->host_form_id.Set(
        host_form_id_fragment.is_null() ? nullptr : host_form_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->host_form_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null host_form_id in FormFieldData struct");
    fragment->properties_mask = Traits::properties_mask(input);
    fragment->form_control_ax_id = Traits::form_control_ax_id(input);
    fragment->max_length = Traits::max_length(input);
    fragment->is_user_edited = Traits::is_user_edited(input);
    fragment->is_autofilled = Traits::is_autofilled(input);
    decltype(Traits::section(input)) in_section = Traits::section(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->section)::BaseType> section_fragment(
            fragment.message());
    mojo::internal::Serialize<::autofill::mojom::SectionDataView>(
        in_section, section_fragment);
    fragment->section.Set(
        section_fragment.is_null() ? nullptr : section_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->section.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null section in FormFieldData struct");
    mojo::internal::Serialize<::autofill::mojom::FormFieldData_CheckStatus>(
        Traits::check_status(input), &fragment->check_status);
    fragment->is_focusable = Traits::is_focusable(input);
    fragment->is_visible = Traits::is_visible(input);
    fragment->should_autocomplete = Traits::should_autocomplete(input);
    mojo::internal::Serialize<::autofill::mojom::FormFieldData_RoleAttribute>(
        Traits::role(input), &fragment->role);
    mojo::internal::Serialize<::mojo_base::mojom::TextDirection>(
        Traits::text_direction(input), &fragment->text_direction);
    fragment->is_enabled = Traits::is_enabled(input);
    fragment->is_readonly = Traits::is_readonly(input);
    decltype(Traits::user_input(input)) in_user_input = Traits::user_input(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->user_input)::BaseType> user_input_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_user_input, user_input_fragment);
    fragment->user_input.Set(
        user_input_fragment.is_null() ? nullptr : user_input_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->user_input.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null user_input in FormFieldData struct");
    fragment->allows_writing_suggestions = Traits::allows_writing_suggestions(input);
    decltype(Traits::options(input)) in_options = Traits::options(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->options)::BaseType>
        options_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& options_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::autofill::mojom::SelectOptionDataView>>(
        in_options, options_fragment, &options_validate_params);
    fragment->options.Set(
        options_fragment.is_null() ? nullptr : options_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->options.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null options in FormFieldData struct");
    mojo::internal::Serialize<::autofill::mojom::FormFieldData_LabelSource>(
        Traits::label_source(input), &fragment->label_source);
    decltype(Traits::bounds(input)) in_bounds = Traits::bounds(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bounds)::BaseType> bounds_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
        in_bounds, bounds_fragment);
    fragment->bounds.Set(
        bounds_fragment.is_null() ? nullptr : bounds_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->bounds.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bounds in FormFieldData struct");
    decltype(Traits::datalist_options(input)) in_datalist_options = Traits::datalist_options(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->datalist_options)::BaseType>
        datalist_options_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& datalist_options_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::autofill::mojom::SelectOptionDataView>>(
        in_datalist_options, datalist_options_fragment, &datalist_options_validate_params);
    fragment->datalist_options.Set(
        datalist_options_fragment.is_null() ? nullptr : datalist_options_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->datalist_options.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null datalist_options in FormFieldData struct");
    fragment->force_override = Traits::force_override(input);
  }

  static bool Deserialize(::autofill::mojom::internal::FormFieldData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::autofill::mojom::FormFieldDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::FormFieldData_FillDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::FormFieldData_FillDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::FormFieldData_FillData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_value, value_fragment);
    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in FormFieldData_FillData struct");
    decltype(Traits::renderer_id(input)) in_renderer_id = Traits::renderer_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->renderer_id)::BaseType> renderer_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
        in_renderer_id, renderer_id_fragment);
    fragment->renderer_id.Set(
        renderer_id_fragment.is_null() ? nullptr : renderer_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->renderer_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null renderer_id in FormFieldData_FillData struct");
    decltype(Traits::host_form_id(input)) in_host_form_id = Traits::host_form_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->host_form_id)::BaseType> host_form_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::autofill::mojom::FormRendererIdDataView>(
        in_host_form_id, host_form_id_fragment);
    fragment->host_form_id.Set(
        host_form_id_fragment.is_null() ? nullptr : host_form_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->host_form_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null host_form_id in FormFieldData_FillData struct");
    fragment->is_autofilled = Traits::is_autofilled(input);
    fragment->force_override = Traits::force_override(input);
  }

  static bool Deserialize(::autofill::mojom::internal::FormFieldData_FillData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::autofill::mojom::FormFieldData_FillDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::ButtonTitleInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::ButtonTitleInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::ButtonTitleInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_title, title_fragment);
    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->title.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in ButtonTitleInfo struct");
    mojo::internal::Serialize<::autofill::mojom::ButtonTitleType>(
        Traits::type(input), &fragment->type);
  }

  static bool Deserialize(::autofill::mojom::internal::ButtonTitleInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::autofill::mojom::ButtonTitleInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::FormDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::FormDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::FormData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::id_attribute(input)) in_id_attribute = Traits::id_attribute(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id_attribute)::BaseType> id_attribute_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_id_attribute, id_attribute_fragment);
    fragment->id_attribute.Set(
        id_attribute_fragment.is_null() ? nullptr : id_attribute_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->id_attribute.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id_attribute in FormData struct");
    decltype(Traits::name_attribute(input)) in_name_attribute = Traits::name_attribute(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name_attribute)::BaseType> name_attribute_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_name_attribute, name_attribute_fragment);
    fragment->name_attribute.Set(
        name_attribute_fragment.is_null() ? nullptr : name_attribute_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name_attribute.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name_attribute in FormData struct");
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in FormData struct");
    decltype(Traits::button_titles(input)) in_button_titles = Traits::button_titles(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->button_titles)::BaseType>
        button_titles_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& button_titles_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::autofill::mojom::ButtonTitleInfoDataView>>(
        in_button_titles, button_titles_fragment, &button_titles_validate_params);
    fragment->button_titles.Set(
        button_titles_fragment.is_null() ? nullptr : button_titles_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->button_titles.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null button_titles in FormData struct");
    decltype(Traits::action(input)) in_action = Traits::action(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->action)::BaseType> action_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_action, action_fragment);
    fragment->action.Set(
        action_fragment.is_null() ? nullptr : action_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->action.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null action in FormData struct");
    fragment->is_action_empty = Traits::is_action_empty(input);
    decltype(Traits::renderer_id(input)) in_renderer_id = Traits::renderer_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->renderer_id)::BaseType> renderer_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::autofill::mojom::FormRendererIdDataView>(
        in_renderer_id, renderer_id_fragment);
    fragment->renderer_id.Set(
        renderer_id_fragment.is_null() ? nullptr : renderer_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->renderer_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null renderer_id in FormData struct");
    decltype(Traits::child_frames(input)) in_child_frames = Traits::child_frames(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->child_frames)::BaseType>
        child_frames_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& child_frames_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::autofill::mojom::FrameTokenWithPredecessorDataView>>(
        in_child_frames, child_frames_fragment, &child_frames_validate_params);
    fragment->child_frames.Set(
        child_frames_fragment.is_null() ? nullptr : child_frames_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->child_frames.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null child_frames in FormData struct");
    mojo::internal::Serialize<::autofill::mojom::SubmissionIndicatorEvent>(
        Traits::submission_event(input), &fragment->submission_event);
    decltype(Traits::fields(input)) in_fields = Traits::fields(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fields)::BaseType>
        fields_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& fields_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::autofill::mojom::FormFieldDataDataView>>(
        in_fields, fields_fragment, &fields_validate_params);
    fragment->fields.Set(
        fields_fragment.is_null() ? nullptr : fields_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->fields.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fields in FormData struct");
    decltype(Traits::username_predictions(input)) in_username_predictions = Traits::username_predictions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->username_predictions)::BaseType>
        username_predictions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& username_predictions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::autofill::mojom::FieldRendererIdDataView>>(
        in_username_predictions, username_predictions_fragment, &username_predictions_validate_params);
    fragment->username_predictions.Set(
        username_predictions_fragment.is_null() ? nullptr : username_predictions_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->username_predictions.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null username_predictions in FormData struct");
    fragment->is_gaia_with_skip_save_password_form = Traits::is_gaia_with_skip_save_password_form(input);
    fragment->likely_contains_captcha = Traits::likely_contains_captcha(input);
  }

  static bool Deserialize(::autofill::mojom::internal::FormData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::autofill::mojom::FormDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::FormFieldDataPredictionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::FormFieldDataPredictionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::FormFieldDataPredictions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::host_form_signature(input)) in_host_form_signature = Traits::host_form_signature(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->host_form_signature)::BaseType> host_form_signature_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_host_form_signature, host_form_signature_fragment);
    fragment->host_form_signature.Set(
        host_form_signature_fragment.is_null() ? nullptr : host_form_signature_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->host_form_signature.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null host_form_signature in FormFieldDataPredictions struct");
    decltype(Traits::signature(input)) in_signature = Traits::signature(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->signature)::BaseType> signature_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_signature, signature_fragment);
    fragment->signature.Set(
        signature_fragment.is_null() ? nullptr : signature_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->signature.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null signature in FormFieldDataPredictions struct");
    decltype(Traits::heuristic_type(input)) in_heuristic_type = Traits::heuristic_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->heuristic_type)::BaseType> heuristic_type_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_heuristic_type, heuristic_type_fragment);
    fragment->heuristic_type.Set(
        heuristic_type_fragment.is_null() ? nullptr : heuristic_type_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->heuristic_type.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null heuristic_type in FormFieldDataPredictions struct");
    decltype(Traits::server_type(input)) in_server_type = Traits::server_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->server_type)::BaseType> server_type_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_server_type, server_type_fragment);
    fragment->server_type.Set(
        server_type_fragment.is_null() ? nullptr : server_type_fragment.data());
    decltype(Traits::html_type(input)) in_html_type = Traits::html_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->html_type)::BaseType> html_type_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_html_type, html_type_fragment);
    fragment->html_type.Set(
        html_type_fragment.is_null() ? nullptr : html_type_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->html_type.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null html_type in FormFieldDataPredictions struct");
    decltype(Traits::overall_type(input)) in_overall_type = Traits::overall_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->overall_type)::BaseType> overall_type_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_overall_type, overall_type_fragment);
    fragment->overall_type.Set(
        overall_type_fragment.is_null() ? nullptr : overall_type_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->overall_type.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null overall_type in FormFieldDataPredictions struct");
    decltype(Traits::parseable_name(input)) in_parseable_name = Traits::parseable_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->parseable_name)::BaseType> parseable_name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_parseable_name, parseable_name_fragment);
    fragment->parseable_name.Set(
        parseable_name_fragment.is_null() ? nullptr : parseable_name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->parseable_name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null parseable_name in FormFieldDataPredictions struct");
    decltype(Traits::parseable_label(input)) in_parseable_label = Traits::parseable_label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->parseable_label)::BaseType> parseable_label_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_parseable_label, parseable_label_fragment);
    fragment->parseable_label.Set(
        parseable_label_fragment.is_null() ? nullptr : parseable_label_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->parseable_label.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null parseable_label in FormFieldDataPredictions struct");
    decltype(Traits::section(input)) in_section = Traits::section(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->section)::BaseType> section_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_section, section_fragment);
    fragment->section.Set(
        section_fragment.is_null() ? nullptr : section_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->section.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null section in FormFieldDataPredictions struct");
    fragment->rank = Traits::rank(input);
    fragment->rank_in_signature_group = Traits::rank_in_signature_group(input);
    fragment->rank_in_host_form = Traits::rank_in_host_form(input);
    fragment->rank_in_host_form_signature_group = Traits::rank_in_host_form_signature_group(input);
  }

  static bool Deserialize(::autofill::mojom::internal::FormFieldDataPredictions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::autofill::mojom::FormFieldDataPredictionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::FormDataPredictionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::FormDataPredictionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::FormDataPredictions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data)::BaseType> data_fragment(
            fragment.message());
    mojo::internal::Serialize<::autofill::mojom::FormDataDataView>(
        in_data, data_fragment);
    fragment->data.Set(
        data_fragment.is_null() ? nullptr : data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in FormDataPredictions struct");
    decltype(Traits::signature(input)) in_signature = Traits::signature(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->signature)::BaseType> signature_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_signature, signature_fragment);
    fragment->signature.Set(
        signature_fragment.is_null() ? nullptr : signature_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->signature.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null signature in FormDataPredictions struct");
    decltype(Traits::alternative_signature(input)) in_alternative_signature = Traits::alternative_signature(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->alternative_signature)::BaseType> alternative_signature_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_alternative_signature, alternative_signature_fragment);
    fragment->alternative_signature.Set(
        alternative_signature_fragment.is_null() ? nullptr : alternative_signature_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->alternative_signature.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null alternative_signature in FormDataPredictions struct");
    decltype(Traits::fields(input)) in_fields = Traits::fields(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fields)::BaseType>
        fields_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& fields_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::autofill::mojom::FormFieldDataPredictionsDataView>>(
        in_fields, fields_fragment, &fields_validate_params);
    fragment->fields.Set(
        fields_fragment.is_null() ? nullptr : fields_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->fields.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fields in FormDataPredictions struct");
  }

  static bool Deserialize(::autofill::mojom::internal::FormDataPredictions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::autofill::mojom::FormDataPredictionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::PasswordAndMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::PasswordAndMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::PasswordAndMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::username_value(input)) in_username_value = Traits::username_value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->username_value)::BaseType> username_value_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_username_value, username_value_fragment);
    fragment->username_value.Set(
        username_value_fragment.is_null() ? nullptr : username_value_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->username_value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null username_value in PasswordAndMetadata struct");
    decltype(Traits::password_value(input)) in_password_value = Traits::password_value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->password_value)::BaseType> password_value_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_password_value, password_value_fragment);
    fragment->password_value.Set(
        password_value_fragment.is_null() ? nullptr : password_value_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->password_value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null password_value in PasswordAndMetadata struct");
    decltype(Traits::realm(input)) in_realm = Traits::realm(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->realm)::BaseType> realm_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_realm, realm_fragment);
    fragment->realm.Set(
        realm_fragment.is_null() ? nullptr : realm_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->realm.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null realm in PasswordAndMetadata struct");
    fragment->uses_account_store = Traits::uses_account_store(input);
    fragment->is_grouped_affiliation = Traits::is_grouped_affiliation(input);
  }

  static bool Deserialize(::autofill::mojom::internal::PasswordAndMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::autofill::mojom::PasswordAndMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::PasswordFormFillDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::PasswordFormFillDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::PasswordFormFillData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::form_renderer_id(input)) in_form_renderer_id = Traits::form_renderer_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->form_renderer_id)::BaseType> form_renderer_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::autofill::mojom::FormRendererIdDataView>(
        in_form_renderer_id, form_renderer_id_fragment);
    fragment->form_renderer_id.Set(
        form_renderer_id_fragment.is_null() ? nullptr : form_renderer_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->form_renderer_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null form_renderer_id in PasswordFormFillData struct");
    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, url_fragment);
    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in PasswordFormFillData struct");
    decltype(Traits::username_element_renderer_id(input)) in_username_element_renderer_id = Traits::username_element_renderer_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->username_element_renderer_id)::BaseType> username_element_renderer_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
        in_username_element_renderer_id, username_element_renderer_id_fragment);
    fragment->username_element_renderer_id.Set(
        username_element_renderer_id_fragment.is_null() ? nullptr : username_element_renderer_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->username_element_renderer_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null username_element_renderer_id in PasswordFormFillData struct");
    decltype(Traits::password_element_renderer_id(input)) in_password_element_renderer_id = Traits::password_element_renderer_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->password_element_renderer_id)::BaseType> password_element_renderer_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
        in_password_element_renderer_id, password_element_renderer_id_fragment);
    fragment->password_element_renderer_id.Set(
        password_element_renderer_id_fragment.is_null() ? nullptr : password_element_renderer_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->password_element_renderer_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null password_element_renderer_id in PasswordFormFillData struct");
    fragment->username_may_use_prefilled_placeholder = Traits::username_may_use_prefilled_placeholder(input);
    decltype(Traits::preferred_login(input)) in_preferred_login = Traits::preferred_login(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->preferred_login)::BaseType> preferred_login_fragment(
            fragment.message());
    mojo::internal::Serialize<::autofill::mojom::PasswordAndMetadataDataView>(
        in_preferred_login, preferred_login_fragment);
    fragment->preferred_login.Set(
        preferred_login_fragment.is_null() ? nullptr : preferred_login_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->preferred_login.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null preferred_login in PasswordFormFillData struct");
    decltype(Traits::additional_logins(input)) in_additional_logins = Traits::additional_logins(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->additional_logins)::BaseType>
        additional_logins_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& additional_logins_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::autofill::mojom::PasswordAndMetadataDataView>>(
        in_additional_logins, additional_logins_fragment, &additional_logins_validate_params);
    fragment->additional_logins.Set(
        additional_logins_fragment.is_null() ? nullptr : additional_logins_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->additional_logins.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null additional_logins in PasswordFormFillData struct");
    fragment->wait_for_username = Traits::wait_for_username(input);
    decltype(Traits::suggestion_banned_fields(input)) in_suggestion_banned_fields = Traits::suggestion_banned_fields(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->suggestion_banned_fields)::BaseType>
        suggestion_banned_fields_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& suggestion_banned_fields_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::autofill::mojom::FieldRendererIdDataView>>(
        in_suggestion_banned_fields, suggestion_banned_fields_fragment, &suggestion_banned_fields_validate_params);
    fragment->suggestion_banned_fields.Set(
        suggestion_banned_fields_fragment.is_null() ? nullptr : suggestion_banned_fields_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->suggestion_banned_fields.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null suggestion_banned_fields in PasswordFormFillData struct");
    fragment->notify_browser_of_successful_filling = Traits::notify_browser_of_successful_filling(input);
  }

  static bool Deserialize(::autofill::mojom::internal::PasswordFormFillData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::autofill::mojom::PasswordFormFillDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::PasswordFormGenerationDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::PasswordFormGenerationDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::PasswordFormGenerationData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::new_password_renderer_id(input)) in_new_password_renderer_id = Traits::new_password_renderer_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->new_password_renderer_id)::BaseType> new_password_renderer_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
        in_new_password_renderer_id, new_password_renderer_id_fragment);
    fragment->new_password_renderer_id.Set(
        new_password_renderer_id_fragment.is_null() ? nullptr : new_password_renderer_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->new_password_renderer_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null new_password_renderer_id in PasswordFormGenerationData struct");
    decltype(Traits::confirmation_password_renderer_id(input)) in_confirmation_password_renderer_id = Traits::confirmation_password_renderer_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->confirmation_password_renderer_id)::BaseType> confirmation_password_renderer_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
        in_confirmation_password_renderer_id, confirmation_password_renderer_id_fragment);
    fragment->confirmation_password_renderer_id.Set(
        confirmation_password_renderer_id_fragment.is_null() ? nullptr : confirmation_password_renderer_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->confirmation_password_renderer_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null confirmation_password_renderer_id in PasswordFormGenerationData struct");
  }

  static bool Deserialize(::autofill::mojom::internal::PasswordFormGenerationData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::autofill::mojom::PasswordFormGenerationDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::PasswordGenerationUIDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::PasswordGenerationUIDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::PasswordGenerationUIData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::bounds(input)) in_bounds = Traits::bounds(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bounds)::BaseType> bounds_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
        in_bounds, bounds_fragment);
    fragment->bounds.Set(
        bounds_fragment.is_null() ? nullptr : bounds_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->bounds.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bounds in PasswordGenerationUIData struct");
    fragment->max_length = Traits::max_length(input);
    decltype(Traits::generation_element(input)) in_generation_element = Traits::generation_element(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->generation_element)::BaseType> generation_element_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_generation_element, generation_element_fragment);
    fragment->generation_element.Set(
        generation_element_fragment.is_null() ? nullptr : generation_element_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->generation_element.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null generation_element in PasswordGenerationUIData struct");
    decltype(Traits::generation_element_id(input)) in_generation_element_id = Traits::generation_element_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->generation_element_id)::BaseType> generation_element_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
        in_generation_element_id, generation_element_id_fragment);
    fragment->generation_element_id.Set(
        generation_element_id_fragment.is_null() ? nullptr : generation_element_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->generation_element_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null generation_element_id in PasswordGenerationUIData struct");
    fragment->is_generation_element_password_type = Traits::is_generation_element_password_type(input);
    mojo::internal::Serialize<::mojo_base::mojom::TextDirection>(
        Traits::text_direction(input), &fragment->text_direction);
    decltype(Traits::form_data(input)) in_form_data = Traits::form_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->form_data)::BaseType> form_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::autofill::mojom::FormDataDataView>(
        in_form_data, form_data_fragment);
    fragment->form_data.Set(
        form_data_fragment.is_null() ? nullptr : form_data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->form_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null form_data in PasswordGenerationUIData struct");
    fragment->generation_rejected = Traits::generation_rejected(input);
  }

  static bool Deserialize(::autofill::mojom::internal::PasswordGenerationUIData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::autofill::mojom::PasswordGenerationUIDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::PasswordSuggestionRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::PasswordSuggestionRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::PasswordSuggestionRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::element_id(input)) in_element_id = Traits::element_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->element_id)::BaseType> element_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
        in_element_id, element_id_fragment);
    fragment->element_id.Set(
        element_id_fragment.is_null() ? nullptr : element_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->element_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null element_id in PasswordSuggestionRequest struct");
    decltype(Traits::form_data(input)) in_form_data = Traits::form_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->form_data)::BaseType> form_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::autofill::mojom::FormDataDataView>(
        in_form_data, form_data_fragment);
    fragment->form_data.Set(
        form_data_fragment.is_null() ? nullptr : form_data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->form_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null form_data in PasswordSuggestionRequest struct");
    mojo::internal::Serialize<::autofill::mojom::AutofillSuggestionTriggerSource>(
        Traits::trigger_source(input), &fragment->trigger_source);
    fragment->username_field_index = Traits::username_field_index(input);
    fragment->password_field_index = Traits::password_field_index(input);
    mojo::internal::Serialize<::mojo_base::mojom::TextDirection>(
        Traits::text_direction(input), &fragment->text_direction);
    decltype(Traits::typed_username(input)) in_typed_username = Traits::typed_username(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->typed_username)::BaseType> typed_username_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_typed_username, typed_username_fragment);
    fragment->typed_username.Set(
        typed_username_fragment.is_null() ? nullptr : typed_username_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->typed_username.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null typed_username in PasswordSuggestionRequest struct");
    fragment->show_webauthn_credentials = Traits::show_webauthn_credentials(input);
    decltype(Traits::bounds(input)) in_bounds = Traits::bounds(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bounds)::BaseType> bounds_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
        in_bounds, bounds_fragment);
    fragment->bounds.Set(
        bounds_fragment.is_null() ? nullptr : bounds_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->bounds.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bounds in PasswordSuggestionRequest struct");
  }

  static bool Deserialize(::autofill::mojom::internal::PasswordSuggestionRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::autofill::mojom::PasswordSuggestionRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::ParsingResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::ParsingResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::ParsingResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::username_renderer_id(input)) in_username_renderer_id = Traits::username_renderer_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->username_renderer_id)::BaseType> username_renderer_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
        in_username_renderer_id, username_renderer_id_fragment);
    fragment->username_renderer_id.Set(
        username_renderer_id_fragment.is_null() ? nullptr : username_renderer_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->username_renderer_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null username_renderer_id in ParsingResult struct");
    decltype(Traits::password_renderer_id(input)) in_password_renderer_id = Traits::password_renderer_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->password_renderer_id)::BaseType> password_renderer_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
        in_password_renderer_id, password_renderer_id_fragment);
    fragment->password_renderer_id.Set(
        password_renderer_id_fragment.is_null() ? nullptr : password_renderer_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->password_renderer_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null password_renderer_id in ParsingResult struct");
    decltype(Traits::new_password_renderer_id(input)) in_new_password_renderer_id = Traits::new_password_renderer_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->new_password_renderer_id)::BaseType> new_password_renderer_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
        in_new_password_renderer_id, new_password_renderer_id_fragment);
    fragment->new_password_renderer_id.Set(
        new_password_renderer_id_fragment.is_null() ? nullptr : new_password_renderer_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->new_password_renderer_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null new_password_renderer_id in ParsingResult struct");
    decltype(Traits::confirm_password_renderer_id(input)) in_confirm_password_renderer_id = Traits::confirm_password_renderer_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->confirm_password_renderer_id)::BaseType> confirm_password_renderer_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
        in_confirm_password_renderer_id, confirm_password_renderer_id_fragment);
    fragment->confirm_password_renderer_id.Set(
        confirm_password_renderer_id_fragment.is_null() ? nullptr : confirm_password_renderer_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->confirm_password_renderer_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null confirm_password_renderer_id in ParsingResult struct");
  }

  static bool Deserialize(::autofill::mojom::internal::ParsingResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::autofill::mojom::ParsingResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::autofill::mojom::SectionValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::autofill::mojom::SectionValueDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::autofill::mojom::internal::SectionValue_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::autofill::mojom::SectionValueDataView::Tag::kDefaultSection: {
        decltype(Traits::default_section(input))
            in_default_section = Traits::default_section(input);
        fragment->data.f_default_section = in_default_section;
        break;
      }
      case ::autofill::mojom::SectionValueDataView::Tag::kAutocomplete: {
        decltype(Traits::autocomplete(input))
            in_autocomplete = Traits::autocomplete(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_autocomplete)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::autofill::mojom::SectionAutocompleteDataView>(
            in_autocomplete, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null autocomplete in SectionValue union");
        fragment->data.f_autocomplete.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::autofill::mojom::SectionValueDataView::Tag::kFieldIdentifier: {
        decltype(Traits::field_identifier(input))
            in_field_identifier = Traits::field_identifier(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_field_identifier)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::autofill::mojom::SectionFieldIdentifierDataView>(
            in_field_identifier, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null field_identifier in SectionValue union");
        fragment->data.f_field_identifier.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::autofill::mojom::internal::SectionValue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::autofill::mojom::SectionValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace autofill::mojom {

inline void FrameTokenDataView::GetTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void FrameTokenWithPredecessorDataView::GetTokenDataView(
    FrameTokenDataView* output) {
  auto pointer = data_->token.Get();
  *output = FrameTokenDataView(pointer, message_);
}






inline void SelectOptionDataView::GetValueDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->value.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void SelectOptionDataView::GetTextDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->text.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void SectionAutocompleteDataView::GetSectionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->section.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void SectionFieldIdentifierDataView::GetFieldNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->field_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SectionFieldIdentifierDataView::GetFieldRendererIdDataView(
    FieldRendererIdDataView* output) {
  auto pointer = data_->field_renderer_id.Get();
  *output = FieldRendererIdDataView(pointer, message_);
}


inline void SectionDataView::GetValueDataView(
    SectionValueDataView* output) {
  auto pointer = &data_->value;
  *output = SectionValueDataView(pointer, message_);
}


inline void AutocompleteParsingResultDataView::GetSectionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->section.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void FormFieldDataDataView::GetLabelDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->label.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void FormFieldDataDataView::GetNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void FormFieldDataDataView::GetIdAttributeDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->id_attribute.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void FormFieldDataDataView::GetNameAttributeDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->name_attribute.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void FormFieldDataDataView::GetValueDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->value.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void FormFieldDataDataView::GetSelectedTextDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->selected_text.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void FormFieldDataDataView::GetAutocompleteAttributeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->autocomplete_attribute.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FormFieldDataDataView::GetParsedAutocompleteDataView(
    AutocompleteParsingResultDataView* output) {
  auto pointer = data_->parsed_autocomplete.Get();
  *output = AutocompleteParsingResultDataView(pointer, message_);
}
inline void FormFieldDataDataView::GetPlaceholderDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->placeholder.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void FormFieldDataDataView::GetCssClassesDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->css_classes.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void FormFieldDataDataView::GetAriaLabelDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->aria_label.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void FormFieldDataDataView::GetAriaDescriptionDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->aria_description.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void FormFieldDataDataView::GetRendererIdDataView(
    FieldRendererIdDataView* output) {
  auto pointer = data_->renderer_id.Get();
  *output = FieldRendererIdDataView(pointer, message_);
}
inline void FormFieldDataDataView::GetHostFormIdDataView(
    FormRendererIdDataView* output) {
  auto pointer = data_->host_form_id.Get();
  *output = FormRendererIdDataView(pointer, message_);
}
inline void FormFieldDataDataView::GetSectionDataView(
    SectionDataView* output) {
  auto pointer = data_->section.Get();
  *output = SectionDataView(pointer, message_);
}
inline void FormFieldDataDataView::GetUserInputDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->user_input.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void FormFieldDataDataView::GetOptionsDataView(
    mojo::ArrayDataView<SelectOptionDataView>* output) {
  auto pointer = data_->options.Get();
  *output = mojo::ArrayDataView<SelectOptionDataView>(pointer, message_);
}
inline void FormFieldDataDataView::GetBoundsDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->bounds.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, message_);
}
inline void FormFieldDataDataView::GetDatalistOptionsDataView(
    mojo::ArrayDataView<SelectOptionDataView>* output) {
  auto pointer = data_->datalist_options.Get();
  *output = mojo::ArrayDataView<SelectOptionDataView>(pointer, message_);
}


inline void FormFieldData_FillDataDataView::GetValueDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->value.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void FormFieldData_FillDataDataView::GetRendererIdDataView(
    FieldRendererIdDataView* output) {
  auto pointer = data_->renderer_id.Get();
  *output = FieldRendererIdDataView(pointer, message_);
}
inline void FormFieldData_FillDataDataView::GetHostFormIdDataView(
    FormRendererIdDataView* output) {
  auto pointer = data_->host_form_id.Get();
  *output = FormRendererIdDataView(pointer, message_);
}


inline void ButtonTitleInfoDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void FormDataDataView::GetIdAttributeDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->id_attribute.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void FormDataDataView::GetNameAttributeDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->name_attribute.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void FormDataDataView::GetNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void FormDataDataView::GetButtonTitlesDataView(
    mojo::ArrayDataView<ButtonTitleInfoDataView>* output) {
  auto pointer = data_->button_titles.Get();
  *output = mojo::ArrayDataView<ButtonTitleInfoDataView>(pointer, message_);
}
inline void FormDataDataView::GetActionDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->action.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void FormDataDataView::GetRendererIdDataView(
    FormRendererIdDataView* output) {
  auto pointer = data_->renderer_id.Get();
  *output = FormRendererIdDataView(pointer, message_);
}
inline void FormDataDataView::GetChildFramesDataView(
    mojo::ArrayDataView<FrameTokenWithPredecessorDataView>* output) {
  auto pointer = data_->child_frames.Get();
  *output = mojo::ArrayDataView<FrameTokenWithPredecessorDataView>(pointer, message_);
}
inline void FormDataDataView::GetFieldsDataView(
    mojo::ArrayDataView<FormFieldDataDataView>* output) {
  auto pointer = data_->fields.Get();
  *output = mojo::ArrayDataView<FormFieldDataDataView>(pointer, message_);
}
inline void FormDataDataView::GetUsernamePredictionsDataView(
    mojo::ArrayDataView<FieldRendererIdDataView>* output) {
  auto pointer = data_->username_predictions.Get();
  *output = mojo::ArrayDataView<FieldRendererIdDataView>(pointer, message_);
}


inline void FormFieldDataPredictionsDataView::GetHostFormSignatureDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->host_form_signature.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FormFieldDataPredictionsDataView::GetSignatureDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->signature.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FormFieldDataPredictionsDataView::GetHeuristicTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->heuristic_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FormFieldDataPredictionsDataView::GetServerTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->server_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FormFieldDataPredictionsDataView::GetHtmlTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->html_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FormFieldDataPredictionsDataView::GetOverallTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->overall_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FormFieldDataPredictionsDataView::GetParseableNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->parseable_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FormFieldDataPredictionsDataView::GetParseableLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->parseable_label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FormFieldDataPredictionsDataView::GetSectionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->section.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void FormDataPredictionsDataView::GetDataDataView(
    FormDataDataView* output) {
  auto pointer = data_->data.Get();
  *output = FormDataDataView(pointer, message_);
}
inline void FormDataPredictionsDataView::GetSignatureDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->signature.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FormDataPredictionsDataView::GetAlternativeSignatureDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->alternative_signature.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FormDataPredictionsDataView::GetFieldsDataView(
    mojo::ArrayDataView<FormFieldDataPredictionsDataView>* output) {
  auto pointer = data_->fields.Get();
  *output = mojo::ArrayDataView<FormFieldDataPredictionsDataView>(pointer, message_);
}


inline void PasswordAndMetadataDataView::GetUsernameValueDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->username_value.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void PasswordAndMetadataDataView::GetPasswordValueDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->password_value.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void PasswordAndMetadataDataView::GetRealmDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->realm.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PasswordFormFillDataDataView::GetFormRendererIdDataView(
    FormRendererIdDataView* output) {
  auto pointer = data_->form_renderer_id.Get();
  *output = FormRendererIdDataView(pointer, message_);
}
inline void PasswordFormFillDataDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void PasswordFormFillDataDataView::GetUsernameElementRendererIdDataView(
    FieldRendererIdDataView* output) {
  auto pointer = data_->username_element_renderer_id.Get();
  *output = FieldRendererIdDataView(pointer, message_);
}
inline void PasswordFormFillDataDataView::GetPasswordElementRendererIdDataView(
    FieldRendererIdDataView* output) {
  auto pointer = data_->password_element_renderer_id.Get();
  *output = FieldRendererIdDataView(pointer, message_);
}
inline void PasswordFormFillDataDataView::GetPreferredLoginDataView(
    PasswordAndMetadataDataView* output) {
  auto pointer = data_->preferred_login.Get();
  *output = PasswordAndMetadataDataView(pointer, message_);
}
inline void PasswordFormFillDataDataView::GetAdditionalLoginsDataView(
    mojo::ArrayDataView<PasswordAndMetadataDataView>* output) {
  auto pointer = data_->additional_logins.Get();
  *output = mojo::ArrayDataView<PasswordAndMetadataDataView>(pointer, message_);
}
inline void PasswordFormFillDataDataView::GetSuggestionBannedFieldsDataView(
    mojo::ArrayDataView<FieldRendererIdDataView>* output) {
  auto pointer = data_->suggestion_banned_fields.Get();
  *output = mojo::ArrayDataView<FieldRendererIdDataView>(pointer, message_);
}


inline void PasswordFormGenerationDataDataView::GetNewPasswordRendererIdDataView(
    FieldRendererIdDataView* output) {
  auto pointer = data_->new_password_renderer_id.Get();
  *output = FieldRendererIdDataView(pointer, message_);
}
inline void PasswordFormGenerationDataDataView::GetConfirmationPasswordRendererIdDataView(
    FieldRendererIdDataView* output) {
  auto pointer = data_->confirmation_password_renderer_id.Get();
  *output = FieldRendererIdDataView(pointer, message_);
}


inline void PasswordGenerationUIDataDataView::GetBoundsDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->bounds.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, message_);
}
inline void PasswordGenerationUIDataDataView::GetGenerationElementDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->generation_element.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void PasswordGenerationUIDataDataView::GetGenerationElementIdDataView(
    FieldRendererIdDataView* output) {
  auto pointer = data_->generation_element_id.Get();
  *output = FieldRendererIdDataView(pointer, message_);
}
inline void PasswordGenerationUIDataDataView::GetFormDataDataView(
    FormDataDataView* output) {
  auto pointer = data_->form_data.Get();
  *output = FormDataDataView(pointer, message_);
}


inline void PasswordSuggestionRequestDataView::GetElementIdDataView(
    FieldRendererIdDataView* output) {
  auto pointer = data_->element_id.Get();
  *output = FieldRendererIdDataView(pointer, message_);
}
inline void PasswordSuggestionRequestDataView::GetFormDataDataView(
    FormDataDataView* output) {
  auto pointer = data_->form_data.Get();
  *output = FormDataDataView(pointer, message_);
}
inline void PasswordSuggestionRequestDataView::GetTypedUsernameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->typed_username.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void PasswordSuggestionRequestDataView::GetBoundsDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->bounds.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, message_);
}


inline void ParsingResultDataView::GetUsernameRendererIdDataView(
    FieldRendererIdDataView* output) {
  auto pointer = data_->username_renderer_id.Get();
  *output = FieldRendererIdDataView(pointer, message_);
}
inline void ParsingResultDataView::GetPasswordRendererIdDataView(
    FieldRendererIdDataView* output) {
  auto pointer = data_->password_renderer_id.Get();
  *output = FieldRendererIdDataView(pointer, message_);
}
inline void ParsingResultDataView::GetNewPasswordRendererIdDataView(
    FieldRendererIdDataView* output) {
  auto pointer = data_->new_password_renderer_id.Get();
  *output = FieldRendererIdDataView(pointer, message_);
}
inline void ParsingResultDataView::GetConfirmPasswordRendererIdDataView(
    FieldRendererIdDataView* output) {
  auto pointer = data_->confirm_password_renderer_id.Get();
  *output = FieldRendererIdDataView(pointer, message_);
}


inline void SectionValueDataView::GetAutocompleteDataView(
    SectionAutocompleteDataView* output) const {
  CHECK(is_autocomplete());
  *output = SectionAutocompleteDataView(data_->data.f_autocomplete.Get(), message_);
}
inline void SectionValueDataView::GetFieldIdentifierDataView(
    SectionFieldIdentifierDataView* output) const {
  CHECK(is_field_identifier());
  *output = SectionFieldIdentifierDataView(data_->data.f_field_identifier.Get(), message_);
}


}  // autofill::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::autofill::mojom::FormControlType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::autofill::mojom::FormControlType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::autofill::mojom::HtmlFieldMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::autofill::mojom::HtmlFieldMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::autofill::mojom::HtmlFieldType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::autofill::mojom::HtmlFieldType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::autofill::mojom::SubmissionIndicatorEvent> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::autofill::mojom::SubmissionIndicatorEvent value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::autofill::mojom::SubmissionSource> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::autofill::mojom::SubmissionSource value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::autofill::mojom::FocusedFieldType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::autofill::mojom::FocusedFieldType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::autofill::mojom::ButtonTitleType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::autofill::mojom::ButtonTitleType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::autofill::mojom::SubmissionReadinessState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::autofill::mojom::SubmissionReadinessState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::autofill::mojom::AutofillSuggestionAvailability> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::autofill::mojom::AutofillSuggestionAvailability value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::autofill::mojom::ActionPersistence> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::autofill::mojom::ActionPersistence value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::autofill::mojom::FormActionType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::autofill::mojom::FormActionType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::autofill::mojom::FieldActionType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::autofill::mojom::FieldActionType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::autofill::mojom::AutofillSuggestionTriggerSource> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::autofill::mojom::AutofillSuggestionTriggerSource value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::autofill::mojom::FormFieldData_CheckStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::autofill::mojom::FormFieldData_CheckStatus value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::autofill::mojom::FormFieldData_RoleAttribute> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::autofill::mojom::FormFieldData_RoleAttribute value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::autofill::mojom::FormFieldData_LabelSource> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::autofill::mojom::FormFieldData_LabelSource value);
};

} // namespace perfetto

#endif  // COMPONENTS_AUTOFILL_CORE_COMMON_MOJOM_AUTOFILL_TYPES_MOJOM_SHARED_H_