// components/services/unzip/public/mojom/unzipper.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_UNZIP_PUBLIC_MOJOM_UNZIPPER_MOJOM_SHARED_H_
#define COMPONENTS_SERVICES_UNZIP_PUBLIC_MOJOM_UNZIPPER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/unzip/public/mojom/unzipper.mojom-shared-internal.h"
#include "components/services/storage/public/mojom/filesystem/directory.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace unzip::mojom {
class UnzipOptionsDataView;

class InfoDataView;



}  // unzip::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::unzip::mojom::UnzipOptionsDataView> {
  using Data = ::unzip::mojom::internal::UnzipOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::unzip::mojom::InfoDataView> {
  using Data = ::unzip::mojom::internal::Info_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace unzip::mojom {
// Interface base classes. They are used for type safety check.
class UnzipFilterInterfaceBase {};

using UnzipFilterPtrDataView =
    mojo::InterfacePtrDataView<UnzipFilterInterfaceBase>;
using UnzipFilterRequestDataView =
    mojo::InterfaceRequestDataView<UnzipFilterInterfaceBase>;
using UnzipFilterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UnzipFilterInterfaceBase>;
using UnzipFilterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UnzipFilterInterfaceBase>;
class UnzipListenerInterfaceBase {};

using UnzipListenerPtrDataView =
    mojo::InterfacePtrDataView<UnzipListenerInterfaceBase>;
using UnzipListenerRequestDataView =
    mojo::InterfaceRequestDataView<UnzipListenerInterfaceBase>;
using UnzipListenerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UnzipListenerInterfaceBase>;
using UnzipListenerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UnzipListenerInterfaceBase>;
class UnzipperInterfaceBase {};

using UnzipperPtrDataView =
    mojo::InterfacePtrDataView<UnzipperInterfaceBase>;
using UnzipperRequestDataView =
    mojo::InterfaceRequestDataView<UnzipperInterfaceBase>;
using UnzipperAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UnzipperInterfaceBase>;
using UnzipperAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UnzipperInterfaceBase>;


class UnzipOptionsDataView {
 public:
  UnzipOptionsDataView() = default;

  UnzipOptionsDataView(
      internal::UnzipOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEncodingDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEncoding(UserType* output) {
    
    auto* pointer = data_->encoding.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPasswordDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPassword(UserType* output) {
    
    auto* pointer = data_->password.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::UnzipOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class InfoDataView {
 public:
  InfoDataView() = default;

  InfoDataView(
      internal::Info_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool size_is_valid() const {
    return data_->size_is_valid;
  }
  uint64_t size() const {
    return data_->size;
  }
  bool is_encrypted() const {
    return data_->is_encrypted;
  }
  bool uses_aes_encryption() const {
    return data_->uses_aes_encryption;
  }
 private:
  internal::Info_Data* data_ = nullptr;
};


}  // unzip::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::unzip::mojom::UnzipOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::unzip::mojom::UnzipOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::unzip::mojom::internal::UnzipOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::encoding(input)) in_encoding = Traits::encoding(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->encoding)::BaseType> encoding_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_encoding, encoding_fragment);
    fragment->encoding.Set(
        encoding_fragment.is_null() ? nullptr : encoding_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->encoding.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null encoding in UnzipOptions struct");
    decltype(Traits::password(input)) in_password = Traits::password(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->password)::BaseType> password_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_password, password_fragment);
    fragment->password.Set(
        password_fragment.is_null() ? nullptr : password_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->password.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null password in UnzipOptions struct");
  }

  static bool Deserialize(::unzip::mojom::internal::UnzipOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::unzip::mojom::UnzipOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::unzip::mojom::InfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::unzip::mojom::InfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::unzip::mojom::internal::Info_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->size_is_valid = Traits::size_is_valid(input);
    fragment->size = Traits::size(input);
    fragment->is_encrypted = Traits::is_encrypted(input);
    fragment->uses_aes_encryption = Traits::uses_aes_encryption(input);
  }

  static bool Deserialize(::unzip::mojom::internal::Info_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::unzip::mojom::InfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace unzip::mojom {

inline void UnzipOptionsDataView::GetEncodingDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->encoding.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void UnzipOptionsDataView::GetPasswordDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->password.Get();
  *output = mojo::StringDataView(pointer, message_);
}





}  // unzip::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // COMPONENTS_SERVICES_UNZIP_PUBLIC_MOJOM_UNZIPPER_MOJOM_SHARED_H_