// extensions/common/mojom/code_injection.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_CODE_INJECTION_MOJOM_SHARED_INTERNAL_H_
#define EXTENSIONS_COMMON_MOJOM_CODE_INJECTION_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "extensions/common/mojom/css_origin.mojom-shared-internal.h"
#include "extensions/common/mojom/execution_world.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/script/script_evaluation_params.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace extensions::mojom {
namespace internal {
class JSSource_Data;
class CSSSource_Data;
class JSInjection_Data;
class CSSInjection_Data;
class CodeInjection_Data;

struct CSSInjection_Operation_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)


class  CodeInjection_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  CodeInjection_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~CodeInjection_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<CodeInjection_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class CodeInjection_Tag : uint32_t {

    
    kCss,
    
    kJs,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::CSSInjection_Data> f_css;
    mojo::internal::Pointer<internal::JSInjection_Data> f_js;
    uint64_t unknown;
  };

  uint32_t size;
  CodeInjection_Tag tag;
  Union_ data;
};
static_assert(sizeof(CodeInjection_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(CodeInjection_Data)");
class  JSSource_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> code;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> script_url;

 private:
  friend class mojo::internal::MessageFragment<JSSource_Data>;

  JSSource_Data();
  ~JSSource_Data() = delete;
};
static_assert(sizeof(JSSource_Data) == 24,
              "Bad sizeof(JSSource_Data)");
// Used by JSSource::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct JSSource_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  JSSource_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~JSSource_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<JSSource_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    JSSource_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  CSSSource_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> code;
  mojo::internal::Pointer<mojo::internal::String_Data> key;

 private:
  friend class mojo::internal::MessageFragment<CSSSource_Data>;

  CSSSource_Data();
  ~CSSSource_Data() = delete;
};
static_assert(sizeof(CSSSource_Data) == 24,
              "Bad sizeof(CSSSource_Data)");
// Used by CSSSource::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CSSSource_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CSSSource_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CSSSource_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CSSSource_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CSSSource_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  JSInjection_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::JSSource_Data>>> sources;
  int32_t world;
  int32_t wants_result;
  mojo::internal::Pointer<mojo::internal::String_Data> world_id;
  int32_t user_gesture;
  int32_t wait_for_promise;

 private:
  friend class mojo::internal::MessageFragment<JSInjection_Data>;

  JSInjection_Data();
  ~JSInjection_Data() = delete;
};
static_assert(sizeof(JSInjection_Data) == 40,
              "Bad sizeof(JSInjection_Data)");
// Used by JSInjection::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct JSInjection_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  JSInjection_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~JSInjection_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<JSInjection_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    JSInjection_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  CSSInjection_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::CSSSource_Data>>> sources;
  int32_t css_origin;
  int32_t operation;

 private:
  friend class mojo::internal::MessageFragment<CSSInjection_Data>;

  CSSInjection_Data();
  ~CSSInjection_Data() = delete;
};
static_assert(sizeof(CSSInjection_Data) == 24,
              "Bad sizeof(CSSInjection_Data)");
// Used by CSSInjection::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CSSInjection_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CSSInjection_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CSSInjection_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CSSInjection_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CSSInjection_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // extensions::mojom

#endif  // EXTENSIONS_COMMON_MOJOM_CODE_INJECTION_MOJOM_SHARED_INTERNAL_H_