// ipc/ipc.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef IPC_IPC_MOJOM_SHARED_H_
#define IPC_IPC_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ipc/ipc.mojom-shared-internal.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared.h"
#include "mojo/public/mojom/base/generic_pending_associated_receiver.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace IPC::mojom {
class MessageDataView;



}  // IPC::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::IPC::mojom::MessageDataView> {
  using Data = ::IPC::mojom::internal::Message_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace IPC::mojom {
// Interface base classes. They are used for type safety check.
class ChannelInterfaceBase {};

using ChannelPtrDataView =
    mojo::InterfacePtrDataView<ChannelInterfaceBase>;
using ChannelRequestDataView =
    mojo::InterfaceRequestDataView<ChannelInterfaceBase>;
using ChannelAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ChannelInterfaceBase>;
using ChannelAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ChannelInterfaceBase>;
class ChannelBootstrapInterfaceBase {};

using ChannelBootstrapPtrDataView =
    mojo::InterfacePtrDataView<ChannelBootstrapInterfaceBase>;
using ChannelBootstrapRequestDataView =
    mojo::InterfaceRequestDataView<ChannelBootstrapInterfaceBase>;
using ChannelBootstrapAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ChannelBootstrapInterfaceBase>;
using ChannelBootstrapAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ChannelBootstrapInterfaceBase>;


class MessageDataView {
 public:
  MessageDataView() = default;

  MessageDataView(
      internal::Message_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBytesDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBytes(UserType* output) {
    
    auto* pointer = data_->bytes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetHandlesDataView(
      mojo::ArrayDataView<::mojo::native::SerializedHandleDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHandles(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::mojo::native::SerializedHandleDataView>, UserType>(),
    "Attempting to read the optional `handles` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHandles` instead "
    "of `ReadHandles if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->handles.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo::native::SerializedHandleDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Message_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // IPC::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::IPC::mojom::MessageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::IPC::mojom::MessageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::IPC::mojom::internal::Message_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::bytes(input)) in_bytes = Traits::bytes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bytes)::BaseType>
        bytes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_bytes, bytes_fragment, &bytes_validate_params);
    fragment->bytes.Set(
        bytes_fragment.is_null() ? nullptr : bytes_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->bytes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bytes in Message struct");
    decltype(Traits::handles(input)) in_handles = Traits::handles(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->handles)::BaseType>
        handles_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& handles_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo::native::SerializedHandleDataView>>(
        in_handles, handles_fragment, &handles_validate_params);
    fragment->handles.Set(
        handles_fragment.is_null() ? nullptr : handles_fragment.data());
  }

  static bool Deserialize(::IPC::mojom::internal::Message_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::IPC::mojom::MessageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace IPC::mojom {

inline void MessageDataView::GetBytesDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->bytes.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void MessageDataView::GetHandlesDataView(
    mojo::ArrayDataView<::mojo::native::SerializedHandleDataView>* output) {
  auto pointer = data_->handles.Get();
  *output = mojo::ArrayDataView<::mojo::native::SerializedHandleDataView>(pointer, message_);
}



}  // IPC::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // IPC_IPC_MOJOM_SHARED_H_