// media/mojo/mojom/audio_input_stream.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_INPUT_STREAM_MOJOM_H_
#define MEDIA_MOJO_MOJOM_AUDIO_INPUT_STREAM_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/audio_input_stream.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/audio_input_stream.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/audio_input_stream.mojom-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/audio_parameters.mojom-forward.h"
#include "media/mojo/mojom/media_types.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace media::mojom {

class AudioInputStreamProxy;

template <typename ImplRefTraits>
class AudioInputStreamStub;

class AudioInputStreamRequestValidator;


class AudioInputStream
    : public AudioInputStreamInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AudioInputStreamInterfaceBase;
  using Proxy_ = AudioInputStreamProxy;

  template <typename ImplRefTraits>
  using Stub_ = AudioInputStreamStub<ImplRefTraits>;

  using RequestValidator_ = AudioInputStreamRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kRecordMinVersion = 0,
    kSetVolumeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Record_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetVolume_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AudioInputStream() = default;

  
  virtual void Record() = 0;

  
  virtual void SetVolume(double volume) = 0;
};

class AudioInputStreamClientProxy;

template <typename ImplRefTraits>
class AudioInputStreamClientStub;

class AudioInputStreamClientRequestValidator;


class AudioInputStreamClient
    : public AudioInputStreamClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AudioInputStreamClientInterfaceBase;
  using Proxy_ = AudioInputStreamClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = AudioInputStreamClientStub<ImplRefTraits>;

  using RequestValidator_ = AudioInputStreamClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnErrorMinVersion = 0,
    kOnMutedStateChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnMutedStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AudioInputStreamClient() = default;

  
  virtual void OnError(::media::mojom::InputStreamErrorCode code) = 0;

  
  virtual void OnMutedStateChanged(bool is_muted) = 0;
};

class AudioInputStreamObserverProxy;

template <typename ImplRefTraits>
class AudioInputStreamObserverStub;

class AudioInputStreamObserverRequestValidator;


class AudioInputStreamObserver
    : public AudioInputStreamObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AudioInputStreamObserverInterfaceBase;
  using Proxy_ = AudioInputStreamObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = AudioInputStreamObserverStub<ImplRefTraits>;

  using RequestValidator_ = AudioInputStreamObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDidStartRecordingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DidStartRecording_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  
  using DisconnectReason = AudioInputStreamObserver_DisconnectReason;
  virtual ~AudioInputStreamObserver() = default;

  
  virtual void DidStartRecording() = 0;
};



class  AudioInputStreamProxy
    : public AudioInputStream {
 public:
  using InterfaceType = AudioInputStream;

  explicit AudioInputStreamProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Record() final;
  
  void SetVolume(double volume) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  AudioInputStreamClientProxy
    : public AudioInputStreamClient {
 public:
  using InterfaceType = AudioInputStreamClient;

  explicit AudioInputStreamClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnError(::media::mojom::InputStreamErrorCode code) final;
  
  void OnMutedStateChanged(bool is_muted) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  AudioInputStreamObserverProxy
    : public AudioInputStreamObserver {
 public:
  using InterfaceType = AudioInputStreamObserver;

  explicit AudioInputStreamObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DidStartRecording() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  AudioInputStreamStubDispatch {
 public:
  static bool Accept(AudioInputStream* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AudioInputStream* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AudioInputStream>>
class AudioInputStreamStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AudioInputStreamStub() = default;
  ~AudioInputStreamStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioInputStreamStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioInputStreamStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AudioInputStreamClientStubDispatch {
 public:
  static bool Accept(AudioInputStreamClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AudioInputStreamClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AudioInputStreamClient>>
class AudioInputStreamClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AudioInputStreamClientStub() = default;
  ~AudioInputStreamClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioInputStreamClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioInputStreamClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AudioInputStreamObserverStubDispatch {
 public:
  static bool Accept(AudioInputStreamObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AudioInputStreamObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AudioInputStreamObserver>>
class AudioInputStreamObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AudioInputStreamObserverStub() = default;
  ~AudioInputStreamObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioInputStreamObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioInputStreamObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AudioInputStreamRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AudioInputStreamClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AudioInputStreamObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // media::mojom

namespace mojo {

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_AUDIO_INPUT_STREAM_MOJOM_H_