// services/network/public/mojom/cors.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CORS_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CORS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/cors.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/cors.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/cors.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "services/network/public/mojom/ip_address_space.mojom-forward.h"
#include <string>
#include <vector>




#include "services/network/public/cpp/cors/cors_mojom_traits.h"




namespace network::mojom {








class  CorsErrorStatus {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CorsErrorStatus, T>::value>;
  using DataView = CorsErrorStatusDataView;
  using Data_ = internal::CorsErrorStatus_Data;

  template <typename... Args>
  static CorsErrorStatusPtr New(Args&&... args) {
    return CorsErrorStatusPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CorsErrorStatusPtr From(const U& u) {
    return mojo::TypeConverter<CorsErrorStatusPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CorsErrorStatus>::Convert(*this);
  }


  CorsErrorStatus();

  CorsErrorStatus(
      CorsError cors_error,
      const std::string& failed_parameter,
      ::network::mojom::IPAddressSpace target_address_space,
      ::network::mojom::IPAddressSpace resource_address_space,
      bool has_authorization_covered_by_wildcard_on_preflight,
      const ::base::UnguessableToken& issue_id);


  ~CorsErrorStatus();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CorsErrorStatusPtr>
  CorsErrorStatusPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CorsErrorStatus::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CorsErrorStatus::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CorsErrorStatus::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CorsErrorStatus::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CorsErrorStatus::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CorsErrorStatus_UnserializedMessageContext<
            UserType, CorsErrorStatus::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CorsErrorStatus::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CorsErrorStatus::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CorsErrorStatus_UnserializedMessageContext<
            UserType, CorsErrorStatus::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CorsErrorStatus::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  CorsError cors_error;
  
  std::string failed_parameter;
  
  ::network::mojom::IPAddressSpace target_address_space;
  
  ::network::mojom::IPAddressSpace resource_address_space;
  
  bool has_authorization_covered_by_wildcard_on_preflight;
  
  ::base::UnguessableToken issue_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CorsErrorStatus::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CorsErrorStatus::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CorsErrorStatus::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CorsErrorStatus::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CorsErrorStatusPtr CorsErrorStatus::Clone() const {
  return New(
      mojo::Clone(cors_error),
      mojo::Clone(failed_parameter),
      mojo::Clone(target_address_space),
      mojo::Clone(resource_address_space),
      mojo::Clone(has_authorization_covered_by_wildcard_on_preflight),
      mojo::Clone(issue_id)
  );
}

template <typename T, CorsErrorStatus::EnableIfSame<T>*>
bool CorsErrorStatus::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cors_error, other_struct.cors_error))
    return false;
  if (!mojo::Equals(this->failed_parameter, other_struct.failed_parameter))
    return false;
  if (!mojo::Equals(this->target_address_space, other_struct.target_address_space))
    return false;
  if (!mojo::Equals(this->resource_address_space, other_struct.resource_address_space))
    return false;
  if (!mojo::Equals(this->has_authorization_covered_by_wildcard_on_preflight, other_struct.has_authorization_covered_by_wildcard_on_preflight))
    return false;
  if (!mojo::Equals(this->issue_id, other_struct.issue_id))
    return false;
  return true;
}

template <typename T, CorsErrorStatus::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.cors_error < rhs.cors_error)
    return true;
  if (rhs.cors_error < lhs.cors_error)
    return false;
  if (lhs.failed_parameter < rhs.failed_parameter)
    return true;
  if (rhs.failed_parameter < lhs.failed_parameter)
    return false;
  if (lhs.target_address_space < rhs.target_address_space)
    return true;
  if (rhs.target_address_space < lhs.target_address_space)
    return false;
  if (lhs.resource_address_space < rhs.resource_address_space)
    return true;
  if (rhs.resource_address_space < lhs.resource_address_space)
    return false;
  if (lhs.has_authorization_covered_by_wildcard_on_preflight < rhs.has_authorization_covered_by_wildcard_on_preflight)
    return true;
  if (rhs.has_authorization_covered_by_wildcard_on_preflight < lhs.has_authorization_covered_by_wildcard_on_preflight)
    return false;
  if (lhs.issue_id < rhs.issue_id)
    return true;
  if (rhs.issue_id < lhs.issue_id)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::CorsErrorStatus::DataView,
                                         ::network::mojom::CorsErrorStatusPtr> {
  static bool IsNull(const ::network::mojom::CorsErrorStatusPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CorsErrorStatusPtr* output) { output->reset(); }

  static decltype(::network::mojom::CorsErrorStatus::cors_error) cors_error(
      const ::network::mojom::CorsErrorStatusPtr& input) {
    return input->cors_error;
  }

  static const decltype(::network::mojom::CorsErrorStatus::failed_parameter)& failed_parameter(
      const ::network::mojom::CorsErrorStatusPtr& input) {
    return input->failed_parameter;
  }

  static decltype(::network::mojom::CorsErrorStatus::target_address_space) target_address_space(
      const ::network::mojom::CorsErrorStatusPtr& input) {
    return input->target_address_space;
  }

  static decltype(::network::mojom::CorsErrorStatus::resource_address_space) resource_address_space(
      const ::network::mojom::CorsErrorStatusPtr& input) {
    return input->resource_address_space;
  }

  static decltype(::network::mojom::CorsErrorStatus::has_authorization_covered_by_wildcard_on_preflight) has_authorization_covered_by_wildcard_on_preflight(
      const ::network::mojom::CorsErrorStatusPtr& input) {
    return input->has_authorization_covered_by_wildcard_on_preflight;
  }

  static const decltype(::network::mojom::CorsErrorStatus::issue_id)& issue_id(
      const ::network::mojom::CorsErrorStatusPtr& input) {
    return input->issue_id;
  }

  static bool Read(::network::mojom::CorsErrorStatus::DataView input, ::network::mojom::CorsErrorStatusPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CORS_MOJOM_H_