// services/network/public/mojom/link_header.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/link_header.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/link_header.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* LinkRelAttributeToStringHelper(LinkRelAttribute value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LinkRelAttribute::kDnsPrefetch:
      return "kDnsPrefetch";
    case LinkRelAttribute::kPreconnect:
      return "kPreconnect";
    case LinkRelAttribute::kPreload:
      return "kPreload";
    case LinkRelAttribute::kModulePreload:
      return "kModulePreload";
    default:
      return nullptr;
  }
}

std::string LinkRelAttributeToString(LinkRelAttribute value) {
  const char *str = LinkRelAttributeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LinkRelAttribute value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LinkRelAttribute value) {
  return os << LinkRelAttributeToString(value);
}

NOINLINE static const char* LinkAsAttributeToStringHelper(LinkAsAttribute value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LinkAsAttribute::kUnspecified:
      return "kUnspecified";
    case LinkAsAttribute::kFont:
      return "kFont";
    case LinkAsAttribute::kImage:
      return "kImage";
    case LinkAsAttribute::kScript:
      return "kScript";
    case LinkAsAttribute::kStyleSheet:
      return "kStyleSheet";
    case LinkAsAttribute::kFetch:
      return "kFetch";
    default:
      return nullptr;
  }
}

std::string LinkAsAttributeToString(LinkAsAttribute value) {
  const char *str = LinkAsAttributeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LinkAsAttribute value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LinkAsAttribute value) {
  return os << LinkAsAttributeToString(value);
}

NOINLINE static const char* CrossOriginAttributeToStringHelper(CrossOriginAttribute value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CrossOriginAttribute::kUnspecified:
      return "kUnspecified";
    case CrossOriginAttribute::kAnonymous:
      return "kAnonymous";
    case CrossOriginAttribute::kUseCredentials:
      return "kUseCredentials";
    default:
      return nullptr;
  }
}

std::string CrossOriginAttributeToString(CrossOriginAttribute value) {
  const char *str = CrossOriginAttributeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CrossOriginAttribute value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CrossOriginAttribute value) {
  return os << CrossOriginAttributeToString(value);
}

namespace internal {


// static
bool LinkHeader_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LinkHeader_Data* object =
      static_cast<const LinkHeader_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->href, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->href, validation_context))
    return false;


  if (!::network::mojom::internal::LinkRelAttribute_Data
        ::Validate(object->rel, validation_context))
    return false;


  if (!::network::mojom::internal::LinkAsAttribute_Data
        ::Validate(object->as, validation_context))
    return false;


  if (!::network::mojom::internal::CrossOriginAttribute_Data
        ::Validate(object->cross_origin, validation_context))
    return false;


  if (!::network::mojom::internal::FetchPriorityAttribute_Data
        ::Validate(object->fetch_priority, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& mime_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->mime_type, validation_context,
                                         &mime_type_validate_params)) {
    return false;
  }

  return true;
}

LinkHeader_Data::LinkHeader_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::LinkRelAttribute>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::LinkRelAttribute value) {
  return std::move(context).WriteString(::network::mojom::LinkRelAttributeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::LinkAsAttribute>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::LinkAsAttribute value) {
  return std::move(context).WriteString(::network::mojom::LinkAsAttributeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CrossOriginAttribute>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CrossOriginAttribute value) {
  return std::move(context).WriteString(::network::mojom::CrossOriginAttributeToString(value));
}

} // namespace perfetto