// services/network/public/mojom/restricted_cookie_manager.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_RESTRICTED_COOKIE_MANAGER_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_RESTRICTED_COOKIE_MANAGER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/restricted_cookie_manager.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/restricted_cookie_manager.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/restricted_cookie_manager.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/cookie_manager.mojom-blink.h"
#include "mojo/public/mojom/base/shared_memory.mojom-blink.h"
#include "services/network/public/mojom/site_for_cookies.mojom-blink.h"
#include "services/network/public/mojom/storage_access_api.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"
#include "url/mojom/origin.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {

class RestrictedCookieManagerProxy;

template <typename ImplRefTraits>
class RestrictedCookieManagerStub;

class RestrictedCookieManagerRequestValidator;
class RestrictedCookieManagerResponseValidator;


class BLINK_PLATFORM_EXPORT RestrictedCookieManager
    : public RestrictedCookieManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    1607347938, 
    1854097722, 
    2087609716
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RestrictedCookieManagerInterfaceBase;
  using Proxy_ = RestrictedCookieManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = RestrictedCookieManagerStub<ImplRefTraits>;

  using RequestValidator_ = RestrictedCookieManagerRequestValidator;
  using ResponseValidator_ = RestrictedCookieManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetAllForUrlMinVersion = 0,
    kSetCanonicalCookieMinVersion = 0,
    kAddChangeListenerMinVersion = 0,
    kSetCookieFromStringMinVersion = 0,
    kGetCookiesStringMinVersion = 0,
    kCookiesEnabledForMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetAllForUrl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCanonicalCookie_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddChangeListener_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCookieFromString_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetCookiesString_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CookiesEnabledFor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~RestrictedCookieManager() = default;


  using GetAllForUrlCallback = base::OnceCallback<void(WTF::Vector<::network::mojom::blink::CookieWithAccessResultPtr>)>;
  
  virtual void GetAllForUrl(const ::blink::KURL& url, const ::net::SiteForCookies& site_for_cookies, const ::scoped_refptr<const ::blink::SecurityOrigin>& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, CookieManagerGetOptionsPtr options, bool is_ad_tagged, bool apply_devtools_overrides, bool force_disable_third_party_cookies, GetAllForUrlCallback callback) = 0;


  using SetCanonicalCookieCallback = base::OnceCallback<void(bool)>;
  
  virtual void SetCanonicalCookie(const ::net::CanonicalCookie& cookie, const ::blink::KURL& url, const ::net::SiteForCookies& site_for_cookies, const ::scoped_refptr<const ::blink::SecurityOrigin>& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, ::net::CookieInclusionStatus status, bool apply_devtools_overrides, SetCanonicalCookieCallback callback) = 0;


  using AddChangeListenerCallback = base::OnceCallback<void()>;
  
  virtual void AddChangeListener(const ::blink::KURL& url, const ::net::SiteForCookies& site_for_cookies, const ::scoped_refptr<const ::blink::SecurityOrigin>& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, ::mojo::PendingRemote<::network::mojom::blink::CookieChangeListener> listener, AddChangeListenerCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool SetCookieFromString(const ::blink::KURL& url, const ::net::SiteForCookies& site_for_cookies, const ::scoped_refptr<const ::blink::SecurityOrigin>& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, bool apply_devtools_overrides, const WTF::String& cookie);

  using SetCookieFromStringCallback = base::OnceCallback<void()>;
  
  virtual void SetCookieFromString(const ::blink::KURL& url, const ::net::SiteForCookies& site_for_cookies, const ::scoped_refptr<const ::blink::SecurityOrigin>& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, bool apply_devtools_overrides, const WTF::String& cookie, SetCookieFromStringCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetCookiesString(const ::blink::KURL& url, const ::net::SiteForCookies& site_for_cookies, const ::scoped_refptr<const ::blink::SecurityOrigin>& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, bool get_version_shared_memory, bool is_ad_tagged, bool apply_devtools_overrides, bool force_disable_third_party_cookies, uint64_t* out_version, ::base::ReadOnlySharedMemoryRegion* out_version_buffer, WTF::String* out_cookies);

  using GetCookiesStringCallback = base::OnceCallback<void(uint64_t, ::base::ReadOnlySharedMemoryRegion, const WTF::String&)>;
  
  virtual void GetCookiesString(const ::blink::KURL& url, const ::net::SiteForCookies& site_for_cookies, const ::scoped_refptr<const ::blink::SecurityOrigin>& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, bool get_version_shared_memory, bool is_ad_tagged, bool apply_devtools_overrides, bool force_disable_third_party_cookies, GetCookiesStringCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool CookiesEnabledFor(const ::blink::KURL& url, const ::net::SiteForCookies& site_for_cookies, const ::scoped_refptr<const ::blink::SecurityOrigin>& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, bool apply_devtools_overrides, bool* out_cookies_enabled);

  using CookiesEnabledForCallback = base::OnceCallback<void(bool)>;
  
  virtual void CookiesEnabledFor(const ::blink::KURL& url, const ::net::SiteForCookies& site_for_cookies, const ::scoped_refptr<const ::blink::SecurityOrigin>& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, bool apply_devtools_overrides, CookiesEnabledForCallback callback) = 0;
};



class BLINK_PLATFORM_EXPORT RestrictedCookieManagerProxy
    : public RestrictedCookieManager {
 public:
  using InterfaceType = RestrictedCookieManager;

  explicit RestrictedCookieManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetAllForUrl(const ::blink::KURL& url, const ::net::SiteForCookies& site_for_cookies, const ::scoped_refptr<const ::blink::SecurityOrigin>& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, CookieManagerGetOptionsPtr options, bool is_ad_tagged, bool apply_devtools_overrides, bool force_disable_third_party_cookies, GetAllForUrlCallback callback) final;
  
  void SetCanonicalCookie(const ::net::CanonicalCookie& cookie, const ::blink::KURL& url, const ::net::SiteForCookies& site_for_cookies, const ::scoped_refptr<const ::blink::SecurityOrigin>& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, ::net::CookieInclusionStatus status, bool apply_devtools_overrides, SetCanonicalCookieCallback callback) final;
  
  void AddChangeListener(const ::blink::KURL& url, const ::net::SiteForCookies& site_for_cookies, const ::scoped_refptr<const ::blink::SecurityOrigin>& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, ::mojo::PendingRemote<::network::mojom::blink::CookieChangeListener> listener, AddChangeListenerCallback callback) final;
  
  bool SetCookieFromString(const ::blink::KURL& url, const ::net::SiteForCookies& site_for_cookies, const ::scoped_refptr<const ::blink::SecurityOrigin>& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, bool apply_devtools_overrides, const WTF::String& cookie) final;
  
  void SetCookieFromString(const ::blink::KURL& url, const ::net::SiteForCookies& site_for_cookies, const ::scoped_refptr<const ::blink::SecurityOrigin>& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, bool apply_devtools_overrides, const WTF::String& cookie, SetCookieFromStringCallback callback) final;
  
  bool GetCookiesString(const ::blink::KURL& url, const ::net::SiteForCookies& site_for_cookies, const ::scoped_refptr<const ::blink::SecurityOrigin>& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, bool get_version_shared_memory, bool is_ad_tagged, bool apply_devtools_overrides, bool force_disable_third_party_cookies, uint64_t* out_version, ::base::ReadOnlySharedMemoryRegion* out_version_buffer, WTF::String* out_cookies) final;
  
  void GetCookiesString(const ::blink::KURL& url, const ::net::SiteForCookies& site_for_cookies, const ::scoped_refptr<const ::blink::SecurityOrigin>& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, bool get_version_shared_memory, bool is_ad_tagged, bool apply_devtools_overrides, bool force_disable_third_party_cookies, GetCookiesStringCallback callback) final;
  
  bool CookiesEnabledFor(const ::blink::KURL& url, const ::net::SiteForCookies& site_for_cookies, const ::scoped_refptr<const ::blink::SecurityOrigin>& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, bool apply_devtools_overrides, bool* out_cookies_enabled) final;
  
  void CookiesEnabledFor(const ::blink::KURL& url, const ::net::SiteForCookies& site_for_cookies, const ::scoped_refptr<const ::blink::SecurityOrigin>& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, bool apply_devtools_overrides, CookiesEnabledForCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT RestrictedCookieManagerStubDispatch {
 public:
  static bool Accept(RestrictedCookieManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RestrictedCookieManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RestrictedCookieManager>>
class RestrictedCookieManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RestrictedCookieManagerStub() = default;
  ~RestrictedCookieManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RestrictedCookieManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RestrictedCookieManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT RestrictedCookieManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT RestrictedCookieManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class BLINK_PLATFORM_EXPORT CookieManagerGetOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieManagerGetOptions, T>::value>;
  using DataView = CookieManagerGetOptionsDataView;
  using Data_ = internal::CookieManagerGetOptions_Data;

  template <typename... Args>
  static CookieManagerGetOptionsPtr New(Args&&... args) {
    return CookieManagerGetOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieManagerGetOptionsPtr From(const U& u) {
    return mojo::TypeConverter<CookieManagerGetOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieManagerGetOptions>::Convert(*this);
  }


  CookieManagerGetOptions();

  CookieManagerGetOptions(
      const WTF::String& name,
      CookieMatchType match_type);


  ~CookieManagerGetOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieManagerGetOptionsPtr>
  CookieManagerGetOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieManagerGetOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CookieManagerGetOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CookieManagerGetOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieManagerGetOptions::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieManagerGetOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieManagerGetOptions_UnserializedMessageContext<
            UserType, CookieManagerGetOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CookieManagerGetOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CookieManagerGetOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieManagerGetOptions_UnserializedMessageContext<
            UserType, CookieManagerGetOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieManagerGetOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WTF::String name;
  
  CookieMatchType match_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieManagerGetOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieManagerGetOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieManagerGetOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieManagerGetOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
CookieManagerGetOptionsPtr CookieManagerGetOptions::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(match_type)
  );
}

template <typename T, CookieManagerGetOptions::EnableIfSame<T>*>
bool CookieManagerGetOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->match_type, other_struct.match_type))
    return false;
  return true;
}

template <typename T, CookieManagerGetOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.match_type < rhs.match_type)
    return true;
  if (rhs.match_type < lhs.match_type)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::CookieManagerGetOptions::DataView,
                                         ::network::mojom::blink::CookieManagerGetOptionsPtr> {
  static bool IsNull(const ::network::mojom::blink::CookieManagerGetOptionsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::CookieManagerGetOptionsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::CookieManagerGetOptions::name)& name(
      const ::network::mojom::blink::CookieManagerGetOptionsPtr& input) {
    return input->name;
  }

  static decltype(::network::mojom::blink::CookieManagerGetOptions::match_type) match_type(
      const ::network::mojom::blink::CookieManagerGetOptionsPtr& input) {
    return input->match_type;
  }

  static bool Read(::network::mojom::blink::CookieManagerGetOptions::DataView input, ::network::mojom::blink::CookieManagerGetOptionsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_RESTRICTED_COOKIE_MANAGER_MOJOM_BLINK_H_