// services/network/public/mojom/shared_storage.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/shared_storage.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/shared_storage.mojom-params-data.h"
namespace network {
namespace mojom {

namespace internal {
// static
bool SharedStorageModifierMethod_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const SharedStorageModifierMethod_Data* object = static_cast<const SharedStorageModifierMethod_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case SharedStorageModifierMethod_Tag::kSetMethod: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_set_method, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_set_method, validation_context))
        return false;
      return true;
    }
    case SharedStorageModifierMethod_Tag::kAppendMethod: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_append_method, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_append_method, validation_context))
        return false;
      return true;
    }
    case SharedStorageModifierMethod_Tag::kDeleteMethod: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_delete_method, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_delete_method, validation_context))
        return false;
      return true;
    }
    case SharedStorageModifierMethod_Tag::kClearMethod: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_clear_method, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_clear_method, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in SharedStorageModifierMethod");
      return false;
    }
  }
}


// static
bool SharedStorageKeyArgument_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageKeyArgument_Data* object =
      static_cast<const SharedStorageKeyArgument_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

SharedStorageKeyArgument_Data::SharedStorageKeyArgument_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageValueArgument_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageValueArgument_Data* object =
      static_cast<const SharedStorageValueArgument_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

SharedStorageValueArgument_Data::SharedStorageValueArgument_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LockName_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LockName_Data* object =
      static_cast<const LockName_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

LockName_Data::LockName_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageSetMethod_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageSetMethod_Data* object =
      static_cast<const SharedStorageSetMethod_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

SharedStorageSetMethod_Data::SharedStorageSetMethod_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageAppendMethod_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageAppendMethod_Data* object =
      static_cast<const SharedStorageAppendMethod_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

SharedStorageAppendMethod_Data::SharedStorageAppendMethod_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageDeleteMethod_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageDeleteMethod_Data* object =
      static_cast<const SharedStorageDeleteMethod_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key, validation_context))
    return false;

  return true;
}

SharedStorageDeleteMethod_Data::SharedStorageDeleteMethod_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageClearMethod_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageClearMethod_Data* object =
      static_cast<const SharedStorageClearMethod_Data*>(data);

  return true;
}

SharedStorageClearMethod_Data::SharedStorageClearMethod_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageModifierMethodWithOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageModifierMethodWithOptions_Data* object =
      static_cast<const SharedStorageModifierMethodWithOptions_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->method, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->method, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->with_lock, validation_context))
    return false;

  return true;
}

SharedStorageModifierMethodWithOptions_Data::SharedStorageModifierMethodWithOptions_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network