// services/viz/privileged/mojom/compositing/frame_sink_manager_test_api.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_MANAGER_TEST_API_MOJOM_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_MANAGER_TEST_API_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/privileged/mojom/compositing/frame_sink_manager_test_api.mojom-features.h"  // IWYU pragma: export
#include "services/viz/privileged/mojom/compositing/frame_sink_manager_test_api.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/privileged/mojom/compositing/frame_sink_manager_test_api.mojom-forward.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace viz::mojom {

class FrameSinkManagerTestApiProxy;

template <typename ImplRefTraits>
class FrameSinkManagerTestApiStub;

class FrameSinkManagerTestApiRequestValidator;
class FrameSinkManagerTestApiResponseValidator;


class FrameSinkManagerTestApi
    : public FrameSinkManagerTestApiInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    579336678, 
    1032856863, 
    1211181785, 
    1350882826
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FrameSinkManagerTestApiInterfaceBase;
  using Proxy_ = FrameSinkManagerTestApiProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameSinkManagerTestApiStub<ImplRefTraits>;

  using RequestValidator_ = FrameSinkManagerTestApiRequestValidator;
  using ResponseValidator_ = FrameSinkManagerTestApiResponseValidator;
  enum MethodMinVersions : uint32_t {
    kHasUnclaimedViewTransitionResourcesMinVersion = 0,
    kSetSameDocNavigationScreenshotSizeMinVersion = 0,
    kGetForceEnableZoomStateMinVersion = 0,
    kWaitForSurfaceAnimationManagerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct HasUnclaimedViewTransitionResources_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSameDocNavigationScreenshotSize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetForceEnableZoomState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WaitForSurfaceAnimationManager_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FrameSinkManagerTestApi() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool HasUnclaimedViewTransitionResources(bool* out_has_resources);

  using HasUnclaimedViewTransitionResourcesCallback = base::OnceCallback<void(bool)>;
  
  virtual void HasUnclaimedViewTransitionResources(HasUnclaimedViewTransitionResourcesCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool SetSameDocNavigationScreenshotSize(const ::gfx::Size& result_size);

  using SetSameDocNavigationScreenshotSizeCallback = base::OnceCallback<void()>;
  
  virtual void SetSameDocNavigationScreenshotSize(const ::gfx::Size& result_size, SetSameDocNavigationScreenshotSizeCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetForceEnableZoomState(const ::viz::FrameSinkId& frame_sink_id, bool* out_enabled);

  using GetForceEnableZoomStateCallback = base::OnceCallback<void(bool)>;
  
  virtual void GetForceEnableZoomState(const ::viz::FrameSinkId& frame_sink_id, GetForceEnableZoomStateCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool WaitForSurfaceAnimationManager(const ::viz::FrameSinkId& frame_sink_id);

  using WaitForSurfaceAnimationManagerCallback = base::OnceCallback<void()>;
  
  virtual void WaitForSurfaceAnimationManager(const ::viz::FrameSinkId& frame_sink_id, WaitForSurfaceAnimationManagerCallback callback) = 0;
};



class  FrameSinkManagerTestApiProxy
    : public FrameSinkManagerTestApi {
 public:
  using InterfaceType = FrameSinkManagerTestApi;

  explicit FrameSinkManagerTestApiProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool HasUnclaimedViewTransitionResources(bool* out_has_resources) final;
  
  void HasUnclaimedViewTransitionResources(HasUnclaimedViewTransitionResourcesCallback callback) final;
  
  bool SetSameDocNavigationScreenshotSize(const ::gfx::Size& result_size) final;
  
  void SetSameDocNavigationScreenshotSize(const ::gfx::Size& result_size, SetSameDocNavigationScreenshotSizeCallback callback) final;
  
  bool GetForceEnableZoomState(const ::viz::FrameSinkId& frame_sink_id, bool* out_enabled) final;
  
  void GetForceEnableZoomState(const ::viz::FrameSinkId& frame_sink_id, GetForceEnableZoomStateCallback callback) final;
  
  bool WaitForSurfaceAnimationManager(const ::viz::FrameSinkId& frame_sink_id) final;
  
  void WaitForSurfaceAnimationManager(const ::viz::FrameSinkId& frame_sink_id, WaitForSurfaceAnimationManagerCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  FrameSinkManagerTestApiStubDispatch {
 public:
  static bool Accept(FrameSinkManagerTestApi* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameSinkManagerTestApi* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameSinkManagerTestApi>>
class FrameSinkManagerTestApiStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameSinkManagerTestApiStub() = default;
  ~FrameSinkManagerTestApiStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkManagerTestApiStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkManagerTestApiStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FrameSinkManagerTestApiRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FrameSinkManagerTestApiResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // viz::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_MANAGER_TEST_API_MOJOM_H_