// services/viz/public/mojom/compositing/frame_sink_id.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_SINK_ID_MOJOM_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_SINK_ID_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/frame_sink_id.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "services/viz/public/cpp/compositing/frame_sink_id_mojom_traits.h"




namespace viz::mojom {





class  FrameSinkId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FrameSinkId, T>::value>;
  using DataView = FrameSinkIdDataView;
  using Data_ = internal::FrameSinkId_Data;

  template <typename... Args>
  static FrameSinkIdPtr New(Args&&... args) {
    return FrameSinkIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FrameSinkIdPtr From(const U& u) {
    return mojo::TypeConverter<FrameSinkIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FrameSinkId>::Convert(*this);
  }


  FrameSinkId();

  FrameSinkId(
      uint32_t client_id,
      uint32_t sink_id);


  ~FrameSinkId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FrameSinkIdPtr>
  FrameSinkIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FrameSinkId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FrameSinkId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FrameSinkId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameSinkId::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FrameSinkId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FrameSinkId_UnserializedMessageContext<
            UserType, FrameSinkId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FrameSinkId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FrameSinkId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FrameSinkId_UnserializedMessageContext<
            UserType, FrameSinkId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FrameSinkId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t client_id;
  
  uint32_t sink_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FrameSinkId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FrameSinkId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FrameSinkId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FrameSinkId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
FrameSinkIdPtr FrameSinkId::Clone() const {
  return New(
      mojo::Clone(client_id),
      mojo::Clone(sink_id)
  );
}

template <typename T, FrameSinkId::EnableIfSame<T>*>
bool FrameSinkId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->client_id, other_struct.client_id))
    return false;
  if (!mojo::Equals(this->sink_id, other_struct.sink_id))
    return false;
  return true;
}

template <typename T, FrameSinkId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.client_id < rhs.client_id)
    return true;
  if (rhs.client_id < lhs.client_id)
    return false;
  if (lhs.sink_id < rhs.sink_id)
    return true;
  if (rhs.sink_id < lhs.sink_id)
    return false;
  return false;
}


}  // viz::mojom

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::FrameSinkId::DataView,
                                         ::viz::mojom::FrameSinkIdPtr> {
  static bool IsNull(const ::viz::mojom::FrameSinkIdPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::FrameSinkIdPtr* output) { output->reset(); }

  static decltype(::viz::mojom::FrameSinkId::client_id) client_id(
      const ::viz::mojom::FrameSinkIdPtr& input) {
    return input->client_id;
  }

  static decltype(::viz::mojom::FrameSinkId::sink_id) sink_id(
      const ::viz::mojom::FrameSinkIdPtr& input) {
    return input->sink_id;
  }

  static bool Read(::viz::mojom::FrameSinkId::DataView input, ::viz::mojom::FrameSinkIdPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_SINK_ID_MOJOM_H_