// skia/public/mojom/image_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SKIA_PUBLIC_MOJOM_IMAGE_INFO_MOJOM_SHARED_H_
#define SKIA_PUBLIC_MOJOM_IMAGE_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "skia/public/mojom/image_info.mojom-shared-internal.h"







namespace skia::mojom {
class ImageInfoDataView;

class BitmapN32ImageInfoDataView;



}  // skia::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::skia::mojom::ImageInfoDataView> {
  using Data = ::skia::mojom::internal::ImageInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::skia::mojom::BitmapN32ImageInfoDataView> {
  using Data = ::skia::mojom::internal::BitmapN32ImageInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace skia::mojom {


enum class ColorType : int32_t {
  
  UNKNOWN = 0,
  
  ALPHA_8 = 1,
  
  RGB_565 = 2,
  
  ARGB_4444 = 3,
  
  RGBA_8888 = 4,
  
  BGRA_8888 = 5,
  
  DEPRECATED_INDEX_8 = 6,
  
  GRAY_8 = 7,
  kMinValue = 0,
  kMaxValue = 7,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, ColorType value);
inline bool IsKnownEnumValue(ColorType value) {
  return internal::ColorType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline ColorType ToKnownEnumValue(ColorType value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return ColorType::kDefaultValue;
}


enum class AlphaType : int32_t {
  
  UNKNOWN = 0,
  
  ALPHA_TYPE_OPAQUE = 1,
  
  PREMUL = 2,
  
  UNPREMUL = 3,
  kMinValue = 0,
  kMaxValue = 3,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, AlphaType value);
inline bool IsKnownEnumValue(AlphaType value) {
  return internal::AlphaType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline AlphaType ToKnownEnumValue(AlphaType value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return AlphaType::kDefaultValue;
}


class ImageInfoDataView {
 public:
  ImageInfoDataView() = default;

  ImageInfoDataView(
      internal::ImageInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadColorType(UserType* output) const {
    auto data_value = data_->color_type;
    return mojo::internal::Deserialize<::skia::mojom::ColorType>(
        data_value, output);
  }
  ColorType color_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::skia::mojom::ColorType>(data_->color_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAlphaType(UserType* output) const {
    auto data_value = data_->alpha_type;
    return mojo::internal::Deserialize<::skia::mojom::AlphaType>(
        data_value, output);
  }
  AlphaType alpha_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::skia::mojom::AlphaType>(data_->alpha_type));
  }
  uint32_t width() const {
    return data_->width;
  }
  uint32_t height() const {
    return data_->height;
  }
  inline void GetColorTransferFunctionDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorTransferFunction(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<float>, UserType>(),
    "Attempting to read the optional `color_transfer_function` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadColorTransferFunction` instead "
    "of `ReadColorTransferFunction if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->color_transfer_function.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, message_);
  }
  inline void GetColorToXyzMatrixDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorToXyzMatrix(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<float>, UserType>(),
    "Attempting to read the optional `color_to_xyz_matrix` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadColorToXyzMatrix` instead "
    "of `ReadColorToXyzMatrix if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->color_to_xyz_matrix.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, message_);
  }
 private:
  internal::ImageInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BitmapN32ImageInfoDataView {
 public:
  BitmapN32ImageInfoDataView() = default;

  BitmapN32ImageInfoDataView(
      internal::BitmapN32ImageInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadAlphaType(UserType* output) const {
    auto data_value = data_->alpha_type;
    return mojo::internal::Deserialize<::skia::mojom::AlphaType>(
        data_value, output);
  }
  AlphaType alpha_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::skia::mojom::AlphaType>(data_->alpha_type));
  }
  uint32_t width() const {
    return data_->width;
  }
  uint32_t height() const {
    return data_->height;
  }
  inline void GetColorTransferFunctionDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorTransferFunction(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<float>, UserType>(),
    "Attempting to read the optional `color_transfer_function` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadColorTransferFunction` instead "
    "of `ReadColorTransferFunction if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->color_transfer_function.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, message_);
  }
  inline void GetColorToXyzMatrixDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorToXyzMatrix(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<float>, UserType>(),
    "Attempting to read the optional `color_to_xyz_matrix` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadColorToXyzMatrix` instead "
    "of `ReadColorToXyzMatrix if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->color_to_xyz_matrix.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, message_);
  }
 private:
  internal::BitmapN32ImageInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // skia::mojom

namespace std {

template <>
struct hash<::skia::mojom::ColorType>
    : public mojo::internal::EnumHashImpl<::skia::mojom::ColorType> {};

template <>
struct hash<::skia::mojom::AlphaType>
    : public mojo::internal::EnumHashImpl<::skia::mojom::AlphaType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::skia::mojom::ColorType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::skia::mojom::ColorType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::skia::mojom::ColorType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::skia::mojom::AlphaType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::skia::mojom::AlphaType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::skia::mojom::AlphaType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::skia::mojom::ImageInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::skia::mojom::ImageInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::skia::mojom::internal::ImageInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::skia::mojom::ColorType>(
        Traits::color_type(input), &fragment->color_type);
    mojo::internal::Serialize<::skia::mojom::AlphaType>(
        Traits::alpha_type(input), &fragment->alpha_type);
    fragment->width = Traits::width(input);
    fragment->height = Traits::height(input);
    decltype(Traits::color_transfer_function(input)) in_color_transfer_function = Traits::color_transfer_function(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color_transfer_function)::BaseType>
        color_transfer_function_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& color_transfer_function_validate_params =
        mojo::internal::GetArrayValidator<7, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
        in_color_transfer_function, color_transfer_function_fragment, &color_transfer_function_validate_params);
    fragment->color_transfer_function.Set(
        color_transfer_function_fragment.is_null() ? nullptr : color_transfer_function_fragment.data());
    decltype(Traits::color_to_xyz_matrix(input)) in_color_to_xyz_matrix = Traits::color_to_xyz_matrix(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color_to_xyz_matrix)::BaseType>
        color_to_xyz_matrix_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& color_to_xyz_matrix_validate_params =
        mojo::internal::GetArrayValidator<9, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
        in_color_to_xyz_matrix, color_to_xyz_matrix_fragment, &color_to_xyz_matrix_validate_params);
    fragment->color_to_xyz_matrix.Set(
        color_to_xyz_matrix_fragment.is_null() ? nullptr : color_to_xyz_matrix_fragment.data());
  }

  static bool Deserialize(::skia::mojom::internal::ImageInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::skia::mojom::ImageInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::skia::mojom::BitmapN32ImageInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::skia::mojom::BitmapN32ImageInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::skia::mojom::internal::BitmapN32ImageInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::skia::mojom::AlphaType>(
        Traits::alpha_type(input), &fragment->alpha_type);
    fragment->width = Traits::width(input);
    fragment->height = Traits::height(input);
    decltype(Traits::color_transfer_function(input)) in_color_transfer_function = Traits::color_transfer_function(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color_transfer_function)::BaseType>
        color_transfer_function_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& color_transfer_function_validate_params =
        mojo::internal::GetArrayValidator<7, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
        in_color_transfer_function, color_transfer_function_fragment, &color_transfer_function_validate_params);
    fragment->color_transfer_function.Set(
        color_transfer_function_fragment.is_null() ? nullptr : color_transfer_function_fragment.data());
    decltype(Traits::color_to_xyz_matrix(input)) in_color_to_xyz_matrix = Traits::color_to_xyz_matrix(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color_to_xyz_matrix)::BaseType>
        color_to_xyz_matrix_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& color_to_xyz_matrix_validate_params =
        mojo::internal::GetArrayValidator<9, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
        in_color_to_xyz_matrix, color_to_xyz_matrix_fragment, &color_to_xyz_matrix_validate_params);
    fragment->color_to_xyz_matrix.Set(
        color_to_xyz_matrix_fragment.is_null() ? nullptr : color_to_xyz_matrix_fragment.data());
  }

  static bool Deserialize(::skia::mojom::internal::BitmapN32ImageInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::skia::mojom::BitmapN32ImageInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace skia::mojom {

inline void ImageInfoDataView::GetColorTransferFunctionDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->color_transfer_function.Get();
  *output = mojo::ArrayDataView<float>(pointer, message_);
}
inline void ImageInfoDataView::GetColorToXyzMatrixDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->color_to_xyz_matrix.Get();
  *output = mojo::ArrayDataView<float>(pointer, message_);
}


inline void BitmapN32ImageInfoDataView::GetColorTransferFunctionDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->color_transfer_function.Get();
  *output = mojo::ArrayDataView<float>(pointer, message_);
}
inline void BitmapN32ImageInfoDataView::GetColorToXyzMatrixDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->color_to_xyz_matrix.Get();
  *output = mojo::ArrayDataView<float>(pointer, message_);
}



}  // skia::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::skia::mojom::ColorType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::skia::mojom::ColorType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::skia::mojom::AlphaType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::skia::mojom::AlphaType value);
};

} // namespace perfetto

#endif  // SKIA_PUBLIC_MOJOM_IMAGE_INFO_MOJOM_SHARED_H_