// third_party/blink/public/mojom/messaging/cloneable_message.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_CLONEABLE_MESSAGE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_CLONEABLE_MESSAGE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/messaging/cloneable_message.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace blink::mojom {
class CloneableMessageDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::CloneableMessageDataView> {
  using Data = ::blink::mojom::internal::CloneableMessage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class CloneableMessageDataView {
 public:
  CloneableMessageDataView() = default;

  CloneableMessageDataView(
      internal::CloneableMessage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEncodedMessageDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEncodedMessage(UserType* output) {
    
    auto* pointer = !data_->encoded_message.is_null() ? &data_->encoded_message : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
  inline void GetBlobsDataView(
      mojo::ArrayDataView<::blink::mojom::SerializedBlobDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBlobs(UserType* output) {
    
    auto* pointer = data_->blobs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::SerializedBlobDataView>>(
        pointer, output, message_);
  }
  inline void GetSenderOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSenderOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `sender_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSenderOrigin` instead "
    "of `ReadSenderOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->sender_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  uint64_t stack_trace_id() const {
    return data_->stack_trace_id;
  }
  int64_t stack_trace_debugger_id_first() const {
    return data_->stack_trace_debugger_id_first;
  }
  int64_t stack_trace_debugger_id_second() const {
    return data_->stack_trace_debugger_id_second;
  }
  bool stack_trace_should_pause() const {
    return data_->stack_trace_should_pause;
  }
  inline void GetSenderAgentClusterIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSenderAgentClusterId(UserType* output) {
    
    auto* pointer = data_->sender_agent_cluster_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  bool locked_to_sender_agent_cluster() const {
    return data_->locked_to_sender_agent_cluster;
  }
  inline void GetFileSystemAccessTokensDataView(
      mojo::ArrayDataView<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileSystemAccessTokens(UserType* output) {
    
    auto* pointer = data_->file_system_access_tokens.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>>(
        pointer, output, message_);
  }
 private:
  internal::CloneableMessage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CloneableMessageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::CloneableMessageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::CloneableMessage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::encoded_message(input)) in_encoded_message = Traits::encoded_message(input);
    mojo::internal::MessageFragment<decltype(fragment->encoded_message)>
        encoded_message_fragment(fragment.message());
    encoded_message_fragment.Claim(&fragment->encoded_message);
    mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
        in_encoded_message, encoded_message_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->encoded_message.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null encoded_message in CloneableMessage struct");
    decltype(Traits::blobs(input)) in_blobs = Traits::blobs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->blobs)::BaseType>
        blobs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& blobs_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SerializedBlobDataView>>(
        in_blobs, blobs_fragment, &blobs_validate_params);
    fragment->blobs.Set(
        blobs_fragment.is_null() ? nullptr : blobs_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->blobs.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null blobs in CloneableMessage struct");
    decltype(Traits::sender_origin(input)) in_sender_origin = Traits::sender_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sender_origin)::BaseType> sender_origin_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_sender_origin, sender_origin_fragment);
    fragment->sender_origin.Set(
        sender_origin_fragment.is_null() ? nullptr : sender_origin_fragment.data());
    fragment->stack_trace_id = Traits::stack_trace_id(input);
    fragment->stack_trace_debugger_id_first = Traits::stack_trace_debugger_id_first(input);
    fragment->stack_trace_debugger_id_second = Traits::stack_trace_debugger_id_second(input);
    fragment->stack_trace_should_pause = Traits::stack_trace_should_pause(input);
    decltype(Traits::sender_agent_cluster_id(input)) in_sender_agent_cluster_id = Traits::sender_agent_cluster_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sender_agent_cluster_id)::BaseType> sender_agent_cluster_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_sender_agent_cluster_id, sender_agent_cluster_id_fragment);
    fragment->sender_agent_cluster_id.Set(
        sender_agent_cluster_id_fragment.is_null() ? nullptr : sender_agent_cluster_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->sender_agent_cluster_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sender_agent_cluster_id in CloneableMessage struct");
    fragment->locked_to_sender_agent_cluster = Traits::locked_to_sender_agent_cluster(input);
    decltype(Traits::file_system_access_tokens(input)) in_file_system_access_tokens = Traits::file_system_access_tokens(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->file_system_access_tokens)::BaseType>
        file_system_access_tokens_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& file_system_access_tokens_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>>(
        in_file_system_access_tokens, file_system_access_tokens_fragment, &file_system_access_tokens_validate_params);
    fragment->file_system_access_tokens.Set(
        file_system_access_tokens_fragment.is_null() ? nullptr : file_system_access_tokens_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->file_system_access_tokens.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null file_system_access_tokens in CloneableMessage struct");
  }

  static bool Deserialize(::blink::mojom::internal::CloneableMessage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::CloneableMessageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void CloneableMessageDataView::GetEncodedMessageDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->encoded_message;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, message_);
}
inline void CloneableMessageDataView::GetBlobsDataView(
    mojo::ArrayDataView<::blink::mojom::SerializedBlobDataView>* output) {
  auto pointer = data_->blobs.Get();
  *output = mojo::ArrayDataView<::blink::mojom::SerializedBlobDataView>(pointer, message_);
}
inline void CloneableMessageDataView::GetSenderOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->sender_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void CloneableMessageDataView::GetSenderAgentClusterIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->sender_agent_cluster_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void CloneableMessageDataView::GetFileSystemAccessTokensDataView(
    mojo::ArrayDataView<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>* output) {
  auto pointer = data_->file_system_access_tokens.Get();
  *output = mojo::ArrayDataView<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_CLONEABLE_MESSAGE_MOJOM_SHARED_H_