// ui/ozone/public/mojom/gesture_properties_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_OZONE_PUBLIC_MOJOM_GESTURE_PROPERTIES_SERVICE_MOJOM_H_
#define UI_OZONE_PUBLIC_MOJOM_GESTURE_PROPERTIES_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/ozone/public/mojom/gesture_properties_service.mojom-features.h"  // IWYU pragma: export
#include "ui/ozone/public/mojom/gesture_properties_service.mojom-shared.h"  // IWYU pragma: export
#include "ui/ozone/public/mojom/gesture_properties_service.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace ui::ozone::mojom {

class GesturePropertiesServiceProxy;

template <typename ImplRefTraits>
class GesturePropertiesServiceStub;

class GesturePropertiesServiceRequestValidator;
class GesturePropertiesServiceResponseValidator;


class GesturePropertiesService
    : public GesturePropertiesServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = GesturePropertiesServiceInterfaceBase;
  using Proxy_ = GesturePropertiesServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = GesturePropertiesServiceStub<ImplRefTraits>;

  using RequestValidator_ = GesturePropertiesServiceRequestValidator;
  using ResponseValidator_ = GesturePropertiesServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kListDevicesMinVersion = 0,
    kListPropertiesMinVersion = 0,
    kGetPropertyMinVersion = 0,
    kSetPropertyMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ListDevices_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ListProperties_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetProperty_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetProperty_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~GesturePropertiesService() = default;


  using ListDevicesCallback = base::OnceCallback<void(const base::flat_map<int32_t, std::string>&)>;
  
  virtual void ListDevices(ListDevicesCallback callback) = 0;


  using ListPropertiesCallback = base::OnceCallback<void(const std::vector<std::string>&)>;
  
  virtual void ListProperties(int32_t device_id, ListPropertiesCallback callback) = 0;


  using GetPropertyCallback = base::OnceCallback<void(bool, GesturePropValuePtr)>;
  
  virtual void GetProperty(int32_t device_id, const std::string& name, GetPropertyCallback callback) = 0;


  using SetPropertyCallback = base::OnceCallback<void(SetGesturePropErrorCode)>;
  
  virtual void SetProperty(int32_t device_id, const std::string& name, GesturePropValuePtr value, SetPropertyCallback callback) = 0;
};



class  GesturePropertiesServiceProxy
    : public GesturePropertiesService {
 public:
  using InterfaceType = GesturePropertiesService;

  explicit GesturePropertiesServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ListDevices(ListDevicesCallback callback) final;
  
  void ListProperties(int32_t device_id, ListPropertiesCallback callback) final;
  
  void GetProperty(int32_t device_id, const std::string& name, GetPropertyCallback callback) final;
  
  void SetProperty(int32_t device_id, const std::string& name, GesturePropValuePtr value, SetPropertyCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  GesturePropertiesServiceStubDispatch {
 public:
  static bool Accept(GesturePropertiesService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GesturePropertiesService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GesturePropertiesService>>
class GesturePropertiesServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GesturePropertiesServiceStub() = default;
  ~GesturePropertiesServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GesturePropertiesServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GesturePropertiesServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  GesturePropertiesServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  GesturePropertiesServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  GesturePropValue {
 public:
  using DataView = GesturePropValueDataView;
  using Data_ = internal::GesturePropValue_Data;
  using Tag = Data_::GesturePropValue_Tag;

  template <typename... Args>
  static GesturePropValuePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |ints|.
  static GesturePropValuePtr
  NewInts(
      std::vector<int32_t> value) {
    auto result = GesturePropValuePtr(std::in_place);
    result->set_ints(std::move(value));
    return result;
  }
  // Construct an instance holding |shorts|.
  static GesturePropValuePtr
  NewShorts(
      std::vector<int16_t> value) {
    auto result = GesturePropValuePtr(std::in_place);
    result->set_shorts(std::move(value));
    return result;
  }
  // Construct an instance holding |bools|.
  static GesturePropValuePtr
  NewBools(
      std::vector<bool> value) {
    auto result = GesturePropValuePtr(std::in_place);
    result->set_bools(std::move(value));
    return result;
  }
  // Construct an instance holding |str|.
  static GesturePropValuePtr
  NewStr(
      const std::string& value) {
    auto result = GesturePropValuePtr(std::in_place);
    result->set_str(std::move(value));
    return result;
  }
  // Construct an instance holding |reals|.
  static GesturePropValuePtr
  NewReals(
      std::vector<double> value) {
    auto result = GesturePropValuePtr(std::in_place);
    result->set_reals(std::move(value));
    return result;
  }

  template <typename U>
  static GesturePropValuePtr From(const U& u) {
    return mojo::TypeConverter<GesturePropValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GesturePropValue>::Convert(*this);
  }

  GesturePropValue();
  ~GesturePropValue();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  GesturePropValue(const GesturePropValue& other) = delete;
  GesturePropValue& operator=(const GesturePropValue& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = GesturePropValuePtr>
  GesturePropValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, GesturePropValue>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, GesturePropValue>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_ints() const { return tag_ == Tag::kInts; }

  
  std::vector<int32_t>& get_ints() const {
    CHECK(tag_ == Tag::kInts);
    return *(data_.ints);
  }

  
  void set_ints(
      std::vector<int32_t> ints);
  
  bool is_shorts() const { return tag_ == Tag::kShorts; }

  
  std::vector<int16_t>& get_shorts() const {
    CHECK(tag_ == Tag::kShorts);
    return *(data_.shorts);
  }

  
  void set_shorts(
      std::vector<int16_t> shorts);
  
  bool is_bools() const { return tag_ == Tag::kBools; }

  
  std::vector<bool>& get_bools() const {
    CHECK(tag_ == Tag::kBools);
    return *(data_.bools);
  }

  
  void set_bools(
      std::vector<bool> bools);
  
  bool is_str() const { return tag_ == Tag::kStr; }

  
  std::string& get_str() const {
    CHECK(tag_ == Tag::kStr);
    return *(data_.str);
  }

  
  void set_str(
      const std::string& str);
  
  bool is_reals() const { return tag_ == Tag::kReals; }

  
  std::vector<double>& get_reals() const {
    CHECK(tag_ == Tag::kReals);
    return *(data_.reals);
  }

  
  void set_reals(
      std::vector<double> reals);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GesturePropValue::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<GesturePropValue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    std::vector<int32_t>* ints;
    std::vector<int16_t>* shorts;
    std::vector<bool>* bools;
    std::string* str;
    std::vector<double>* reals;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};

template <typename UnionPtrType>
GesturePropValuePtr GesturePropValue::Clone() const {
  switch (tag_) {
    case Tag::kInts:
      return NewInts(
          mojo::Clone(*data_.ints));
    case Tag::kShorts:
      return NewShorts(
          mojo::Clone(*data_.shorts));
    case Tag::kBools:
      return NewBools(
          mojo::Clone(*data_.bools));
    case Tag::kStr:
      return NewStr(
          mojo::Clone(*data_.str));
    case Tag::kReals:
      return NewReals(
          mojo::Clone(*data_.reals));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, GesturePropValue>::value>::type*>
bool GesturePropValue::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kInts:
      return mojo::Equals(*(data_.ints), *(other.data_.ints));
    case Tag::kShorts:
      return mojo::Equals(*(data_.shorts), *(other.data_.shorts));
    case Tag::kBools:
      return mojo::Equals(*(data_.bools), *(other.data_.bools));
    case Tag::kStr:
      return mojo::Equals(*(data_.str), *(other.data_.str));
    case Tag::kReals:
      return mojo::Equals(*(data_.reals), *(other.data_.reals));
  }

  return false;
}


}  // ui::ozone::mojom

namespace mojo {


template <>
struct  UnionTraits<::ui::ozone::mojom::GesturePropValue::DataView,
                                        ::ui::ozone::mojom::GesturePropValuePtr> {
  static bool IsNull(const ::ui::ozone::mojom::GesturePropValuePtr& input) { return !input; }
  static void SetToNull(::ui::ozone::mojom::GesturePropValuePtr* output) { output->reset(); }

  static ::ui::ozone::mojom::GesturePropValue::Tag GetTag(const ::ui::ozone::mojom::GesturePropValuePtr& input) {
    return input->which();
  }

  static const std::vector<int32_t>& ints(const ::ui::ozone::mojom::GesturePropValuePtr& input) {
    return input->get_ints();
  }

  static const std::vector<int16_t>& shorts(const ::ui::ozone::mojom::GesturePropValuePtr& input) {
    return input->get_shorts();
  }

  static const std::vector<bool>& bools(const ::ui::ozone::mojom::GesturePropValuePtr& input) {
    return input->get_bools();
  }

  static const std::string& str(const ::ui::ozone::mojom::GesturePropValuePtr& input) {
    return input->get_str();
  }

  static const std::vector<double>& reals(const ::ui::ozone::mojom::GesturePropValuePtr& input) {
    return input->get_reals();
  }

  static bool Read(::ui::ozone::mojom::GesturePropValue::DataView input, ::ui::ozone::mojom::GesturePropValuePtr* output);
};

}  // namespace mojo

#endif  // UI_OZONE_PUBLIC_MOJOM_GESTURE_PROPERTIES_SERVICE_MOJOM_H_