// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_AUTOFILL_CONTENT_RENDERER_HTML_BASED_USERNAME_DETECTOR_VOCABULARY_H_
#define COMPONENTS_AUTOFILL_CONTENT_RENDERER_HTML_BASED_USERNAME_DETECTOR_VOCABULARY_H_

#include <array>
#include <string_view>

namespace autofill {

// Words that certainly point to a non-username field.
// If field values contain at least one negative word, then the field is
// excluded from the list of possible usernames.
inline constexpr auto kNegativeLatin = std::to_array<std::u16string_view>(
    {u"pin",    u"parola",   u"wagwoord",   u"wachtwoord",
     u"fake",   u"parole",   u"givenname",  u"achinsinsi",
     u"token",  u"parool",   u"firstname",  u"facalfaire",
     u"fname",  u"lozinka",  u"pasahitza",  u"focalfaire",
     u"lname",  u"passord",  u"pasiwedhi",  u"iphasiwedi",
     u"geslo",  u"huahuna",  u"passwuert",  u"katalaluan",
     u"heslo",  u"fullname", u"phasewete",  u"adgangskode",
     u"parol",  u"optional", u"wachtwurd",  u"contrasenya",
     u"sandi",  u"lastname", u"cyfrinair",  u"contrasinal",
     u"senha",  u"kupuhipa", u"katasandi",  u"kalmarsirri",
     u"hidden", u"password", u"loluszais",  u"tenimiafina",
     u"second", u"passwort", u"middlename", u"paroladordine",
     u"codice", u"pasvorto", u"familyname", u"inomboloyokuvula",
     u"modpas", u"salasana", u"motdepasse", u"numeraeleiloaesesi",
     u"captcha"});
inline constexpr auto kNegativeNonLatin =
    std::to_array<std::u16string_view>({u"fjalëkalim",
                                        u"የይለፍቃል",
                                        u"كلمهالسر",
                                        u"գաղտնաբառ",
                                        u"пароль",
                                        u"পাসওয়ার্ড",
                                        u"парола",
                                        u"密码",
                                        u"密碼",
                                        u"დაგავიწყდათ",
                                        u"κωδικόςπρόσβασης",
                                        u"પાસવર્ડ",
                                        u"סיסמה",
                                        u"पासवर्ड",
                                        u"jelszó",
                                        u"lykilorð",
                                        u"paswọọdụ",
                                        u"パスワード",
                                        u"ಪಾಸ್ವರ್ಡ್",
                                        u"пароль",
                                        u"ការពាក្យសម្ងាត់",
                                        u"암호",
                                        u"şîfre",
                                        u"купуясөз",
                                        u"ລະຫັດຜ່ານ",
                                        u"slaptažodis",
                                        u"лозинка",
                                        u"पासवर्ड",
                                        u"нууцүг",
                                        u"စကားဝှက်ကို",
                                        u"पासवर्ड",
                                        u"رمز",
                                        u"کلمهعبور",
                                        u"hasło",
                                        u"пароль",
                                        u"лозинка",
                                        u"پاسورڊ",
                                        u"මුරපදය",
                                        u"contraseña",
                                        u"lösenord",
                                        u"гузарвожа",
                                        u"கடவுச்சொல்",
                                        u"పాస్వర్డ్",
                                        u"รหัสผ่าน",
                                        u"пароль",
                                        u"پاسورڈ",
                                        u"mậtkhẩu",
                                        u"פּאַראָל",
                                        u"ọrọigbaniwọle"});

// Translations of "username".
inline constexpr auto kUsernameLatin = std::to_array<std::u16string_view>(
    {u"gatti",      u"uzantonomo",   u"solonanarana",    u"nombredeusuario",
     u"olumulo",    u"nomenusoris",  u"enwdefnyddiwr",   u"nomdutilisateur",
     u"lolowera",   u"notandanafn",  u"nomedeusuario",   u"vartotojovardas",
     u"username",   u"ahanjirimara", u"gebruikersnaam",  u"numedeutilizator",
     u"brugernavn", u"benotzernumm", u"jinalamtumiaji",  u"erabiltzaileizena",
     u"brukernavn", u"benutzername", u"sunanmaiamfani",  u"foydalanuvchinomi",
     u"mosebedisi", u"kasutajanimi", u"ainmcleachdaidh", u"igamalomsebenzisi",
     u"nomdusuari", u"lomsebenzisi", u"jenengpanganggo", u"ingoakaiwhakamahi",
     u"nomeutente", u"namapengguna"});
inline constexpr auto kUsernameNonLatin =
    std::to_array<std::u16string_view>({u"用户名",
                                        u"کاتيجونالو",
                                        u"用戶名",
                                        u"የተጠቃሚስም",
                                        u"логин",
                                        u"اسمالمستخدم",
                                        u"נאמען",
                                        u"کاصارفکانام",
                                        u"ユーザ名",
                                        u"όνομα χρήστη",
                                        u"brûkersnamme",
                                        u"корисничкоиме",
                                        u"nonitilizatè",
                                        u"корисничкоиме",
                                        u"ngaranpamaké",
                                        u"ຊື່ຜູ້ໃຊ້",
                                        u"användarnamn",
                                        u"యూజర్పేరు",
                                        u"korisničkoime",
                                        u"пайдаланушыаты",
                                        u"שםמשתמש",
                                        u"ім'якористувача",
                                        u"کارننوم",
                                        u"хэрэглэгчийннэр",
                                        u"nomedeusuário",
                                        u"имяпользователя",
                                        u"têntruynhập",
                                        u"பயனர்பெயர்",
                                        u"ainmúsáideora",
                                        u"ชื่อผู้ใช้",
                                        u"사용자이름",
                                        u"імякарыстальніка",
                                        u"lietotājvārds",
                                        u"потребителскоиме",
                                        u"uporabniškoime",
                                        u"колдонуучунунаты",
                                        u"kullanıcıadı",
                                        u"පරිශීලකනාමය",
                                        u"istifadəçiadı",
                                        u"օգտագործողիանունը",
                                        u"navêbikarhêner",
                                        u"ಬಳಕೆದಾರಹೆಸರು",
                                        u"emriipërdoruesit",
                                        u"वापरकर्तानाव",
                                        u"käyttäjätunnus",
                                        u"વપરાશકર્તાનામ",
                                        u"felhasználónév",
                                        u"उपयोगकर्तानाम",
                                        u"nazwaużytkownika",
                                        u"ഉപയോക്തൃനാമം",
                                        u"სახელი",
                                        u"အသုံးပြုသူအမည်",
                                        u"نامکاربری",
                                        u"प्रयोगकर्तानाम",
                                        u"uživatelskéjméno",
                                        u"ব্যবহারকারীরনাম",
                                        u"užívateľskémeno",
                                        u"ឈ្មោះអ្នកប្រើប្រាស់"});

// Translations of "user".
inline constexpr auto kUserLatin = std::to_array<std::u16string_view>(
    {u"user",   u"wosuta",   u"gebruiker",  u"utilizator",
     u"usor",   u"notandi",  u"gumagamit",  u"vartotojas",
     u"fammi",  u"olumulo",  u"maiamfani",  u"cleachdaidh",
     u"utent",  u"pemakai",  u"mpampiasa",  u"umsebenzisi",
     u"bruger", u"usuario",  u"panganggo",  u"utilisateur",
     u"bruker", u"benotzer", u"uporabnik",  u"doutilizador",
     u"numake", u"benutzer", u"covneegsiv", u"erabiltzaile",
     u"usuari", u"kasutaja", u"defnyddiwr", u"kaiwhakamahi",
     u"utente", u"korisnik", u"mosebedisi", u"foydalanuvchi",
     u"uzanto", u"pengguna", u"mushandisi"});
inline constexpr auto kUserNonLatin =
    std::to_array<std::u16string_view>({u"用户",
                                        u"użytkownik",
                                        u"tagatafaʻaaogā",
                                        u"دکارونکيعکس",
                                        u"用戶",
                                        u"užívateľ",
                                        u"корисник",
                                        u"карыстальнік",
                                        u"brûker",
                                        u"kullanıcı",
                                        u"истифода",
                                        u"អ្នកប្រើ",
                                        u"ọrụ",
                                        u"ተጠቃሚ",
                                        u"באַניצער",
                                        u"хэрэглэгчийн",
                                        u"يوزر",
                                        u"istifadəçi",
                                        u"ຜູ້ໃຊ້",
                                        u"пользователь",
                                        u"صارف",
                                        u"meahoʻohana",
                                        u"потребител",
                                        u"वापरकर्ता",
                                        u"uživatel",
                                        u"ユーザー",
                                        u"מִשׁתַמֵשׁ",
                                        u"ผู้ใช้งาน",
                                        u"사용자",
                                        u"bikaranîvan",
                                        u"колдонуучу",
                                        u"વપરાશકર્તા",
                                        u"përdorues",
                                        u"ngườidùng",
                                        u"корисникот",
                                        u"उपयोगकर्ता",
                                        u"itilizatè",
                                        u"χρήστης",
                                        u"користувач",
                                        u"օգտվողիանձնագիրը",
                                        u"használó",
                                        u"faoiúsáideoir",
                                        u"შესახებ",
                                        u"ব্যবহারকারী",
                                        u"lietotājs",
                                        u"பயனர்",
                                        u"ಬಳಕೆದಾರ",
                                        u"ഉപയോക്താവ്",
                                        u"کاربر",
                                        u"యూజర్",
                                        u"පරිශීලක",
                                        u"प्रयोगकर्ता",
                                        u"användare",
                                        u"المستعمل",
                                        u"пайдаланушы",
                                        u"အသုံးပြုသူကို",
                                        u"käyttäjä"});

// Words that certainly point to a username field, if they appear in developer
// value. They are technical words, because they can only be used as variable
// names, and not as stand-alone words.
inline constexpr auto kTechnicalWords = std::to_array<std::u16string_view>(
    {u"uid",    u"newtel",   u"uaccount",  u"regaccount",
     u"ureg",   u"loginid",  u"laddress",  u"accountreg",
     u"regid",  u"regname",  u"loginname", u"membername",
     u"uname",  u"ucreate",  u"loginmail", u"accountname",
     u"umail",  u"loginreg", u"accountid", u"loginaccount",
     u"ulogin", u"regemail", u"newmobile", u"accountlogin"});

// Words that might point to a username field.They have the smallest priority
// in the heuristic, because there are also field attribute values that
// contain them, but are not username fields.
inline constexpr auto kWeakWords =
    std::to_array<std::u16string_view>({u"id", u"login", u"mail"});

}  // namespace autofill

#endif  // COMPONENTS_AUTOFILL_CONTENT_RENDERER_HTML_BASED_USERNAME_DETECTOR_VOCABULARY_H_
