// components/services/storage/public/mojom/blob_storage_context.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/public/mojom/blob_storage_context.mojom-features.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/blob_storage_context.mojom-shared.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/blob_storage_context.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace storage::mojom {

class BlobDataItemReaderProxy;

template <typename ImplRefTraits>
class BlobDataItemReaderStub;

class BlobDataItemReaderRequestValidator;
class BlobDataItemReaderResponseValidator;


class BlobDataItemReader
    : public BlobDataItemReaderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BlobDataItemReaderInterfaceBase;
  using Proxy_ = BlobDataItemReaderProxy;

  template <typename ImplRefTraits>
  using Stub_ = BlobDataItemReaderStub<ImplRefTraits>;

  using RequestValidator_ = BlobDataItemReaderRequestValidator;
  using ResponseValidator_ = BlobDataItemReaderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kReadMinVersion = 0,
    kReadSideDataMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Read_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReadSideData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BlobDataItemReader() = default;


  using ReadCallback = base::OnceCallback<void(int32_t)>;
  
  virtual void Read(uint64_t offset, uint64_t length, ::mojo::ScopedDataPipeProducerHandle pipe, ReadCallback callback) = 0;


  using ReadSideDataCallback = base::OnceCallback<void(int32_t, ::mojo_base::BigBuffer)>;
  
  virtual void ReadSideData(ReadSideDataCallback callback) = 0;
};

class BlobStorageContextProxy;

template <typename ImplRefTraits>
class BlobStorageContextStub;

class BlobStorageContextRequestValidator;
class BlobStorageContextResponseValidator;


class BlobStorageContext
    : public BlobStorageContextInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BlobStorageContextInterfaceBase;
  using Proxy_ = BlobStorageContextProxy;

  template <typename ImplRefTraits>
  using Stub_ = BlobStorageContextStub<ImplRefTraits>;

  using RequestValidator_ = BlobStorageContextRequestValidator;
  using ResponseValidator_ = BlobStorageContextResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRegisterFromDataItemMinVersion = 0,
    kRegisterFromMemoryMinVersion = 0,
    kWriteBlobToFileMinVersion = 0,
    kCloneMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RegisterFromDataItem_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RegisterFromMemory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WriteBlobToFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Clone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BlobStorageContext() = default;

  
  virtual void RegisterFromDataItem(::mojo::PendingReceiver<::blink::mojom::Blob> blob, const std::string& uuid, BlobDataItemPtr item) = 0;

  
  virtual void RegisterFromMemory(::mojo::PendingReceiver<::blink::mojom::Blob> blob, const std::string& uuid, ::mojo_base::BigBuffer data) = 0;


  using WriteBlobToFileCallback = base::OnceCallback<void(WriteBlobToFileResult)>;
  
  virtual void WriteBlobToFile(::mojo::PendingRemote<::blink::mojom::Blob> blob, const ::base::FilePath& path, bool flush_on_write, std::optional<::base::Time> last_modified, WriteBlobToFileCallback callback) = 0;

  
  virtual void Clone(::mojo::PendingReceiver<BlobStorageContext> receiver) = 0;
};



class  BlobDataItemReaderProxy
    : public BlobDataItemReader {
 public:
  using InterfaceType = BlobDataItemReader;

  explicit BlobDataItemReaderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Read(uint64_t offset, uint64_t length, ::mojo::ScopedDataPipeProducerHandle pipe, ReadCallback callback) final;
  
  void ReadSideData(ReadSideDataCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  BlobStorageContextProxy
    : public BlobStorageContext {
 public:
  using InterfaceType = BlobStorageContext;

  explicit BlobStorageContextProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RegisterFromDataItem(::mojo::PendingReceiver<::blink::mojom::Blob> blob, const std::string& uuid, BlobDataItemPtr item) final;
  
  void RegisterFromMemory(::mojo::PendingReceiver<::blink::mojom::Blob> blob, const std::string& uuid, ::mojo_base::BigBuffer data) final;
  
  void WriteBlobToFile(::mojo::PendingRemote<::blink::mojom::Blob> blob, const ::base::FilePath& path, bool flush_on_write, std::optional<::base::Time> last_modified, WriteBlobToFileCallback callback) final;
  
  void Clone(::mojo::PendingReceiver<BlobStorageContext> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  BlobDataItemReaderStubDispatch {
 public:
  static bool Accept(BlobDataItemReader* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BlobDataItemReader* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BlobDataItemReader>>
class BlobDataItemReaderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BlobDataItemReaderStub() = default;
  ~BlobDataItemReaderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BlobDataItemReaderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BlobDataItemReaderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  BlobStorageContextStubDispatch {
 public:
  static bool Accept(BlobStorageContext* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BlobStorageContext* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BlobStorageContext>>
class BlobStorageContextStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BlobStorageContextStub() = default;
  ~BlobStorageContextStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BlobStorageContextStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BlobStorageContextStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  BlobDataItemReaderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  BlobStorageContextRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  BlobDataItemReaderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  BlobStorageContextResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  BlobDataItem {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BlobDataItem, T>::value>;
  using DataView = BlobDataItemDataView;
  using Data_ = internal::BlobDataItem_Data;

  template <typename... Args>
  static BlobDataItemPtr New(Args&&... args) {
    return BlobDataItemPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BlobDataItemPtr From(const U& u) {
    return mojo::TypeConverter<BlobDataItemPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BlobDataItem>::Convert(*this);
  }


  BlobDataItem();

  BlobDataItem(
      BlobDataItemType type,
      uint64_t size,
      uint64_t side_data_size,
      const std::string& content_type,
      ::mojo::PendingRemote<BlobDataItemReader> reader);

BlobDataItem(const BlobDataItem&) = delete;
BlobDataItem& operator=(const BlobDataItem&) = delete;

  ~BlobDataItem();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BlobDataItemPtr>
  BlobDataItemPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BlobDataItem::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BlobDataItem::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BlobDataItem::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BlobDataItem::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BlobDataItem_UnserializedMessageContext<
            UserType, BlobDataItem::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BlobDataItem::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BlobDataItem::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BlobDataItem_UnserializedMessageContext<
            UserType, BlobDataItem::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BlobDataItem::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  BlobDataItemType type;
  
  uint64_t size;
  
  uint64_t side_data_size;
  
  std::string content_type;
  
  ::mojo::PendingRemote<BlobDataItemReader> reader;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BlobDataItem::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BlobDataItem::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BlobDataItem::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BlobDataItem::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
BlobDataItemPtr BlobDataItem::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(size),
      mojo::Clone(side_data_size),
      mojo::Clone(content_type),
      mojo::Clone(reader)
  );
}

template <typename T, BlobDataItem::EnableIfSame<T>*>
bool BlobDataItem::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->side_data_size, other_struct.side_data_size))
    return false;
  if (!mojo::Equals(this->content_type, other_struct.content_type))
    return false;
  if (!mojo::Equals(this->reader, other_struct.reader))
    return false;
  return true;
}

template <typename T, BlobDataItem::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  if (lhs.side_data_size < rhs.side_data_size)
    return true;
  if (rhs.side_data_size < lhs.side_data_size)
    return false;
  if (lhs.content_type < rhs.content_type)
    return true;
  if (rhs.content_type < lhs.content_type)
    return false;
  if (lhs.reader < rhs.reader)
    return true;
  if (rhs.reader < lhs.reader)
    return false;
  return false;
}


}  // storage::mojom

namespace mojo {


template <>
struct  StructTraits<::storage::mojom::BlobDataItem::DataView,
                                         ::storage::mojom::BlobDataItemPtr> {
  static bool IsNull(const ::storage::mojom::BlobDataItemPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::BlobDataItemPtr* output) { output->reset(); }

  static decltype(::storage::mojom::BlobDataItem::type) type(
      const ::storage::mojom::BlobDataItemPtr& input) {
    return input->type;
  }

  static decltype(::storage::mojom::BlobDataItem::size) size(
      const ::storage::mojom::BlobDataItemPtr& input) {
    return input->size;
  }

  static decltype(::storage::mojom::BlobDataItem::side_data_size) side_data_size(
      const ::storage::mojom::BlobDataItemPtr& input) {
    return input->side_data_size;
  }

  static const decltype(::storage::mojom::BlobDataItem::content_type)& content_type(
      const ::storage::mojom::BlobDataItemPtr& input) {
    return input->content_type;
  }

  static  decltype(::storage::mojom::BlobDataItem::reader)& reader(
       ::storage::mojom::BlobDataItemPtr& input) {
    return input->reader;
  }

  static bool Read(::storage::mojom::BlobDataItem::DataView input, ::storage::mojom::BlobDataItemPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_H_