// gpu/ipc/common/memory_stats.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_MEMORY_STATS_MOJOM_H_
#define GPU_IPC_COMMON_MEMORY_STATS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/memory_stats.mojom-features.h"  // IWYU pragma: export
#include "gpu/ipc/common/memory_stats.mojom-shared.h"  // IWYU pragma: export
#include "gpu/ipc/common/memory_stats.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "gpu/ipc/common/memory_stats_mojom_traits.h"
#include "gpu/gpu_export.h"




namespace gpu::mojom {





class GPU_EXPORT VideoMemoryProcessStats {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoMemoryProcessStats, T>::value>;
  using DataView = VideoMemoryProcessStatsDataView;
  using Data_ = internal::VideoMemoryProcessStats_Data;

  template <typename... Args>
  static VideoMemoryProcessStatsPtr New(Args&&... args) {
    return VideoMemoryProcessStatsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoMemoryProcessStatsPtr From(const U& u) {
    return mojo::TypeConverter<VideoMemoryProcessStatsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoMemoryProcessStats>::Convert(*this);
  }


  VideoMemoryProcessStats();

  VideoMemoryProcessStats(
      uint64_t video_memory_bytes,
      bool has_duplicates);


  ~VideoMemoryProcessStats();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoMemoryProcessStatsPtr>
  VideoMemoryProcessStatsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoMemoryProcessStats::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoMemoryProcessStats::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoMemoryProcessStats::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoMemoryProcessStats::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoMemoryProcessStats::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoMemoryProcessStats_UnserializedMessageContext<
            UserType, VideoMemoryProcessStats::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoMemoryProcessStats::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoMemoryProcessStats::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoMemoryProcessStats_UnserializedMessageContext<
            UserType, VideoMemoryProcessStats::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoMemoryProcessStats::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t video_memory_bytes;
  
  bool has_duplicates;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoMemoryProcessStats::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoMemoryProcessStats::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoMemoryProcessStats::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoMemoryProcessStats::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class GPU_EXPORT VideoMemoryUsageStats {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoMemoryUsageStats, T>::value>;
  using DataView = VideoMemoryUsageStatsDataView;
  using Data_ = internal::VideoMemoryUsageStats_Data;

  template <typename... Args>
  static VideoMemoryUsageStatsPtr New(Args&&... args) {
    return VideoMemoryUsageStatsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoMemoryUsageStatsPtr From(const U& u) {
    return mojo::TypeConverter<VideoMemoryUsageStatsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoMemoryUsageStats>::Convert(*this);
  }


  VideoMemoryUsageStats();

  VideoMemoryUsageStats(
      const base::flat_map<int32_t, ::gpu::VideoMemoryUsageStats::ProcessStats>& process_map,
      uint64_t bytes_allocated);


  ~VideoMemoryUsageStats();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoMemoryUsageStatsPtr>
  VideoMemoryUsageStatsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoMemoryUsageStats::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoMemoryUsageStats::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoMemoryUsageStats::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoMemoryUsageStats::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoMemoryUsageStats::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoMemoryUsageStats_UnserializedMessageContext<
            UserType, VideoMemoryUsageStats::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoMemoryUsageStats::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoMemoryUsageStats::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoMemoryUsageStats_UnserializedMessageContext<
            UserType, VideoMemoryUsageStats::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoMemoryUsageStats::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  base::flat_map<int32_t, ::gpu::VideoMemoryUsageStats::ProcessStats> process_map;
  
  uint64_t bytes_allocated;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoMemoryUsageStats::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoMemoryUsageStats::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoMemoryUsageStats::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoMemoryUsageStats::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
VideoMemoryProcessStatsPtr VideoMemoryProcessStats::Clone() const {
  return New(
      mojo::Clone(video_memory_bytes),
      mojo::Clone(has_duplicates)
  );
}

template <typename T, VideoMemoryProcessStats::EnableIfSame<T>*>
bool VideoMemoryProcessStats::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->video_memory_bytes, other_struct.video_memory_bytes))
    return false;
  if (!mojo::Equals(this->has_duplicates, other_struct.has_duplicates))
    return false;
  return true;
}

template <typename T, VideoMemoryProcessStats::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.video_memory_bytes < rhs.video_memory_bytes)
    return true;
  if (rhs.video_memory_bytes < lhs.video_memory_bytes)
    return false;
  if (lhs.has_duplicates < rhs.has_duplicates)
    return true;
  if (rhs.has_duplicates < lhs.has_duplicates)
    return false;
  return false;
}
template <typename StructPtrType>
VideoMemoryUsageStatsPtr VideoMemoryUsageStats::Clone() const {
  return New(
      mojo::Clone(process_map),
      mojo::Clone(bytes_allocated)
  );
}

template <typename T, VideoMemoryUsageStats::EnableIfSame<T>*>
bool VideoMemoryUsageStats::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->process_map, other_struct.process_map))
    return false;
  if (!mojo::Equals(this->bytes_allocated, other_struct.bytes_allocated))
    return false;
  return true;
}

template <typename T, VideoMemoryUsageStats::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.process_map < rhs.process_map)
    return true;
  if (rhs.process_map < lhs.process_map)
    return false;
  if (lhs.bytes_allocated < rhs.bytes_allocated)
    return true;
  if (rhs.bytes_allocated < lhs.bytes_allocated)
    return false;
  return false;
}


}  // gpu::mojom

namespace mojo {


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::VideoMemoryProcessStats::DataView,
                                         ::gpu::mojom::VideoMemoryProcessStatsPtr> {
  static bool IsNull(const ::gpu::mojom::VideoMemoryProcessStatsPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::VideoMemoryProcessStatsPtr* output) { output->reset(); }

  static decltype(::gpu::mojom::VideoMemoryProcessStats::video_memory_bytes) video_memory_bytes(
      const ::gpu::mojom::VideoMemoryProcessStatsPtr& input) {
    return input->video_memory_bytes;
  }

  static decltype(::gpu::mojom::VideoMemoryProcessStats::has_duplicates) has_duplicates(
      const ::gpu::mojom::VideoMemoryProcessStatsPtr& input) {
    return input->has_duplicates;
  }

  static bool Read(::gpu::mojom::VideoMemoryProcessStats::DataView input, ::gpu::mojom::VideoMemoryProcessStatsPtr* output);
};


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::VideoMemoryUsageStats::DataView,
                                         ::gpu::mojom::VideoMemoryUsageStatsPtr> {
  static bool IsNull(const ::gpu::mojom::VideoMemoryUsageStatsPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::VideoMemoryUsageStatsPtr* output) { output->reset(); }

  static const decltype(::gpu::mojom::VideoMemoryUsageStats::process_map)& process_map(
      const ::gpu::mojom::VideoMemoryUsageStatsPtr& input) {
    return input->process_map;
  }

  static decltype(::gpu::mojom::VideoMemoryUsageStats::bytes_allocated) bytes_allocated(
      const ::gpu::mojom::VideoMemoryUsageStatsPtr& input) {
    return input->bytes_allocated;
  }

  static bool Read(::gpu::mojom::VideoMemoryUsageStats::DataView input, ::gpu::mojom::VideoMemoryUsageStatsPtr* output);
};

}  // namespace mojo

#endif  // GPU_IPC_COMMON_MEMORY_STATS_MOJOM_H_