// gpu/ipc/common/shared_image_metadata.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_SHARED_IMAGE_METADATA_MOJOM_SHARED_H_
#define GPU_IPC_COMMON_SHARED_IMAGE_METADATA_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/shared_image_metadata.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/shared_image_format.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"
#include "skia/public/mojom/surface_origin.mojom-shared.h"
#include "skia/public/mojom/image_info.mojom-shared.h"



#include "base/component_export.h"




namespace gpu::mojom {
class SharedImageMetadataDataView;



}  // gpu::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gpu::mojom::SharedImageMetadataDataView> {
  using Data = ::gpu::mojom::internal::SharedImageMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gpu::mojom {


class SharedImageMetadataDataView {
 public:
  SharedImageMetadataDataView() = default;

  SharedImageMetadataDataView(
      internal::SharedImageMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFormatDataView(
      ::viz::mojom::SharedImageFormatDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormat(UserType* output) {
    
    auto* pointer = !data_->format.is_null() ? &data_->format : nullptr;
    return mojo::internal::Deserialize<::viz::mojom::SharedImageFormatDataView>(
        pointer, output, message_);
  }
  inline void GetSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSize(UserType* output) {
    
    auto* pointer = data_->size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetColorSpaceDataView(
      ::gfx::mojom::ColorSpaceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorSpace(UserType* output) {
    
    auto* pointer = data_->color_space.Get();
    return mojo::internal::Deserialize<::gfx::mojom::ColorSpaceDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSurfaceOrigin(UserType* output) const {
    auto data_value = data_->surface_origin;
    return mojo::internal::Deserialize<::skia::mojom::SurfaceOrigin>(
        data_value, output);
  }
  ::skia::mojom::SurfaceOrigin surface_origin() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::skia::mojom::SurfaceOrigin>(data_->surface_origin));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAlphaType(UserType* output) const {
    auto data_value = data_->alpha_type;
    return mojo::internal::Deserialize<::skia::mojom::AlphaType>(
        data_value, output);
  }
  ::skia::mojom::AlphaType alpha_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::skia::mojom::AlphaType>(data_->alpha_type));
  }
  uint32_t usage() const {
    return data_->usage;
  }
 private:
  internal::SharedImageMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // gpu::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::SharedImageMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::SharedImageMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::SharedImageMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::format(input)) in_format = Traits::format(input);
    mojo::internal::MessageFragment<decltype(fragment->format)>
        format_fragment(fragment.message());
    format_fragment.Claim(&fragment->format);
    mojo::internal::Serialize<::viz::mojom::SharedImageFormatDataView>(
        in_format, format_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->format.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null format in SharedImageMetadata struct");
    decltype(Traits::size(input)) in_size = Traits::size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->size)::BaseType> size_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_size, size_fragment);
    fragment->size.Set(
        size_fragment.is_null() ? nullptr : size_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null size in SharedImageMetadata struct");
    decltype(Traits::color_space(input)) in_color_space = Traits::color_space(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color_space)::BaseType> color_space_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::ColorSpaceDataView>(
        in_color_space, color_space_fragment);
    fragment->color_space.Set(
        color_space_fragment.is_null() ? nullptr : color_space_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->color_space.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null color_space in SharedImageMetadata struct");
    mojo::internal::Serialize<::skia::mojom::SurfaceOrigin>(
        Traits::surface_origin(input), &fragment->surface_origin);
    mojo::internal::Serialize<::skia::mojom::AlphaType>(
        Traits::alpha_type(input), &fragment->alpha_type);
    fragment->usage = Traits::usage(input);
  }

  static bool Deserialize(::gpu::mojom::internal::SharedImageMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::SharedImageMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gpu::mojom {

inline void SharedImageMetadataDataView::GetFormatDataView(
    ::viz::mojom::SharedImageFormatDataView* output) {
  auto pointer = &data_->format;
  *output = ::viz::mojom::SharedImageFormatDataView(pointer, message_);
}
inline void SharedImageMetadataDataView::GetSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void SharedImageMetadataDataView::GetColorSpaceDataView(
    ::gfx::mojom::ColorSpaceDataView* output) {
  auto pointer = data_->color_space.Get();
  *output = ::gfx::mojom::ColorSpaceDataView(pointer, message_);
}



}  // gpu::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // GPU_IPC_COMMON_SHARED_IMAGE_METADATA_MOJOM_SHARED_H_